/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.layoutexample;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.layoutexample.LayoutExample;
import org.eclipse.swt.examples.layoutexample.Tab;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

class RowLayoutTab
extends Tab {
    Button horizontal;
    Button vertical;
    Button wrap;
    Button pack;
    Button justify;
    Combo marginRight;
    Combo marginLeft;
    Combo marginTop;
    Combo marginBottom;
    Combo spacing;
    RowLayout rowLayout;
    TableEditor comboEditor;
    TableEditor widthEditor;
    TableEditor heightEditor;
    CCombo combo;
    Text widthText;
    Text heightText;
    final int COMBO_COL = 1;
    final int WIDTH_COL = 2;
    final int HEIGHT_COL = 3;
    final int TOTAL_COLS = 4;

    RowLayoutTab(LayoutExample layoutExample) {
        super(layoutExample);
    }

    @Override
    void createChildWidgets() {
        super.createChildWidgets();
        this.comboEditor = new TableEditor(this.table);
        this.widthEditor = new TableEditor(this.table);
        this.heightEditor = new TableEditor(this.table);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                RowLayoutTab.this.resetEditors();
                RowLayoutTab.this.index = RowLayoutTab.this.table.getSelectionIndex();
                Point point = new Point(mouseEvent.x, mouseEvent.y);
                RowLayoutTab.this.newItem = RowLayoutTab.this.table.getItem(point);
                if (RowLayoutTab.this.newItem == null) {
                    return;
                }
                TableItem tableItem = RowLayoutTab.this.comboEditor.getItem();
                if (RowLayoutTab.this.newItem == tableItem || RowLayoutTab.this.newItem != RowLayoutTab.this.lastSelected) {
                    RowLayoutTab.this.lastSelected = RowLayoutTab.this.newItem;
                    return;
                }
                RowLayoutTab.this.table.showSelection();
                RowLayoutTab.this.combo = new CCombo((Composite)RowLayoutTab.this.table, 8);
                RowLayoutTab.this.createComboEditor(RowLayoutTab.this.combo, RowLayoutTab.this.comboEditor);
                RowLayoutTab.this.widthText = new Text((Composite)RowLayoutTab.this.table, 4);
                RowLayoutTab.this.widthText.setText(((String[])RowLayoutTab.this.data.elementAt(RowLayoutTab.this.index))[2]);
                RowLayoutTab.this.createTextEditor(RowLayoutTab.this.widthText, RowLayoutTab.this.widthEditor, 2);
                RowLayoutTab.this.heightText = new Text((Composite)RowLayoutTab.this.table, 4);
                RowLayoutTab.this.heightText.setText(((String[])RowLayoutTab.this.data.elementAt(RowLayoutTab.this.index))[3]);
                RowLayoutTab.this.createTextEditor(RowLayoutTab.this.heightText, RowLayoutTab.this.heightEditor, 3);
                block5: for (int i = 0; i < RowLayoutTab.this.table.getColumnCount(); ++i) {
                    Rectangle rectangle = RowLayoutTab.this.newItem.getBounds(i);
                    if (!rectangle.contains(point)) continue;
                    switch (i) {
                        case 1: {
                            RowLayoutTab.this.combo.setFocus();
                            continue block5;
                        }
                        case 2: {
                            RowLayoutTab.this.widthText.setFocus();
                            continue block5;
                        }
                        case 3: {
                            RowLayoutTab.this.heightText.setFocus();
                            continue block5;
                        }
                        default: {
                            RowLayoutTab.this.resetEditors();
                        }
                    }
                }
            }
        });
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem tableItem = new TableItem(RowLayoutTab.this.table, 0);
                String[] stringArray = new String[]{String.valueOf(RowLayoutTab.this.table.indexOf(tableItem)), "Button", "-1", "-1"};
                tableItem.setText(stringArray);
                RowLayoutTab.this.data.addElement(stringArray);
                RowLayoutTab.this.resetEditors();
            }
        });
    }

    @Override
    void createControlWidgets() {
        Group group = new Group((Composite)this.controlGroup, 0);
        group.setText(LayoutExample.getResourceString("Type"));
        group.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        this.horizontal = new Button((Composite)group, 16);
        this.horizontal.setText("SWT.HORIZONTAL");
        this.horizontal.setLayoutData((Object)new GridData(768));
        this.horizontal.setSelection(true);
        this.horizontal.addSelectionListener(this.selectionListener);
        this.vertical = new Button((Composite)group, 16);
        this.vertical.setText("SWT.VERTICAL");
        this.vertical.setLayoutData((Object)new GridData(768));
        this.vertical.addSelectionListener(this.selectionListener);
        String[] stringArray = new String[]{"0", "3", "5", "10"};
        Group group2 = new Group((Composite)this.controlGroup, 0);
        group2.setText(LayoutExample.getResourceString("Margins_Spacing"));
        gridData = new GridData(770);
        gridData.verticalSpan = 2;
        group2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group2.setLayout((Layout)gridLayout);
        new Label((Composite)group2, 0).setText("marginRight");
        this.marginRight = new Combo((Composite)group2, 0);
        this.marginRight.setItems(stringArray);
        this.marginRight.select(1);
        this.marginRight.setLayoutData((Object)new GridData(768));
        this.marginRight.addSelectionListener(this.selectionListener);
        this.marginRight.addTraverseListener(this.traverseListener);
        new Label((Composite)group2, 0).setText("marginLeft");
        this.marginLeft = new Combo((Composite)group2, 0);
        this.marginLeft.setItems(stringArray);
        this.marginLeft.select(1);
        this.marginLeft.setLayoutData((Object)new GridData(768));
        this.marginLeft.addSelectionListener(this.selectionListener);
        this.marginLeft.addTraverseListener(this.traverseListener);
        new Label((Composite)group2, 0).setText("marginTop");
        this.marginTop = new Combo((Composite)group2, 0);
        this.marginTop.setItems(stringArray);
        this.marginTop.select(1);
        this.marginTop.setLayoutData((Object)new GridData(768));
        this.marginTop.addSelectionListener(this.selectionListener);
        this.marginTop.addTraverseListener(this.traverseListener);
        new Label((Composite)group2, 0).setText("marginBottom");
        this.marginBottom = new Combo((Composite)group2, 0);
        this.marginBottom.setItems(stringArray);
        this.marginBottom.select(1);
        this.marginBottom.setLayoutData((Object)new GridData(768));
        this.marginBottom.addSelectionListener(this.selectionListener);
        this.marginBottom.addTraverseListener(this.traverseListener);
        new Label((Composite)group2, 0).setText("spacing");
        this.spacing = new Combo((Composite)group2, 0);
        this.spacing.setItems(stringArray);
        this.spacing.select(1);
        this.spacing.setLayoutData((Object)new GridData(768));
        this.spacing.addSelectionListener(this.selectionListener);
        this.spacing.addTraverseListener(this.traverseListener);
        Group group3 = new Group((Composite)this.controlGroup, 0);
        group3.setText(LayoutExample.getResourceString("Properties"));
        group3.setLayoutData((Object)new GridData(768));
        group3.setLayout((Layout)new GridLayout());
        this.wrap = new Button((Composite)group3, 32);
        this.wrap.setText("wrap");
        this.wrap.setSelection(true);
        this.wrap.setLayoutData((Object)new GridData(768));
        this.wrap.addSelectionListener(this.selectionListener);
        this.pack = new Button((Composite)group3, 32);
        this.pack.setText("pack");
        this.pack.setLayoutData((Object)new GridData(768));
        this.pack.setSelection(true);
        this.pack.addSelectionListener(this.selectionListener);
        this.justify = new Button((Composite)group3, 32);
        this.justify.setText("justify");
        this.justify.setLayoutData((Object)new GridData(768));
        this.justify.addSelectionListener(this.selectionListener);
        super.createControlWidgets();
        this.sash.setWeights(new int[]{6, 5});
    }

    @Override
    void createLayout() {
        this.rowLayout = new RowLayout();
        this.layoutComposite.setLayout((Layout)this.rowLayout);
    }

    @Override
    void disposeEditors() {
        this.comboEditor.setEditor(null, null, -1);
        this.combo.dispose();
        this.widthText.dispose();
        this.heightText.dispose();
    }

    @Override
    StringBuffer generateLayoutCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t\tRowLayout rowLayout = new RowLayout ();\n");
        if (this.rowLayout.type == 512) {
            stringBuffer.append("\t\trowLayout.type = SWT.VERTICAL;\n");
        }
        if (!this.rowLayout.wrap) {
            stringBuffer.append("\t\trowLayout.wrap = false;\n");
        }
        if (!this.rowLayout.pack) {
            stringBuffer.append("\t\trowLayout.pack = false;\n");
        }
        if (this.rowLayout.justify) {
            stringBuffer.append("\t\trowLayout.justify = true;\n");
        }
        if (this.rowLayout.marginLeft != 3) {
            stringBuffer.append("\t\trowLayout.marginLeft = " + this.rowLayout.marginLeft + ";\n");
        }
        if (this.rowLayout.marginRight != 3) {
            stringBuffer.append("\t\trowLayout.marginRight = " + this.rowLayout.marginRight + ";\n");
        }
        if (this.rowLayout.marginTop != 3) {
            stringBuffer.append("\t\trowLayout.marginTop = " + this.rowLayout.marginTop + ";\n");
        }
        if (this.rowLayout.marginBottom != 3) {
            stringBuffer.append("\t\trowLayout.marginBottom = " + this.rowLayout.marginBottom + ";\n");
        }
        if (this.rowLayout.spacing != 3) {
            stringBuffer.append("\t\trowLayout.spacing = " + this.rowLayout.spacing + ";\n");
        }
        stringBuffer.append("\t\tshell.setLayout (rowLayout);\n");
        boolean bl = true;
        for (int i = 0; i < this.children.length; ++i) {
            Control control = this.children[i];
            stringBuffer.append(this.getChildCode(control, i));
            RowData rowData = (RowData)control.getLayoutData();
            if (rowData == null || rowData.width == -1 && rowData.height == -1) continue;
            stringBuffer.append("\t\t");
            if (bl) {
                stringBuffer.append("RowData ");
                bl = false;
            }
            if (rowData.width == -1) {
                stringBuffer.append("data = new RowData (SWT.DEFAULT, " + rowData.height + ");\n");
            } else if (rowData.height == -1) {
                stringBuffer.append("data = new RowData (" + rowData.width + ", SWT.DEFAULT);\n");
            } else {
                stringBuffer.append("data = new RowData (" + rowData.width + ", " + rowData.height + ");\n");
            }
            stringBuffer.append("\t\t" + this.names[i] + ".setLayoutData (data);\n");
        }
        return stringBuffer;
    }

    @Override
    String[] getLayoutDataFieldNames() {
        return new String[]{"", "Control", "width", "height"};
    }

    @Override
    String getTabText() {
        return "RowLayout";
    }

    @Override
    void resetEditors() {
        this.resetEditors(false);
    }

    @Override
    void resetEditors(boolean bl) {
        TableItem tableItem = this.comboEditor.getItem();
        if (tableItem != null) {
            int n = this.table.indexOf(tableItem);
            try {
                Integer.valueOf(this.widthText.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.widthText.setText(tableItem.getText(2));
            }
            try {
                Integer.valueOf(this.heightText.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.heightText.setText(tableItem.getText(3));
            }
            String[] stringArray = new String[]{String.valueOf(n), this.combo.getText(), this.widthText.getText(), this.heightText.getText()};
            this.data.setElementAt(stringArray, n);
            for (int i = 0; i < 4; ++i) {
                tableItem.setText(i, ((String[])this.data.elementAt(n))[i]);
            }
            if (!bl) {
                this.disposeEditors();
            }
        }
        this.setLayoutState();
        this.refreshLayoutComposite();
        this.setLayoutData();
        this.layoutComposite.layout(true);
        this.layoutGroup.layout(true);
    }

    @Override
    void setLayoutData() {
        Control[] controlArray = this.layoutComposite.getChildren();
        TableItem[] tableItemArray = this.table.getItems();
        for (int i = 0; i < controlArray.length; ++i) {
            int n = Integer.valueOf(tableItemArray[i].getText(2));
            int n2 = Integer.valueOf(tableItemArray[i].getText(3));
            RowData rowData = new RowData(n, n2);
            controlArray[i].setLayoutData((Object)rowData);
        }
    }

    @Override
    void setLayoutState() {
        this.rowLayout.type = this.vertical.getSelection() ? 512 : 256;
        try {
            this.rowLayout.marginRight = Integer.valueOf(this.marginRight.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.rowLayout.marginRight = 3;
            this.marginRight.select(1);
        }
        try {
            this.rowLayout.marginLeft = Integer.valueOf(this.marginLeft.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.rowLayout.marginLeft = 3;
            this.marginLeft.select(1);
        }
        try {
            this.rowLayout.marginTop = Integer.valueOf(this.marginTop.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.rowLayout.marginTop = 3;
            this.marginTop.select(1);
        }
        try {
            this.rowLayout.marginBottom = Integer.valueOf(this.marginBottom.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.rowLayout.marginBottom = 3;
            this.marginBottom.select(1);
        }
        try {
            this.rowLayout.spacing = Integer.valueOf(this.spacing.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.rowLayout.spacing = 3;
            this.spacing.select(1);
        }
        this.rowLayout.wrap = this.wrap.getSelection();
        this.rowLayout.pack = this.pack.getSelection();
        this.rowLayout.justify = this.justify.getSelection();
    }
}

