/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.layoutexample;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.examples.layoutexample.LayoutExample;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

abstract class Tab {
    Composite tabFolderPage;
    SashForm sash;
    Group layoutGroup;
    Group controlGroup;
    Group childGroup;
    Composite layoutComposite;
    String[] names;
    Control[] children;
    Button size;
    Button add;
    Button delete;
    Button clear;
    Button code;
    Table table;
    int index;
    TableItem newItem;
    TableItem lastSelected;
    Vector data = new Vector();
    final LayoutExample instance;
    SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Tab.this.resetEditors();
        }
    };
    TraverseListener traverseListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent traverseEvent) {
            if (traverseEvent.detail == 4) {
                traverseEvent.doit = false;
                Tab.this.resetEditors();
            }
        }
    };

    Tab(LayoutExample layoutExample) {
        this.instance = layoutExample;
    }

    void createChildGroup() {
        this.childGroup = new Group((Composite)this.controlGroup, 0);
        this.childGroup.setText(LayoutExample.getResourceString("Children"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.childGroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.childGroup.setLayoutData((Object)gridData);
        this.createChildWidgets();
    }

    void createChildWidgets() {
        this.add = new Button((Composite)this.childGroup, 8);
        this.add.setText(LayoutExample.getResourceString("Add"));
        this.add.setLayoutData((Object)new GridData(768));
        this.delete = new Button((Composite)this.childGroup, 8);
        this.delete.setText(LayoutExample.getResourceString("Delete"));
        this.delete.setLayoutData((Object)new GridData(768));
        this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Tab.this.resetEditors();
                int[] nArray = Tab.this.table.getSelectionIndices();
                Tab.this.table.remove(nArray);
                for (int i = 0; i < Tab.this.table.getItemCount(); ++i) {
                    Tab.this.table.getItem(i).setText(0, String.valueOf(i));
                }
                Tab.this.refreshLayoutComposite();
                Tab.this.layoutComposite.layout(true);
                Tab.this.layoutGroup.layout(true);
            }
        });
        this.clear = new Button((Composite)this.childGroup, 8);
        this.clear.setText(LayoutExample.getResourceString("Clear"));
        this.clear.setLayoutData((Object)new GridData(768));
        this.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Tab.this.resetEditors();
                Tab.this.children = Tab.this.layoutComposite.getChildren();
                for (int i = 0; i < Tab.this.children.length; ++i) {
                    Tab.this.children[i].dispose();
                }
                Tab.this.table.removeAll();
                Tab.this.data.clear();
                Tab.this.children = new Control[0];
                Tab.this.layoutGroup.layout(true);
            }
        });
        this.table = new Table((Composite)this.childGroup, 101122);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 150;
        this.table.setLayoutData((Object)gridData);
        this.table.addTraverseListener(this.traverseListener);
        String[] stringArray = this.getLayoutDataFieldNames();
        for (int i = 0; i < stringArray.length; ++i) {
            TableColumn tableColumn = new TableColumn(this.table, 0);
            tableColumn.setText(stringArray[i]);
            if (i == 0) {
                tableColumn.setWidth(20);
                continue;
            }
            if (i == 1) {
                tableColumn.setWidth(80);
                continue;
            }
            tableColumn.pack();
        }
    }

    void createComboEditor(CCombo cCombo, TableEditor tableEditor) {
        cCombo.setItems(new String[]{"Button", "Canvas", "Combo", "Composite", "CoolBar", "Group", "Label", "List", "ProgressBar", "Scale", "Slider", "StyledText", "Table", "Text", "ToolBar", "Tree"});
        cCombo.setText(this.newItem.getText(1));
        tableEditor.horizontalAlignment = 16384;
        tableEditor.grabHorizontal = true;
        tableEditor.minimumWidth = 50;
        tableEditor.setEditor((Control)cCombo, this.newItem, 1);
        cCombo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 16 || traverseEvent.detail == 4) {
                    Tab.this.resetEditors();
                }
                if (traverseEvent.detail == 2) {
                    Tab.this.disposeEditors();
                }
            }
        });
    }

    void createControlGroup() {
        this.controlGroup = new Group((Composite)this.sash, 0);
        this.controlGroup.setText(LayoutExample.getResourceString("Parameters"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.controlGroup.setLayout((Layout)gridLayout);
        this.size = new Button((Composite)this.controlGroup, 32);
        this.size.setText(LayoutExample.getResourceString("Preferred_Size"));
        this.size.setSelection(false);
        this.size.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Tab.this.resetEditors();
                if (Tab.this.size.getSelection()) {
                    Tab.this.layoutComposite.setLayoutData((Object)new GridData());
                    Tab.this.layoutGroup.layout(true);
                } else {
                    Tab.this.layoutComposite.setLayoutData((Object)new GridData(1808));
                    Tab.this.layoutGroup.layout(true);
                }
            }
        });
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.size.setLayoutData((Object)gridData);
        this.createControlWidgets();
    }

    void createControlWidgets() {
        this.createChildGroup();
        this.code = new Button((Composite)this.controlGroup, 8);
        this.code.setText(LayoutExample.getResourceString("Code"));
        GridData gridData = new GridData(576);
        gridData.horizontalSpan = 2;
        this.code.setLayoutData((Object)gridData);
        this.code.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                final Shell shell = new Shell();
                shell.setText(LayoutExample.getResourceString("Generated_Code"));
                shell.setLayout((Layout)new FillLayout());
                final StyledText styledText = new StyledText((Composite)shell, 2818);
                String string = Tab.this.generateCode().toString();
                if (string.length() == 0) {
                    return;
                }
                styledText.setText(string);
                Menu menu = new Menu((Decorations)shell, 2);
                shell.setMenuBar(menu);
                MenuItem menuItem = new MenuItem(menu, 64);
                menuItem.setText(LayoutExample.getResourceString("Edit"));
                Menu menu2 = new Menu(menu);
                MenuItem menuItem2 = new MenuItem(menu2, 8);
                menuItem2.setText(LayoutExample.getResourceString("Select_All"));
                menuItem2.setAccelerator(SWT.MOD1 + 65);
                menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        styledText.selectAll();
                    }
                });
                MenuItem menuItem3 = new MenuItem(menu2, 8);
                menuItem3.setText(LayoutExample.getResourceString("Copy"));
                menuItem3.setAccelerator(SWT.MOD1 + 67);
                menuItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        styledText.copy();
                    }
                });
                MenuItem menuItem4 = new MenuItem(menu2, 8);
                menuItem4.setText(LayoutExample.getResourceString("Exit"));
                menuItem4.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        shell.close();
                    }
                });
                menuItem.setMenu(menu2);
                shell.pack();
                shell.setSize(400, 500);
                shell.open();
                Display display = shell.getDisplay();
                while (!shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    void createLayout() {
    }

    void createLayoutComposite() {
        this.layoutComposite = new Composite((Composite)this.layoutGroup, 2048);
        this.layoutComposite.setLayoutData((Object)new GridData(1808));
        this.createLayout();
    }

    void createLayoutGroup() {
        this.layoutGroup = new Group((Composite)this.sash, 0);
        this.layoutGroup.setText(LayoutExample.getResourceString("Layout"));
        this.layoutGroup.setLayout((Layout)new GridLayout());
        this.createLayoutComposite();
    }

    Composite createTabFolderPage(TabFolder tabFolder) {
        this.tabFolderPage = new Composite((Composite)tabFolder, 0);
        this.tabFolderPage.setLayout((Layout)new FillLayout());
        this.sash = new SashForm(this.tabFolderPage, 256);
        this.createLayoutGroup();
        this.createControlGroup();
        return this.tabFolderPage;
    }

    void createTextEditor(Text text, TableEditor tableEditor, int n) {
        text.setFont(this.table.getFont());
        text.selectAll();
        tableEditor.horizontalAlignment = 16384;
        tableEditor.grabHorizontal = true;
        tableEditor.setEditor((Control)text, this.newItem, n);
        text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 16) {
                    Tab.this.resetEditors(true);
                }
                if (traverseEvent.detail == 2) {
                    Tab.this.disposeEditors();
                }
            }
        });
    }

    void disposeEditors() {
    }

    StringBuffer generateCode() {
        this.resetEditors();
        this.names = new String[this.children.length];
        for (int i = 0; i < this.children.length; ++i) {
            Control control = this.children[i];
            String string = control.getClass().toString();
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            this.names[i] = string2.toLowerCase() + i;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("import org.eclipse.swt.*;\n");
        stringBuffer.append("import org.eclipse.swt.custom.*;\n");
        stringBuffer.append("import org.eclipse.swt.graphics.*;\n");
        stringBuffer.append("import org.eclipse.swt.layout.*;\n");
        stringBuffer.append("import org.eclipse.swt.widgets.*;\n\n");
        stringBuffer.append("public class MyLayout {\n");
        stringBuffer.append("\tpublic static void main (String [] args) {\n");
        stringBuffer.append("\t\tDisplay display = new Display ();\n");
        stringBuffer.append("\t\tShell shell = new Shell (display);\n");
        stringBuffer.append(this.generateLayoutCode());
        stringBuffer.append("\n\t\tshell.pack ();\n\t\tshell.open ();\n\n");
        stringBuffer.append("\t\twhile (!shell.isDisposed ()) {\n");
        stringBuffer.append("\t\t\tif (!display.readAndDispatch ())\n");
        stringBuffer.append("\t\t\t\tdisplay.sleep ();\n\t\t}\n\t\tdisplay.dispose ();\n\t}\n}");
        return stringBuffer;
    }

    StringBuffer generateLayoutCode() {
        return new StringBuffer();
    }

    StringBuffer getChildCode(Control control, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = control.getClass().toString();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        String string3 = string2.equals("Button") ? "SWT.PUSH" : (string2.equals("Text") ? "SWT.BORDER" : (string2.equals("StyledText") ? "SWT.MULTI | SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL" : (string2.equals("Canvas") || string2.equals("Composite") || string2.equals("Table") || string2.equals("StyledText") || string2.equals("ToolBar") || string2.equals("Tree") || string2.equals("List") ? "SWT.BORDER" : "SWT.NONE")));
        stringBuffer.append("\n\t\t" + string2 + " " + this.names[n] + " = new " + string2 + " (shell, " + string3 + ");\n");
        if (string2.equals("Combo") || string2.equals("List")) {
            stringBuffer.append("\t\t" + this.names[n] + ".setItems (new String [] {\"Item 1\", \"Item 2\", \"Item 2\"});\n");
        } else if (string2.equals("Table")) {
            stringBuffer.append("\t\t" + this.names[n] + ".setLinesVisible (true);\n");
            for (int i = 1; i < 3; ++i) {
                stringBuffer.append("\t\tTableItem tableItem" + i + " = new TableItem (" + this.names[n] + ", SWT.NONE);\n");
                stringBuffer.append("\t\ttableItem" + i + ".setText (\"Item" + i + "\");\n");
            }
        } else if (string2.equals("Tree")) {
            for (int i = 1; i < 3; ++i) {
                stringBuffer.append("\t\tTreeItem treeItem" + i + " = new TreeItem (" + this.names[n] + ", SWT.NONE);\n");
                stringBuffer.append("\t\ttreeItem" + i + ".setText (\"Item" + i + "\");\n");
            }
        } else if (string2.equals("ToolBar")) {
            for (int i = 1; i < 3; ++i) {
                stringBuffer.append("\t\tToolItem toolItem" + i + " = new ToolItem (" + this.names[n] + ", SWT.NONE);\n");
                stringBuffer.append("\t\ttoolItem" + i + ".setText (\"Item" + i + "\");\n");
            }
        } else if (string2.equals("CoolBar")) {
            stringBuffer.append("\t\tToolBar coolToolBar = new ToolBar (" + this.names[n] + ", SWT.BORDER);\n");
            stringBuffer.append("\t\tToolItem coolToolItem = new ToolItem (coolToolBar, SWT.NONE);\n");
            stringBuffer.append("\t\tcoolToolItem.setText (\"Item 1\");\n");
            stringBuffer.append("\t\tcoolToolItem = new ToolItem (coolToolBar, SWT.NONE);\n");
            stringBuffer.append("\t\tcoolToolItem.setText (\"Item 2\");\n");
            stringBuffer.append("\t\tCoolItem coolItem1 = new CoolItem (" + this.names[n] + ", SWT.NONE);\n");
            stringBuffer.append("\t\tcoolItem1.setControl (coolToolBar);\n");
            stringBuffer.append("\t\tPoint size = coolToolBar.computeSize (SWT.DEFAULT, SWT.DEFAULT);\n");
            stringBuffer.append("\t\tcoolItem1.setSize (coolItem1.computeSize (size.x, size.y));\n");
            stringBuffer.append("\t\tcoolToolBar = new ToolBar (" + this.names[n] + ", SWT.BORDER);\n");
            stringBuffer.append("\t\tcoolToolItem = new ToolItem (coolToolBar, SWT.NONE);\n");
            stringBuffer.append("\t\tcoolToolItem.setText (\"Item 3\");\n");
            stringBuffer.append("\t\tcoolToolItem = new ToolItem (coolToolBar, SWT.NONE);\n");
            stringBuffer.append("\t\tcoolToolItem.setText (\"Item 4\");\n");
            stringBuffer.append("\t\tCoolItem coolItem2 = new CoolItem (" + this.names[n] + ", SWT.NONE);\n");
            stringBuffer.append("\t\tcoolItem2.setControl (coolToolBar);\n");
            stringBuffer.append("\t\tsize = coolToolBar.computeSize (SWT.DEFAULT, SWT.DEFAULT);\n");
            stringBuffer.append("\t\tcoolItem2.setSize (coolItem2.computeSize (size.x, size.y));\n");
            stringBuffer.append("\t\t" + this.names[n] + ".setSize (" + this.names[n] + ".computeSize (SWT.DEFAULT, SWT.DEFAULT));\n");
        } else if (string2.equals("ProgressBar")) {
            stringBuffer.append("\t\t" + this.names[n] + ".setSelection (50);\n");
        }
        if (string2.equals("Button") || string2.equals("Combo") || string2.equals("Group") || string2.equals("Label") || string2.equals("StyledText") || string2.equals("Text")) {
            stringBuffer.append("\t\t" + this.names[n] + ".setText (\"" + this.names[n] + "\");\n");
        }
        return stringBuffer;
    }

    String[] getLayoutDataFieldNames() {
        return new String[0];
    }

    String getTabText() {
        return "";
    }

    void refreshLayoutComposite() {
        this.children = this.layoutComposite.getChildren();
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].dispose();
        }
        TableItem[] tableItemArray = this.table.getItems();
        this.children = new Control[tableItemArray.length];
        String[] stringArray = new String[]{LayoutExample.getResourceString("Item", new String[]{"1"}), LayoutExample.getResourceString("Item", new String[]{"2"}), LayoutExample.getResourceString("Item", new String[]{"3"})};
        for (int i = 0; i < tableItemArray.length; ++i) {
            ToolItem toolItem;
            ToolBar toolBar;
            Button button;
            String string = tableItemArray[i].getText(1);
            if (string.equals("Button")) {
                button = new Button(this.layoutComposite, 8);
                button.setText(LayoutExample.getResourceString("Button_Index", new String[]{Integer.valueOf(i).toString()}));
                this.children[i] = button;
                continue;
            }
            if (string.equals("Canvas")) {
                button = new Canvas(this.layoutComposite, 2048);
                this.children[i] = button;
                continue;
            }
            if (string.equals("Combo")) {
                button = new Combo(this.layoutComposite, 0);
                button.setItems(stringArray);
                button.setText(LayoutExample.getResourceString("Combo_Index", new String[]{Integer.valueOf(i).toString()}));
                this.children[i] = button;
                continue;
            }
            if (string.equals("Composite")) {
                button = new Composite(this.layoutComposite, 2048);
                this.children[i] = button;
                continue;
            }
            if (string.equals("CoolBar")) {
                button = new CoolBar(this.layoutComposite, 0);
                toolBar = new ToolBar((Composite)button, 2048);
                toolItem = new ToolItem(toolBar, 0);
                toolItem.setText(LayoutExample.getResourceString("Item", new String[]{"1"}));
                toolItem = new ToolItem(toolBar, 0);
                toolItem.setText(LayoutExample.getResourceString("Item", new String[]{"2"}));
                CoolItem coolItem = new CoolItem((CoolBar)button, 0);
                coolItem.setControl((Control)toolBar);
                toolBar = new ToolBar((Composite)button, 2048);
                toolItem = new ToolItem(toolBar, 0);
                toolItem.setText(LayoutExample.getResourceString("Item", new String[]{"3"}));
                toolItem = new ToolItem(toolBar, 0);
                toolItem.setText(LayoutExample.getResourceString("Item", new String[]{"4"}));
                CoolItem coolItem2 = new CoolItem((CoolBar)button, 0);
                coolItem2.setControl((Control)toolBar);
                Point point = toolBar.computeSize(-1, -1);
                coolItem.setSize(coolItem.computeSize(point.x, point.y));
                coolItem2.setSize(coolItem2.computeSize(point.x, point.y));
                button.setSize(button.computeSize(-1, -1));
                this.children[i] = button;
                continue;
            }
            if (string.equals("Group")) {
                button = new Group(this.layoutComposite, 0);
                button.setText(LayoutExample.getResourceString("Group_Index", new String[]{Integer.valueOf(i).toString()}));
                this.children[i] = button;
                continue;
            }
            if (string.equals("Label")) {
                button = new Label(this.layoutComposite, 0);
                button.setText(LayoutExample.getResourceString("Label_Index", new String[]{Integer.valueOf(i).toString()}));
                this.children[i] = button;
                continue;
            }
            if (string.equals("List")) {
                button = new List(this.layoutComposite, 2048);
                button.setItems(stringArray);
                this.children[i] = button;
                continue;
            }
            if (string.equals("ProgressBar")) {
                button = new ProgressBar(this.layoutComposite, 0);
                button.setSelection(50);
                this.children[i] = button;
                continue;
            }
            if (string.equals("Scale")) {
                button = new Scale(this.layoutComposite, 0);
                this.children[i] = button;
                continue;
            }
            if (string.equals("Slider")) {
                button = new Slider(this.layoutComposite, 0);
                this.children[i] = button;
                continue;
            }
            if (string.equals("StyledText")) {
                button = new StyledText(this.layoutComposite, 2818);
                button.setText(LayoutExample.getResourceString("StyledText_Index", new String[]{Integer.valueOf(i).toString()}));
                this.children[i] = button;
                continue;
            }
            if (string.equals("Table")) {
                button = new Table(this.layoutComposite, 2048);
                button.setLinesVisible(true);
                toolBar = new TableItem((Table)button, 0);
                toolBar.setText(LayoutExample.getResourceString("Item", new String[]{"1"}));
                toolItem = new TableItem((Table)button, 0);
                toolItem.setText(LayoutExample.getResourceString("Item", new String[]{"2"}));
                this.children[i] = button;
                continue;
            }
            if (string.equals("Text")) {
                button = new Text(this.layoutComposite, 2048);
                button.setText(LayoutExample.getResourceString("Text_Index", new String[]{Integer.valueOf(i).toString()}));
                this.children[i] = button;
                continue;
            }
            if (string.equals("ToolBar")) {
                button = new ToolBar(this.layoutComposite, 2048);
                toolBar = new ToolItem((ToolBar)button, 0);
                toolBar.setText(LayoutExample.getResourceString("Item", new String[]{"1"}));
                toolItem = new ToolItem((ToolBar)button, 0);
                toolItem.setText(LayoutExample.getResourceString("Item", new String[]{"2"}));
                this.children[i] = button;
                continue;
            }
            button = new Tree(this.layoutComposite, 2048);
            toolBar = new TreeItem((Tree)button, 0);
            toolBar.setText(LayoutExample.getResourceString("Item", new String[]{"1"}));
            toolItem = new TreeItem((Tree)button, 0);
            toolItem.setText(LayoutExample.getResourceString("Item", new String[]{"2"}));
            this.children[i] = button;
        }
    }

    void resetEditors() {
        this.resetEditors(false);
    }

    void resetEditors(boolean bl) {
    }

    void setLayoutData() {
    }

    void setLayoutState() {
    }
}

