/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.examples.paint.BasicPaintSession;
import org.eclipse.swt.examples.paint.PaintExample;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public abstract class ContinuousPaintSession
extends BasicPaintSession {
    private boolean dragInProgress = false;
    private Point[] points = new Point[]{new Point(-1, -1), new Point(-1, -1)};
    private int retriggerInterval = 0;
    protected Runnable retriggerHandler = null;

    protected ContinuousPaintSession(PaintSurface paintSurface) {
        super(paintSurface);
    }

    public void setRetriggerTimer(int n) {
        this.retriggerInterval = n;
    }

    @Override
    public void beginSession() {
        this.getPaintSurface().setStatusMessage(PaintExample.getResourceString("session.ContinuousPaint.message"));
        this.dragInProgress = false;
    }

    @Override
    public void endSession() {
        this.abortRetrigger();
    }

    @Override
    public void resetSession() {
        this.abortRetrigger();
    }

    public final void mouseDown(MouseEvent mouseEvent) {
        if (mouseEvent.button != 1) {
            return;
        }
        if (this.dragInProgress) {
            return;
        }
        this.dragInProgress = true;
        this.points[0].x = mouseEvent.x;
        this.points[0].y = mouseEvent.y;
        this.render(this.points[0]);
        this.prepareRetrigger();
    }

    public final void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public final void mouseUp(MouseEvent mouseEvent) {
        if (mouseEvent.button != 1) {
            return;
        }
        if (!this.dragInProgress) {
            return;
        }
        this.abortRetrigger();
        this.mouseSegmentFinished(mouseEvent);
        this.dragInProgress = false;
    }

    public final void mouseMove(MouseEvent mouseEvent) {
        PaintSurface paintSurface = this.getPaintSurface();
        paintSurface.setStatusCoord(paintSurface.getCurrentPosition());
        if (!this.dragInProgress) {
            return;
        }
        this.mouseSegmentFinished(mouseEvent);
        this.prepareRetrigger();
    }

    private final void mouseSegmentFinished(MouseEvent mouseEvent) {
        if (this.points[0].x == -1) {
            return;
        }
        if (this.points[0].x != mouseEvent.x || this.points[0].y != mouseEvent.y) {
            this.points[1].x = mouseEvent.x;
            this.points[1].y = mouseEvent.y;
            this.renderContinuousSegment();
        }
    }

    protected void renderContinuousSegment() {
        int n = this.points[1].x - this.points[0].x;
        int n2 = this.points[1].y - this.points[0].y;
        int n3 = Math.abs(n);
        int n4 = Math.abs(n2);
        if (n == 0 && n2 == 0) {
            return;
        }
        if (n4 > n3) {
            int n5 = (n << 16) / n4;
            int n6 = n2 > 0 ? 1 : -1;
            int n7 = this.points[0].x << 16;
            while (--n4 >= 0) {
                this.points[0].y += n6;
                this.points[0].x = (n7 += n5) >> 16;
                this.render(this.points[0]);
            }
            if (this.points[0].x == this.points[1].x) {
                return;
            }
            this.points[0].x = this.points[1].x;
        } else {
            int n8 = (n2 << 16) / n3;
            int n9 = n > 0 ? 1 : -1;
            int n10 = this.points[0].y << 16;
            while (--n3 >= 0) {
                this.points[0].x += n9;
                this.points[0].y = (n10 += n8) >> 16;
                this.render(this.points[0]);
            }
            if (this.points[0].y == this.points[1].y) {
                return;
            }
            this.points[0].y = this.points[1].y;
        }
        this.render(this.points[0]);
    }

    private final void prepareRetrigger() {
        if (this.retriggerInterval > 0) {
            Display display = this.getPaintSurface().getDisplay();
            this.retriggerHandler = new Runnable(){

                @Override
                public void run() {
                    if (ContinuousPaintSession.this.retriggerHandler == this) {
                        ContinuousPaintSession.this.render(ContinuousPaintSession.this.points[0]);
                        ContinuousPaintSession.this.prepareRetrigger();
                    }
                }
            };
            display.timerExec(this.retriggerInterval, this.retriggerHandler);
        }
    }

    private final void abortRetrigger() {
        this.retriggerHandler = null;
    }

    protected abstract void render(Point var1);
}

