/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.paint.AirbrushTool;
import org.eclipse.swt.examples.paint.EllipseTool;
import org.eclipse.swt.examples.paint.LineTool;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.examples.paint.PaintTool;
import org.eclipse.swt.examples.paint.PencilTool;
import org.eclipse.swt.examples.paint.PolyLineTool;
import org.eclipse.swt.examples.paint.RectangleTool;
import org.eclipse.swt.examples.paint.RoundedRectangleTool;
import org.eclipse.swt.examples.paint.TextTool;
import org.eclipse.swt.examples.paint.Tool;
import org.eclipse.swt.examples.paint.ToolSettings;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class PaintExample {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_paint");
    private Composite mainComposite;
    private Canvas activeForegroundColorCanvas;
    private Canvas activeBackgroundColorCanvas;
    private Color paintColorBlack;
    private Color paintColorWhite;
    private Color[] paintColors;
    private Font paintDefaultFont;
    private static final int numPaletteRows = 3;
    private static final int numPaletteCols = 50;
    private ToolSettings toolSettings;
    private PaintSurface paintSurface;
    static final int Pencil_tool = 0;
    static final int Airbrush_tool = 1;
    static final int Line_tool = 2;
    static final int PolyLine_tool = 3;
    static final int Rectangle_tool = 4;
    static final int RoundedRectangle_tool = 5;
    static final int Ellipse_tool = 6;
    static final int Text_tool = 7;
    static final int None_fill = 8;
    static final int Outline_fill = 9;
    static final int Solid_fill = 10;
    static final int Solid_linestyle = 11;
    static final int Dash_linestyle = 12;
    static final int Dot_linestyle = 13;
    static final int DashDot_linestyle = 14;
    static final int Font_options = 15;
    static final int Default_tool = 0;
    static final int Default_fill = 8;
    static final int Default_linestyle = 11;
    public static final Tool[] tools = new Tool[]{new Tool(0, "Pencil", "tool", 16), new Tool(1, "Airbrush", "tool", 16), new Tool(2, "Line", "tool", 16), new Tool(3, "PolyLine", "tool", 16), new Tool(4, "Rectangle", "tool", 16), new Tool(5, "RoundedRectangle", "tool", 16), new Tool(6, "Ellipse", "tool", 16), new Tool(7, "Text", "tool", 16), new Tool(8, "None", "fill", 16, 0), new Tool(9, "Outline", "fill", 16, 1), new Tool(10, "Solid", "fill", 16, 2), new Tool(11, "Solid", "linestyle", 16, 1), new Tool(12, "Dash", "linestyle", 16, 2), new Tool(13, "Dot", "linestyle", 16, 3), new Tool(14, "DashDot", "linestyle", 16, 4), new Tool(15, "Font", "options", 8)};

    public PaintExample(Composite composite) {
        this.mainComposite = composite;
        this.initResources();
        this.initActions();
        this.init();
    }

    public static void main(String[] stringArray) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText(PaintExample.getResourceString("window.title"));
        shell.setLayout((Layout)new GridLayout());
        PaintExample paintExample = new PaintExample((Composite)shell);
        paintExample.createToolBar((Composite)shell);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        paintExample.createGUI(composite);
        paintExample.setDefaults();
        PaintExample.setShellSize(display, shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        paintExample.dispose();
    }

    private void createToolBar(Composite composite) {
        ToolBar toolBar = new ToolBar(composite, 0);
        String string = null;
        for (int i = 0; i < tools.length; ++i) {
            Tool tool = tools[i];
            if (string != null && !tool.group.equals(string)) {
                new ToolItem(toolBar, 2);
            }
            string = tool.group;
            ToolItem toolItem = this.addToolItem(toolBar, tool);
            if (i != 0 && i != 8 && i != 11) continue;
            toolItem.setSelection(true);
        }
    }

    private ToolItem addToolItem(ToolBar toolBar, final Tool tool) {
        final String string = tool.group + '.' + tool.name;
        ToolItem toolItem = new ToolItem(toolBar, tool.type);
        toolItem.setText(PaintExample.getResourceString(string + ".label"));
        toolItem.setToolTipText(PaintExample.getResourceString(string + ".tooltip"));
        toolItem.setImage(tool.image);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                tool.action.run();
            }
        });
        final int n = toolBar.indexOf(toolItem);
        toolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                if (accessibleEvent.childID == n) {
                    accessibleEvent.result = PaintExample.getResourceString(string + ".description");
                }
            }
        });
        return toolItem;
    }

    public void setDefaults() {
        this.setPaintTool(0);
        this.setFillType(8);
        this.setLineStyle(11);
        this.setForegroundColor(this.paintColorBlack);
        this.setBackgroundColor(this.paintColorWhite);
    }

    public void createGUI(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        Canvas canvas = new Canvas(composite2, 1313536);
        GridData gridData = new GridData(1808);
        canvas.setLayoutData((Object)gridData);
        canvas.setBackground(this.paintColorWhite);
        Composite composite3 = new Composite(composite2, 0);
        gridData = new GridData(784);
        composite3.setLayoutData((Object)gridData);
        Composite composite4 = new Composite(composite2, 0);
        gridData = new GridData(784);
        composite4.setLayoutData((Object)gridData);
        Text text = new Text(composite2, 2060);
        gridData = new GridData(784);
        text.setLayoutData((Object)gridData);
        this.paintSurface = new PaintSurface(canvas, text, this.paintColorWhite);
        PaintExample.tools[0].data = new PencilTool(this.toolSettings, this.paintSurface);
        PaintExample.tools[1].data = new AirbrushTool(this.toolSettings, this.paintSurface);
        PaintExample.tools[2].data = new LineTool(this.toolSettings, this.paintSurface);
        PaintExample.tools[3].data = new PolyLineTool(this.toolSettings, this.paintSurface);
        PaintExample.tools[4].data = new RectangleTool(this.toolSettings, this.paintSurface);
        PaintExample.tools[5].data = new RoundedRectangleTool(this.toolSettings, this.paintSurface);
        PaintExample.tools[6].data = new EllipseTool(this.toolSettings, this.paintSurface);
        PaintExample.tools[7].data = new TextTool(this.toolSettings, this.paintSurface);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        this.activeForegroundColorCanvas = new Canvas(composite3, 2048);
        gridData = new GridData(256);
        gridData.heightHint = 24;
        gridData.widthHint = 24;
        this.activeForegroundColorCanvas.setLayoutData((Object)gridData);
        this.activeBackgroundColorCanvas = new Canvas(composite3, 2048);
        gridData = new GridData(256);
        gridData.heightHint = 24;
        gridData.widthHint = 24;
        this.activeBackgroundColorCanvas.setLayoutData((Object)gridData);
        final Canvas canvas2 = new Canvas(composite3, 264192);
        gridData = new GridData(768);
        gridData.heightHint = 24;
        canvas2.setLayoutData((Object)gridData);
        canvas2.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = canvas2.getClientArea();
                Color color = this.getColorAt(rectangle, event.x, event.y);
                if (event.button == 1) {
                    PaintExample.this.setForegroundColor(color);
                } else {
                    PaintExample.this.setBackgroundColor(color);
                }
            }

            private Color getColorAt(Rectangle rectangle, int n, int n2) {
                if (rectangle.height <= 1 && rectangle.width <= 1) {
                    return PaintExample.this.paintColorWhite;
                }
                int n3 = (n2 - rectangle.y) * 3 / rectangle.height;
                int n4 = (n - rectangle.x) * 50 / rectangle.width;
                return PaintExample.this.paintColors[Math.min(Math.max(n3 * 50 + n4, 0), PaintExample.this.paintColors.length - 1)];
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.gc == null) {
                    return;
                }
                Rectangle rectangle = canvas2.getClientArea();
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 50; ++j) {
                        int n = rectangle.width * j / 50;
                        int n2 = rectangle.height * i / 3;
                        int n3 = Math.max(rectangle.width * (j + 1) / 50 - n, 1);
                        int n4 = Math.max(rectangle.height * (i + 1) / 3 - n2, 1);
                        event.gc.setBackground(PaintExample.this.paintColors[i * 50 + j]);
                        event.gc.fillRectangle(rectangle.x + n, rectangle.y + n2, n3, n4);
                    }
                }
            }
        };
        canvas2.addListener(11, listener);
        canvas2.addListener(9, listener);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite4.setLayout((Layout)gridLayout);
        Label label = new Label(composite4, 0);
        label.setText(PaintExample.getResourceString("settings.AirbrushRadius.text"));
        final Scale scale = new Scale(composite4, 256);
        scale.setMinimum(5);
        scale.setMaximum(50);
        scale.setSelection(this.toolSettings.airbrushRadius);
        scale.setLayoutData((Object)new GridData(784));
        scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ((PaintExample)PaintExample.this).toolSettings.airbrushRadius = scale.getSelection();
                PaintExample.this.updateToolSettings();
            }
        });
        label = new Label(composite4, 0);
        label.setText(PaintExample.getResourceString("settings.AirbrushIntensity.text"));
        final Scale scale2 = new Scale(composite4, 256);
        scale2.setMinimum(1);
        scale2.setMaximum(100);
        scale2.setSelection(this.toolSettings.airbrushIntensity);
        scale2.setLayoutData((Object)new GridData(784));
        scale2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ((PaintExample)PaintExample.this).toolSettings.airbrushIntensity = scale2.getSelection();
                PaintExample.this.updateToolSettings();
            }
        });
    }

    public void dispose() {
        if (this.paintSurface != null) {
            this.paintSurface.dispose();
        }
        if (this.paintColors != null) {
            for (int i = 0; i < this.paintColors.length; ++i) {
                Color color = this.paintColors[i];
                if (color == null) continue;
                color.dispose();
            }
        }
        this.paintDefaultFont = null;
        this.paintColors = null;
        this.paintSurface = null;
        this.freeResources();
    }

    public void freeResources() {
        for (int i = 0; i < tools.length; ++i) {
            Tool tool = tools[i];
            Image image = tool.image;
            if (image != null) {
                image.dispose();
            }
            tool.image = null;
        }
    }

    public Display getDisplay() {
        return this.mainComposite.getDisplay();
    }

    public static String getResourceString(String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + string + "!";
        }
    }

    public static String getResourceString(String string, Object[] objectArray) {
        try {
            return MessageFormat.format(PaintExample.getResourceString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + string + "!";
        }
    }

    private void init() {
        Display display = this.mainComposite.getDisplay();
        this.paintColorWhite = new Color((Device)display, 255, 255, 255);
        this.paintColorBlack = new Color((Device)display, 0, 0, 0);
        this.paintDefaultFont = display.getSystemFont();
        this.paintColors = new Color[150];
        this.paintColors[0] = this.paintColorBlack;
        this.paintColors[1] = this.paintColorWhite;
        for (int i = 2; i < this.paintColors.length; ++i) {
            this.paintColors[i] = new Color((Device)display, i * 7 % 255, i * 23 % 255, i * 51 % 255);
        }
        this.toolSettings = new ToolSettings();
        this.toolSettings.commonForegroundColor = this.paintColorBlack;
        this.toolSettings.commonBackgroundColor = this.paintColorWhite;
        this.toolSettings.commonFont = this.paintDefaultFont;
    }

    private void initActions() {
        for (int i = 0; i < tools.length; ++i) {
            final Tool tool = tools[i];
            String string = tool.group;
            if (string.equals("tool")) {
                tool.action = new Runnable(){

                    @Override
                    public void run() {
                        PaintExample.this.setPaintTool(tool.id);
                    }
                };
                continue;
            }
            if (string.equals("fill")) {
                tool.action = new Runnable(){

                    @Override
                    public void run() {
                        PaintExample.this.setFillType(tool.id);
                    }
                };
                continue;
            }
            if (string.equals("linestyle")) {
                tool.action = new Runnable(){

                    @Override
                    public void run() {
                        PaintExample.this.setLineStyle(tool.id);
                    }
                };
                continue;
            }
            if (!string.equals("options")) continue;
            tool.action = new Runnable(){

                @Override
                public void run() {
                    FontDialog fontDialog = new FontDialog(PaintExample.this.paintSurface.getShell(), 32768);
                    FontData[] fontDataArray = ((PaintExample)PaintExample.this).toolSettings.commonFont.getFontData();
                    if (fontDataArray != null && fontDataArray.length > 0) {
                        fontDialog.setFontList(fontDataArray);
                    }
                    fontDialog.setText(PaintExample.getResourceString("options.Font.dialog.title"));
                    PaintExample.this.paintSurface.hideRubberband();
                    FontData fontData = fontDialog.open();
                    PaintExample.this.paintSurface.showRubberband();
                    if (fontData != null) {
                        try {
                            Font font;
                            ((PaintExample)PaintExample.this).toolSettings.commonFont = font = new Font((Device)PaintExample.this.mainComposite.getDisplay(), fontData);
                            PaintExample.this.updateToolSettings();
                        }
                        catch (SWTException sWTException) {
                            // empty catch block
                        }
                    }
                }
            };
        }
    }

    public void initResources() {
        Class<PaintExample> clazz = PaintExample.class;
        if (resourceBundle != null) {
            try {
                for (int i = 0; i < tools.length; ++i) {
                    Tool tool = tools[i];
                    String string = tool.group + '.' + tool.name;
                    InputStream inputStream = clazz.getResourceAsStream(PaintExample.getResourceString(string + ".image"));
                    ImageData imageData = new ImageData(inputStream);
                    ImageData imageData2 = imageData.getTransparencyMask();
                    tool.image = new Image(null, imageData, imageData2);
                    try {
                        inputStream.close();
                        continue;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String string = resourceBundle != null ? PaintExample.getResourceString("error.CouldNotLoadResources") : "Unable to load resources";
        this.freeResources();
        throw new RuntimeException(string);
    }

    public void setFocus() {
        this.mainComposite.setFocus();
    }

    public void setForegroundColor(Color color) {
        if (this.activeForegroundColorCanvas != null) {
            this.activeForegroundColorCanvas.setBackground(color);
        }
        this.toolSettings.commonForegroundColor = color;
        this.updateToolSettings();
    }

    public void setBackgroundColor(Color color) {
        if (this.activeBackgroundColorCanvas != null) {
            this.activeBackgroundColorCanvas.setBackground(color);
        }
        this.toolSettings.commonBackgroundColor = color;
        this.updateToolSettings();
    }

    public void setPaintTool(int n) {
        PaintTool paintTool = (PaintTool)PaintExample.tools[n].data;
        this.paintSurface.setPaintSession(paintTool);
        this.updateToolSettings();
    }

    public void setFillType(int n) {
        Integer n2 = (Integer)PaintExample.tools[n].data;
        this.toolSettings.commonFillType = n2;
        this.updateToolSettings();
    }

    public void setLineStyle(int n) {
        Integer n2 = (Integer)PaintExample.tools[n].data;
        this.toolSettings.commonLineStyle = n2;
        this.updateToolSettings();
    }

    private static void setShellSize(Display display, Shell shell) {
        Rectangle rectangle = display.getBounds();
        Point point = shell.computeSize(-1, -1);
        if (point.x > rectangle.width) {
            point.x = rectangle.width * 9 / 10;
        }
        if (point.y > rectangle.height) {
            point.y = rectangle.height * 9 / 10;
        }
        shell.setSize(point);
    }

    private void updateToolSettings() {
        PaintTool paintTool = this.paintSurface.getPaintTool();
        if (paintTool == null) {
            return;
        }
        paintTool.endSession();
        paintTool.set(this.toolSettings);
        paintTool.beginSession();
    }
}

