/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.examples.paint.ContainerFigure;
import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.LineFigure;
import org.eclipse.swt.examples.paint.PaintExample;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.examples.paint.PaintTool;
import org.eclipse.swt.examples.paint.SegmentedPaintSession;
import org.eclipse.swt.examples.paint.SolidPolygonFigure;
import org.eclipse.swt.examples.paint.ToolSettings;
import org.eclipse.swt.graphics.Point;

public class PolyLineTool
extends SegmentedPaintSession
implements PaintTool {
    private ToolSettings settings;

    public PolyLineTool(ToolSettings toolSettings, PaintSurface paintSurface) {
        super(paintSurface);
        this.set(toolSettings);
    }

    @Override
    public void set(ToolSettings toolSettings) {
        this.settings = toolSettings;
    }

    @Override
    public String getDisplayName() {
        return PaintExample.getResourceString("tool.PolyLine.label");
    }

    @Override
    protected Figure createFigure(Point[] pointArray, int n, boolean bl) {
        ContainerFigure containerFigure = new ContainerFigure();
        if (bl && this.settings.commonFillType != 0 && n >= 3) {
            containerFigure.add(new SolidPolygonFigure(this.settings.commonBackgroundColor, pointArray, n));
        }
        if (!bl || this.settings.commonFillType != 2 || n < 3) {
            Point point;
            for (int i = 0; i < n - 1; ++i) {
                point = pointArray[i];
                Point point2 = pointArray[i + 1];
                containerFigure.add(new LineFigure(this.settings.commonForegroundColor, this.settings.commonBackgroundColor, this.settings.commonLineStyle, point.x, point.y, point2.x, point2.y));
            }
            if (bl) {
                Point point3 = pointArray[pointArray.length - 1];
                point = pointArray[0];
                containerFigure.add(new LineFigure(this.settings.commonForegroundColor, this.settings.commonBackgroundColor, this.settings.commonLineStyle, point3.x, point3.y, point.x, point.y));
            }
        }
        return containerFigure;
    }
}

