/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import java.util.Vector;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.examples.paint.BasicPaintSession;
import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.PaintExample;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.graphics.Point;

public abstract class SegmentedPaintSession
extends BasicPaintSession {
    private Vector controlPoints = new Vector();
    private Figure previousFigure = null;
    private Figure currentFigure = null;

    protected SegmentedPaintSession(PaintSurface paintSurface) {
        super(paintSurface);
    }

    @Override
    public void beginSession() {
        this.getPaintSurface().setStatusMessage(PaintExample.getResourceString("session.SegmentedInteractivePaint.message.anchorMode"));
        this.previousFigure = null;
        this.currentFigure = null;
        this.controlPoints.clear();
    }

    @Override
    public void endSession() {
        this.getPaintSurface().clearRubberbandSelection();
        if (this.previousFigure != null) {
            this.getPaintSurface().drawFigure(this.previousFigure);
        }
    }

    @Override
    public void resetSession() {
        this.getPaintSurface().clearRubberbandSelection();
        if (this.previousFigure != null) {
            this.getPaintSurface().drawFigure(this.previousFigure);
        }
        this.getPaintSurface().setStatusMessage(PaintExample.getResourceString("session.SegmentedInteractivePaint.message.anchorMode"));
        this.previousFigure = null;
        this.currentFigure = null;
        this.controlPoints.clear();
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (mouseEvent.button != 1) {
            return;
        }
        this.getPaintSurface().setStatusMessage(PaintExample.getResourceString("session.SegmentedInteractivePaint.message.interactiveMode"));
        this.previousFigure = this.currentFigure;
        if (this.controlPoints.size() > 0) {
            Point point = (Point)this.controlPoints.elementAt(this.controlPoints.size() - 1);
            if (point.x == mouseEvent.x || point.y == mouseEvent.y) {
                return;
            }
        }
        this.controlPoints.add(new Point(mouseEvent.x, mouseEvent.y));
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
        if (mouseEvent.button != 1) {
            return;
        }
        if (this.controlPoints.size() >= 2) {
            this.getPaintSurface().clearRubberbandSelection();
            this.previousFigure = this.createFigure(this.controlPoints.toArray(new Point[this.controlPoints.size()]), this.controlPoints.size(), true);
        }
        this.resetSession();
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (mouseEvent.button != 1) {
            this.resetSession();
            return;
        }
    }

    public void mouseMove(MouseEvent mouseEvent) {
        PaintSurface paintSurface = this.getPaintSurface();
        if (this.controlPoints.size() == 0) {
            paintSurface.setStatusCoord(paintSurface.getCurrentPosition());
            return;
        }
        paintSurface.setStatusCoordRange((Point)this.controlPoints.elementAt(this.controlPoints.size() - 1), paintSurface.getCurrentPosition());
        paintSurface.clearRubberbandSelection();
        Point[] pointArray = this.controlPoints.toArray(new Point[this.controlPoints.size() + 1]);
        pointArray[this.controlPoints.size()] = paintSurface.getCurrentPosition();
        this.currentFigure = this.createFigure(pointArray, pointArray.length, false);
        paintSurface.addRubberbandSelection(this.currentFigure);
    }

    protected abstract Figure createFigure(Point[] var1, int var2, boolean var3);
}

