/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.paint.BasicPaintSession;
import org.eclipse.swt.examples.paint.PaintExample;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.examples.paint.PaintTool;
import org.eclipse.swt.examples.paint.TextFigure;
import org.eclipse.swt.examples.paint.ToolSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextTool
extends BasicPaintSession
implements PaintTool {
    private ToolSettings settings;
    private String drawText = PaintExample.getResourceString("tool.Text.settings.defaulttext");

    public TextTool(ToolSettings toolSettings, PaintSurface paintSurface) {
        super(paintSurface);
        this.set(toolSettings);
    }

    @Override
    public void set(ToolSettings toolSettings) {
        this.settings = toolSettings;
    }

    @Override
    public String getDisplayName() {
        return PaintExample.getResourceString("tool.Text.label");
    }

    @Override
    public void beginSession() {
        this.getPaintSurface().setStatusMessage(PaintExample.getResourceString("session.Text.message"));
    }

    @Override
    public void endSession() {
        this.getPaintSurface().clearRubberbandSelection();
    }

    @Override
    public void resetSession() {
        this.getPaintSurface().clearRubberbandSelection();
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (mouseEvent.button == 1) {
            this.getPaintSurface().commitRubberbandSelection();
        } else {
            this.getPaintSurface().clearRubberbandSelection();
            Shell shell = this.getPaintSurface().getShell();
            final Shell shell2 = new Shell(shell, 67680);
            shell2.setText(PaintExample.getResourceString("tool.Text.dialog.title"));
            shell2.setLayout((Layout)new GridLayout());
            Label label = new Label((Composite)shell2, 0);
            label.setText(PaintExample.getResourceString("tool.Text.dialog.message"));
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            final Text text = new Text((Composite)shell2, 2052);
            text.setText(this.drawText);
            text.selectAll();
            text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Composite composite = new Composite((Composite)shell2, 0);
            GridLayout gridLayout = new GridLayout(2, true);
            gridLayout.marginWidth = 0;
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            Button button = new Button(composite, 8);
            button.setText(PaintExample.getResourceString("OK"));
            button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TextTool.this.drawText = text.getText();
                    shell2.dispose();
                }
            });
            Button button2 = new Button(composite, 8);
            button2.setText(PaintExample.getResourceString("Cancel"));
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.setDefaultButton(button);
            shell2.pack();
            shell2.open();
            Display display = shell2.getDisplay();
            while (!shell.isDisposed() && !shell2.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseUp(MouseEvent mouseEvent) {
    }

    public void mouseMove(MouseEvent mouseEvent) {
        PaintSurface paintSurface = this.getPaintSurface();
        paintSurface.setStatusCoord(paintSurface.getCurrentPosition());
        paintSurface.clearRubberbandSelection();
        paintSurface.addRubberbandSelection(new TextFigure(this.settings.commonForegroundColor, this.settings.commonFont, this.drawText, mouseEvent.x, mouseEvent.y));
    }
}

