/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.macro.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.macro.runtime.MacroContext;
import org.codehaus.groovy.macro.runtime.MacroStub;
import org.codehaus.groovy.macro.transform.MacroMethodsCache;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.transform.stc.AbstractExtensionMethodCache;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;

class MacroCallTransformingVisitor
extends ClassCodeVisitorSupport {
    private static final ClassNode MACRO_CONTEXT_CLASS_NODE = ClassHelper.make(MacroContext.class);
    private static final ClassNode MACRO_STUB_CLASS_NODE = ClassHelper.make(MacroStub.class);
    private static final PropertyExpression MACRO_STUB_INSTANCE = new PropertyExpression((Expression)new ClassExpression(MACRO_STUB_CLASS_NODE), "INSTANCE");
    private static final String MACRO_STUB_METHOD_NAME = "macroMethod";
    private static final AbstractExtensionMethodCache MACRO_METHOD_CACHE = MacroMethodsCache.INSTANCE;
    private final SourceUnit sourceUnit;
    private final CompilationUnit unit;
    private final ClassLoader classLoader;
    private static final ArrayList<Integer> exceptions = new ArrayList();

    public MacroCallTransformingVisitor(SourceUnit sourceUnit, CompilationUnit compilationUnit) {
        this.sourceUnit = sourceUnit;
        this.unit = compilationUnit;
        this.classLoader = compilationUnit.getTransformLoader();
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression methodCallExpression) {
        super.visitMethodCallExpression(methodCallExpression);
        List<Expression> list = methodCallExpression.getArguments() instanceof TupleExpression ? ((TupleExpression)methodCallExpression.getArguments()).getExpressions() : Collections.singletonList(methodCallExpression.getArguments());
        List<MethodNode> list2 = this.findMacroMethods(methodCallExpression.getMethodAsString(), list);
        if (list2.isEmpty()) {
            return;
        }
        MacroContext macroContext = new MacroContext(this.unit, this.sourceUnit, methodCallExpression);
        Object[] objectArray = new Object[list.size() + 1];
        objectArray[0] = macroContext;
        System.arraycopy(list.toArray(), 0, objectArray, 1, list.size());
        for (MethodNode methodNode : list2) {
            if (!(methodNode instanceof ExtensionMethodNode)) {
                throw new IllegalStateException(methodNode + " is not an instance of ExtensionMethodNode");
            }
            if (!this.tryMacroMethod(methodCallExpression, (ExtensionMethodNode)methodNode, objectArray)) continue;
            break;
        }
    }

    private List<MethodNode> findMacroMethods(String string, List<Expression> list) {
        int n;
        List<MethodNode> list2;
        block4: {
            list2 = null;
            try {
                list2 = MACRO_METHOD_CACHE.get(this.classLoader).get(string);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                n = noClassDefFoundError.toString().hashCode();
                if (exceptions.contains(n)) break block4;
                exceptions.add(n);
                System.err.println(noClassDefFoundError);
            }
        }
        if (list2 == null) {
            return Collections.emptyList();
        }
        ClassNode[] classNodeArray = new ClassNode[list.size()];
        for (n = 0; n < list.size(); ++n) {
            classNodeArray[n] = ClassHelper.make(list.get(n).getClass());
        }
        return StaticTypeCheckingSupport.chooseBestMethod(MACRO_CONTEXT_CLASS_NODE, list2, classNodeArray);
    }

    private boolean tryMacroMethod(MethodCallExpression methodCallExpression, ExtensionMethodNode extensionMethodNode, Object[] objectArray) {
        Expression expression = (Expression)InvokerHelper.invokeStaticMethod(extensionMethodNode.getExtensionMethodNode().getDeclaringClass().getTypeClass(), extensionMethodNode.getName(), (Object)objectArray);
        if (expression == null) {
            return false;
        }
        methodCallExpression.setObjectExpression(MACRO_STUB_INSTANCE);
        methodCallExpression.setMethod(new ConstantExpression(MACRO_STUB_METHOD_NAME));
        methodCallExpression.setSpreadSafe(false);
        methodCallExpression.setSafe(false);
        methodCallExpression.setImplicitThis(false);
        methodCallExpression.setArguments(expression);
        methodCallExpression.setGenericsTypes(GenericsType.EMPTY_ARRAY);
        return true;
    }
}

