/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.macro.transform;

import java.util.List;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodCallTransformation;
import org.codehaus.groovy.ast.TransformingCodeVisitor;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.macro.methods.MacroGroovyMethods;
import org.codehaus.groovy.macro.runtime.MacroBuilder;
import org.codehaus.groovy.macro.transform.MacroClass;
import org.codehaus.groovy.macro.transform.MacroTransformation;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CONVERSION)
public class MacroClassTransformation
extends MethodCallTransformation {
    private static final String MACRO_METHOD = "macro";
    private static final ClassNode MACROCLASS_TYPE = ClassHelper.make(MacroClass.class);
    private static final Logger LOGGER = Logger.getLogger(MacroClassTransformation.class.getName());

    @Override
    protected GroovyCodeVisitor getTransformer(ASTNode[] nodes, SourceUnit sourceUnit) {
        MacroClassTransformer transformer = new MacroClassTransformer(sourceUnit);
        return new MacroClassTransformingCodeVisitor(transformer, sourceUnit);
    }

    private static class MacroClassTransformer
    extends ClassCodeExpressionTransformer {
        private final SourceUnit sourceUnit;

        MacroClassTransformer(SourceUnit sourceUnit) {
            this.sourceUnit = sourceUnit;
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return this.sourceUnit;
        }

        @Override
        public Expression transform(Expression exp) {
            MethodCallExpression call;
            if (exp instanceof ConstructorCallExpression && (call = (MethodCallExpression)exp.getNodeMetaData(MacroTransformation.class)) != null) {
                return call;
            }
            return super.transform(exp);
        }
    }

    private static class MacroClassTransformingCodeVisitor
    extends TransformingCodeVisitor {
        private final SourceUnit sourceUnit;

        MacroClassTransformingCodeVisitor(ClassCodeExpressionTransformer transformer, SourceUnit sourceUnit) {
            super(transformer);
            this.sourceUnit = sourceUnit;
        }

        @Override
        public void visitConstructorCallExpression(ConstructorCallExpression call) {
            ClassNode type = call.getType();
            if (type instanceof InnerClassNode && ((InnerClassNode)type).isAnonymous() && MACROCLASS_TYPE.getNameWithoutPackage().equals(type.getSuperClass().getNameWithoutPackage())) {
                try {
                    String source = this.convertInnerClassToSource(type);
                    MethodCallExpression macroCall = GeneralUtils.callX((Expression)GeneralUtils.propX((Expression)GeneralUtils.classX(ClassHelper.makeWithoutCaching(MacroBuilder.class, false)), "INSTANCE"), MacroClassTransformation.MACRO_METHOD, (Expression)GeneralUtils.args(GeneralUtils.constX(source), MacroGroovyMethods.buildSubstitutions(this.sourceUnit, type), GeneralUtils.classX(ClassHelper.make(ClassNode.class))));
                    macroCall.setSpreadSafe(false);
                    macroCall.setSafe(false);
                    macroCall.setImplicitThis(false);
                    call.putNodeMetaData(MacroTransformation.class, macroCall);
                    List<ClassNode> classes = this.sourceUnit.getAST().getClasses();
                    classes.removeIf(aClass -> aClass == type || type == aClass.getOuterClass());
                }
                catch (Exception e) {
                    LOGGER.warning(DefaultGroovyMethods.asString(e));
                }
                return;
            }
            super.visitConstructorCallExpression(call);
        }

        private String convertInnerClassToSource(ClassNode type) throws Exception {
            String source = GeneralUtils.convertASTToSource(this.sourceUnit.getSource(), type);
            source = source.substring(source.indexOf(123) + 1, source.lastIndexOf(125) - 1);
            return source;
        }
    }
}

