/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import de.qfs.lib.log.Logger;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ExceptionStash;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.Graphene;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk3.GdkEventKey;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    public long handle;
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int HANDLE = 8;
    static final int DISABLED = 16;
    static final int MENU = 32;
    static final int OBSCURED = 64;
    static final int MOVED = 128;
    static final int RESIZED = 256;
    static final int ZERO_WIDTH = 512;
    static final int ZERO_HEIGHT = 1024;
    static final int HIDDEN = 2048;
    static final int FOREGROUND = 4096;
    static final int BACKGROUND = 8192;
    static final int FONT = 16384;
    static final int PARENT_BACKGROUND = 32768;
    static final int THEME_BACKGROUND = 65536;
    static final int LAYOUT_NEEDED = 131072;
    static final int LAYOUT_CHANGED = 262144;
    static final int LAYOUT_CHILD = 524288;
    static final int RELEASED = 0x100000;
    static final int DISPOSE_SENT = 0x200000;
    static final int FOREIGN_HANDLE = 0x400000;
    static final int DRAG_DETECT = 0x800000;
    static final int SKIN_NEEDED = 0x1000000;
    static final int CHECK_SUBWINDOW = 0x2000000;
    static final int HAS_AUTO_DIRECTION = 0;
    static final int AUTO_TEXT_DIRECTION = 0x6000000;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int ACTIVATE = 1;
    static final int BUTTON_PRESS_EVENT = 2;
    static final int BUTTON_PRESS_EVENT_INVERSE = 3;
    static final int BUTTON_RELEASE_EVENT = 4;
    static final int BUTTON_RELEASE_EVENT_INVERSE = 5;
    static final int CHANGED = 6;
    static final int CHANGE_VALUE = 7;
    static final int CLICKED = 8;
    static final int COMMIT = 9;
    static final int CONFIGURE_EVENT = 10;
    static final int DELETE_EVENT = 11;
    static final int DELETE_RANGE = 12;
    static final int DELETE_TEXT = 13;
    static final int ENTER_NOTIFY_EVENT = 14;
    static final int EVENT = 15;
    static final int EVENT_AFTER = 16;
    static final int EXPAND_COLLAPSE_CURSOR_ROW = 17;
    static final int EXPOSE_EVENT = 18;
    static final int DRAW = 18;
    static final int EXPOSE_EVENT_INVERSE = 19;
    static final int FOCUS = 20;
    static final int FOCUS_IN_EVENT = 21;
    static final int FOCUS_OUT_EVENT = 22;
    static final int GRAB_FOCUS = 23;
    static final int HIDE = 24;
    static final int INPUT = 25;
    static final int INSERT_TEXT = 26;
    static final int KEY_PRESS_EVENT = 27;
    static final int KEY_RELEASE_EVENT = 28;
    static final int LEAVE_NOTIFY_EVENT = 29;
    static final int MAP = 30;
    static final int MAP_EVENT = 31;
    static final int MNEMONIC_ACTIVATE = 32;
    static final int MOTION_NOTIFY_EVENT = 33;
    static final int MOTION_NOTIFY_EVENT_INVERSE = 34;
    static final int MOVE_FOCUS = 35;
    static final int OUTPUT = 36;
    static final int POPULATE_POPUP = 37;
    static final int POPUP_MENU = 38;
    static final int PREEDIT_CHANGED = 39;
    static final int REALIZE = 40;
    static final int ROW_ACTIVATED = 41;
    static final int SCROLL_CHILD = 42;
    static final int SCROLL_EVENT = 43;
    static final int SELECT = 44;
    static final int SHOW = 45;
    static final int SHOW_HELP = 46;
    static final int SIZE_ALLOCATE = 47;
    static final int STYLE_UPDATED = 48;
    static final int SWITCH_PAGE = 49;
    static final int TEST_COLLAPSE_ROW = 50;
    static final int TEST_EXPAND_ROW = 51;
    static final int TEXT_BUFFER_INSERT_TEXT = 52;
    static final int TOGGLED = 53;
    static final int UNMAP = 54;
    static final int UNMAP_EVENT = 55;
    static final int UNREALIZE = 56;
    static final int VALUE_CHANGED = 57;
    static final int WINDOW_STATE_EVENT = 59;
    static final int ACTIVATE_INVERSE = 60;
    static final int DAY_SELECTED = 61;
    static final int MONTH_CHANGED = 62;
    static final int STATUS_ICON_POPUP_MENU = 63;
    static final int ROW_INSERTED = 64;
    static final int ROW_DELETED = 65;
    static final int DAY_SELECTED_DOUBLE_CLICK = 66;
    static final int ICON_RELEASE = 67;
    static final int SELECTION_DONE = 68;
    static final int START_INTERACTIVE_SEARCH = 69;
    static final int BACKSPACE = 70;
    static final int BACKSPACE_INVERSE = 71;
    static final int COPY_CLIPBOARD = 72;
    static final int COPY_CLIPBOARD_INVERSE = 73;
    static final int CUT_CLIPBOARD = 74;
    static final int CUT_CLIPBOARD_INVERSE = 75;
    static final int PASTE_CLIPBOARD = 76;
    static final int PASTE_CLIPBOARD_INVERSE = 77;
    static final int DELETE_FROM_CURSOR = 78;
    static final int DELETE_FROM_CURSOR_INVERSE = 79;
    static final int MOVE_CURSOR = 80;
    static final int MOVE_CURSOR_INVERSE = 81;
    static final int DIRECTION_CHANGED = 82;
    static final int CREATE_MENU_PROXY = 83;
    static final int ROW_HAS_CHILD_TOGGLED = 84;
    static final int POPPED_UP = 85;
    static final int FOCUS_IN = 86;
    static final int FOCUS_OUT = 87;
    static final int IM_UPDATE = 88;
    static final int KEY_PRESSED = 89;
    static final int KEY_RELEASED = 90;
    static final int DECELERATE = 91;
    static final int SCROLL = 92;
    static final int SCROLL_BEGIN = 93;
    static final int SCROLL_END = 94;
    static final int ENTER = 95;
    static final int LEAVE = 96;
    static final int MOTION = 97;
    static final int MOTION_INVERSE = 98;
    static final int CLOSE_REQUEST = 99;
    static final int GESTURE_PRESSED = 100;
    static final int GESTURE_RELEASED = 101;
    static final int NOTIFY_STATE = 102;
    static final int SIZE_ALLOCATE_GTK4 = 103;
    static final int DPI_CHANGED = 104;
    static final int NOTIFY_DEFAULT_HEIGHT = 105;
    static final int NOTIFY_DEFAULT_WIDTH = 106;
    static final int LAST_SIGNAL = 107;
    static final String IS_ACTIVE = "org.eclipse.swt.internal.control.isactive";
    static final String KEY_CHECK_SUBWINDOW = "org.eclipse.swt.internal.control.checksubwindow";
    static final String KEY_GTK_CSS = "org.eclipse.swt.internal.gtk.css";
    static Callback gdkSeatGrabPrepareFunc;
    private static final Logger logger;

    Widget() {
    }

    public Widget(Widget widget, int n) {
        this.checkSubclass();
        this.checkParent(widget);
        this.style = n;
        this.display = widget.display;
        this.reskinWidget();
    }

    void _addListener(int n, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    public void addListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(n, listener);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)disposeListener);
        this.addListener(12, (Listener)typedListener);
    }

    long paintWindow() {
        return 0L;
    }

    long paintSurface() {
        return 0L;
    }

    long cssHandle() {
        return this.handle;
    }

    static int checkBits(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 | n3 | n4 | n5 | n6 | n7;
        if ((n & n8) == 0) {
            n |= n2;
        }
        if ((n & n2) != 0) {
            n = n & ~n8 | n2;
        }
        if ((n & n3) != 0) {
            n = n & ~n8 | n3;
        }
        if ((n & n4) != 0) {
            n = n & ~n8 | n4;
        }
        if ((n & n5) != 0) {
            n = n & ~n8 | n5;
        }
        if ((n & n6) != 0) {
            n = n & ~n8 | n6;
        }
        if ((n & n7) != 0) {
            n = n & ~n8 | n7;
        }
        return n;
    }

    long cellDataProc(long l, long l2, long l3, long l4, long l5) {
        return 0L;
    }

    void checkOpen() {
    }

    void checkOrientation(Widget widget) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && widget != null) {
            if ((widget.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((widget.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkParent(Widget widget) {
        if (widget == null) {
            this.error(4);
        }
        if (widget.isDisposed()) {
            this.error(5);
        }
        widget.checkWidget();
        widget.checkOpen();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void createHandle(int n) {
    }

    void createWidget(int n) {
        this.createHandle(n);
        this.setOrientation(true);
        this.hookEvents();
        this.register();
    }

    void deregister() {
        if (this.handle == 0L) {
            return;
        }
        if ((this.state & 8) != 0) {
            this.display.removeWidget(this.handle);
        }
    }

    void destroyWidget() {
        long l = this.topHandle();
        this.releaseHandle();
        if (l != 0L && (this.state & 8) != 0) {
            if (GTK.GTK4) {
                GTK.gtk_widget_unparent((long)l);
            } else {
                GTK3.gtk_widget_destroy((long)l);
            }
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    long dpiChanged(long l, long l2) {
        int n;
        int n2 = DPIUtil.getDeviceZoom() / 100;
        if (n2 != (n = GTK.gtk_widget_get_scale_factor((long)l))) {
            this.display.dpiChanged(n);
            Event event = new Event();
            event.type = 55;
            event.widget = this;
            event.detail = n;
            event.doit = true;
            this.notifyListeners(55, event);
        }
        return 0L;
    }

    void error(int n) {
        SWT.error(n);
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(KEY_CHECK_SUBWINDOW)) {
            return (this.state & 0x2000000) != 0;
        }
        if (string.equals(IS_ACTIVE)) {
            return this.isActive();
        }
        if ((this.state & 4) != 0) {
            Object[] objectArray = (Object[])this.data;
            for (int i = 1; i < objectArray.length; i += 2) {
                if (!string.equals(objectArray[i])) continue;
                return objectArray[i + 1];
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    public Listener[] getListeners(int n) {
        this.checkWidget();
        if (this.eventTable == null) {
            return new Listener[0];
        }
        return this.eventTable.getListeners(n);
    }

    String getName() {
        String string = this.getClass().getName();
        int n = string.length();
        while (--n > 0 && string.charAt(n) != '.') {
        }
        return string.substring(n + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    long gtk_activate(long l) {
        return 0L;
    }

    void gtk_adjustment_get(long l, GtkAdjustment gtkAdjustment) {
        gtkAdjustment.lower = GTK.gtk_adjustment_get_lower((long)l);
        gtkAdjustment.upper = GTK.gtk_adjustment_get_upper((long)l);
        gtkAdjustment.page_increment = GTK.gtk_adjustment_get_page_increment((long)l);
        gtkAdjustment.step_increment = GTK.gtk_adjustment_get_step_increment((long)l);
        gtkAdjustment.page_size = GTK.gtk_adjustment_get_page_size((long)l);
        gtkAdjustment.value = GTK.gtk_adjustment_get_value((long)l);
    }

    long gtk_button_press_event(long l, long l2) {
        return 0L;
    }

    long gtk_button_release_event(long l, long l2) {
        return 0L;
    }

    void gtk_gesture_press_event(long l, int n, double d, double d2, long l2) {
    }

    void gtk_gesture_release_event(long l, int n, double d, double d2, long l2) {
    }

    void gtk4_motion_event(long l, double d, double d2, long l2) {
    }

    boolean gtk4_key_press_event(long l, int n, int n2, int n3, long l2) {
        return !this.sendKeyEvent(1, l2);
    }

    void gtk4_key_release_event(long l, int n, int n2, int n3, long l2) {
        this.sendKeyEvent(2, l2);
    }

    void gtk4_focus_enter_event(long l, long l2) {
    }

    void gtk4_focus_leave_event(long l, long l2) {
    }

    void gtk4_enter_event(long l, double d, double d2, long l2) {
    }

    void gtk4_leave_event(long l, long l2) {
    }

    boolean gtk4_scroll_event(long l, double d, double d2, long l2) {
        return false;
    }

    long gtk_changed(long l) {
        return 0L;
    }

    boolean gtk_change_value(long l, int n, double d, long l2) {
        return false;
    }

    long gtk_clicked(long l) {
        return 0L;
    }

    long gtk_close_request(long l) {
        return 0L;
    }

    long gtk_commit(long l, long l2) {
        return 0L;
    }

    long gtk_configure_event(long l, long l2) {
        return 0L;
    }

    long gtk_create_menu_proxy(long l) {
        return 0L;
    }

    long gtk_day_selected(long l) {
        return 0L;
    }

    long gtk_day_selected_double_click(long l) {
        return 0L;
    }

    long gtk_delete_event(long l, long l2) {
        return 0L;
    }

    long gtk_delete_range(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_delete_text(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_enter_notify_event(long l, long l2) {
        return 0L;
    }

    long gtk_event_after(long l, long l2) {
        return 0L;
    }

    long gtk_expand_collapse_cursor_row(long l, long l2, long l3, long l4) {
        return 0L;
    }

    long gtk_draw(long l, long l2) {
        return 0L;
    }

    void gtk4_draw(long l, long l2, Rectangle rectangle) {
    }

    long gtk_focus(long l, long l2) {
        return 0L;
    }

    long gtk_focus_in_event(long l, long l2) {
        return 0L;
    }

    long gtk_focus_out_event(long l, long l2) {
        return 0L;
    }

    long gtk_grab_focus(long l) {
        return 0L;
    }

    long gtk_hide(long l) {
        return 0L;
    }

    long gtk_icon_release(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_input(long l, long l2) {
        return 0L;
    }

    long gtk_insert_text(long l, long l2, long l3, long l4) {
        return 0L;
    }

    long gtk_key_press_event(long l, long l2) {
        if (Widget.logger.level >= 7) {
            Logger.Builder builder = logger.build("gtk_key_press_event(int,int)");
            (Widget.logger.level < 8 ? builder : builder.add("this: ").add((Object)this).add(", widget: ").add(l).add(", event: ").add(l2)).log(7);
        }
        return this.sendKeyEvent(1, l2) ? 0L : 1L;
    }

    long gtk_key_release_event(long l, long l2) {
        if (Widget.logger.level >= 7) {
            Logger.Builder builder = logger.build("gtk_key_release_event(int,int)");
            (Widget.logger.level < 8 ? builder : builder.add("widget: ").add(l).add(", event: ").add(l2)).log(7);
        }
        return this.sendKeyEvent(2, l2) ? 0L : 1L;
    }

    long gtk_leave_notify_event(long l, long l2) {
        return 0L;
    }

    long gtk_map(long l) {
        return 0L;
    }

    long gtk_map_event(long l, long l2) {
        return 0L;
    }

    long gtk_menu_popped_up(long l, long l2, long l3, long l4, long l5) {
        return 0L;
    }

    long gtk_mnemonic_activate(long l, long l2) {
        return 0L;
    }

    long gtk_month_changed(long l) {
        return 0L;
    }

    long gtk_motion_notify_event(long l, long l2) {
        return 0L;
    }

    long gtk_move_focus(long l, long l2) {
        return 0L;
    }

    long gtk_output(long l) {
        return 0L;
    }

    long gtk_populate_popup(long l, long l2) {
        return 0L;
    }

    long gtk_popup_menu(long l) {
        return 0L;
    }

    long gtk_preedit_changed(long l) {
        return 0L;
    }

    long gtk_realize(long l) {
        return 0L;
    }

    long gtk_row_activated(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_row_deleted(long l, long l2) {
        return 0L;
    }

    long gtk_row_inserted(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_row_has_child_toggled(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_scroll_child(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_scroll_event(long l, long l2) {
        return 0L;
    }

    long gtk_select(long l) {
        return 0L;
    }

    long gtk_selection_done(long l) {
        return 0L;
    }

    long gtk_show(long l) {
        return 0L;
    }

    long gtk3_show_help(long l, long l2) {
        return 0L;
    }

    long gtk_size_allocate(long l, long l2) {
        return 0L;
    }

    long gtk_status_icon_popup_menu(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_start_interactive_search(long l) {
        return 0L;
    }

    long gtk_style_updated(long l) {
        return 0L;
    }

    long gtk_switch_page(long l, long l2, int n) {
        return 0L;
    }

    long gtk_test_collapse_row(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_test_expand_row(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_text_buffer_insert_text(long l, long l2, long l3, long l4) {
        return 0L;
    }

    long gtk_timer() {
        return 0L;
    }

    long gtk_toggled(long l, long l2) {
        return 0L;
    }

    boolean gtk_tree_view_column_cell_get_position(long l, long l2, int[] nArray, int[] nArray2) {
        Callback.setEnabled((boolean)false);
        boolean bl = GTK.gtk_tree_view_column_cell_get_position((long)l, (long)l2, (int[])nArray, (int[])nArray2);
        Callback.setEnabled((boolean)true);
        return bl;
    }

    long gtk_unmap(long l) {
        return 0L;
    }

    long gtk_unmap_event(long l, long l2) {
        return 0L;
    }

    long gtk_unrealize(long l) {
        return 0L;
    }

    long gtk_value_changed(long l) {
        return 0L;
    }

    long gtk_window_state_event(long l, long l2) {
        return 0L;
    }

    int fontHeight(long l, long l2) {
        long l3 = GTK.gtk_widget_get_pango_context((long)l2);
        long l4 = OS.pango_context_get_language(l3);
        long l5 = OS.pango_context_get_metrics(l3, l, l4);
        int n = OS.pango_font_metrics_get_ascent(l5);
        int n2 = OS.pango_font_metrics_get_descent(l5);
        OS.pango_font_metrics_unref(l5);
        return OS.PANGO_PIXELS(n + n2);
    }

    long filterProc(long l, long l2, long l3) {
        return 0L;
    }

    boolean filters(int n) {
        return this.display.filters(n);
    }

    char[] fixMnemonic(String string) {
        return this.fixMnemonic(string, true);
    }

    char[] fixMnemonic(String string, boolean bl) {
        return this.fixMnemonic(string, bl, false);
    }

    char[] fixMnemonic(String string, boolean bl, boolean bl2) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        int n3 = 0;
        char[] cArray2 = new char[n * 2];
        block5: while (n2 < n) {
            switch (cArray[n2]) {
                case '&': {
                    if (n2 + 1 < n && cArray[n2 + 1] == '&') {
                        cArray2[n3++] = cArray[n2++];
                    } else if (bl) {
                        cArray2[n3++] = 95;
                    }
                    ++n2;
                    continue block5;
                }
                case '(': {
                    if (bl2 && n2 + 4 == string.length() && cArray[n2 + 1] == '&' && cArray[n2 + 3] == ')') {
                        if (bl) {
                            cArray2[n3++] = 32;
                        }
                        n2 += 4;
                        continue block5;
                    }
                    cArray2[n3++] = cArray[n2++];
                    continue block5;
                }
                case '_': {
                    if (!bl) break;
                    cArray2[n3++] = 95;
                }
            }
            cArray2[n3++] = cArray[n2++];
        }
        return cArray2;
    }

    boolean isActive() {
        return true;
    }

    public boolean isAutoDirection() {
        return false;
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    public boolean isListening(int n) {
        this.checkWidget();
        return this.hooks(n);
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    void hookEvents() {
        if (this.handle != 0L) {
            OS.g_signal_connect(this.handle, OS.dpi_changed, this.display.notifyProc, 104L);
        }
    }

    boolean hooks(int n) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(n);
    }

    long hoverProc(long l) {
        return 0L;
    }

    boolean mnemonicHit(long l, char c) {
        if (!this.mnemonicMatch(l, c)) {
            return false;
        }
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 32L);
        boolean bl = GTK.gtk_widget_mnemonic_activate((long)l, (boolean)false);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 32L);
        return bl;
    }

    boolean mnemonicMatch(long l, char c) {
        long l2;
        long l3 = GDK.gdk_keyval_to_lower((long)GDK.gdk_unicode_to_keyval((int)c));
        return l3 == (l2 = GDK.gdk_keyval_to_lower((long)GTK.gtk_label_get_mnemonic_keyval((long)l)));
    }

    public void notifyListeners(int n, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(n, event);
    }

    void postEvent(int n) {
        this.sendEvent(n, null, false);
    }

    void postEvent(int n, Event event) {
        this.sendEvent(n, event, false);
    }

    void register() {
        if (this.handle == 0L) {
            return;
        }
        if ((this.state & 8) != 0) {
            this.display.addWidget(this.handle, this);
        }
    }

    void release(boolean bl) {
        try (ExceptionStash exceptionStash = new ExceptionStash();){
            if ((this.state & 0x200000) == 0) {
                this.state |= 0x200000;
                try {
                    this.sendEvent(12);
                }
                catch (Error | RuntimeException throwable) {
                    exceptionStash.stash(throwable);
                }
            }
            if ((this.state & 1) == 0) {
                try {
                    this.releaseChildren(bl);
                }
                catch (Error | RuntimeException throwable) {
                    exceptionStash.stash(throwable);
                }
            }
            if ((this.state & 0x100000) == 0) {
                this.state |= 0x100000;
                if (bl) {
                    this.releaseParent();
                    this.releaseWidget();
                    this.destroyWidget();
                } else {
                    this.releaseWidget();
                    this.releaseHandle();
                }
            }
        }
    }

    void releaseChildren(boolean bl) {
    }

    void releaseHandle() {
        this.handle = 0L;
        this.state |= 1;
        this.display = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.deregister();
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    protected void removeListener(int n, SWTEventListener sWTEventListener) {
        this.checkWidget();
        if (sWTEventListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, sWTEventListener);
    }

    long rendererGetPreferredWidthProc(long l, long l2, long l3, long l4) {
        return 0L;
    }

    long rendererRenderProc(long l, long l2, long l3, long l4, long l5, long l6) {
        return 0L;
    }

    long rendererSnapshotProc(long l, long l2, long l3, long l4, long l5, long l6) {
        return 0L;
    }

    public void reskin(int n) {
        this.checkWidget();
        this.reskinWidget();
        if ((n & 1) != 0) {
            this.reskinChildren(n);
        }
    }

    void reskinChildren(int n) {
    }

    void reskinWidget() {
        if ((this.state & 0x1000000) != 0x1000000) {
            this.state |= 0x1000000;
            this.display.addSkinnableWidget(this);
        }
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, (SWTEventListener)disposeListener);
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            display.sendEvent(this.eventTable, event);
        }
    }

    void sendEvent(int n) {
        this.sendEvent(n, null, true);
    }

    public void sendEvent(int n, Event event) {
        this.sendEvent(n, event, true);
    }

    void sendEvent(int n, Event event, boolean bl) {
        if (this.eventTable == null && !this.display.filters(n)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = n;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (bl) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendKeyEvent(int n, long l) {
        Object object;
        Object object2;
        int n2 = 0;
        long l2 = 0L;
        if (!GTK.GTK4) {
            object2 = new GdkEventKey();
            GTK3.memmove((GdkEventKey)object2, (long)l, (long)GdkEventKey.sizeof);
            if (Widget.logger.level >= 7) {
                object = logger.build("sendKeyEvent(int,long)");
                (Widget.logger.level < 8 ? object : object.add("type: ").add(n).add(", gdkEvent: ").add(object2).add(", keyval: ").add(object2.keyval).add(", state: ").add(object2.state).add(", scan: ").add((int)object2.hardware_keycode)).log(7);
            }
            n2 = object2.length;
            l2 = object2.string;
        }
        if (l2 == 0L || OS.g_utf16_strlen(l2, n2) <= 1L) {
            boolean bl;
            object2 = new Event();
            object2.time = GDK.gdk_event_get_time((long)l);
            boolean bl2 = bl = !this.setKeyState((Event)object2, l);
            if (Widget.logger.level >= 9) {
                logger.build("sendKeyEvent(int,long)").add("ret: ").add(bl).log(9);
            }
            if (bl) {
                return true;
            }
            this.sendEvent(n, (Event)object2);
            if (this.isDisposed()) {
                return false;
            }
            return object2.doit;
        }
        object2 = new byte[n2];
        C.memmove((byte[])object2, (long)l2, (long)n2);
        object = Converter.mbcsToWcs((byte[])object2);
        return this.sendIMKeyEvent(n, l, (char[])object) != null;
    }

    char[] sendIMKeyEvent(int n, long l, char[] cArray) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        long l2 = 0L;
        if (l == 0L) {
            l2 = GTK3.gtk_get_current_event();
            if (l2 != 0L) {
                int n5 = GDK.gdk_event_get_event_type((long)l2);
                n5 = Control.fixGdkEventTypeValues(n5);
                switch (n5) {
                    case 8: 
                    case 9: {
                        int[] nArray = new int[1];
                        if (GTK.GTK4) {
                            nArray[0] = GDK.gdk_event_get_modifier_state((long)l);
                        } else {
                            GDK.gdk_event_get_state((long)l, (int[])nArray);
                        }
                        n4 = nArray[0];
                        break;
                    }
                    default: {
                        l = 0L;
                        break;
                    }
                }
            } else {
                int[] nArray = new int[1];
                GTK3.gtk_get_current_event_state((int[])nArray);
                n4 = nArray[0];
            }
        } else {
            l2 = l;
        }
        while (n2 < cArray.length) {
            Event event = new Event();
            if (l2 != 0L && cArray.length <= 1) {
                this.setKeyState(event, l2);
            } else {
                this.setInputState(event, n4);
            }
            event.character = cArray[n2];
            this.sendEvent(n, event);
            if (this.isDisposed()) {
                if (l2 != 0L && l2 != l) {
                    this.gdk_event_free(l2);
                }
                return null;
            }
            if (event.doit) {
                cArray[n3++] = cArray[n2];
            }
            ++n2;
        }
        if (l2 != 0L && l2 != l) {
            this.gdk_event_free(l2);
        }
        if (n3 == 0) {
            return null;
        }
        if (n2 != n3) {
            char[] cArray2 = new char[n3];
            System.arraycopy(cArray, 0, cArray2, 0, n3);
            return cArray2;
        }
        return cArray;
    }

    void sendSelectionEvent(int n) {
        this.sendSelectionEvent(n, null, false);
    }

    void sendSelectionEvent(int n, Event event, boolean bl) {
        long l;
        if (this.eventTable == null && !this.display.filters(n)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        long l2 = l = GTK.GTK4 ? 0L : GTK3.gtk_get_current_event();
        if (l != 0L) {
            int n2 = GDK.gdk_event_get_event_type((long)l);
            n2 = Control.fixGdkEventTypeValues(n2);
            switch (n2) {
                case 4: 
                case 5: 
                case 7: {
                    int[] nArray = new int[1];
                    if (GTK.GTK4) {
                        nArray[0] = GDK.gdk_button_event_get_button((long)l);
                    } else {
                        GDK.gdk_event_get_button((long)l, (int[])nArray);
                    }
                    this.setButtonState(event, nArray[0]);
                }
                case 8: 
                case 9: {
                    int[] nArray = new int[1];
                    if (GTK.GTK4) {
                        nArray[0] = GDK.gdk_event_get_modifier_state((long)l);
                    } else {
                        GDK.gdk_event_get_state((long)l, (int[])nArray);
                    }
                    this.setInputState(event, nArray[0]);
                    break;
                }
            }
            this.gdk_event_free(l);
        }
        this.sendEvent(n, event, bl);
    }

    public void setData(Object object) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = object;
        } else {
            this.data = object;
        }
    }

    public void setData(String string, Object object) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(KEY_CHECK_SUBWINDOW)) {
            if (object != null && object instanceof Boolean) {
                this.state = ((Boolean)object).booleanValue() ? (this.state |= 0x2000000) : (this.state &= 0xFDFFFFFF);
            }
            return;
        }
        Object[] objectArray = null;
        if ((this.state & 4) != 0) {
            objectArray = (Object[])this.data;
            for (n = 1; n < objectArray.length && !string.equals(objectArray[n]); n += 2) {
            }
        }
        if (object != null) {
            if ((this.state & 4) != 0) {
                if (n == objectArray.length) {
                    Object[] objectArray2 = new Object[objectArray.length + 2];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                    objectArray = objectArray2;
                    this.data = objectArray2;
                }
            } else {
                objectArray = new Object[3];
                objectArray[0] = this.data;
                this.data = objectArray;
                this.state |= 4;
            }
            objectArray[n] = string;
            objectArray[n + 1] = object;
        } else if ((this.state & 4) != 0 && n != objectArray.length) {
            int n2 = objectArray.length - 2;
            if (n2 == 1) {
                this.data = objectArray[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] objectArray3 = new Object[n2];
                System.arraycopy(objectArray, 0, objectArray3, 0, n);
                System.arraycopy(objectArray, n + 2, objectArray3, n, n2 - n);
                this.data = objectArray3;
            }
        }
        if (string.equals("org.eclipse.swt.skin.class") || string.equals("org.eclipse.swt.skin.id")) {
            this.reskin(1);
        }
        if (string.equals(KEY_GTK_CSS) && object instanceof String) {
            long l = GTK.gtk_widget_get_style_context((long)this.cssHandle());
            long l2 = GTK.gtk_css_provider_new();
            if (l != 0L && l2 != 0L) {
                GTK.gtk_style_context_add_provider((long)l, (long)l2, (int)800);
                if (GTK.GTK4) {
                    GTK4.gtk_css_provider_load_from_data((long)l2, (byte[])Converter.wcsToMbcs((String)((String)object), (boolean)true), (long)-1L);
                } else {
                    GTK3.gtk_css_provider_load_from_data((long)l2, (byte[])Converter.wcsToMbcs((String)((String)object), (boolean)true), (long)-1L, null);
                }
                OS.g_object_unref(l2);
            }
        }
    }

    void setFontDescription(long l, long l2) {
        if (GTK.GTK4) {
            long l3 = GTK.gtk_widget_get_style_context((long)l);
            long l4 = GTK.gtk_css_provider_new();
            GTK.gtk_style_context_add_provider((long)l3, (long)l4, (int)600);
            OS.g_object_unref(l4);
            String string = this.convertPangoFontDescriptionToCss(l2);
            GTK4.gtk_css_provider_load_from_data((long)l4, (byte[])Converter.javaStringToCString((String)string), (long)-1L);
        } else {
            GTK3.gtk_widget_override_font((long)l, (long)l2);
            long l5 = GTK.gtk_widget_get_style_context((long)l);
            GTK3.gtk_style_context_invalidate((long)l5);
        }
    }

    String convertPangoFontDescriptionToCss(long l) {
        String string;
        Object object = "* { ";
        int n = OS.pango_font_description_get_set_fields(l);
        if ((n & 1) != 0) {
            long l2 = OS.pango_font_description_get_family(l);
            object = (String)object + "font-family: \"" + Converter.cCharPtrToJavaString((long)l2, (boolean)false) + "\";";
        }
        if ((n & 8) != 0) {
            int n2 = OS.pango_font_description_get_weight(l);
            string = n2 < 700 ? "normal" : "bold";
            object = (String)object + "font-weight: " + string + ";";
        }
        if ((n & 2) != 0) {
            int n3 = OS.pango_font_description_get_style(l);
            switch (n3) {
                case 0: {
                    string = "normal";
                    break;
                }
                case 2: {
                    string = "italic";
                    break;
                }
                default: {
                    string = "";
                }
            }
            object = (String)object + "font-style: " + string + ";";
        }
        if ((n & 0x20) != 0) {
            int n4 = OS.pango_font_description_get_size(l);
            object = (String)object + "font-size: " + n4 / 1024 + "pt;";
        }
        object = (String)object + " } ";
        return object;
    }

    void setButtonState(Event event, int n) {
        switch (n) {
            case 1: {
                event.stateMask |= 0x80000;
                break;
            }
            case 2: {
                event.stateMask |= 0x100000;
                break;
            }
            case 3: {
                event.stateMask |= 0x200000;
                break;
            }
            case 4: {
                event.stateMask |= 0x800000;
                break;
            }
            case 5: {
                event.stateMask |= 0x2000000;
                break;
            }
        }
    }

    boolean setInputState(Event event, int n) {
        if ((n & 8) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((n & 1) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((n & 4) != 0) {
            event.stateMask |= 0x40000;
        }
        if ((n & 0x100) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((n & 0x200) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((n & 0x400) != 0) {
            event.stateMask |= 0x200000;
        }
        return true;
    }

    boolean setKeyState(Event event, long l) {
        Object object;
        int n;
        long l2 = 0L;
        int n2 = 0;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_key_event_get_keyval((long)l);
            nArray2[0] = GDK.gdk_event_get_modifier_state((long)l);
        } else {
            GDK.gdk_event_get_keyval((long)l, (int[])nArray);
            GDK.gdk_event_get_state((long)l, (int[])nArray2);
        }
        if (GTK.GTK4) {
            n = GDK.gdk_key_event_get_layout((long)l);
        } else {
            GdkEventKey gdkEventKey = new GdkEventKey();
            GTK3.memmove((GdkEventKey)gdkEventKey, (long)l, (long)GdkEventKey.sizeof);
            if (Widget.logger.level >= 7) {
                object = logger.build("setKeyState(Event,GdkEventKey)");
                (Widget.logger.level < 8 ? object : object.add("event: ").add(l).add(", gdkEvent: ").add((Object)gdkEventKey).add(", keyval: ").add(gdkEventKey.keyval).add(", state: ").add(gdkEventKey.state).add(", scan: ").add((int)gdkEventKey.hardware_keycode)).log(7);
            }
            n2 = gdkEventKey.length;
            l2 = gdkEventKey.string;
            n = gdkEventKey.group;
        }
        if (l2 != 0L && OS.g_utf16_strlen(l2, n2) > 1L) {
            return false;
        }
        boolean bl = false;
        event.keyCode = Display.translateKey(nArray[0]);
        if (Widget.logger.level >= 9) {
            logger.build("setKeyState(Event,GdkEventKey)").add("keyCode: ").add(event.keyCode).log(9);
        }
        switch (nArray[0]) {
            case 65288: {
                event.character = (char)8;
                break;
            }
            case 65290: {
                event.character = (char)10;
                break;
            }
            case 65293: 
            case 65421: {
                event.character = (char)13;
                break;
            }
            case 65439: 
            case 65535: {
                event.character = (char)127;
                break;
            }
            case 65307: {
                event.character = (char)27;
                break;
            }
            case 65056: 
            case 65289: {
                event.character = (char)9;
                break;
            }
            default: {
                if (event.keyCode == 0) {
                    object = new int[1];
                    int[] nArray3 = new int[1];
                    int[] nArray4 = new int[1];
                    int[] nArray5 = new int[1];
                    Map<Integer, Integer> map = this.display.getGroupKeysCount();
                    if (!map.containsKey(n)) {
                        n = this.display.getLatinKeyGroup();
                    }
                    long l3 = 0L;
                    long l4 = GDK.gdk_display_get_default();
                    if (!GTK.GTK4) {
                        l3 = GDK.gdk_keymap_get_for_display((long)l4);
                    }
                    short[] sArray = new short[1];
                    if (GTK.GTK4) {
                        sArray[0] = (short)GDK.gdk_key_event_get_keycode((long)l);
                        event.keyCode = sArray[0];
                    } else {
                        GDK.gdk_event_get_keycode((long)l, (short[])sArray);
                        if (GDK.gdk_keymap_translate_keyboard_state((long)l3, (int)sArray[0], (int)0, (int)n, (int[])object, (int[])nArray3, (int[])nArray4, (int[])nArray5)) {
                            if (Widget.logger.level >= 9) {
                                logger.build("setKeyState(Event,GdkEventKey)").add("keyval: ").addAll((int[])object).log(9);
                            }
                            event.keyCode = (int)GDK.gdk_keyval_to_unicode((long)((long)object[0]));
                            if (Widget.logger.level >= 9) {
                                logger.build("setKeyState(Event,GdkEventKey)").add("keyCode: ").add(event.keyCode).log(9);
                            }
                        } else {
                            event.keyCode = (int)GDK.gdk_keyval_to_unicode((long)((long)object[0]));
                        }
                    }
                }
                int n3 = nArray[0];
                if ((nArray2[0] & 4) != 0 && 0 <= n3 && n3 <= 127) {
                    if (97 <= n3 && n3 <= 122) {
                        n3 -= 32;
                    }
                    if (64 <= n3 && n3 <= 95) {
                        n3 -= 64;
                    }
                    event.character = (char)n3;
                    bl = nArray[0] == 64 && n3 == 0;
                    break;
                }
                event.character = (char)GDK.gdk_keyval_to_unicode((long)n3);
            }
        }
        this.setLocationState(event, l);
        if (event.keyCode == 0 && event.character == '\u0000' && !bl) {
            return false;
        }
        return this.setInputState(event, nArray2[0]);
    }

    void setLocationState(Event event, long l) {
        int[] nArray = new int[1];
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_key_event_get_keyval((long)l);
        } else {
            GDK.gdk_event_get_keyval((long)l, (int[])nArray);
        }
        switch (nArray[0]) {
            case 65505: 
            case 65507: 
            case 65513: {
                event.keyLocation = 16384;
                break;
            }
            case 65506: 
            case 65508: 
            case 65514: {
                event.keyLocation = 131072;
                break;
            }
            case 65407: 
            case 65421: 
            case 65429: 
            case 65430: 
            case 65431: 
            case 65432: 
            case 65433: 
            case 65434: 
            case 65435: 
            case 65436: 
            case 65438: 
            case 65439: 
            case 65450: 
            case 65451: 
            case 65453: 
            case 65454: 
            case 65455: 
            case 65456: 
            case 65457: 
            case 65458: 
            case 65459: 
            case 65460: 
            case 65461: 
            case 65462: 
            case 65463: 
            case 65464: 
            case 65465: 
            case 65469: {
                event.keyLocation = 2;
            }
        }
    }

    void setOrientation(boolean bl) {
    }

    boolean setTabGroupFocus(boolean bl) {
        return this.setTabItemFocus(bl);
    }

    boolean setTabItemFocus(boolean bl) {
        return false;
    }

    long shellMapProc(long l, long l2, long l3) {
        return 0L;
    }

    long sizeAllocateProc(long l, long l2, long l3) {
        return 0L;
    }

    long sizeRequestProc(long l, long l2, long l3) {
        return 0L;
    }

    void snapshotToDraw(long l, long l2) {
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation((long)l, (GtkAllocation)gtkAllocation);
        long l3 = Graphene.graphene_rect_alloc();
        Graphene.graphene_rect_init((long)l3, (float)0.0f, (float)0.0f, (float)gtkAllocation.width, (float)gtkAllocation.height);
        long l4 = GTK4.gtk_snapshot_append_cairo((long)l2, (long)l3);
        if (l4 != 0L) {
            Rectangle rectangle = new Rectangle(0, 0, gtkAllocation.width, gtkAllocation.height);
            this.gtk4_draw(l, l4, rectangle);
        }
        Graphene.graphene_rect_free((long)l3);
    }

    long gtk_widget_get_window(long l) {
        GTK.gtk_widget_realize((long)l);
        return GTK3.gtk_widget_get_window((long)l);
    }

    long gtk_widget_get_surface(long l) {
        GTK.gtk_widget_realize((long)l);
        return GTK4.gtk_native_get_surface((long)GTK4.gtk_widget_get_native((long)l));
    }

    void gdk_window_get_size(long l, int[] nArray, int[] nArray2) {
        nArray[0] = GDK.gdk_window_get_width((long)l);
        nArray2[0] = GDK.gdk_window_get_height((long)l);
    }

    void gdk_surface_get_size(long l, int[] nArray, int[] nArray2) {
        nArray[0] = GDK.gdk_surface_get_width((long)l);
        nArray2[0] = GDK.gdk_surface_get_height((long)l);
    }

    void gdk_event_free(long l) {
        if (l == 0L) {
            return;
        }
        if (GTK.GTK4) {
            GDK.gdk_event_unref((long)l);
        } else {
            GDK.gdk_event_free((long)l);
        }
    }

    long gdk_event_get_surface_or_window(long l) {
        if (l == 0L) {
            return 0L;
        }
        if (GTK.GTK4) {
            return GDK.gdk_event_get_surface((long)l);
        }
        return GDK.gdk_event_get_window((long)l);
    }

    int gdk_event_get_state(long l) {
        int[] nArray = new int[1];
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_event_get_modifier_state((long)l);
        } else {
            GDK.gdk_event_get_state((long)l, (int[])nArray);
        }
        return nArray[0];
    }

    long gtk_box_new(int n, boolean bl, int n2) {
        long l = GTK.gtk_box_new((int)n, (int)n2);
        GTK.gtk_box_set_homogeneous((long)l, (boolean)bl);
        return l;
    }

    void gtk_box_set_child_packing(long l, long l2, boolean bl, boolean bl2, int n, int n2) {
        if (GTK.GTK4) {
            GTK.gtk_widget_set_hexpand((long)l2, (boolean)bl);
            GTK.gtk_widget_set_vexpand((long)l2, (boolean)bl);
            if (bl2) {
                GTK.gtk_widget_set_halign((long)l2, (int)0);
                GTK.gtk_widget_set_valign((long)l2, (int)0);
            }
        } else {
            GTK3.gtk_box_set_child_packing((long)l, (long)l2, (boolean)bl, (boolean)bl2, (int)n, (int)n2);
        }
    }

    void gtk_box_pack_end(long l, long l2, boolean bl, boolean bl2, int n) {
        if (GTK.GTK4) {
            GTK.gtk_widget_set_hexpand((long)l2, (boolean)bl);
            GTK.gtk_widget_set_vexpand((long)l2, (boolean)bl);
            if (bl2) {
                GTK.gtk_widget_set_halign((long)l2, (int)0);
                GTK.gtk_widget_set_valign((long)l2, (int)0);
            }
            GTK4.gtk_box_append((long)l, (long)l2);
        } else {
            GTK3.gtk_box_pack_end((long)l, (long)l2, (boolean)bl, (boolean)bl2, (int)n);
        }
    }

    int gdk_pointer_grab(long l, int n, boolean bl, int n2, long l2, long l3, int n3) {
        long l4 = 0L;
        if (GTK.GTK4) {
            if (l != 0L) {
                l4 = GDK.gdk_surface_get_display((long)l);
            }
        } else if (l != 0L) {
            l4 = GDK.gdk_window_get_display((long)l);
        } else {
            l = GDK.gdk_get_default_root_window();
            l4 = GDK.gdk_window_get_display((long)l);
        }
        long l5 = GDK.gdk_display_get_default_seat((long)l4);
        if (gdkSeatGrabPrepareFunc == null) {
            gdkSeatGrabPrepareFunc = new Callback(Widget.class, "GdkSeatGrabPrepareFunc", 3);
        }
        return GDK.gdk_seat_grab((long)l5, (long)l, (int)7, (boolean)bl, (long)l3, (long)0L, (long)gdkSeatGrabPrepareFunc.getAddress(), (long)l);
    }

    void gdk_pointer_ungrab(long l, int n) {
        long l2 = GTK.GTK4 ? GDK.gdk_surface_get_display((long)l) : GDK.gdk_window_get_display((long)l);
        long l3 = GDK.gdk_display_get_default_seat((long)l2);
        GDK.gdk_seat_ungrab((long)l3);
    }

    static long GdkSeatGrabPrepareFunc(long l, long l2, long l3) {
        if (l3 != 0L && !GTK.GTK4) {
            GDK.gdk_window_show((long)l3);
        }
        return 0L;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return this.getName() + " {" + string + "}";
    }

    long topHandle() {
        return this.handle;
    }

    long timerProc(long l) {
        return 0L;
    }

    boolean translateTraversal(int n) {
        return false;
    }

    void enterMotionProc(long l, double d, double d2, long l2) {
        long l3 = GTK4.gtk_event_controller_get_current_event((long)l);
        switch ((int)l2) {
            case 95: {
                this.gtk4_enter_event(l, d, d2, l3);
                break;
            }
            case 97: {
                this.gtk4_motion_event(l, d, d2, l3);
                break;
            }
        }
    }

    boolean scrollProc(long l, double d, double d2, long l2) {
        long l3 = GTK4.gtk_event_controller_get_current_event((long)l);
        switch ((int)l2) {
            case 92: {
                return this.gtk4_scroll_event(l, d, d2, l3);
            }
        }
        return false;
    }

    void focusProc(long l, long l2) {
        long l3 = GTK4.gtk_event_controller_get_current_event((long)l);
        switch ((int)l2) {
            case 86: {
                this.gtk4_focus_enter_event(l, l3);
                break;
            }
            case 87: {
                this.gtk4_focus_leave_event(l, l3);
            }
        }
    }

    boolean keyPressReleaseProc(long l, int n, int n2, int n3, long l2) {
        long l3 = GTK4.gtk_event_controller_get_current_event((long)l);
        switch ((int)l2) {
            case 89: {
                return this.gtk4_key_press_event(l, n, n2, n3, l3);
            }
            case 90: {
                this.gtk4_key_release_event(l, n, n2, n3, l3);
            }
        }
        return false;
    }

    void gesturePressReleaseProc(long l, int n, double d, double d2, long l2) {
        long l3 = GTK4.gtk_event_controller_get_current_event((long)l);
        switch ((int)l2) {
            case 100: {
                this.gtk_gesture_press_event(l, n, d, d2, l3);
                break;
            }
            case 101: {
                this.gtk_gesture_release_event(l, n, d, d2, l3);
            }
        }
    }

    void leaveProc(long l, long l2, long l3) {
        long l4 = GTK4.gtk_event_controller_get_current_event((long)l);
        switch ((int)l3) {
            case 96: {
                this.gtk4_leave_event(l, l4);
            }
        }
    }

    long notifyProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 104: {
                return this.dpiChanged(l, l2);
            }
            case 102: {
                return this.notifyState(l, l2);
            }
            case 105: 
            case 106: {
                return this.gtk_size_allocate(l, 0L);
            }
        }
        return 0L;
    }

    long notifyState(long l, long l2) {
        return 0L;
    }

    long windowProc(long l, long l2) {
        if (Widget.logger.level >= 7) {
            Logger.Builder builder = logger.build("windowProc(int,int)");
            (Widget.logger.level < 8 ? builder : builder.add("handle: ").add(l).add(", user_data: ").add(l2)).log(7);
        }
        switch ((int)l2) {
            case 1: {
                return this.gtk_activate(l);
            }
            case 6: {
                return this.gtk_changed(l);
            }
            case 8: {
                return this.gtk_clicked(l);
            }
            case 99: {
                return this.gtk_close_request(l);
            }
            case 83: {
                return this.gtk_create_menu_proxy(l);
            }
            case 61: {
                return this.gtk_day_selected(l);
            }
            case 66: {
                return this.gtk_day_selected_double_click(l);
            }
            case 24: {
                return this.gtk_hide(l);
            }
            case 23: {
                return this.gtk_grab_focus(l);
            }
            case 30: {
                return this.gtk_map(l);
            }
            case 62: {
                return this.gtk_month_changed(l);
            }
            case 36: {
                return this.gtk_output(l);
            }
            case 38: {
                return this.gtk_popup_menu(l);
            }
            case 39: {
                return this.gtk_preedit_changed(l);
            }
            case 40: {
                return this.gtk_realize(l);
            }
            case 69: {
                return this.gtk_start_interactive_search(l);
            }
            case 48: {
                return this.gtk_style_updated(l);
            }
            case 44: {
                return this.gtk_select(l);
            }
            case 68: {
                return this.gtk_selection_done(l);
            }
            case 45: {
                return this.gtk_show(l);
            }
            case 57: {
                return this.gtk_value_changed(l);
            }
            case 54: {
                return this.gtk_unmap(l);
            }
            case 56: {
                return this.gtk_unrealize(l);
            }
        }
        return 0L;
    }

    long windowProc(long l, long l2, long l3) {
        if (Widget.logger.level >= 7) {
            Logger.Builder builder = logger.build("windowProc(int,int,int)");
            (Widget.logger.level < 8 ? builder : builder.add("handle: ").add(l).add(", arg0: ").add(l2).add(", user_data: ").add(l3).add(", class:").add(this.getClass().getName())).log(7);
        }
        switch ((int)l3) {
            case 19: {
                if (GTK.GTK_IS_CONTAINER((long)l)) {
                    return this.gtk_draw(l, l2);
                }
                return 0L;
            }
            case 3: 
            case 5: 
            case 34: {
                return 1L;
            }
            case 2: {
                return this.gtk_button_press_event(l, l2);
            }
            case 4: {
                return this.gtk_button_release_event(l, l2);
            }
            case 9: {
                return this.gtk_commit(l, l2);
            }
            case 10: {
                return this.gtk_configure_event(l, l2);
            }
            case 11: {
                return this.gtk_delete_event(l, l2);
            }
            case 14: {
                return this.gtk_enter_notify_event(l, l2);
            }
            case 16: {
                return this.gtk_event_after(l, l2);
            }
            case 18: {
                if (!GTK.GTK_IS_CONTAINER((long)l)) {
                    return this.gtk_draw(l, l2);
                }
                return 0L;
            }
            case 20: {
                return this.gtk_focus(l, l2);
            }
            case 21: {
                return this.gtk_focus_in_event(l, l2);
            }
            case 22: {
                return this.gtk_focus_out_event(l, l2);
            }
            case 27: {
                return this.gtk_key_press_event(l, l2);
            }
            case 28: {
                return this.gtk_key_release_event(l, l2);
            }
            case 25: {
                return this.gtk_input(l, l2);
            }
            case 29: {
                return this.gtk_leave_notify_event(l, l2);
            }
            case 31: {
                return this.gtk_map_event(l, l2);
            }
            case 32: {
                return this.gtk_mnemonic_activate(l, l2);
            }
            case 33: {
                return this.gtk_motion_notify_event(l, l2);
            }
            case 35: {
                return this.gtk_move_focus(l, l2);
            }
            case 37: {
                return this.gtk_populate_popup(l, l2);
            }
            case 43: {
                return this.gtk_scroll_event(l, l2);
            }
            case 46: {
                return this.gtk3_show_help(l, l2);
            }
            case 47: {
                return this.gtk_size_allocate(l, l2);
            }
            case 53: {
                return this.gtk_toggled(l, l2);
            }
            case 55: {
                return this.gtk_unmap_event(l, l2);
            }
            case 59: {
                return this.gtk_window_state_event(l, l2);
            }
            case 65: {
                return this.gtk_row_deleted(l, l2);
            }
        }
        return 0L;
    }

    long windowProc(long l, long l2, long l3, long l4) {
        if (Widget.logger.level >= 7) {
            Logger.Builder builder = logger.build("windowProc(int,int,int,int)");
            (Widget.logger.level < 8 ? builder : builder.add("handle: ").add(l).add(", arg0: ").add(l2).add(", arg1: ").add(l3).add(", user_data: ").add(l4)).log(7);
        }
        switch ((int)l4) {
            case 12: {
                return this.gtk_delete_range(l, l2, l3);
            }
            case 13: {
                return this.gtk_delete_text(l, l2, l3);
            }
            case 67: {
                return this.gtk_icon_release(l, l2, l3);
            }
            case 41: {
                return this.gtk_row_activated(l, l2, l3);
            }
            case 42: {
                return this.gtk_scroll_child(l, l2, l3);
            }
            case 63: {
                return this.gtk_status_icon_popup_menu(l, l2, l3);
            }
            case 49: {
                return this.gtk_switch_page(l, l2, (int)l3);
            }
            case 50: {
                return this.gtk_test_collapse_row(l, l2, l3);
            }
            case 51: {
                return this.gtk_test_expand_row(l, l2, l3);
            }
            case 64: {
                return this.gtk_row_inserted(l, l2, l3);
            }
            case 84: {
                return this.gtk_row_has_child_toggled(l, l2, l3);
            }
        }
        return 0L;
    }

    long windowProc(long l, long l2, long l3, long l4, long l5) {
        switch ((int)l5) {
            case 17: {
                return this.gtk_expand_collapse_cursor_row(l, l2, l3, l4);
            }
            case 26: {
                return this.gtk_insert_text(l, l2, l3, l4);
            }
            case 52: {
                return this.gtk_text_buffer_insert_text(l, l2, l3, l4);
            }
        }
        return 0L;
    }

    long windowProc(long l, long l2, long l3, long l4, long l5, long l6) {
        switch ((int)l6) {
            case 85: {
                return this.gtk_menu_popped_up(l, l2, l3, l4, l5);
            }
        }
        return 0L;
    }

    void gtk_cell_renderer_get_preferred_size(long l, long l2, int[] nArray, int[] nArray2) {
        GtkRequisition gtkRequisition = new GtkRequisition();
        GTK.gtk_cell_renderer_get_preferred_size((long)l, (long)l2, (GtkRequisition)gtkRequisition, null);
        if (nArray != null) {
            nArray[0] = gtkRequisition.width;
        }
        if (nArray2 != null) {
            nArray2[0] = gtkRequisition.height;
        }
    }

    void gtk_widget_get_preferred_size(long l, GtkRequisition gtkRequisition) {
        GTK.gtk_widget_get_preferred_size((long)l, (GtkRequisition)gtkRequisition, null);
    }

    int gtk_container_get_border_width_or_margin(long l) {
        if (GTK.GTK4) {
            int n = GTK.gtk_widget_get_margin_top((long)l);
            int n2 = GTK.gtk_widget_get_margin_bottom((long)l);
            int n3 = GTK.gtk_widget_get_margin_start((long)l);
            int n4 = GTK.gtk_widget_get_margin_end((long)l);
            return Math.max(Math.max(n, n2), Math.max(n3, n4));
        }
        return GTK3.gtk_container_get_border_width((long)l);
    }

    void gtk_container_set_border_width(long l, int n) {
        if (GTK.GTK4) {
            GTK.gtk_widget_set_margin_top((long)l, (int)n);
            GTK.gtk_widget_set_margin_bottom((long)l, (int)n);
            GTK.gtk_widget_set_margin_start((long)l, (int)n);
            GTK.gtk_widget_set_margin_end((long)l, (int)n);
        } else {
            GTK3.gtk_container_set_border_width((long)l, (int)n);
        }
    }

    void setToolTipText(long l, String string) {
        byte[] byArray = null;
        if (string != null && !string.isEmpty()) {
            char[] cArray = this.fixMnemonic(string, false, true);
            byArray = Converter.wcsToMbcs((char[])cArray, (boolean)true);
        }
        GTK.gtk_widget_set_tooltip_text((long)l, byArray);
    }

    static {
        logger = new Logger("org.eclipse.swt.widgets.Widget");
    }
}

