/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.AsyncReadyCallback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SyncDialogUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;
    RGB[] rgbs;

    public ColorDialog(Shell shell) {
        this(shell, 65536);
    }

    public ColorDialog(Shell shell, int n) {
        super(shell, ColorDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB[] getRGBs() {
        return this.rgbs;
    }

    public RGB open() {
        boolean bl;
        int n;
        byte[] byArray = Converter.javaStringToCString((String)this.title);
        final long l = GTK.GTK_VERSION >= OS.VERSION(4, 10, 0) ? GTK4.gtk_color_dialog_new() : GTK.gtk_color_chooser_dialog_new((byte[])byArray, (long)this.parent.topHandle());
        if (l == 0L) {
            this.error(2);
        }
        if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
            GTK4.gtk_color_dialog_set_modal((long)l, (boolean)true);
            GTK4.gtk_color_dialog_set_title((long)l, (byte[])byArray);
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        GdkRGBA gdkRGBA = new GdkRGBA();
        if (this.rgb != null) {
            gdkRGBA.red = (double)this.rgb.red / 255.0;
            gdkRGBA.green = (double)this.rgb.green / 255.0;
            gdkRGBA.blue = (double)this.rgb.blue / 255.0;
            gdkRGBA.alpha = 1.0;
        }
        if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
            if (GTK4.gtk_color_dialog_get_with_alpha((long)l)) {
                GTK4.gtk_color_dialog_set_with_alpha((long)l, (boolean)false);
            }
        } else {
            GTK.gtk_color_chooser_set_rgba((long)l, (GdkRGBA)gdkRGBA);
            display.runDialogShownHooks(this, l);
            if (this.rgbs != null) {
                int n2 = 9;
                long l2 = OS.g_malloc(GdkRGBA.sizeof * this.rgbs.length);
                gdkRGBA = new GdkRGBA();
                for (int i = 0; i < this.rgbs.length; ++i) {
                    RGB rGB = this.rgbs[i];
                    if (rGB == null) continue;
                    gdkRGBA.red = (double)rGB.red / 255.0;
                    gdkRGBA.green = (double)rGB.green / 255.0;
                    gdkRGBA.blue = (double)rGB.blue / 255.0;
                    OS.memmove(l2 + (long)(i * GdkRGBA.sizeof), gdkRGBA, (long)GdkRGBA.sizeof);
                }
                GTK.gtk_color_chooser_add_palette((long)l, (int)0, (int)n2, (int)this.rgbs.length, (long)l2);
                GTK.gtk_color_chooser_set_rgba((long)l, (GdkRGBA)gdkRGBA);
                if (GTK.gtk_color_chooser_get_use_alpha((long)l)) {
                    GTK.gtk_color_chooser_set_use_alpha((long)l, (boolean)false);
                }
                OS.g_free(l2);
            }
        }
        display.addIdleProc();
        Dialog dialog = null;
        if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0) ? GTK4.gtk_color_dialog_get_modal((long)l) : GTK.gtk_window_get_modal((long)l)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n3 = 0;
        long l3 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n3 = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            l3 = OS.g_signal_add_emission_hook(n3, 0, display.emissionProc, l, 0L);
        }
        if (GTK.GTK4) {
            if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
                GdkRGBA gdkRGBA2;
                final long l4 = this.parent != null ? this.parent.topHandle() : 0L;
                long l5 = SyncDialogUtil.run((Display)display, (AsyncReadyCallback)new AsyncReadyCallback(){
                    final /* synthetic */ GdkRGBA val$initialColor;
                    {
                        this.val$initialColor = gdkRGBA;
                    }

                    public void async(long l2) {
                        GTK4.gtk_color_dialog_choose_rgba((long)l, (long)l4, (GdkRGBA)this.val$initialColor, (long)0L, (long)l2, (long)0L);
                    }

                    public long await(long l2) {
                        return GTK4.gtk_color_dialog_choose_rgba_finish((long)l, (long)l2, null);
                    }
                });
                if (l5 != 0L) {
                    OS.memmove(gdkRGBA, l5, (long)GdkRGBA.sizeof);
                    GDK.gdk_rgba_free((long)l5);
                    n = -5;
                } else {
                    n = -6;
                }
            } else {
                n = SyncDialogUtil.run((Display)display, (long)l, (boolean)false);
            }
        } else {
            display.externalEventLoop = true;
            display.sendPreExternalEventDispatchEvent();
            n = GTK3.gtk_dialog_run((long)l);
            display.externalEventLoop = false;
            display.sendPostExternalEventDispatchEvent();
        }
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n3, l3);
        }
        if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0) ? GTK4.gtk_color_dialog_get_modal((long)l) : GTK.gtk_window_get_modal((long)l)) {
            display.setModalDialog(dialog);
        }
        boolean bl2 = bl = n == -5;
        if (bl) {
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            if (GTK.GTK_VERSION < OS.VERSION(4, 10, 0)) {
                gdkRGBA = new GdkRGBA();
                GTK.gtk_color_chooser_get_rgba((long)l, (GdkRGBA)gdkRGBA);
            }
            n4 = (int)(gdkRGBA.red * 255.0);
            n5 = (int)(gdkRGBA.green * 255.0);
            n6 = (int)(gdkRGBA.blue * 255.0);
            this.rgb = new RGB(n4, n5, n6);
        } else {
            this.rgb = null;
        }
        this.rgb = (RGB)display.runDialogClosedHooks(this, bl ? this.rgb : null);
        if (this.rgb != null) {
            bl = true;
        }
        display.removeIdleProc();
        if (GTK.GTK4) {
            if (GTK.GTK_VERSION < OS.VERSION(4, 10, 0)) {
                GTK4.gtk_window_destroy((long)l);
            }
        } else {
            GTK3.gtk_widget_destroy((long)l);
        }
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }

    public void setRGBs(RGB[] rGBArray) {
        this.rgbs = rGBArray;
    }

    static String[] splitString(String string, char c) {
        String[] stringArray = new String[1];
        int n = 0;
        int n2 = 0;
        while (n2 != -1) {
            n2 = string.indexOf(c, n);
            if (n2 == -1) {
                stringArray[stringArray.length - 1] = string.substring(n);
                continue;
            }
            stringArray[stringArray.length - 1] = string.substring(n, n2);
            n = n2 + 1;
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray = stringArray2;
        }
        return stringArray;
    }
}

