/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.LogUser;
import de.qfs.lib.log.LogWriter;

public abstract class AbstractLogUser
implements LogUser {
    protected int mode = 3;
    private LogWriter writer;

    public AbstractLogUser(int n, LogWriter logWriter) {
        this.mode = n;
        this.writer = logWriter;
    }

    public final LogWriter getLogWriter() {
        return this.writer;
    }

    public final void setLogWriter(LogWriter logWriter) {
        this.writer = logWriter;
    }

    public boolean filter(LogEntry logEntry) {
        boolean bl = false;
        if (this.isUseful(logEntry)) {
            if (this.writer != null) {
                this.writer.write(logEntry);
            }
            bl = true;
        }
        return this.mode != 2 && (bl && this.mode != 0 || !bl && this.mode != 1);
    }

    public LogEntry[] filter(LogEntry[] logEntryArray) {
        int n = 0;
        for (int i = 0; i < logEntryArray.length; ++i) {
            if (!this.isUseful(logEntryArray[i])) continue;
            ++n;
        }
        if (n == logEntryArray.length) {
            if (this.writer != null) {
                this.writer.write(logEntryArray);
            }
            if (this.mode == 2 || this.mode == 0) {
                return null;
            }
            return logEntryArray;
        }
        if (n == 0) {
            if (this.mode == 2 || this.mode == 1) {
                return null;
            }
            return logEntryArray;
        }
        LogEntry[] logEntryArray2 = this.mode == 0 ? new LogEntry[logEntryArray.length - n] : null;
        LogEntry[] logEntryArray3 = null;
        if (this.writer != null || this.mode == 1) {
            logEntryArray3 = new LogEntry[n];
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < logEntryArray.length; ++i) {
            if (this.isUseful(logEntryArray[i])) {
                if (logEntryArray3 == null) continue;
                logEntryArray3[n2++] = logEntryArray[i];
                continue;
            }
            if (logEntryArray2 == null) continue;
            logEntryArray2[n3++] = logEntryArray[i];
        }
        if (this.writer != null) {
            this.writer.write(logEntryArray3);
        }
        switch (this.mode) {
            case 2: {
                return null;
            }
            case 3: {
                return logEntryArray;
            }
            case 0: {
                return logEntryArray2;
            }
            case 1: {
                return logEntryArray3;
            }
        }
        return null;
    }

    public void setFilterMode(int n) {
        this.mode = n;
    }

    protected abstract boolean isUseful(LogEntry var1);
}

