/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.FileLogWriter;
import de.qfs.lib.log.LevelFilter;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.LogFilter;
import de.qfs.lib.log.LogStream;
import de.qfs.lib.log.LogWriter;
import de.qfs.lib.log.Logger;
import de.qfs.lib.log.RingFileLogWriter;
import de.qfs.lib.log.StreamLogWriter;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class IntTests
extends TestCase {
    private static final Logger logger = new Logger("de.qfs.lib.log.IntTests");
    private static final String LINESEP = System.getProperty("line.separator");
    private int id;

    public IntTests(String string) {
        super(string);
    }

    protected void setUp() {
        this.id = 0;
        Log.setOutputLevel(2);
    }

    public static Test suite() {
        return new TestSuite(IntTests.class);
    }

    public void testLevels() {
        Logger.setDefaultLogLevel(1);
        IntTests.assertTrue((IntTests.logger.level == 1 ? 1 : 0) != 0);
        Logger.setLogLevel("de.", 7);
        IntTests.assertTrue((IntTests.logger.level == 7 ? 1 : 0) != 0);
        Logger.setLogLevel("de.qfs.lib.log.IntTests", 9);
        IntTests.assertTrue((IntTests.logger.level == 9 ? 1 : 0) != 0);
    }

    public void testFilter() {
        Filter filter = new Filter();
        Log.addFilter(filter);
        Logger.setLogLevel("de.qfs.lib.log.IntTests", 9);
        Log.setPreQueueLevel(9);
        this.log(9, 5);
        this.flush();
        IntTests.assertTrue((filter.count == 5 ? 1 : 0) != 0);
        IntTests.assertNotNull((Object)filter.entries);
        IntTests.assertTrue((boolean)filter.entries[filter.entries.length - 1].getMessage().equals("4"));
        Log.setQueueing(false);
        this.log(9, 5);
        IntTests.assertTrue((filter.count == 10 ? 1 : 0) != 0);
        IntTests.assertTrue((filter.entries.length == 1 ? 1 : 0) != 0);
        IntTests.assertTrue((boolean)filter.entries[0].getMessage().equals("9"));
        Log.setQueueing(true);
        Log.removeFilter(filter);
    }

    public void testPreQueueLevel() {
        Filter filter = new Filter();
        Log.addFilter(filter);
        Logger.setLogLevel("de.qfs.lib.log.IntTests", 10);
        Log.setPreQueueLevel(9);
        Log.setQueueing(true);
        this.log(10, 5);
        this.flush();
        IntTests.assertTrue((filter.count == 0 ? 1 : 0) != 0);
        this.log(9, 5);
        this.flush();
        IntTests.assertTrue((filter.count == 5 ? 1 : 0) != 0);
        IntTests.assertNotNull((Object)filter.entries);
        IntTests.assertTrue((boolean)filter.entries[filter.entries.length - 1].getMessage().equals("9"));
        Log.removeFilter(filter);
    }

    public void testFlushBuffer() {
        Filter filter = new Filter();
        Log.addFilter(filter);
        Logger.setLogLevel("de.qfs.lib.log.IntTests", 10);
        Log.setPreQueueLevel(4);
        Log.setFlushBufferSize(5);
        Log.setPostFlushSize(3);
        Log.setFlushTriggerLevel(3);
        Log.setQueueing(true);
        this.log(10, 10);
        this.flush();
        IntTests.assertTrue((filter.count == 0 ? 1 : 0) != 0);
        this.log(3, 1);
        this.flush();
        IntTests.assertTrue((filter.count == 6 ? 1 : 0) != 0);
        IntTests.assertNotNull((Object)filter.entries);
        IntTests.assertTrue((boolean)filter.entries[filter.entries.length - 1].getMessage().equals("10"));
        this.log(9, 5);
        this.flush();
        IntTests.assertTrue((filter.count == 9 ? 1 : 0) != 0);
        IntTests.assertNotNull((Object)filter.entries);
        IntTests.assertTrue((boolean)filter.entries[filter.entries.length - 1].getMessage().equals("13"));
        Log.removeFilter(filter);
        Log.setFlushBufferSize(0);
        Log.setPostFlushSize(0);
    }

    public void testLogLevel() {
        PrintStream printStream = System.err;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            System.setErr((PrintStream)PrintStream.class.getConstructor(OutputStream.class).newInstance(byteArrayOutputStream));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            IntTests.assertTrue((boolean)false);
        }
        Logger.setLogLevel("de.qfs.lib.log.IntTests", 10);
        Log.setPreQueueLevel(10);
        Log.setOutputLevel(9);
        Log.setQueueing(true);
        this.log(10, 5);
        this.flush();
        String string = byteArrayOutputStream.toString();
        IntTests.assertTrue((boolean)string.equals(""));
        this.log(9, 5);
        this.flush();
        string = byteArrayOutputStream.toString();
        IntTests.assertTrue((string.length() > 0 ? 1 : 0) != 0);
        IntTests.assertTrue((boolean)string.endsWith("9" + LINESEP));
        System.setErr(printStream);
    }

    public void testStreamLogWriter() {
        Filter filter = new Filter();
        Log.addFilter(filter);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamLogWriter streamLogWriter = new StreamLogWriter(new PrintWriter(byteArrayOutputStream), true);
        LevelFilter levelFilter = new LevelFilter(9);
        levelFilter.setFilterMode(0);
        levelFilter.setLogWriter(streamLogWriter);
        Log.addFilter(levelFilter);
        Logger.setLogLevel("de.qfs.lib.log.IntTests", 10);
        Log.setPreQueueLevel(10);
        Log.setQueueing(true);
        this.log(10, 5);
        this.flush();
        String string = byteArrayOutputStream.toString();
        IntTests.assertTrue((boolean)string.equals(""));
        IntTests.assertTrue((filter.count == 5 ? 1 : 0) != 0);
        this.log(9, 5);
        this.flush();
        string = byteArrayOutputStream.toString();
        IntTests.assertTrue((string.length() > 0 ? 1 : 0) != 0);
        IntTests.assertTrue((boolean)string.endsWith("9" + LINESEP));
        IntTests.assertTrue((filter.count == 5 ? 1 : 0) != 0);
        levelFilter.setFilterMode(1);
        this.log(10, 5);
        this.flush();
        IntTests.assertTrue((filter.count == 5 ? 1 : 0) != 0);
        this.log(9, 5);
        this.flush();
        IntTests.assertTrue((filter.count == 10 ? 1 : 0) != 0);
        levelFilter.setFilterMode(2);
        this.log(10, 5);
        this.flush();
        IntTests.assertTrue((filter.count == 10 ? 1 : 0) != 0);
        this.log(9, 5);
        this.flush();
        IntTests.assertTrue((filter.count == 10 ? 1 : 0) != 0);
        levelFilter.setFilterMode(3);
        this.log(10, 5);
        this.flush();
        IntTests.assertTrue((filter.count == 15 ? 1 : 0) != 0);
        this.log(9, 5);
        this.flush();
        IntTests.assertTrue((filter.count == 20 ? 1 : 0) != 0);
        Log.removeFilter(filter);
        Log.removeFilter(levelFilter);
        streamLogWriter.close();
    }

    public void testStreamLogWriter2() {
        Filter filter = new Filter();
        Log.addFilter(filter);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamLogWriter streamLogWriter = new StreamLogWriter(new PrintWriter(byteArrayOutputStream), true);
        LogWriter logWriter = Log.getLogWriter();
        Log.setLogWriter(streamLogWriter);
        Logger.setLogLevel("de.qfs.lib.log.IntTests", 10);
        Log.setPreQueueLevel(10);
        Log.setOutputLevel(9);
        Log.setQueueing(true);
        this.log(10, 5);
        this.flush();
        String string = byteArrayOutputStream.toString();
        IntTests.assertTrue((boolean)string.equals(""));
        IntTests.assertTrue((filter.count == 5 ? 1 : 0) != 0);
        this.log(9, 5);
        this.flush();
        string = byteArrayOutputStream.toString();
        IntTests.assertTrue((string.length() > 0 ? 1 : 0) != 0);
        IntTests.assertTrue((boolean)string.endsWith("9" + LINESEP));
        IntTests.assertTrue((filter.count == 10 ? 1 : 0) != 0);
        Log.setOutputLevel(10);
        Log.setLogWriter(logWriter);
        Log.removeFilter(filter);
        streamLogWriter.close();
    }

    public void testFileLogWriter() {
        String string = "/tmp/xIntTestx.log";
        String string2 = "/tmp/xIntTestx1.log";
        String string3 = "/tmp/xIntTestx2.log";
        LogWriter logWriter = Log.getLogWriter();
        FileLogWriter fileLogWriter = null;
        try {
            fileLogWriter = new FileLogWriter("IntTest", string, 0, false);
        }
        catch (IOException iOException) {
            IntTests.assertTrue((boolean)false);
        }
        Log.setLogWriter(fileLogWriter);
        IntTests.assertTrue((this.countLines(string) == 1 ? 1 : 0) != 0);
        Logger.setLogLevel("de.qfs.lib.log.IntTests", 10);
        Log.setPreQueueLevel(10);
        Log.setQueueing(true);
        Log.setOutputLevel(9);
        this.log(10, 5);
        this.flush();
        IntTests.assertTrue((this.countLines(string) == 1 ? 1 : 0) != 0);
        this.log(9, 5);
        this.flush();
        IntTests.assertTrue((this.countLines(string) == 6 ? 1 : 0) != 0);
        this.log(9, 5);
        this.flush();
        IntTests.assertTrue((this.countLines(string) == 11 ? 1 : 0) != 0);
        fileLogWriter.close();
        try {
            fileLogWriter = new FileLogWriter("IntTest", string, 0, true);
        }
        catch (IOException iOException) {
            IntTests.assertTrue((boolean)false);
        }
        Log.setLogWriter(fileLogWriter);
        IntTests.assertTrue((this.countLines(string) == 1 ? 1 : 0) != 0);
        this.log(9, 5);
        this.flush();
        IntTests.assertTrue((this.countLines(string) == 6 ? 1 : 0) != 0);
        this.log(9, 5);
        this.flush();
        IntTests.assertTrue((this.countLines(string) == 11 ? 1 : 0) != 0);
        fileLogWriter.close();
        try {
            fileLogWriter = new FileLogWriter("IntTest", string, 1, false);
        }
        catch (IOException iOException) {
            IntTests.assertTrue((boolean)false);
        }
        Log.setLogWriter(fileLogWriter);
        IntTests.assertTrue((this.countLines(string) == 11 ? 1 : 0) != 0);
        this.log(9, 5);
        this.flush();
        IntTests.assertTrue((this.countLines(string) == 16 ? 1 : 0) != 0);
        fileLogWriter.close();
        this.log(9, 5);
        this.flush();
        IntTests.assertTrue((this.countLines(string) == 16 ? 1 : 0) != 0);
        new File(string2).delete();
        try {
            fileLogWriter = new FileLogWriter("IntTest", string, 2, true);
        }
        catch (IOException iOException) {
            IntTests.assertTrue((boolean)false);
        }
        Log.setLogWriter(fileLogWriter);
        IntTests.assertTrue((this.countLines(string) == 16 ? 1 : 0) != 0);
        IntTests.assertTrue((this.countLines(string2) == 1 ? 1 : 0) != 0);
        this.log(9, 5);
        this.flush();
        IntTests.assertTrue((this.countLines(string) == 16 ? 1 : 0) != 0);
        IntTests.assertTrue((this.countLines(string2) == 6 ? 1 : 0) != 0);
        this.log(9, 5);
        this.flush();
        IntTests.assertTrue((this.countLines(string) == 16 ? 1 : 0) != 0);
        IntTests.assertTrue((this.countLines(string2) == 11 ? 1 : 0) != 0);
        fileLogWriter.close();
        this.log(9, 5);
        this.flush();
        IntTests.assertTrue((this.countLines(string) == 16 ? 1 : 0) != 0);
        IntTests.assertTrue((this.countLines(string2) == 11 ? 1 : 0) != 0);
        new File(string3).delete();
        try {
            fileLogWriter = new FileLogWriter("IntTest", string, 2, false);
        }
        catch (IOException iOException) {
            IntTests.assertTrue((boolean)false);
        }
        Log.setLogWriter(fileLogWriter);
        IntTests.assertTrue((this.countLines(string) == 16 ? 1 : 0) != 0);
        IntTests.assertTrue((this.countLines(string2) == 11 ? 1 : 0) != 0);
        IntTests.assertTrue((this.countLines(string3) == 1 ? 1 : 0) != 0);
        this.log(9, 5);
        this.flush();
        IntTests.assertTrue((this.countLines(string) == 16 ? 1 : 0) != 0);
        IntTests.assertTrue((this.countLines(string2) == 11 ? 1 : 0) != 0);
        IntTests.assertTrue((this.countLines(string3) == 6 ? 1 : 0) != 0);
        fileLogWriter.close();
        this.log(9, 5);
        this.flush();
        IntTests.assertTrue((this.countLines(string) == 16 ? 1 : 0) != 0);
        IntTests.assertTrue((this.countLines(string2) == 11 ? 1 : 0) != 0);
        IntTests.assertTrue((this.countLines(string3) == 6 ? 1 : 0) != 0);
        Log.setLogWriter(logWriter);
    }

    public void XXXtestRingFileLogWriter() {
        String string = "/tmp/xIntTestx.log";
        String string2 = "/tmp/xIntTestx1.log";
        String string3 = "/tmp/xIntTestx2.log";
        String string4 = "/tmp/xIntTestx3.log";
        new File(string).delete();
        new File(string2).delete();
        new File(string3).delete();
        new File(string4).delete();
        LogWriter logWriter = Log.getLogWriter();
        Logger.setLogLevel("de.qfs.lib.log.IntTests", 10);
        Log.setPreQueueLevel(10);
        Log.setQueueing(true);
        Log.setOutputLevel(9);
        RingFileLogWriter ringFileLogWriter = null;
        try {
            ringFileLogWriter = new RingFileLogWriter("IntTest", string, 1, 2);
        }
        catch (IOException iOException) {
            IntTests.assertTrue((boolean)false);
        }
        Log.setLogWriter(ringFileLogWriter);
        IntTests.assertTrue((this.countLines(string) == 1 ? 1 : 0) != 0);
        IntTests.assertTrue((!new File(string2).exists() ? 1 : 0) != 0);
        IntTests.assertTrue((!new File(string3).exists() ? 1 : 0) != 0);
        logger.log(1, "mark0", "");
        this.log(9, 10);
        this.flush();
        this.log(9, 10);
        this.flush();
        IntTests.assertTrue((boolean)new File(string2).exists());
        IntTests.assertTrue((boolean)this.contains(string2, "mark0"));
        IntTests.assertTrue((!new File(string3).exists() ? 1 : 0) != 0);
        logger.log(1, "mark1", "");
        this.log(9, 20);
        this.flush();
        IntTests.assertTrue((boolean)new File(string2).exists());
        IntTests.assertTrue((boolean)this.contains(string2, "mark1"));
        IntTests.assertTrue((boolean)new File(string3).exists());
        IntTests.assertTrue((boolean)this.contains(string3, "mark0"));
        logger.log(1, "mark2", "");
        this.log(9, 20);
        this.flush();
        IntTests.assertTrue((boolean)new File(string2).exists());
        IntTests.assertTrue((boolean)this.contains(string2, "mark2"));
        IntTests.assertTrue((boolean)new File(string3).exists());
        IntTests.assertTrue((boolean)this.contains(string3, "mark1"));
        IntTests.assertTrue((!new File(string4).exists() ? 1 : 0) != 0);
        Log.setLogWriter(logWriter);
    }

    public void testLogStream() {
        Filter filter = new Filter();
        Log.addFilter(filter);
        PrintStream printStream = null;
        try {
            printStream = (PrintStream)PrintStream.class.getConstructor(OutputStream.class).newInstance(new LogStream(9, "clazz", "method"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            IntTests.assertTrue((boolean)false);
        }
        Log.setPreQueueLevel(10);
        Log.setQueueing(true);
        printStream.print("bla");
        this.flush();
        IntTests.assertTrue((filter.count == 0 ? 1 : 0) != 0);
        printStream.flush();
        this.flush();
        IntTests.assertTrue((filter.count == 1 ? 1 : 0) != 0);
        printStream.println("bla");
        this.flush();
        IntTests.assertTrue((filter.count == 2 ? 1 : 0) != 0);
        Log.setPreQueueLevel(3);
        printStream.println("bla");
        this.flush();
        IntTests.assertTrue((filter.count == 2 ? 1 : 0) != 0);
        Log.removeFilter(filter);
    }

    public void testExceptions() {
        Filter filter = new Filter();
        Log.addFilter(filter);
        Logger.setLogLevel("de.qfs.lib.log.IntTests", 9);
        Log.setPreQueueLevel(9);
        Log.setOutputLevel(0);
        try {
            throw new Exception("test");
        }
        catch (Exception exception) {
            logger.log("testExceptions()", exception);
            this.flush();
            IntTests.assertTrue((filter.count == 2 ? 1 : 0) != 0);
            IntTests.assertNotNull((Object)filter.entries);
            IntTests.assertTrue((filter.entries[filter.entries.length - 1].getLevel() == 2 ? 1 : 0) != 0);
            try {
                throw new Exception("test");
            }
            catch (Exception exception2) {
                logger.log(9, "testExceptions()", exception2);
                this.flush();
                IntTests.assertTrue((filter.count == 3 ? 1 : 0) != 0);
                IntTests.assertTrue((filter.entries[filter.entries.length - 1].getLevel() == 9 ? 1 : 0) != 0);
                logger.dumpStack(3, "testExceptions()", "test");
                this.flush();
                IntTests.assertTrue((filter.count == 5 ? 1 : 0) != 0);
                IntTests.assertTrue((filter.entries[filter.entries.length - 1].getLevel() == 4 ? 1 : 0) != 0);
                Log.removeFilter(filter);
                return;
            }
        }
    }

    private void log(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            logger.log(n, "log", "" + (this.id + i));
        }
        this.id += n2;
    }

    private void flush() {
        if (Log.isQueueing()) {
            Log.setQueueing(false);
            Log.setQueueing(true);
        }
    }

    private int countLines(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            int n = 0;
            while (bufferedReader.readLine() != null) {
                ++n;
            }
            return n;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return -1;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1;
        }
    }

    private boolean contains(String string, String string2) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                if (string3.indexOf(string2) >= 0) {
                    return true;
                }
                string3 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    private class Filter
    implements LogFilter {
        public int count;
        public LogEntry[] entries;

        private Filter() {
        }

        public boolean filter(LogEntry logEntry) {
            ++this.count;
            this.entries = new LogEntry[]{logEntry};
            return true;
        }

        public LogEntry[] filter(LogEntry[] logEntryArray) {
            this.count += logEntryArray.length;
            this.entries = logEntryArray;
            return logEntryArray;
        }
    }
}

