/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.FileLogWriter;
import de.qfs.lib.log.LevelFilter;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.LogFormat;
import java.io.File;
import java.io.IOException;

public class RingFileLogWriter
extends FileLogWriter {
    public static final int DEFAULT_SIZE_LIMIT = 1024;
    public static final int DEFAULT_FILE_LIMIT = 5;
    private static LevelFilter lastLevelFilter;
    protected int sizeLimit = 5;
    protected int fileLimit = 5;
    protected String client;
    protected String basename;
    protected String ext;
    protected File dir;
    private int writeCount;

    public RingFileLogWriter(String string, String string2, int n, int n2) throws IOException {
        super(string, string2, 1, true);
        this.client = string;
        this.sizeLimit = n;
        this.fileLimit = n2;
        String string3 = this.file.getParent();
        if (string3 == null) {
            string3 = ".";
        }
        this.dir = new File(string3);
        String string4 = this.file.getName();
        int n3 = string4.lastIndexOf(46);
        if (n3 > 0) {
            this.ext = string4.substring(n3);
            this.basename = string4.substring(0, n3);
        } else {
            this.ext = "";
            this.basename = string4;
        }
        this.checkLimit();
    }

    public RingFileLogWriter(String string, String string2, int n, int n2, LogFormat logFormat) throws IOException {
        super(string, string2, 1, true, logFormat);
        this.client = string;
        this.sizeLimit = n;
        this.fileLimit = n2;
        String string3 = this.file.getParent();
        if (string3 == null) {
            string3 = ".";
        }
        this.dir = new File(string3);
        String string4 = this.file.getName();
        int n3 = string4.lastIndexOf(46);
        if (n3 > 0) {
            this.ext = string4.substring(n3);
            this.basename = string4.substring(0, n3);
        } else {
            this.ext = "";
            this.basename = string4;
        }
        this.checkLimit();
    }

    public static LevelFilter logToFile(String string, String string2, int n, int n2) throws IOException {
        lastLevelFilter = new LevelFilter(-1, new RingFileLogWriter(string, string2, n, n2));
        Log.addFilter(lastLevelFilter);
        return lastLevelFilter;
    }

    public static LevelFilter logToFile(String string, String string2, int n, int n2, LogFormat logFormat) throws IOException {
        lastLevelFilter = new LevelFilter(-1, new RingFileLogWriter(string, string2, n, n2, logFormat));
        Log.addFilter(lastLevelFilter);
        return lastLevelFilter;
    }

    public static void stopLogging() {
        if (lastLevelFilter != null) {
            lastLevelFilter.getLogWriter().close();
            Log.removeFilter(lastLevelFilter);
            lastLevelFilter = null;
        }
    }

    public final int getSizeLimit() {
        return this.sizeLimit;
    }

    public final synchronized void setSizeLimit(int n) {
        this.sizeLimit = n;
        this.checkLimit();
    }

    public final int getFileLimit() {
        return this.fileLimit;
    }

    public final void setFileLimit(int n) {
        this.fileLimit = n;
    }

    public synchronized void write(LogEntry logEntry) {
        if (this.closed) {
            return;
        }
        super.write(logEntry);
        this.checkLimit();
    }

    public synchronized void write(LogEntry[] logEntryArray) {
        if (this.closed) {
            return;
        }
        super.write(logEntryArray);
        this.checkLimit();
    }

    protected synchronized void checkLimit() {
        if (this.writeCount++ < 100) {
            return;
        }
        this.writeCount = 0;
        if (this.file.length() / 1024L >= (long)this.sizeLimit) {
            int n = this.removeFiles();
            this.moveFiles(n);
            try {
                this.openFile(this.client, this.file.getPath(), 0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.closed = true;
            }
        }
    }

    protected int removeFiles() {
        String[] stringArray = this.dir.list();
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = this.getFileNum(stringArray[i]);
            if (this.fileLimit >= 0 && n2 >= this.fileLimit) {
                new File(this.dir, stringArray[i]).delete();
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    protected synchronized void moveFiles(int n) {
        int n2;
        for (int i = n2 = this.fileLimit < 0 ? n : this.fileLimit - 1; i >= 0; --i) {
            File file;
            File file2;
            File file3 = file2 = i == 0 ? this.file : new File(this.dir, this.basename + i + this.ext);
            if (!file2.exists() || file2.renameTo(file = new File(this.dir, this.basename + (i + 1) + this.ext))) continue;
            System.err.println("RingFileLogWriter: Failed to rename " + file2.getPath() + " to " + file);
        }
    }

    protected int getFileNum(String string) {
        if (string.startsWith(this.basename) && string.endsWith(this.ext) && string.length() > this.basename.length() + this.ext.length()) {
            String string2 = string.substring(this.basename.length(), string.length() - this.ext.length());
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }
}

