/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Properties;
import org.python.antlr.base.mod;
import org.python.core.CodeFlag;
import org.python.core.CompileMode;
import org.python.core.CompilerFlags;
import org.python.core.Options;
import org.python.core.ParserFacade;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFileReader;
import org.python.core.PyFileWriter;
import org.python.core.PyIntern;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.__builtin__;

public class PythonInterpreter
implements AutoCloseable,
Closeable {
    protected PySystemState systemState;
    PyObject globals;
    protected final boolean useThreadLocalState;
    protected static ThreadLocal<Object[]> threadLocals = new ThreadLocal<Object[]>(){

        @Override
        protected Object[] initialValue() {
            return new Object[1];
        }
    };
    protected CompilerFlags cflags = new CompilerFlags();
    private volatile boolean closed = false;

    public static void initialize(Properties preProperties, Properties postProperties, String[] argv) {
        PySystemState.initialize(preProperties, postProperties, argv);
    }

    public PythonInterpreter() {
        this(null, null);
    }

    public static PythonInterpreter threadLocalStateInterpreter(PyObject dict) {
        return new PythonInterpreter(dict, new PySystemState(), true);
    }

    public PythonInterpreter(PyObject dict) {
        this(dict, null);
    }

    public PythonInterpreter(PyObject dict, PySystemState systemState) {
        this(dict, systemState, false);
    }

    protected PythonInterpreter(PyObject dict, PySystemState systemState, boolean useThreadLocalState) {
        this.globals = dict != null ? dict : Py.newStringMap();
        this.systemState = systemState != null ? systemState : Py.getSystemState();
        this.setSystemState();
        this.useThreadLocalState = useThreadLocalState;
        PyModule module = new PyModule("__main__", this.globals);
        this.systemState.modules.__setitem__("__main__", (PyObject)module);
        if (Options.Qnew) {
            this.cflags.setFlag(CodeFlag.CO_FUTURE_DIVISION);
        }
        Py.importSiteIfSelected();
    }

    public PySystemState getSystemState() {
        return this.systemState;
    }

    protected void setSystemState() {
        Py.setSystemState(this.getSystemState());
    }

    public void setIn(PyObject inStream) {
        this.getSystemState().stdin = inStream;
    }

    public void setIn(Reader inStream) {
        this.setIn(new PyFileReader(inStream));
    }

    public void setIn(InputStream inStream) {
        this.setIn(new PyFile(inStream));
    }

    public void setOut(PyObject outStream) {
        this.getSystemState().stdout = outStream;
    }

    public void setOut(Writer outStream) {
        this.setOut(new PyFileWriter(outStream));
    }

    public void setOut(OutputStream outStream) {
        this.setOut(new PyFile(outStream));
    }

    public void setErr(PyObject outStream) {
        this.getSystemState().stderr = outStream;
    }

    public void setErr(Writer outStream) {
        this.setErr(new PyFileWriter(outStream));
    }

    public void setErr(OutputStream outStream) {
        this.setErr(new PyFile(outStream));
    }

    public PyObject eval(String s) {
        this.setSystemState();
        return __builtin__.eval(new PyString(s), this.getLocals());
    }

    public PyObject eval(PyObject code2) {
        this.setSystemState();
        return __builtin__.eval(code2, this.getLocals());
    }

    public void exec(String s) {
        this.setSystemState();
        Py.exec(Py.compile_flags(s, "<string>", CompileMode.exec, this.cflags), this.getLocals(), null);
        Py.flushLine();
    }

    public void exec(PyObject code2) {
        this.setSystemState();
        Py.exec(code2, this.getLocals(), null);
        Py.flushLine();
    }

    public void execfile(String filename) {
        PyObject locals = this.getLocals();
        this.setSystemState();
        __builtin__.execfile_flags(filename, locals, locals, this.cflags);
        Py.flushLine();
    }

    public void execfile(InputStream s) {
        this.execfile(s, "<iostream>");
    }

    public void execfile(InputStream s, String name) {
        this.setSystemState();
        Py.runCode(Py.compile_flags(s, name, CompileMode.exec, this.cflags), null, this.getLocals());
        Py.flushLine();
    }

    public PyCode compile(String script) {
        return this.compile(script, "<script>");
    }

    public PyCode compile(Reader reader) {
        return this.compile(reader, "<script>");
    }

    public PyCode compile(String script, String filename) {
        return this.compile(new StringReader(script), filename);
    }

    public PyCode compile(Reader reader, String filename) {
        mod node = ParserFacade.parseExpressionOrModule(reader, filename, this.cflags);
        this.setSystemState();
        return Py.compile_flags(node, filename, CompileMode.eval, this.cflags);
    }

    public PyObject getLocals() {
        if (!this.useThreadLocalState) {
            return this.globals;
        }
        PyObject locals = (PyObject)threadLocals.get()[0];
        if (locals != null) {
            return locals;
        }
        return this.globals;
    }

    public void setLocals(PyObject d) {
        if (!this.useThreadLocalState) {
            this.globals = d;
        } else {
            PythonInterpreter.threadLocals.get()[0] = d;
        }
    }

    public void set(String name, Object value) {
        this.getLocals().__setitem__(PyIntern.intern(name), Py.java2py(value));
    }

    public void set(String name, PyObject value) {
        this.getLocals().__setitem__(PyIntern.intern(name), value);
    }

    public PyObject get(String name) {
        return this.getLocals().__finditem__(PyIntern.intern(name));
    }

    public <T> T get(String name, Class<T> javaclass) {
        PyObject val = this.getLocals().__finditem__(PyIntern.intern(name));
        if (val == null) {
            return null;
        }
        return Py.tojava(val, javaclass);
    }

    public void cleanup() {
        this.setSystemState();
        PySystemState sys = Py.getSystemState();
        sys.callExitFunc();
        try {
            sys.stdout.invoke("flush");
        }
        catch (PyException pyException) {
            // empty catch block
        }
        try {
            sys.stderr.invoke("flush");
        }
        catch (PyException pyException) {
            // empty catch block
        }
        threadLocals.remove();
        sys.cleanup();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.cleanup();
        }
    }
}

