/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.accessibility;

import de.qfs.apps.qftest.client.Engine;
import de.qfs.apps.qftest.client.accessibility.ElementCheckResult;
import de.qfs.apps.qftest.client.accessibility.RuleCheckResult;
import de.qfs.apps.qftest.client.accessibility.ScreenshotHelper;
import de.qfs.apps.qftest.client.accessibility.a;
import de.qfs.apps.qftest.client.accessibility.checks.RuleCheck;
import de.qfs.apps.qftest.client.accessibility.g;
import de.qfs.apps.qftest.client.accessibility.m;
import de.qfs.apps.qftest.client.accessibility.r;
import de.qfs.apps.qftest.client.web.WebEngine;
import de.qfs.apps.qftest.client.web.dom.DocumentNode;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.Node;
import de.qfs.apps.qftest.shared.d.d;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.apps.qftest.shared.rmi.qftest.RemoteRunContext;
import de.qfs.lib.gui.Message;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.awt.Color;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class AccessibilityHelper {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.accessibility.AccessibilityHelper");

    public AccessibilityHelper() {
        if (AccessibilityHelper.a.level >= 7) {
            a.lvlBuild(7, "AccessibilityHelper.AccessibilityHelper()", 52).log();
        }
    }

    public static void addFailedRuleResult(RuleCheckResult ruleCheckResult, ElementCheckResult elementCheckResult, Node node, Node node2, List list) {
        if (AccessibilityHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "addFailedRuleResult(RuleCheckResult,ElementCheckResult,Node,Node,List<DomNode>)", 54).addDetail("ruleCheckResult", (Object)ruleCheckResult)).addDetail("check", (Object)elementCheckResult)).addDetail("scope", (Object)node)).addDetail("node", (Object)node2)).addDetail("scrollableElements", (Object)list)).log();
        }
        if (node == null) {
            throw new IllegalArgumentException("scope is marked non-null but is null");
        }
        AccessibilityHelper.a(elementCheckResult, node, node2, list);
        ruleCheckResult.addFailedCheck(elementCheckResult);
    }

    public static void addImpossibleRuleResult(RuleCheckResult ruleCheckResult, ElementCheckResult elementCheckResult, Node node, Node node2, Boolean bl2, List list) {
        if (AccessibilityHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "addImpossibleRuleResult(RuleCheckResult,ElementCheckResult,Node,Node,Boolean,List<DomNode>)", 59).addDetail("ruleCheckResult", (Object)ruleCheckResult)).addDetail("check", (Object)elementCheckResult)).addDetail("scope", (Object)node)).addDetail("node", (Object)node2)).addDetail("shouldShowSkippedResults", (Object)bl2)).addDetail("scrollableElements", (Object)list)).log();
        }
        if (node == null) {
            throw new IllegalArgumentException("scope is marked non-null but is null");
        }
        if (bl2.booleanValue()) {
            AccessibilityHelper.a(elementCheckResult, node, node2, list);
            ruleCheckResult.addImpossibleCheck(elementCheckResult);
        }
    }

    @Deprecated
    public static void addFailedRuleResult(RuleCheckResult ruleCheckResult, ElementCheckResult elementCheckResult, Node node, Node node2, RuleCheck.a a2, List list) {
        if (AccessibilityHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "addFailedRuleResult(RuleCheckResult,ElementCheckResult,Node,Node,LogElementScreenshotsEnum,List<DomNode>)", 70).addDetail("ruleCheckResult", (Object)ruleCheckResult)).addDetail("check", (Object)elementCheckResult)).addDetail("scope", (Object)node)).addDetail("node", (Object)node2)).addDetail("logElementScreenshots", (Object)a2)).addDetail("scrollableElements", (Object)list)).log();
        }
        if (node == null) {
            throw new IllegalArgumentException("scope is marked non-null but is null");
        }
        AccessibilityHelper.addFailedRuleResult(ruleCheckResult, elementCheckResult, node, node2, list);
    }

    @Deprecated
    public static void addImpossibleRuleResult(RuleCheckResult ruleCheckResult, ElementCheckResult elementCheckResult, Node node, Node node2, RuleCheck.a a2, Boolean bl2, List list) {
        if (AccessibilityHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "addImpossibleRuleResult(RuleCheckResult,ElementCheckResult,Node,Node,LogElementScreenshotsEnum,Boolean,List<DomNode>)", 75).addDetail("ruleCheckResult", (Object)ruleCheckResult)).addDetail("check", (Object)elementCheckResult)).addDetail("scope", (Object)node)).addDetail("node", (Object)node2)).addDetail("logElementScreenshots", (Object)a2)).addDetail("shouldShowSkippedResults", (Object)bl2)).addDetail("scrollableElements", (Object)list)).log();
        }
        if (node == null) {
            throw new IllegalArgumentException("scope is marked non-null but is null");
        }
        AccessibilityHelper.addImpossibleRuleResult(ruleCheckResult, elementCheckResult, node, node2, bl2, list);
    }

    public static void addSatisfiedRuleResult(RuleCheckResult ruleCheckResult, ElementCheckResult elementCheckResult, Boolean bl2) {
        if (AccessibilityHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "addSatisfiedRuleResult(RuleCheckResult,ElementCheckResult,Boolean)", 80).addDetail("ruleCheckResult", (Object)ruleCheckResult)).addDetail("check", (Object)elementCheckResult)).addDetail("shouldShowSatisfiedResults", (Object)bl2)).log();
        }
        if (bl2.booleanValue()) {
            ruleCheckResult.addSatisfiedCheck(elementCheckResult);
        }
    }

    public static void setFailureOverviewAndScreenshots(RuleCheckResult ruleCheckResult, Node node, List list, Boolean bl2, d d2, Boolean bl3, Integer n2) {
        if (AccessibilityHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "setFailureOverviewAndScreenshots(RuleCheckResult,Node,List<DomNode>,Boolean,LogElementScreenshots,Boolean,Integer)", 86).addDetail("ruleCheckResult", (Object)ruleCheckResult)).addDetail("scope", (Object)node)).addDetail("scrollableNodes", (Object)list)).addDetail("logOverviewScreenshot", (Object)bl2)).addDetail("logElementScreenshots", (Object)d2)).addDetail("shouldShowSkippedResults", (Object)bl3)).addDetail("allowedHeightOfOverviewScreenshot", (Object)n2)).log();
        }
        if (node == null) {
            throw new IllegalArgumentException("scope is marked non-null but is null");
        }
        List list2 = ruleCheckResult.getFailedChecks();
        List list3 = ruleCheckResult.getImpossibleChecks();
        if (!list2.isEmpty() || !list3.isEmpty()) {
            Iterator iterator;
            m m2 = new m(node, null, null, n2);
            m2.a(node);
            m2.b(list);
            Callable<List> callable = () -> AccessibilityHelper.a(list, ruleCheckResult);
            List list4 = (List)de.qfs.apps.qftest.client.accessibility.a.a((Engine)node.getEngine(), 5, "scrollable nodes with violation", callable);
            DomNode domNode = null;
            if (node instanceof DocumentNode) {
                iterator = de.qfs.apps.qftest.client.accessibility.a.c(node, "return document.scrollingElement", 5, "scroll component for document");
                if (iterator instanceof DomNode) {
                    domNode = (DomNode)((Object)iterator);
                }
            } else {
                domNode = AccessibilityHelper.a(list4, ruleCheckResult.getFailedChecks());
            }
            m2.a(domNode);
            if (AccessibilityHelper.a(d2)) {
                for (g g2 : list2) {
                    if (g2.getElement() == null) continue;
                    ScreenshotHelper.logElementScreenshot(g2, node, domNode, g2.getElement(), Color.RED);
                }
            }
            if (bl3.booleanValue() && AccessibilityHelper.a(d2)) {
                for (g g2 : list3) {
                    if (g2.getElement() == null) continue;
                    ScreenshotHelper.logElementScreenshot(g2, node, domNode, g2.getElement(), Color.YELLOW);
                }
            }
            if (bl2.booleanValue() && (node instanceof DomNode || node instanceof DocumentNode)) {
                if (node instanceof DomNode) {
                    iterator = ((DomNode)node)::scrollVisible;
                    de.qfs.apps.qftest.client.accessibility.a.a((Engine)node.getEngine(), 5, "scrolling scope visible", (Runnable)((Object)iterator));
                }
                ScreenshotHelper.createOverviewScreenshotAndHighlightViolations(node, ruleCheckResult, m2, list4);
            }
            ruleCheckResult.setFailureOverview(m2);
        }
    }

    public static void logResults(RuleCheckResult ruleCheckResult, RemoteRunContext remoteRunContext, Boolean bl2, d d2, Integer n2, Boolean bl3) {
        String[] stringArray;
        List list;
        List list2;
        List list3;
        block15: {
            if (AccessibilityHelper.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "logResults(RuleCheckResult,RemoteRunContext,Boolean,LogElementScreenshots,Integer,Boolean)", 137).addDetail("ruleCheckResult", (Object)ruleCheckResult)).addDetail("context", (Object)remoteRunContext)).addDetail("squashCheckResultsWithSameMessage", (Object)bl2)).addDetail("logElementScreenshots", (Object)d2)).addDetail("allowedNumberOfElementScreenshots", (Object)n2)).addDetail("logElementSmartIdToMessage", (Object)bl3)).log();
            }
            try {
                remoteRunContext.setScreenshotsAlreadyCreated(true);
            }
            catch (RemoteException remoteException) {
                if (AccessibilityHelper.a.level < 3) break block15;
                ((LevelAwareLogBuilder)a.lvlBuild(3, "logResults(RuleCheckResult,RemoteRunContext,Boolean,LogElementScreenshots,Integer,Boolean)", 147).add("e", (Object)remoteException)).log();
            }
        }
        String string = ruleCheckResult.getErrorCode();
        String string2 = ruleCheckResult.getRuleId();
        String string3 = ruleCheckResult.getRuleImpact();
        m m2 = ruleCheckResult.getFailureOverview();
        if (bl2.booleanValue()) {
            list3 = ruleCheckResult.getSquashedFailedChecks();
            list2 = ruleCheckResult.getSquashedImpossibleChecks();
            list = ruleCheckResult.getSquashedSatisfiedChecks();
        } else {
            list3 = ruleCheckResult.getFailedChecks();
            list2 = ruleCheckResult.getImpossibleChecks();
            list = ruleCheckResult.getSatisfiedChecks();
        }
        if (m2 != null) {
            Object object2;
            Iterator iterator = ruleCheckResult.getNumberOfFailedChecksPerImpact().entrySet();
            Object object3 = new StringBuilder();
            stringArray = iterator.iterator();
            while (stringArray.hasNext()) {
                object2 = (Map.Entry)stringArray.next();
                ((StringBuilder)object3).append("\n- impact ").append((String)object2.getKey()).append(" ").append(object2.getValue());
            }
            stringArray = ruleCheckResult.getNumberOfImpossibleChecksPerImpact().entrySet();
            object2 = new StringBuilder();
            for (Map.Entry object4 : stringArray) {
                ((StringBuilder)object2).append("\n- impact ").append((String)object4.getKey()).append(" ").append(object4.getValue());
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = m2.getUrl();
            AccessibilityHelper.a(string4, stringBuilder);
            AccessibilityHelper.a(stringBuilder, m2, true, bl3);
            String[] stringArray2 = new String[]{string, ruleCheckResult.getNumberOfFailedChecks(), ((StringBuilder)object3).toString(), string2, ruleCheckResult.getNumberOfImpossibleChecks(), ((StringBuilder)object2).toString(), stringBuilder.toString()};
            de.qfs.apps.qftest.client.accessibility.a.a(remoteRunContext, "msg.a11y.overviewMessage", stringArray2);
            ImageRep imageRep = m2.getImage();
            if (imageRep != null) {
                boolean bl4 = m2.a();
                String string5 = bl4 ? Message.format((String)"msg.a11y.overviewImage.title.cropped", (Object[])new Object[]{string}) : Message.format((String)"msg.a11y.overviewImage.title.standard", (Object[])new Object[]{string});
                String string6 = stringBuilder.toString();
                List list4 = m2.b();
                if (!list4.isEmpty()) {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    AccessibilityHelper.a(string4, stringBuilder2);
                    for (g g2 : list4) {
                        AccessibilityHelper.a(stringBuilder2, g2, false, bl3);
                    }
                    string6 = string6 + "\n\n" + Message.format((String)"msg.a11y.overviewImage.comment.invisibleElements", (Object[])new Object[]{stringBuilder2.toString()});
                }
                if (bl4) {
                    string6 = string6 + "\n\n" + Message.format((String)"msg.a11y.overviewImage.comment.cropped", (Object[])new Object[0]);
                }
                de.qfs.apps.qftest.client.accessibility.a.a(remoteRunContext, imageRep, string5, string6);
            }
        }
        for (Object object3 : list3) {
            stringArray = new String[]{((g)object3).getAxeRuleIds().isEmpty() ? string2 + "\n" : AccessibilityHelper.b((g)object3), string, !Misc.emptyOrNull((String)string3) ? AccessibilityHelper.a(string3) : AccessibilityHelper.a((g)object3), AccessibilityHelper.a(bl2, (g)object3, bl3), ((g)object3).getMessage()};
            de.qfs.apps.qftest.client.accessibility.a.c(remoteRunContext, "msg.a11y.failedCheck", stringArray);
            n2 = AccessibilityHelper.a(remoteRunContext, bl2, d2, (g)object3, "msg.a11y.firstFailureImageTitle", "msg.a11y.failureImageTitle", bl3, n2);
        }
        for (Object object3 : list2) {
            stringArray = new String[]{((g)object3).getAxeRuleIds().isEmpty() ? string2 + "\n" : AccessibilityHelper.b((g)object3), string2, !Misc.emptyOrNull((String)string3) ? AccessibilityHelper.a(string3) : AccessibilityHelper.a((g)object3), AccessibilityHelper.a(bl2, (g)object3, bl3), ((g)object3).getMessage()};
            de.qfs.apps.qftest.client.accessibility.a.b(remoteRunContext, "msg.a11y.impossibleCheck", stringArray);
            n2 = AccessibilityHelper.a(remoteRunContext, bl2, d2, (g)object3, "msg.a11y.firstImpossibleImageTitle", "msg.a11y.impossibleImageTitle", bl3, n2);
        }
        for (Object object3 : list) {
            stringArray = new String[]{((g)object3).getAxeRuleIds().isEmpty() ? string2 + "\n" : AccessibilityHelper.b((g)object3), string2, AccessibilityHelper.a(bl2, (g)object3, bl3), ((g)object3).getMessage()};
            de.qfs.apps.qftest.client.accessibility.a.a(remoteRunContext, "msg.a11y.satisfiedCheck", stringArray);
        }
    }

    private static void a(String string, StringBuilder stringBuilder) {
        if (AccessibilityHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "appendUrl(String,StringBuilder)", 273).addDetail("url", string)).addDetail("componentInfos", (Object)stringBuilder)).log();
        }
        if (!Misc.emptyOrNull((String)string)) {
            stringBuilder.append("\nURL: ").append(string).append("\n");
        }
    }

    private static Integer a(RemoteRunContext remoteRunContext, Boolean bl2, d d2, g g2, String string, String string2, Boolean bl3, Integer n2) {
        if (AccessibilityHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "logElementScreenshotsAndGetNumberOfRestAllowed(RemoteRunContext,Boolean,LogElementScreenshots,CheckResult,String,String,Boolean,Integer)", 280).addDetail("context", (Object)remoteRunContext)).addDetail("squashCheckResultsWithSameMessage", (Object)bl2)).addDetail("logElementScreenshots", (Object)d2)).addDetail("check", (Object)g2)).addDetail("firstImageTitleResource", string)).addDetail("imageTitleResource", string2)).addDetail("logElementSmartIdToMessage", (Object)bl3)).addDetail("allowedNumberOfElementScreenshots", (Object)n2)).log();
        }
        if (AccessibilityHelper.a(d2)) {
            Object object5;
            Object object2;
            ArrayList arrayList;
            if (bl2.booleanValue() && g2 instanceof r) {
                Object object3;
                Object object4;
                arrayList = ((r)g2).a();
                if (d.b.equals((Object)d2) && !arrayList.isEmpty()) {
                    String string3 = arrayList.size() > 1 ? Message.format((String)string, (Object[])new String[0]) : Message.format((String)string2, (Object[])new String[]{""});
                    object2 = (ElementCheckResult)arrayList.get(0);
                    object5 = ((g)object2).getImage();
                    if (object5 != null && n2 > 0) {
                        de.qfs.apps.qftest.client.accessibility.a.a(remoteRunContext, (ImageRep)object5, string3, AccessibilityHelper.a(false, (g)object2, bl3));
                        object4 = n2;
                        n2 = n2 - 1;
                        object3 = n2;
                    }
                }
                if (d.a.equals((Object)d2)) {
                    int n3 = 1;
                    for (Object object5 : arrayList) {
                        object4 = ((g)object5).getImage();
                        if (object4 == null) continue;
                        if (n2 <= 0) break;
                        object3 = arrayList.size() == 1 ? Message.format((String)string2, (Object[])new String[]{""}) : Message.format((String)string2, (Object[])new String[]{n3 + " "});
                        ++n3;
                        de.qfs.apps.qftest.client.accessibility.a.a(remoteRunContext, object4, (String)object3, AccessibilityHelper.a(false, (g)object5, bl3));
                        Integer n4 = n2;
                        Integer n5 = n2 = Integer.valueOf(n2 - 1);
                    }
                }
            }
            if (!bl2.booleanValue() && g2 instanceof ElementCheckResult && (arrayList = g2.getImage()) != null && n2 > 0) {
                String string4 = Message.format((String)string2, (Object[])new String[]{""});
                de.qfs.apps.qftest.client.accessibility.a.a(remoteRunContext, (ImageRep)arrayList, string4, AccessibilityHelper.a(false, g2, bl3));
                object2 = n2;
                n2 = n2 - 1;
                object5 = n2;
            }
        }
        return n2;
    }

    private static void a(ElementCheckResult elementCheckResult, Node node, Node node2, List list) {
        if (AccessibilityHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "detectScrollableParentsAndSetGeometry(ElementCheckResult,Node,Node,List<DomNode>)", 344).addDetail("check", (Object)elementCheckResult)).addDetail("scope", (Object)node)).addDetail("node", (Object)node2)).addDetail("scrollableElements", (Object)list)).log();
        }
        if (node == null) {
            throw new IllegalArgumentException("scope is marked non-null but is null");
        }
        Runnable runnable = () -> {
            elementCheckResult.setScrollableParents(list);
            elementCheckResult.setGeometry(node2, node);
        };
        de.qfs.apps.qftest.client.accessibility.a.a((Engine)node.getEngine(), 5, "detecting scrollable parents and setting geometry", runnable);
    }

    private static String a(g g2) {
        if (AccessibilityHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getAxeRuleIdsPerImpact(CheckResult)", 352).addDetail("check", (Object)g2)).log();
        }
        if (!g2.getAxeRuleIds().isEmpty()) {
            return g2.getAxeRuleIdsPerImpact();
        }
        return "";
    }

    private static String a(String string) {
        if (AccessibilityHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getRuleImpactForMessage(String)", 359).addDetail("ruleImpact", string)).log();
        }
        return String.format("- impact %s\n", string);
    }

    private static String b(g g2) {
        if (AccessibilityHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getAxeRuleIds(CheckResult)", 363).addDetail("check", (Object)g2)).log();
        }
        List list = g2.getAxeRuleIds();
        return String.join((CharSequence)", ", list) + "\n";
    }

    private static void a(StringBuilder stringBuilder, g g2, boolean bl2, Boolean bl3) {
        String string;
        String string2;
        Node node;
        if (AccessibilityHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "appendElementInfo(StringBuilder,CheckResult,boolean,Boolean)", 368).addDetail("messageBuilder", (Object)stringBuilder)).addDetail("checkResult", (Object)g2)).addDetail("isOverview", bl2)).addDetail("shouldLogSmartId", (Object)bl3)).log();
        }
        if (!Misc.emptyOrNull((Object)(node = g2.getElement()))) {
            stringBuilder.append(bl2 ? "\nScope" : "\nElement").append(":");
        }
        if (!Misc.emptyOrNull((String)(string2 = g2.getXPath()))) {
            stringBuilder.append("\n- XPath: ").append(string2);
        }
        if (bl3 != null && bl3.booleanValue() && !Misc.emptyOrNull((String)(string = g2.getSmartID()))) {
            stringBuilder.append("\n- SmartID: ").append(string);
        }
        if (!Misc.emptyOrNull((String)(string = g2.getSelector()))) {
            stringBuilder.append("\n- Selector: ").append(string);
        }
    }

    private static String a(boolean bl2, g g2, Boolean bl3) {
        if (AccessibilityHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckElementsInfo(boolean,CheckResult,Boolean)", 391).addDetail("squashCheckResultsWithSameMessage", bl2)).addDetail("check", (Object)g2)).addDetail("logElementSmartIdToMessage", (Object)bl3)).log();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = g2.getUrl();
        AccessibilityHelper.a(string, stringBuilder);
        if (bl2 && g2 instanceof r) {
            for (ElementCheckResult elementCheckResult : ((r)g2).a()) {
                AccessibilityHelper.a(stringBuilder, elementCheckResult, false, bl3);
            }
        } else if (g2 instanceof ElementCheckResult) {
            ElementCheckResult elementCheckResult = (ElementCheckResult)g2;
            AccessibilityHelper.a(stringBuilder, elementCheckResult, false, bl3);
        }
        return stringBuilder.toString();
    }

    private static boolean a(d d2) {
        if (AccessibilityHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "shouldLogElementScreenshots(LogElementScreenshots)", 414).addDetail("logElementScreenshots", (Object)d2)).log();
        }
        return d.a.equals((Object)d2) || d.b.equals((Object)d2);
    }

    private static List a(List list, RuleCheckResult ruleCheckResult) {
        List list2 = ruleCheckResult.getAllFailedAndImpossibleChecks();
        return list.stream().filter(domNode -> list2.stream().anyMatch(g2 -> g2.getElement().isAncestor((Node)domNode))).collect(Collectors.toList());
    }

    private static DomNode a(List list, List list2) {
        if (AccessibilityHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getMainScrollComponent(List<DomNode>,List<CheckResult>)", 426).addDetail("scrollableNodesWithViolations", (Object)list)).addDetail("failedChecks", (Object)list2)).log();
        }
        DomNode domNode = null;
        String string = null;
        if (!Misc.emptyOrNull((Collection)list)) {
            List list3 = list2.stream().map(g::getXPath).collect(Collectors.toList());
            for (DomNode domNode2 : list) {
                boolean bl2 = true;
                String string2 = de.qfs.apps.qftest.client.accessibility.a.b((Node)domNode2);
                for (String string3 : list3) {
                    if (string3.startsWith(string2)) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                if (domNode == null) {
                    domNode = domNode2;
                    string = string2;
                    continue;
                }
                if (string.length() <= string2.length()) continue;
                domNode = domNode2;
                string = string2;
            }
        }
        return domNode;
    }

    public static void registerScrollListener(Node node) {
        if (AccessibilityHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "registerScrollListener(Node)", 456).addDetail("scope", (Object)node)).log();
        }
        if (node == null) {
            throw new IllegalArgumentException("scope is marked non-null but is null");
        }
        WebEngine webEngine = node.getEngine();
        Runnable runnable = () -> webEngine.injectCode("overviewScreenshotScrollListener", "window._qf_set_timestamp = function(){window._qf_scroll_timestamp = Date.now()}; window.addEventListener('scroll', window._qf_set_timestamp)", "window._qf_scroll_timestamp = undefined;window.removeEventListener('scroll', window._qf_set_timestamp);window._qf_set_timestamp = undefined");
        de.qfs.apps.qftest.client.accessibility.a.a((Engine)webEngine, 5, "injecting scroll listener", runnable);
    }
}

