/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.accessibility;

import de.qfs.apps.qftest.client.ElementHelper;
import de.qfs.apps.qftest.client.Engine;
import de.qfs.apps.qftest.client.accessibility.ElementCheckResult;
import de.qfs.apps.qftest.client.accessibility.RuleCheckResult;
import de.qfs.apps.qftest.client.accessibility.a;
import de.qfs.apps.qftest.client.accessibility.g;
import de.qfs.apps.qftest.client.accessibility.m;
import de.qfs.apps.qftest.client.av;
import de.qfs.apps.qftest.client.web.WebEngine;
import de.qfs.apps.qftest.client.web.WebHelper;
import de.qfs.apps.qftest.client.web.WebImageHandler;
import de.qfs.apps.qftest.client.web.dom.DocumentNode;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.Node;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.image.BaseImageHandler;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.apps.qftest.shared.f;
import de.qfs.apps.qftest.shared.j;
import de.qfs.apps.qftest.shared.system.Native;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;

public class ScreenshotHelper {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.accessibility.ScreenshotHelper");
    public static final int PADDING = 50;

    public ScreenshotHelper() {
        if (ScreenshotHelper.a.level >= 7) {
            a.lvlBuild(7, "ScreenshotHelper.ScreenshotHelper()", 64).log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createOverviewScreenshotAndHighlightViolations(Node node, RuleCheckResult ruleCheckResult, m m2, List list) {
        if (ScreenshotHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createOverviewScreenshotAndHighlightViolations(Node,RuleCheckResult,OverviewResult,List<DomNode>)", 77).addDetail("scope", (Object)node)).addDetail("ruleCheckResult", (Object)ruleCheckResult)).addDetail("overviewResult", (Object)m2)).addDetail("scrollableNodesWithViolations", (Object)list)).log();
        }
        if (node == null) {
            throw new IllegalArgumentException("scope is marked non-null but is null");
        }
        int n2 = Options.cached_OPT_WEB_A11Y_SLEEP_OVERVIEW_SCREENSHOT;
        boolean bl2 = node instanceof DocumentNode;
        WebEngine webEngine = node.getEngine();
        WebImageHandler webImageHandler = (WebImageHandler)WebImageHandler.instance(webEngine);
        Options.pushOption((String)Options.OPT_WEB_SCROLL_VISIBLE, (Object)"never");
        try {
            DomNode domNode = m2.e();
            ScreenshotHelper.a(m2, ruleCheckResult, list, domNode);
            av av2 = node.getEngine().getPlayer();
            av2.sync(false);
            if (node instanceof DomNode) {
                ScreenshotHelper.removeOverflowFromScope((DomNode)node);
            }
            double d2 = ScreenshotHelper.d(node);
            int n3 = j.a((int)ScreenshotHelper.a(node), (double)d2);
            int n4 = j.a((int)ScreenshotHelper.b(node), (double)d2);
            if (domNode == null) {
                ScreenshotHelper.a(node, m2, n3, n4, webImageHandler);
            } else {
                f f2 = ScreenshotHelper.a(ruleCheckResult, domNode, bl2);
                int n5 = j.a((int)ScreenshotHelper.c((Node)domNode), (double)d2);
                int n6 = n5 <= n4 ? 0 : Math.max(f2.a() - 70, 0);
                m2.b(n6);
                if (node instanceof DocumentNode) {
                    ScreenshotHelper.createScrolledOverviewScreenshotForDocumentNode(node, webImageHandler, m2, f2, n3, n4, n5, n6, n2);
                } else if (node instanceof DomNode) {
                    ScreenshotHelper.createScrolledOverviewScreenshotForDomNode((DomNode)node, webImageHandler, m2, domNode, f2, n4, n5, n6, n2);
                }
            }
        }
        finally {
            Options.popOption((String)Options.OPT_WEB_SCROLL_VISIBLE);
        }
        if (m2.getImage() != null) {
            ScreenshotHelper.highlightImpossibleAndFailedChecks(node, ruleCheckResult, m2);
        }
    }

    private static void a(Node node, m m2, int n2, int n3, WebImageHandler webImageHandler) {
        if (ScreenshotHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createNotScrolledOverviewScreenshot(Node,OverviewResult,int,int,WebImageHandler)", 144).addDetail("scope", (Object)node)).addDetail("overviewResult", (Object)m2)).addDetail("windowInnerWidth", n2)).addDetail("windowInnerHeight", n3)).addDetail("imageHandler", (Object)webImageHandler)).log();
        }
        if (node == null) {
            throw new IllegalArgumentException("scope is marked non-null but is null");
        }
        m2.b(0);
        ElementHelper.Geometry geometry = de.qfs.apps.qftest.client.accessibility.a.a(node);
        int n4 = n2;
        int n5 = n3;
        if (geometry != null) {
            double d2 = ScreenshotHelper.d(node);
            n4 = Math.min(j.a((int)geometry.width, (double)d2), n2);
            n5 = Math.min(j.a((int)geometry.height, (double)d2), n3);
        }
        if (n4 < Integer.MAX_VALUE && n5 < Integer.MAX_VALUE) {
            m2.setImage(de.qfs.apps.qftest.client.accessibility.a.a(webImageHandler, node, 0, 0, n4, n5));
        }
    }

    public static void createScrolledOverviewScreenshotForDocumentNode(Node node, WebImageHandler webImageHandler, m m2, f f2, int n2, int n3, int n4, int n5, int n6) {
        if (ScreenshotHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createScrolledOverviewScreenshotForDocumentNode(Node,WebImageHandler,OverviewResult,Interval,int,int,int,int,int)", 167).addDetail("scope", (Object)node)).addDetail("imageHandler", (Object)webImageHandler)).addDetail("overview", (Object)m2)).addDetail("yIntervalOfViolations", (Object)f2)).addDetail("windowInnerWidth", n2)).addDetail("windowInnerHeight", n3)).addDetail("maxScrollHeight", n4)).addDetail("initialScrollHeight", n5)).addDetail("sleepForOverviewScreenshot", n6)).log();
        }
        if (node == null) {
            throw new IllegalArgumentException("scope is marked non-null but is null");
        }
        WebHelper webHelper = node.getHelper();
        int n7 = Math.max(Math.min(f2.b(), m2.c()), n3);
        ImageRep imageRep = null;
        if (Options.cached_OPT_WEB_A11Y_BROWSER_OVERVIEW_SCREENSHOT) {
            imageRep = webHelper.captureCompletePageImage(node);
        }
        if (imageRep != null) {
            imageRep.crop(0, n5, imageRep.getWidth(), n7);
            m2.setImage(imageRep);
        } else {
            int n8;
            int n9 = n5;
            int n10 = 0;
            int n11 = (int)Math.ceil((double)n7 / (double)n3);
            int n12 = (int)Math.ceil((double)(n4 - n9) / (double)n3);
            int n13 = Math.min(n12, n11);
            int n14 = n4 - n9 - n3 * (n13 - 1);
            if (n14 < (n8 = n3)) {
                n8 = n14;
            }
            BufferedImage bufferedImage = new BufferedImage(n2, (n13 - 1) * n3 + n8, 2);
            av av2 = node.getEngine().getPlayer();
            for (int i2 = 0; i2 < n13; ++i2) {
                de.qfs.apps.qftest.client.accessibility.a.d(node, String.format("document.scrollingElement.scroll(0, %d)", j.b((int)n9, (double)ScreenshotHelper.d(node))), 5, "scroll component for document");
                if (ScreenshotHelper.a.level >= 5) {
                    ((LevelAwareLogBuilder)a.lvlBuild(5, "createScrolledOverviewScreenshotForDocumentNode(Node,WebImageHandler,OverviewResult,Interval,int,int,int,int,int)", 201).add("currentScrollHeight", n9)).log();
                }
                int n15 = 1;
                if (i2 == 0) {
                    n15 = 4;
                }
                ScreenshotHelper.a(m2.e(), n6, n15);
                av2.sync(false);
                int n16 = n3;
                if (i2 == n13 - 1) {
                    n16 = n8;
                }
                BufferedImage bufferedImage2 = ScreenshotHelper.a(node, webImageHandler, n9, n2, n16);
                n9 += n3;
                if (bufferedImage2 != null) {
                    bufferedImage = ScreenshotHelper.a(bufferedImage2, n10, bufferedImage);
                } else if (ScreenshotHelper.a.level >= 1) {
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "createScrolledOverviewScreenshotForDocumentNode(Node,WebImageHandler,OverviewResult,Interval,int,int,int,int,int)", 217).add("Current overview screenshot part was null on scroll position", n9)).log();
                }
                n10 += n16;
            }
            m2.setImage(ScreenshotHelper.a(bufferedImage));
        }
        if (f2.b() > m2.c()) {
            m2.a(true);
        }
    }

    public static void createScrolledOverviewScreenshotForDomNode(DomNode domNode, WebImageHandler webImageHandler, m m2, DomNode domNode2, f f2, int n2, int n3, int n4, int n5) {
        if (ScreenshotHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createScrolledOverviewScreenshotForDomNode(DomNode,WebImageHandler,OverviewResult,DomNode,Interval,int,int,int,int)", 231).addDetail("scope", (Object)domNode)).addDetail("imageHandler", (Object)webImageHandler)).addDetail("overview", (Object)m2)).addDetail("scrollComponent", (Object)domNode2)).addDetail("yIntervalOfViolations", (Object)f2)).addDetail("windowInnerHeight", n2)).addDetail("maxScrollHeight", n3)).addDetail("initialScrollHeight", n4)).addDetail("sleepForOverviewScreenshot", n5)).log();
        }
        int n6 = n4;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        boolean bl2 = de.qfs.apps.qftest.client.accessibility.a.b(domNode);
        int n10 = 0;
        int n11 = n6;
        m2.b(n6);
        BufferedImage bufferedImage = null;
        av av2 = domNode.getEngine().getPlayer();
        av2.sync(false);
        int n12 = 0;
        double d2 = ScreenshotHelper.d((Node)domNode);
        while (n6 < n3 && n7 < m2.c()) {
            int n13;
            ElementHelper.Geometry geometry;
            BufferedImage bufferedImage2;
            de.qfs.apps.qftest.client.accessibility.a.d(domNode2, String.format("_qf_node.scroll(0, %d)", j.b((int)n6, (double)d2)), 5, "scrolling");
            if (ScreenshotHelper.a.level >= 5) {
                ((LevelAwareLogBuilder)a.lvlBuild(5, "createScrolledOverviewScreenshotForDomNode(DomNode,WebImageHandler,OverviewResult,DomNode,Interval,int,int,int,int)", 257).add("currentScrollHeight", n6)).log();
            }
            int n14 = 1;
            if (n12 == 0) {
                n14 = 4;
            }
            ++n12;
            ScreenshotHelper.a(domNode2, n5, n14);
            av2.sync(false);
            if (bl2) {
                if (n8 == 0) {
                    n9 = j.a((int)Integer.parseInt(DomNode.getAttribute(domNode2.getBrowser(), domNode2.getHandle(), "offsetheight", '\u0000')), (double)d2);
                }
                n8 = n8 != 0 ? n8 : j.a((int)Integer.parseInt(DomNode.getAttribute(domNode2.getBrowser(), domNode2.getHandle(), "offsetwidth", '\u0000')), (double)d2);
                m2.a((Node)domNode);
                bufferedImage2 = ScreenshotHelper.a(m2.d(), webImageHandler, n6, n8, n9);
            } else {
                if (m2.d() == null) {
                    m2.a((Node)domNode);
                }
                if ((bufferedImage2 = ScreenshotHelper.a(m2.d(), webImageHandler, n11, n8, n9)) != null && bufferedImage2.getHeight() > n2) {
                    ElementHelper.Geometry geometry2 = de.qfs.apps.qftest.client.accessibility.a.a((Node)domNode2, (Node)domNode);
                    if (geometry2 != null) {
                        n10 = j.a((int)geometry2.getY(), (double)d2);
                    }
                    m2.a((Node)domNode2);
                    bufferedImage2 = ScreenshotHelper.a(m2.d(), webImageHandler, n11, bufferedImage2.getWidth(), n2 - n10);
                }
            }
            if (bufferedImage2 == null) break;
            if (n3 < bufferedImage2.getHeight() || f2.b() < bufferedImage2.getHeight()) {
                geometry = de.qfs.apps.qftest.client.accessibility.a.a((Node)domNode2, (Node)domNode);
                if (geometry == null) break;
                int n15 = j.a((int)geometry.getHeight(), (double)d2);
                int n16 = n13 = n15 != bufferedImage2.getHeight() ? n15 : bufferedImage2.getHeight();
                if (n3 - n13 > 0) {
                    m2.b(Math.min(n3 - n13, n6));
                } else {
                    m2.b(n6);
                }
                m2.setImage(ScreenshotHelper.a(bufferedImage2));
                break;
            }
            if (n6 + bufferedImage2.getHeight() > n3) {
                int n17;
                int n18 = n6 + bufferedImage2.getHeight() - n3;
                n13 = bufferedImage2.getHeight() - n18;
                if (n6 + bufferedImage2.getHeight() > m2.c()) {
                    n13 = m2.c() - n7;
                }
                bufferedImage2 = bl2 ? ScreenshotHelper.a(m2.d(), webImageHandler, n6, n8, n13) : (n6 > (n17 = j.a((int)DomNode.getScrollAttributes(domNode2.getBrowser(), domNode2.getHandle(), (byte)32, '\u0000')[5], (double)d2)) ? ScreenshotHelper.a(m2.d(), webImageHandler, n6 - n17 + n11, n8, n13) : ScreenshotHelper.a(m2.d(), webImageHandler, n18 + n11, n8, n13));
            } else if (n7 + bufferedImage2.getHeight() > m2.c()) {
                int n19 = m2.c() - n7;
                bufferedImage2 = bl2 ? ScreenshotHelper.a(m2.d(), webImageHandler, n6, n8, n19) : ScreenshotHelper.a(m2.d(), webImageHandler, n11, n8, n19);
            }
            if (bufferedImage2 == null) break;
            if (n6 == 0 || n6 == m2.h()) {
                if (n10 > 0) {
                    geometry = de.qfs.apps.qftest.client.accessibility.a.a((Node)domNode2, (Node)domNode);
                    if (geometry != null) {
                        n9 = bufferedImage2.getHeight() - j.a((int)geometry.getY(), (double)d2);
                    }
                } else {
                    geometry = de.qfs.apps.qftest.client.accessibility.a.a((Node)domNode2, m2.d());
                    if (geometry != null) {
                        int n20 = j.a((int)geometry.getY(), (double)d2);
                        n11 = n20 > 0 ? n6 + Math.abs(n20) : n6 - Math.abs(n20);
                        n9 = bufferedImage2.getHeight() - n11;
                    }
                }
                n8 = bufferedImage2.getWidth();
                n6 += bufferedImage2.getHeight() - n11;
            } else {
                n6 += bufferedImage2.getHeight();
            }
            if (bufferedImage == null) {
                m2.a(Math.min(m2.c(), n3 - m2.h() + n11));
                bufferedImage = new BufferedImage(bufferedImage2.getWidth(), m2.c(), 2);
            }
            bufferedImage = ScreenshotHelper.a(bufferedImage2, n7, bufferedImage);
            if ((n7 += bufferedImage2.getHeight()) < m2.c()) continue;
            break;
        }
        if (bufferedImage != null) {
            m2.setImage(ScreenshotHelper.a(bufferedImage));
        }
        if (n6 > m2.c()) {
            m2.a(true);
        }
    }

    private static BufferedImage a(Node node, WebImageHandler webImageHandler, int n2, int n3, int n4) {
        if (ScreenshotHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createAndConvertScreenshot(Node,WebImageHandler,int,int,int)", 382).addDetail("scope", (Object)node)).addDetail("imageHandler", (Object)webImageHandler)).addDetail("startLowerPart", n2)).addDetail("widthInParent", n3)).addDetail("heightInParent", n4)).log();
        }
        if (node == null) {
            throw new IllegalArgumentException("scope is marked non-null but is null");
        }
        ImageRep imageRep = de.qfs.apps.qftest.client.accessibility.a.a(webImageHandler, node, 0, n2, n3, n4);
        if (imageRep != null) {
            return ScreenshotHelper.a(imageRep);
        }
        return null;
    }

    private static BufferedImage a(BufferedImage bufferedImage, int n2, BufferedImage bufferedImage2) {
        block4: {
            if (ScreenshotHelper.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "combinePictures(BufferedImage,int,BufferedImage)", 400).addDetail("newImg", (Object)bufferedImage)).addDetail("currScreenshotFillHeight", n2)).addDetail("overviewScreenshot", (Object)bufferedImage2)).log();
            }
            if (bufferedImage == null) {
                throw new IllegalArgumentException("newImg is marked non-null but is null");
            }
            int[] nArray = bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null, 0, bufferedImage.getWidth());
            try {
                bufferedImage2.setRGB(0, n2, bufferedImage.getWidth(), bufferedImage.getHeight(), nArray, 0, bufferedImage.getWidth());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (ScreenshotHelper.a.level < 5) break block4;
                ((LevelAwareLogBuilder)a.lvlBuild(5, "combinePictures(BufferedImage,int,BufferedImage)", 405).add("Problem occurred combining overview screenshot", (Object)arrayIndexOutOfBoundsException)).log();
            }
        }
        return bufferedImage2;
    }

    private static BufferedImage a(ImageRep imageRep) {
        BufferedImage bufferedImage;
        block3: {
            if (ScreenshotHelper.a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "convertImageRepToBufferedImage(ImageRep)", 419).addDetail("imageRep", (Object)imageRep)).log();
            }
            int n2 = imageRep.getWidth();
            int n3 = imageRep.getHeight();
            bufferedImage = new BufferedImage(n2, n3, 2);
            try {
                bufferedImage.setRGB(0, 0, n2, n3, imageRep.getARGB(), 0, n2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (ScreenshotHelper.a.level < 5) break block3;
                ((LevelAwareLogBuilder)a.lvlBuild(5, "convertImageRepToBufferedImage(ImageRep)", 427).add("Problem occurred combining overview screenshot", (Object)arrayIndexOutOfBoundsException)).log();
            }
        }
        return bufferedImage;
    }

    private static ImageRep a(BufferedImage bufferedImage) {
        if (ScreenshotHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "bufferedImageToImageRep(BufferedImage)", 441).addDetail("bufferedImage", (Object)bufferedImage)).log();
        }
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int[] nArray = bufferedImage.getRGB(0, 0, n2, n3, null, 0, n2);
        return new ImageRep("region", nArray, ImageRep.CompressionMode.BINARY, n2, n3);
    }

    public static void highlightImpossibleAndFailedChecks(Node node, RuleCheckResult ruleCheckResult, m m2) {
        if (ScreenshotHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "highlightImpossibleAndFailedChecks(Node,RuleCheckResult,OverviewResult)", 456).addDetail("scope", (Object)node)).addDetail("ruleCheckResult", (Object)ruleCheckResult)).addDetail("overview", (Object)m2)).log();
        }
        if (!Misc.emptyOrNull((Collection)ruleCheckResult.getImpossibleChecks())) {
            ScreenshotHelper.a(node, ruleCheckResult.getImpossibleChecks(), Color.yellow, m2);
        }
        if (!Misc.emptyOrNull((Collection)ruleCheckResult.getFailedChecks())) {
            ScreenshotHelper.a(node, ruleCheckResult.getFailedChecks(), Color.red, m2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void a(Node node, List list, Color color, m m2) {
        if (ScreenshotHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "highlightCheckResults(Node,List<CheckResult>,Color,OverviewResult)", 473).addDetail("scope", (Object)node)).addDetail("ruleCheckResults", (Object)list)).addDetail("highlightColor", (Object)color)).addDetail("overview", (Object)m2)).log();
        }
        Iterator iterator = list.iterator();
        while (true) {
            int n2;
            ElementCheckResult elementCheckResult;
            block8: {
                if (!iterator.hasNext()) {
                    return;
                }
                g g2 = (g)iterator.next();
                if (!(g2 instanceof ElementCheckResult)) continue;
                elementCheckResult = (ElementCheckResult)g2;
                n2 = m2.h();
                if (!Misc.emptyOrNull((Collection)elementCheckResult.getScrollableParents())) {
                    m2.b(0);
                    if (ScreenshotHelper.a(elementCheckResult, n2, m2)) {
                        ElementHelper.Geometry geometry = ScreenshotHelper.getGeometryInScroll(m2.d(), node instanceof DocumentNode, elementCheckResult, n2, m2);
                        elementCheckResult.setGeometry(geometry);
                        break block8;
                    } else {
                        m2.b(n2);
                        continue;
                    }
                }
                if (node instanceof DocumentNode) {
                    elementCheckResult.setGeometry(ScreenshotHelper.getGeometryInScroll(m2.d(), true, elementCheckResult, n2, m2));
                } else {
                    elementCheckResult.setGeometry(ScreenshotHelper.getGeometryInScroll(m2.d(), false, elementCheckResult, n2, m2));
                }
            }
            ScreenshotHelper.paintRectangle(node, m2.getImage(), elementCheckResult.getGeometry(), m2.h(), color, true);
            m2.b(n2);
        }
    }

    public static void paintRectangle(Node node, ImageRep imageRep, ElementHelper.Geometry geometry, int n2, Color color, boolean bl2) {
        block8: {
            if (ScreenshotHelper.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "paintRectangle(Node,ImageRep,Geometry,int,Color,boolean)", 513).addDetail("scope", (Object)node)).addDetail("image", (Object)imageRep)).addDetail("geometryInParent", (Object)geometry)).addDetail("highlightStartPos", n2)).addDetail("color", (Object)color)).addDetail("isOverview", bl2)).log();
            }
            if (node == null) {
                throw new IllegalArgumentException("scope is marked non-null but is null");
            }
            if (geometry != null && imageRep != null) {
                int n3 = geometry.x;
                int n4 = geometry.y - n2;
                int n5 = geometry.width;
                int n6 = geometry.height;
                if (bl2) {
                    double d2 = ScreenshotHelper.d(node);
                    n5 = j.a((int)n5, (double)d2);
                    n6 = j.a((int)n6, (double)d2);
                }
                try {
                    boolean bl3;
                    boolean bl4 = bl3 = n3 == 0 && n4 == 0 && n5 == imageRep.getWidth() && n6 == imageRep.getHeight();
                    if (bl3) {
                        imageRep.draw().rectangle(2, 2, Math.max(0, n5 - 5), Math.max(0, n6 - 5), 2, color);
                    } else {
                        imageRep.draw().rectangle(n3 - 1, n4 - 1, n5 + 1, n6 + 1, 2, color);
                    }
                }
                catch (TestException testException) {
                    if (ScreenshotHelper.a.level < 5) break block8;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(5, "paintRectangle(Node,ImageRep,Geometry,int,Color,boolean)", 532).add("ex", (Object)testException)).add("Problem occurred highlighting an element with geometry")).add("geometryInParent", (Object)geometry)).log();
                }
            }
        }
    }

    public static DomNode getNearestVerticallyScrollableParent(ElementCheckResult elementCheckResult) {
        Optional<DomNode> optional;
        if (!Misc.emptyOrNull((Collection)elementCheckResult.getScrollableParents()) && (optional = elementCheckResult.getScrollableParents().stream().filter(a::b).max(Comparator.comparingInt(domNode -> de.qfs.apps.qftest.client.accessibility.a.b((Node)domNode).length()))).isPresent()) {
            return optional.get();
        }
        return null;
    }

    public static DomNode getNearestVerticallyScrollableParent(ElementCheckResult elementCheckResult, ArrayList arrayList) {
        Optional<DomNode> optional;
        List list = elementCheckResult.getScrollableParents();
        if (!Misc.emptyOrNull((Collection)list) && (optional = list.stream().filter(domNode -> {
            if (Misc.emptyOrNull((Collection)arrayList) || !arrayList.contains(domNode)) {
                return de.qfs.apps.qftest.client.accessibility.a.b(domNode);
            }
            return false;
        }).max(Comparator.comparingInt(domNode -> de.qfs.apps.qftest.client.accessibility.a.b((Node)domNode).length()))).isPresent()) {
            return optional.get();
        }
        return null;
    }

    public static ElementHelper.Geometry getGeometryInScroll(Node node, boolean bl2, ElementCheckResult elementCheckResult, int n2, m m2) {
        if (node == null) {
            throw new IllegalArgumentException("screenshotComponent is marked non-null but is null");
        }
        WebEngine webEngine = node.getEngine();
        DomNode domNode = elementCheckResult.getElement();
        Callable<ElementHelper.Geometry> callable = () -> node.getHelper().getGeometryInParent(domNode, node);
        ElementHelper.Geometry geometry = (ElementHelper.Geometry)((Object)de.qfs.apps.qftest.client.accessibility.a.a((Engine)webEngine, 5, "element check result geometry in mein scroll", callable));
        Callable<DomNode> callable2 = () -> ScreenshotHelper.getNearestVerticallyScrollableParent(elementCheckResult);
        DomNode domNode2 = (DomNode)de.qfs.apps.qftest.client.accessibility.a.a((Engine)webEngine, 5, "nearest vertically scrollable parent", callable2);
        int n3 = 0;
        List list = elementCheckResult.getScrollableParents();
        if (list != null && m2 != null) {
            for (DomNode domNode3 : list) {
                if (Misc.emptyOrNull((Object)domNode2) && !bl2) continue;
                double d2 = ScreenshotHelper.d(node);
                int n4 = j.a((int)DomNode.getScrollAttributes(domNode3.getBrowser(), domNode3.getHandle(), (byte)32, '\u0000')[5], (double)d2);
                if (domNode3.equals(m2.e())) {
                    if (m2.getImage().getHeight() + n2 > n4) {
                        n3 += n2;
                        continue;
                    }
                    n3 += n4 - n2;
                    continue;
                }
                n3 += n4;
            }
        }
        ElementHelper.Geometry geometry2 = elementCheckResult.getGeometry();
        if (geometry != null) {
            int n5 = geometry.getX();
            int n6 = geometry.getY();
            if (m2 != null) {
                double d3 = ScreenshotHelper.d(node);
                n5 = j.a((int)n5, (double)d3);
                n6 = j.a((int)n6, (double)d3);
            }
            if (geometry2 != null && n6 - n2 > 0) {
                geometry2.setLocation(n5, n6 - n2);
            }
            if (m2 != null && geometry2 != null && n6 - n3 > 0) {
                geometry2.setLocation(n5, n6 - n3);
            }
        }
        return geometry2;
    }

    private static boolean a(ElementCheckResult elementCheckResult, int n2, m m2) {
        ArrayList<DomNode> arrayList = new ArrayList<DomNode>();
        for (int i2 = elementCheckResult.getScrollableParents().size() - 1; i2 >= 0; --i2) {
            boolean bl2;
            DomNode domNode = ScreenshotHelper.getNearestVerticallyScrollableParent(elementCheckResult, arrayList);
            if (domNode == null) continue;
            arrayList.add(domNode);
            double d2 = ScreenshotHelper.d((Node)domNode);
            int n3 = j.a((int)DomNode.getScrollAttributes(domNode.getBrowser(), domNode.getHandle(), (byte)32, '\u0000')[5], (double)d2);
            int n4 = j.a((int)Integer.parseInt(DomNode.getAttribute(domNode.getBrowser(), domNode.getHandle(), "offsetheight", '\u0000')), (double)d2);
            DomNode domNode2 = elementCheckResult.getElement();
            ElementHelper.Geometry geometry = de.qfs.apps.qftest.client.accessibility.a.a((Node)domNode2, (Node)domNode);
            if (geometry == null) {
                return true;
            }
            int n5 = j.a((int)geometry.getY(), (double)d2);
            int n6 = j.a((int)geometry.getHeight(), (double)d2);
            if (domNode == m2.e()) {
                boolean bl3;
                boolean bl4 = bl3 = n5 >= n2 && n5 + n6 <= n2 + m2.getImage().getHeight();
                if (!bl3) {
                    m2.a(elementCheckResult);
                }
                return bl3;
            }
            boolean bl5 = bl2 = n5 > n3 && n5 + n6 < n3 + n4;
            if (!bl2) {
                m2.a(elementCheckResult);
            }
            return bl2;
        }
        return true;
    }

    private static void a(m m2, RuleCheckResult ruleCheckResult, List list, DomNode domNode) {
        if (ScreenshotHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "resetScrollToFirstViolation(OverviewResult,RuleCheckResult,List<DomNode>,DomNode)", 696).addDetail("overview", (Object)m2)).addDetail("ruleCheckResult", (Object)ruleCheckResult)).addDetail("scrollableNodesWithViolations", (Object)list)).addDetail("scrollComponent", (Object)domNode)).log();
        }
        if (!Misc.emptyOrNull((Collection)m2.f())) {
            for (DomNode domNode2 : m2.f()) {
                g g3;
                Node node;
                ElementHelper.Geometry geometry;
                Optional<ElementCheckResult> optional;
                int n2 = DomNode.getScrollAttributes(domNode2.getBrowser(), domNode2.getHandle(), (byte)16, '\u0000')[4];
                if (n2 > 0) {
                    m2.b(true);
                }
                de.qfs.apps.qftest.client.accessibility.a.d(domNode2, "_qf_node.scroll(0, 0)", 5, "scrolling");
                if (domNode2.equals(domNode) || Misc.emptyOrNull((Collection)list) || !list.contains(domNode2) || !(optional = ruleCheckResult.getAllFailedAndImpossibleChecks().stream().filter(g2 -> g2 instanceof ElementCheckResult).map(g2 -> (ElementCheckResult)g2).filter(elementCheckResult -> {
                    if (elementCheckResult.getScrollableParents() != null) {
                        return elementCheckResult.getScrollableParents().contains(domNode2);
                    }
                    return false;
                }).findFirst()).isPresent() || (geometry = de.qfs.apps.qftest.client.accessibility.a.a(node = (g3 = (g)optional.get()).getElement(), (Node)domNode2)) == null) continue;
                de.qfs.apps.qftest.client.accessibility.a.d(domNode2, String.format("_qf_node.scroll(0, %d)", Math.max(geometry.getY() - 50, 0)), 5, "scrolling");
            }
        }
    }

    public static void removeOverflowFromScope(DomNode domNode) {
        if (ScreenshotHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "removeOverflowFromScope(DomNode)", 730).addDetail("scope", (Object)domNode)).log();
        }
        Callable<String> callable = () -> domNode.getStyle("overflow-x");
        String string = (String)de.qfs.apps.qftest.client.accessibility.a.a((Engine)domNode.getEngine(), 5, "overflow-x", callable);
        if (string != null && string.equals("hidden")) {
            de.qfs.apps.qftest.client.accessibility.a.d(domNode, "_qf_node.style.overflowX = 'visible'", 5, "setting overflow-x to visible");
        }
        Callable<String> callable2 = () -> domNode.getStyle("overflow-y");
        String string2 = (String)de.qfs.apps.qftest.client.accessibility.a.a((Engine)domNode.getEngine(), 5, "overflow-y", callable2);
        if (string2 != null && string2.equals("hidden")) {
            de.qfs.apps.qftest.client.accessibility.a.d(domNode, "_qf_node.style.overflowY = 'visible'", 5, "setting overflow-y to visible");
        }
    }

    public static void logElementScreenshot(g g2, Node node, DomNode domNode, Node node2, Color color) {
        boolean bl2;
        if (ScreenshotHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "logElementScreenshot(CheckResult,Node,DomNode,Node,Color)", 746).addDetail("check", (Object)g2)).addDetail("scope", (Object)node)).addDetail("scrollComponent", (Object)domNode)).addDetail("component", (Object)node2)).addDetail("highlightingColor", (Object)color)).log();
        }
        if (node == null) {
            throw new IllegalArgumentException("scope is marked non-null but is null");
        }
        WebEngine webEngine = node.getEngine();
        BaseImageHandler baseImageHandler = BaseImageHandler.instance((Object)webEngine);
        int n2 = ScreenshotHelper.a(node);
        int n3 = ScreenshotHelper.b(node);
        ElementHelper.Geometry geometry = de.qfs.apps.qftest.client.accessibility.a.a(node2);
        int n4 = n2;
        int n5 = n3;
        if (geometry != null) {
            n4 = Math.min(geometry.width, n2);
            n5 = Math.min(geometry.height, n3);
        }
        boolean bl3 = bl2 = n4 == 0 || n5 == 0 || n4 == Integer.MAX_VALUE || n5 == Integer.MAX_VALUE;
        if (bl2) {
            return;
        }
        double d2 = ScreenshotHelper.d(node);
        int n6 = j.a((int)n4, (double)d2);
        int n7 = j.a((int)n5, (double)d2);
        ImageRep imageRep = null;
        if (node2 instanceof DomNode && baseImageHandler != null) {
            av av2 = node2.getEngine().getPlayer();
            av2.sync(false);
            Runnable runnable = () -> ((DomNode)node2).scrollRegionVisibleWithPadding(-50, -50, n6 + 100, n7 + 100, 0, 0, true);
            de.qfs.apps.qftest.client.accessibility.a.a((Engine)webEngine, 5, "scrolling region visible", runnable);
            int n8 = Options.cached_OPT_WEB_A11Y_SLEEP_ELEMENT_SCREENSHOT;
            if (ScreenshotHelper.a.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(5, "logElementScreenshot(CheckResult,Node,DomNode,Node,Color)", 772).add("component", (Object)node2)).add("check.getXPath()", g2.getXPath())).log();
            }
            ScreenshotHelper.a(domNode, n8);
            av2.sync(false);
            imageRep = de.qfs.apps.qftest.client.accessibility.a.a(baseImageHandler, node2, -50, -50, n6 + 100, n7 + 100);
            g2.setImage(imageRep);
        }
        if (imageRep != null) {
            ScreenshotHelper.paintRectangle(node, imageRep, ElementHelper.Geometry.geometry(50, 50, n6, n7), 0, color, false);
        }
    }

    private static f a(RuleCheckResult ruleCheckResult, DomNode domNode, boolean bl2) {
        if (ScreenshotHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getYIntervalOfViolations(RuleCheckResult,DomNode,boolean)", 786).addDetail("ruleCheckResult", (Object)ruleCheckResult)).addDetail("scrollComponent", (Object)domNode)).addDetail("isScopeGenericDocument", bl2)).log();
        }
        if (domNode == null) {
            throw new IllegalArgumentException("scrollComponent is marked non-null but is null");
        }
        int n2 = -1;
        int n3 = -1;
        if (!Misc.emptyOrNull((Collection)ruleCheckResult.getAllFailedAndImpossibleChecks())) {
            for (g g2 : ruleCheckResult.getAllFailedAndImpossibleChecks()) {
                ElementHelper.Geometry geometry = ScreenshotHelper.getGeometryInScroll(domNode, bl2, (ElementCheckResult)g2, 0, null);
                if (geometry == null) continue;
                if (Misc.emptyOrNull((Collection)ruleCheckResult.getFailedChecks()) || ruleCheckResult.getFailedChecks().contains(g2)) {
                    if (n2 == -1) {
                        n2 = geometry.y;
                    }
                    n2 = Math.min(geometry.y, n2);
                }
                int n4 = geometry.y + geometry.height;
                n3 = Math.max(n4, n3);
            }
        }
        return new f(n2, n3, ScreenshotHelper.d((Node)domNode));
    }

    private static int a(Node node) {
        if (ScreenshotHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getWindowInnerWidth(Node)", 810).addDetail("node", (Object)node)).log();
        }
        if (node == null) {
            throw new IllegalArgumentException("node is marked non-null but is null");
        }
        Object object = de.qfs.apps.qftest.client.accessibility.a.c(node, "return Math.round(window.innerWidth)", 5, "window inner width");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return Integer.MAX_VALUE;
    }

    private static int b(Node node) {
        Object object;
        if (ScreenshotHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getWindowInnerHeight(Node)", 821).addDetail("node", (Object)node)).log();
        }
        if ((object = de.qfs.apps.qftest.client.accessibility.a.c(node, "return Math.round(window.innerHeight)", 5, "window inner height")) instanceof Integer) {
            return (Integer)object;
        }
        return Integer.MAX_VALUE;
    }

    private static int c(Node node) {
        if (ScreenshotHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getMaxScrollHeight(Node)", 832).addDetail("scrollComponent", (Object)node)).log();
        }
        int[] nArray = DomNode.getScrollAttributes(node.getBrowser(), node.getHandle(), (byte)-128, '\u0000');
        return nArray[7];
    }

    private static void a(DomNode domNode, int n2) {
        if (ScreenshotHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "waitForScrolling(DomNode,int)", 840).addDetail("scrollableComponent", (Object)domNode)).addDetail("sleepForScreenshot", n2)).log();
        }
        ScreenshotHelper.a(domNode, n2, 1);
    }

    private static void a(DomNode domNode, int n2, int n3) {
        if (ScreenshotHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "waitForScrolling(DomNode,int,int)", 847).addDetail("scrollableComponent", (Object)domNode)).addDetail("sleepForScreenshot", n2)).addDetail("factor", n3)).log();
        }
        if (domNode != null) {
            Object object;
            int n4;
            int n5;
            int n6 = Options.cached_OPT_WEB_A11Y_SLEEP_FOR_POLLING;
            int n7 = (int)Math.ceil((double)n2 / (double)n6);
            if (ScreenshotHelper.a.level >= 5) {
                ((LevelAwareLogBuilder)a.lvlBuild(5, "waitForScrolling(DomNode,int,int)", 851).add("maxNumberOfPolling", n7)).log();
            }
            Object object2 = null;
            for (n5 = 0; n5 < n7; ++n5) {
                object2 = ScreenshotHelper.a(domNode);
                if (ScreenshotHelper.a.level >= 5) {
                    ((LevelAwareLogBuilder)a.lvlBuild(5, "waitForScrolling(DomNode,int,int)", 855).add("currentScrollInScrollableComponent", object2)).log();
                }
                if (object2 != null) break;
                ScreenshotHelper.a(n6);
            }
            n5 = 0;
            int n8 = 0;
            for (n4 = 0; n4 < n7; ++n4) {
                ScreenshotHelper.a(n6 * n3);
                object = ScreenshotHelper.a(domNode);
                if (ScreenshotHelper.a.level >= 5) {
                    ((LevelAwareLogBuilder)a.lvlBuild(5, "waitForScrolling(DomNode,int,int)", 867).add("newScrollInScrollableComponent", object)).log();
                }
                if (!Misc.equalOrNull((Object)object2, (Object)object)) {
                    object2 = object;
                    n5 = 1;
                    break;
                }
                if (++n8 > 1) break;
            }
            if (ScreenshotHelper.a.level >= 5) {
                ((LevelAwareLogBuilder)a.lvlBuild(5, "waitForScrolling(DomNode,int,int)", 879).add("isScrollChanged", n5 != 0)).log();
            }
            if (n5 != 0) {
                n8 = 0;
                for (n4 = 0; n4 < n7; ++n4) {
                    ScreenshotHelper.a(n6 * n3);
                    object = ScreenshotHelper.a(domNode);
                    if (ScreenshotHelper.a.level >= 5) {
                        ((LevelAwareLogBuilder)a.lvlBuild(5, "waitForScrolling(DomNode,int,int)", 885).add("newScrollInScrollableComponent", object)).log();
                    }
                    if (Misc.equalOrNull((Object)object2, (Object)object)) {
                        if (++n8 <= 5) continue;
                        break;
                    }
                    n8 = 0;
                    object2 = object;
                }
            }
        }
    }

    private static Object a(DomNode domNode) {
        return de.qfs.apps.qftest.client.accessibility.a.c(domNode, "return window._qf_scroll_timestamp", 5, "scroll timestamp");
    }

    private static void a(int n2) {
        try {
            Thread.sleep(n2);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private static double a(Node node, boolean bl2) {
        if (node == null) {
            throw new IllegalArgumentException("node is marked non-null but is null");
        }
        if (bl2 || Options.cached_OPT_WEB_BROWSER_ZOOM_SCALING) {
            Double d2 = node.getBrowser().getInfo().getDevicePixelRatio();
            if (d2 == null) {
                d2 = Native.instance().getScreenScaleFactor();
            }
            return d2;
        }
        return 1.0;
    }

    private static double d(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node is marked non-null but is null");
        }
        return ScreenshotHelper.a(node, false);
    }
}

