/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.awt.check;

import de.qfs.apps.qftest.client.awt.check.JComponentChecker;
import de.qfs.apps.qftest.client.awt.s;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.shared.data.check.BooleanCheckData;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.apps.qftest.shared.data.check.StringItemsCheckData;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Pair;
import javax.swing.JComboBox;

public class JComboBoxChecker
extends JComponentChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.awt.check.JComboBoxChecker");
    private CheckType[] b = new CheckType[]{CheckType.VALUE, CheckType.VALUES, CheckType.VISIBLE, CheckType.ENABLED, CheckType.EDITABLE, CheckType.FOCUSED, CheckType.IMAGE, CheckType.GEOMETRY};
    private CheckType[] c = new CheckType[]{CheckType.ITEM, CheckType.VALUE, CheckType.ITEM_VISIBLE, CheckType.VALUES, CheckType.VISIBLE, CheckType.ENABLED, CheckType.EDITABLE, CheckType.FOCUSED, CheckType.IMAGE, CheckType.GEOMETRY};

    public JComboBoxChecker(s s2) {
        super(s2);
    }

    @Override
    public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
        if (JComboBoxChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSupportedCheckTypes(Object,Object)", 108).addDetail("target", object)).addDetail("item", object2)).log();
        }
        if (object instanceof JComboBox) {
            return object2 == null ? this.b : this.c;
        }
        return null;
    }

    @Override
    public CheckData getCheckData(Object object, Object object2, CheckType checkType) {
        if (JComboBoxChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckData(Object,Object,CheckType)", 129).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
        }
        if (!(object instanceof JComboBox)) {
            if (JComboBoxChecker.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 132).add("Bad check target - not a JComboBox", object)).log();
            }
            return null;
        }
        JComboBox jComboBox = (JComboBox)object;
        if (object2 instanceof Integer && checkType.getDataType() == CheckDataType.STRING && ("default".equals(checkType.getIdentifier()) || CheckType.ITEM.getIdentifier().equals(checkType.getIdentifier()))) {
            int n2 = (Integer)object2;
            if (n2 >= 0 && n2 < jComboBox.getItemCount()) {
                try {
                    String string = ItemRegistry.instance().getItemValue(jComboBox, n2);
                    return new StringCheckData("default", string);
                }
                catch (BadItemException badItemException) {
                    if (JComboBoxChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 148).add("ex", (Object)badItemException)).log();
                    }
                    return null;
                }
            }
            return null;
        }
        if (checkType.getDataType() == CheckDataType.STRING && (object2 == null && "default".equals(checkType.getIdentifier()) || CheckType.VALUE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.CURRENT_ITEM.getIdentifier().equals(checkType.getIdentifier()) || "value".equals(checkType.getIdentifier()) || CheckType.ITEM_CURRENT.getIdentifier().equals(checkType.getIdentifier()))) {
            int n3 = jComboBox.getSelectedIndex();
            if (n3 >= 0) {
                try {
                    String string = ItemRegistry.instance().getItemValue(jComboBox, n3);
                    return new StringCheckData(CheckType.VALUE.getIdentifier(), string);
                }
                catch (BadItemException badItemException) {
                    if (JComboBoxChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 168).add("ex", (Object)badItemException)).log();
                    }
                    return null;
                }
            }
            Object object3 = jComboBox.getSelectedItem();
            return new StringCheckData(CheckType.VALUE.getIdentifier(), object3 == null ? null : object3.toString());
        }
        if (checkType.getDataType() == CheckDataType.STRING_LIST && (object2 == null && "default".equals(checkType.getIdentifier()) || CheckType.VALUES.getIdentifier().equals(checkType.getIdentifier()) || "values".equals(checkType.getIdentifier()) || CheckType.ITEMS.getIdentifier().equals(checkType.getIdentifier()))) {
            int n4 = jComboBox.getItemCount();
            String[] stringArray = new String[n4];
            try {
                for (int i2 = 0; i2 < n4; ++i2) {
                    stringArray[i2] = ItemRegistry.instance().getItemValue(jComboBox, i2);
                }
                return new StringItemsCheckData(CheckType.ITEMS.getIdentifier(), stringArray);
            }
            catch (BadItemException badItemException) {
                if (JComboBoxChecker.a.level >= 1) {
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 191).add("ex", (Object)badItemException)).log();
                }
                return null;
            }
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && object2 != null && CheckType.ITEM_VISIBLE.getIdentifier().equals(checkType.getIdentifier())) {
            return new BooleanCheckData(CheckType.VISIBLE.getIdentifier(), true);
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.EDITABLE.getIdentifier().equals(checkType.getIdentifier())) {
            return new BooleanCheckData(CheckType.EDITABLE.getIdentifier(), jComboBox.isEditable());
        }
        return null;
    }

    @Override
    public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) {
        CheckData checkData;
        if (JComboBoxChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataAndItem(Object,Object,CheckType)", 226).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
        }
        if ((checkData = this.getCheckData(object, object2, checkType)) == null) {
            return null;
        }
        if (CheckType.ITEM_VISIBLE.getIdentifier().equals(checkType.getIdentifier())) {
            return new Pair((Object)checkData, object2);
        }
        return new Pair((Object)checkData, null);
    }
}

