/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.awt.check;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.awt.check.JComponentChecker;
import de.qfs.apps.qftest.client.awt.s;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.check.BooleanCheckData;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.exceptions.UnexpectedClientException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Pair;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class JEditorPaneChecker
extends JComponentChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.awt.check.JEditorPaneChecker");
    private CheckType[] b = new CheckType[]{CheckType.TEXT, CheckType.VISIBLE, CheckType.ENABLED, CheckType.EDITABLE, CheckType.FOCUSED, CheckType.IMAGE, CheckType.VISIBLE_IMAGE, CheckType.GEOMETRY};
    private CheckType[] c = new CheckType[]{CheckType.TEXT, CheckType.VISIBLE, CheckType.ENABLED, CheckType.EDITABLE, CheckType.FOCUSED, CheckType.IMAGE, CheckType.VISIBLE_IMAGE, CheckType.GEOMETRY};
    private CheckType[] d = new CheckType[]{CheckType.PLAIN_TEXT, CheckType.HTML_TEXT, CheckType.VISIBLE, CheckType.ENABLED, CheckType.EDITABLE, CheckType.FOCUSED, CheckType.IMAGE, CheckType.VISIBLE_IMAGE, CheckType.GEOMETRY};
    private CheckType[] e = new CheckType[]{CheckType.PLAIN_TEXT, CheckType.HTML_TEXT, CheckType.VISIBLE, CheckType.ENABLED, CheckType.EDITABLE, CheckType.FOCUSED, CheckType.IMAGE, CheckType.VISIBLE_IMAGE, CheckType.GEOMETRY};

    public JEditorPaneChecker(s s2) {
        super(s2);
    }

    @Override
    public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
        if (JEditorPaneChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSupportedCheckTypes(Object,Object)", 135).addDetail("target", object)).addDetail("subItem", object2)).log();
        }
        if (object instanceof JEditorPane && "text/html".equals(((JEditorPane)object).getContentType())) {
            return object2 == null ? this.d : this.e;
        }
        return object2 == null ? this.b : this.c;
    }

    @Override
    public CheckData getCheckData(Object object, Object object2, CheckType checkType) throws TestException {
        if (JEditorPaneChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckData(Object,Object,CheckType)", 157).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        if (object2 != null) {
            // empty if block
        }
        JEditorPane jEditorPane = (JEditorPane)object;
        if (checkType.getDataType() == CheckDataType.STRING && (object2 == null && "default".equals(checkType.getIdentifier()) || CheckType.TEXT.getIdentifier().equals(checkType.getIdentifier()))) {
            if ("text/rtf".equals(((JEditorPane)object).getContentType())) {
                Document document = ((JEditorPane)object).getDocument();
                try {
                    return new StringCheckData("default", Util.getCleanElementText((String)document.getText(0, document.getLength())));
                }
                catch (BadLocationException badLocationException) {
                    if (JEditorPaneChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 174).add("ex", (Object)badLocationException)).log();
                    }
                    throw new UnexpectedClientException(Client.instance().getName(), (Throwable)badLocationException);
                }
            }
            return new StringCheckData("default", Util.getCleanElementText((String)jEditorPane.getText()));
        }
        if (checkType.getDataType() == CheckDataType.STRING && CheckType.HTML_TEXT.getIdentifier().equals(checkType.getIdentifier()) && "text/html".equals(((JEditorPane)object).getContentType())) {
            return new StringCheckData(CheckType.HTML_TEXT.getIdentifier(), Util.getCleanElementText((String)jEditorPane.getText()));
        }
        if (checkType.getDataType() == CheckDataType.STRING && CheckType.PLAIN_TEXT.getIdentifier().equals(checkType.getIdentifier())) {
            Document document = ((JEditorPane)object).getDocument();
            try {
                return new StringCheckData(CheckType.PLAIN_TEXT.getIdentifier(), Util.getCleanElementText((String)document.getText(0, document.getLength())));
            }
            catch (BadLocationException badLocationException) {
                if (JEditorPaneChecker.a.level >= 1) {
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 196).add("ex", (Object)badLocationException)).log();
                }
                throw new UnexpectedClientException(Client.instance().getName(), (Throwable)badLocationException);
            }
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.EDITABLE.getIdentifier().equals(checkType.getIdentifier())) {
            return new BooleanCheckData(CheckType.EDITABLE.getIdentifier(), jEditorPane.isEditable());
        }
        return super.getCheckData(object, object2, checkType);
    }

    @Override
    public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) throws TestException {
        CheckData checkData;
        if (JEditorPaneChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataAndItem(Object,Object,CheckType)", 224).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
        }
        if ((checkData = this.getCheckData(object, object2, checkType)) == null) {
            return null;
        }
        return new Pair((Object)checkData, null);
    }
}

