/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.awt.check;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.awt.check.JComponentChecker;
import de.qfs.apps.qftest.client.awt.s;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.shared.data.check.BooleanCheckData;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.ImageCheckData;
import de.qfs.apps.qftest.shared.data.check.SelectableItemsCheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.apps.qftest.shared.data.check.StringItemsCheckData;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Pair;
import java.awt.Component;
import javax.swing.JList;

public class JListChecker
extends JComponentChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.awt.check.JListChecker");
    private CheckType[] b = new CheckType[]{CheckType.ITEMS, CheckType.ITEMS_WITH_SELECTION, CheckType.VISIBLE, CheckType.ENABLED, CheckType.FOCUSED, CheckType.IMAGE, CheckType.VISIBLE_IMAGE, CheckType.GEOMETRY};
    private CheckType[] c = new CheckType[]{CheckType.ITEM, CheckType.ITEM_VISIBLE, CheckType.ITEM_SELECTED, CheckType.ITEMS, CheckType.ITEMS_WITH_SELECTION, CheckType.VISIBLE, CheckType.ENABLED, CheckType.FOCUSED, CheckType.IMAGE, CheckType.VISIBLE_IMAGE, CheckType.ITEM_IMAGE, CheckType.GEOMETRY};

    public JListChecker(s s2) {
        super(s2);
    }

    @Override
    public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
        if (JListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSupportedCheckTypes(Object,Object)", 113).addDetail("target", object)).addDetail("subItem", object2)).log();
        }
        return object2 == null ? this.b : this.c;
    }

    @Override
    public CheckData getCheckData(Object object, Object object2, CheckType checkType) throws TestException {
        if (JListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckData(Object,Object,CheckType)", 131).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        JList jList = (JList)object;
        if (object2 != null) {
            if (checkType.getDataType() == CheckDataType.STRING && ("default".equals(checkType.getIdentifier()) || CheckType.ITEM.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    String string = ItemRegistry.instance().getItemValue(object, object2);
                    return new StringCheckData(CheckType.ITEM.getIdentifier(), string);
                }
                catch (BadItemException badItemException) {
                    if (JListChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 144).add("ex", (Object)badItemException)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.ITEM_VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier()))) {
                return new BooleanCheckData(CheckType.ITEM_VISIBLE.getIdentifier(), true);
            }
            if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.ITEM_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.SELECTED.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    int n2 = (Integer)object2;
                    if (n2 < 0 || n2 >= jList.getModel().getSize()) {
                        return null;
                    }
                    return new BooleanCheckData(CheckType.ITEM_SELECTED.getIdentifier(), jList.isSelectedIndex(n2));
                }
                catch (Exception exception) {
                    if (JListChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 164).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.IMAGE && ("default".equals(checkType.getIdentifier()) || CheckType.ITEM_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_IMAGE_OLD.getIdentifier().equals(checkType.getIdentifier()) || !Client.instance().isCaptureContext() && CheckType.IMAGE.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    ImageRep imageRep = this.grabImage((Component)object, object2);
                    return new ImageCheckData(CheckType.ITEM_IMAGE.getIdentifier(), imageRep, -1, -1, -1, -1, -1, -1, false);
                }
                catch (Exception exception) {
                    if (JListChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 179).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
        }
        if (checkType.getDataType() == CheckDataType.STRING_LIST && (object2 == null && "default".equals(checkType.getIdentifier()) || CheckType.ITEMS.getIdentifier().equals(checkType.getIdentifier()))) {
            try {
                int n3 = jList.getModel().getSize();
                String[] stringArray = new String[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    stringArray[i2] = ItemRegistry.instance().getItemValue(object, i2);
                }
                return new StringItemsCheckData(CheckType.ITEMS.getIdentifier(), stringArray);
            }
            catch (Exception exception) {
                if (JListChecker.a.level >= 1) {
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 195).add("ex", (Object)exception)).log();
                }
                return null;
            }
        }
        if (checkType.getDataType() == CheckDataType.SELECTABLE_STRING_LIST && (object2 == null && "default".equals(checkType.getIdentifier()) || CheckType.ITEMS_WITH_SELECTION.getIdentifier().equals(checkType.getIdentifier()))) {
            try {
                int n4 = jList.getModel().getSize();
                Object[][] objectArray = new Object[n4][];
                for (int i3 = 0; i3 < n4; ++i3) {
                    objectArray[i3] = new Object[]{ItemRegistry.instance().getItemValue(object, i3), Boolean.FALSE, jList.isSelectedIndex(i3)};
                }
                return new SelectableItemsCheckData(CheckType.ITEMS_WITH_SELECTION.getIdentifier(), objectArray, false);
            }
            catch (Exception exception) {
                if (JListChecker.a.level >= 1) {
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 215).add("ex", (Object)exception)).log();
                }
                return null;
            }
        }
        return super.getCheckData(object, object2, checkType);
    }

    @Override
    public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) throws TestException {
        if (JListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataAndItem(Object,Object,CheckType)", 237).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
        }
        CheckData checkData = null;
        checkData = CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier()) ? this.getCheckData(object, null, checkType) : this.getCheckData(object, object2, checkType);
        if (checkData == null) {
            return null;
        }
        if (CheckType.ITEM.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_VISIBLE.getIdentifier().equals(checkType.getIdentifier())) {
            return new Pair((Object)checkData, object2);
        }
        return new Pair((Object)checkData, null);
    }
}

