/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.awt.check;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.awt.check.JComponentChecker;
import de.qfs.apps.qftest.client.awt.s;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.shared.data.check.BooleanCheckData;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.ImageCheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.apps.qftest.shared.data.check.StringItemsCheckData;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Pair;
import java.awt.Component;
import javax.swing.JTabbedPane;

public class JTabbedPaneChecker
extends JComponentChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.awt.check.JTabbedPaneChecker");
    private CheckType[] b = new CheckType[]{CheckType.CURRENT_TAB, CheckType.VISIBLE, CheckType.ENABLED, CheckType.FOCUSED, CheckType.TABS, CheckType.IMAGE, CheckType.VISIBLE_IMAGE, CheckType.TOOLTIP, CheckType.GEOMETRY};
    private CheckType[] c = new CheckType[]{CheckType.TAB, CheckType.CURRENT_TAB, CheckType.TAB_VISIBLE, CheckType.TABS, CheckType.TAB_SELECTED, CheckType.TAB_ENABLED, CheckType.VISIBLE, CheckType.ENABLED, CheckType.FOCUSED, CheckType.IMAGE, CheckType.VISIBLE_IMAGE, CheckType.TAB_IMAGE, CheckType.TAB_TOOLTIP, CheckType.TOOLTIP, CheckType.GEOMETRY};

    public JTabbedPaneChecker(s s2) {
        super(s2);
    }

    @Override
    public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
        if (JTabbedPaneChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSupportedCheckTypes(Object,Object)", 116).addDetail("target", object)).addDetail("subItem", object2)).log();
        }
        return object2 == null ? this.b : this.c;
    }

    @Override
    public CheckData getCheckData(Object object, Object object2, CheckType checkType) throws TestException {
        if (JTabbedPaneChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckData(Object,Object,CheckType)", 134).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        JTabbedPane jTabbedPane = (JTabbedPane)object;
        if (object2 != null) {
            if (checkType.getDataType() == CheckDataType.STRING && ("default".equals(checkType.getIdentifier()) || CheckType.ITEM.getIdentifier().equals(checkType.getIdentifier()) || "tab".equals(checkType.getIdentifier()) || CheckType.TAB.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    String string = ItemRegistry.instance().getItemValue(object, object2);
                    return new StringCheckData(CheckType.ITEM.getIdentifier(), string);
                }
                catch (BadItemException badItemException) {
                    if (JTabbedPaneChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 148).add("ex", (Object)badItemException)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.TAB_VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || "tab_visible".equals(checkType.getIdentifier()) || CheckType.ITEM_VISIBLE.getIdentifier().equals(checkType.getIdentifier()))) {
                return new BooleanCheckData(CheckType.ITEM_VISIBLE.getIdentifier(), true);
            }
            if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.TAB_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.SELECTED.getIdentifier().equals(checkType.getIdentifier()) || "tab_selected".equals(checkType.getIdentifier()) || CheckType.ITEM_SELECTED.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    int n2 = (Integer)object2;
                    if (n2 < 0 || n2 >= jTabbedPane.getTabCount()) {
                        return null;
                    }
                    return new BooleanCheckData(CheckType.ITEM_SELECTED.getIdentifier(), jTabbedPane.getSelectedIndex() == n2);
                }
                catch (Exception exception) {
                    if (JTabbedPaneChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 172).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.TAB_ENABLED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ENABLED.getIdentifier().equals(checkType.getIdentifier()) || "tab_enabled".equals(checkType.getIdentifier()) || CheckType.ITEM_ENABLED.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    int n3 = (Integer)object2;
                    if (n3 < 0 || n3 >= jTabbedPane.getTabCount()) {
                        return null;
                    }
                    return new BooleanCheckData(CheckType.ITEM_ENABLED.getIdentifier(), jTabbedPane.isEnabledAt(n3));
                }
                catch (Exception exception) {
                    if (JTabbedPaneChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 189).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.IMAGE && ("default".equals(checkType.getIdentifier()) || CheckType.TAB_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || "tab_image".equals(checkType.getIdentifier()) || CheckType.ITEM_IMAGE_OLD.getIdentifier().equals(checkType.getIdentifier()) || !Client.instance().isCaptureContext() && CheckType.IMAGE.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    ImageRep imageRep = this.grabImage((Component)object, object2);
                    return new ImageCheckData(CheckType.ITEM_IMAGE.getIdentifier(), imageRep, -1, -1, -1, -1, -1, -1, false);
                }
                catch (Exception exception) {
                    if (JTabbedPaneChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 206).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.STRING && (CheckType.TOOLTIP.getIdentifier().equals(checkType.getIdentifier()) || "tab_tooltip".equals(checkType.getIdentifier()) || CheckType.TAB_TOOLTIP.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    boolean bl2 = Client.instance().isCaptureContext() && CheckType.TOOLTIP.getIdentifier().equals(checkType.getIdentifier());
                    return new StringCheckData((bl2 ? CheckType.TOOLTIP : CheckType.TAB_TOOLTIP).getIdentifier(), this.engine.getHelper().getTooltipText(object, bl2 ? null : object2));
                }
                catch (Exception exception) {
                    if (JTabbedPaneChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 221).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
        }
        if (checkType.getDataType() == CheckDataType.STRING && (object2 == null && "default".equals(checkType.getIdentifier()) || CheckType.TAB_CURRENT.getIdentifier().equals(checkType.getIdentifier()) || CheckType.CURRENT_TAB.getIdentifier().equals(checkType.getIdentifier()) || CheckType.CURRENT_ITEM.getIdentifier().equals(checkType.getIdentifier()) || "tab_current".equals(checkType.getIdentifier()) || "current_tab".equals(checkType.getIdentifier()) || CheckType.ITEM_CURRENT.getIdentifier().equals(checkType.getIdentifier()))) {
            int n4 = jTabbedPane.getTabCount();
            int n5 = jTabbedPane.getSelectedIndex();
            if (n5 >= 0) {
                try {
                    String string = ItemRegistry.instance().getItemValue(object, n5);
                    return new StringCheckData(CheckType.CURRENT_ITEM.getIdentifier(), string);
                }
                catch (BadItemException badItemException) {
                    if (JTabbedPaneChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 242).add("ex", (Object)badItemException)).log();
                    }
                    return null;
                }
            }
            return new StringCheckData(CheckType.CURRENT_ITEM.getIdentifier(), null);
        }
        if (checkType.getDataType() == CheckDataType.STRING_LIST && (object2 == null && "default".equals(checkType.getIdentifier()) || CheckType.TABS.getIdentifier().equals(checkType.getIdentifier()) || "tabs".equals(checkType.getIdentifier()) || CheckType.ITEMS.getIdentifier().equals(checkType.getIdentifier()))) {
            int n6 = jTabbedPane.getTabCount();
            try {
                String[] stringArray = new String[n6];
                for (int i2 = 0; i2 < n6; ++i2) {
                    stringArray[i2] = ItemRegistry.instance().getItemValue(object, i2);
                }
                return new StringItemsCheckData(CheckType.ITEMS.getIdentifier(), stringArray);
            }
            catch (Exception exception) {
                if (JTabbedPaneChecker.a.level >= 1) {
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 261).add("ex", (Object)exception)).log();
                }
                return null;
            }
        }
        return super.getCheckData(object, object2, checkType);
    }

    @Override
    public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) throws TestException {
        if (JTabbedPaneChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataAndItem(Object,Object,CheckType)", 283).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
        }
        CheckData checkData = null;
        checkData = CheckType.ENABLED.getIdentifier().equals(checkType.getIdentifier()) ? this.getCheckData(object, null, checkType) : (CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier()) ? this.getCheckData(object, null, checkType) : this.getCheckData(object, object2, checkType));
        if (checkData == null) {
            return null;
        }
        if (CheckType.TAB.getIdentifier().equals(checkType.getIdentifier()) || CheckType.TAB_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.TAB_ENABLED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.TAB_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.TAB_TOOLTIP.getIdentifier().equals(checkType.getIdentifier()) || CheckType.TAB_VISIBLE.getIdentifier().equals(checkType.getIdentifier())) {
            return new Pair((Object)checkData, object2);
        }
        return new Pair((Object)checkData, null);
    }
}

