/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.awt.data;

import de.qfs.apps.qftest.client.awt.data.f;
import de.qfs.apps.qftest.client.awt.data.h;
import de.qfs.apps.qftest.client.awt.data.i;
import de.qfs.apps.qftest.client.awt.ui.ComponentHelper;
import de.qfs.apps.qftest.extensions.ResolverRegistry;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.IndexFormatException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.IndexRequiredException;
import de.qfs.apps.qftest.shared.exceptions.OperationNotSupportedException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.exceptions.UnexpectedIndexException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Reflector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ItemToIndexVisitor {
    private static final QFLogger c = new QFLogger("de.qfs.apps.qftest.client.awt.data.ItemToIndexVisitor");
    protected SubItemIndex a;
    protected SubItemIndex b;

    public ItemToIndexVisitor(SubItemIndex subItemIndex, SubItemIndex subItemIndex2) {
        if (ItemToIndexVisitor.c.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "ItemToIndexVisitor(SubItemIndex,SubItemIndex)", 93).addDetail("primary", (Object)subItemIndex)).addDetail("secondary", (Object)subItemIndex2)).log();
        }
        this.a = subItemIndex;
        this.b = subItemIndex2;
    }

    public static Object getIndex(Component component, SubItemIndex subItemIndex, SubItemIndex subItemIndex2) throws TestException {
        if (ItemToIndexVisitor.c.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "getIndex(Component,SubItemIndex,SubItemIndex)", 117).addDetail("com", (Object)component)).addDetail("primary", (Object)subItemIndex)).addDetail("secondary", (Object)subItemIndex2)).log();
        }
        ItemToIndexVisitor itemToIndexVisitor = new ItemToIndexVisitor(subItemIndex, subItemIndex2);
        Object[] objectArray = new Object[1];
        TestException[] testExceptionArray = new TestException[1];
        SwingUtil.invokeAndWait((Runnable)new i(objectArray, itemToIndexVisitor, component, testExceptionArray, subItemIndex2, subItemIndex));
        if (testExceptionArray[0] != null) {
            throw testExceptionArray[0];
        }
        if (ItemToIndexVisitor.c.level >= 9) {
            ((LevelAwareLogBuilder)c.lvlBuild(9, "getIndex(Component,SubItemIndex,SubItemIndex)", 158).add("result", objectArray[0])).log();
        }
        return objectArray[0];
    }

    public Object visit(Component component) throws OperationNotSupportedException {
        throw new OperationNotSupportedException(ComponentHelper.instance().getNamedClass(component).getName());
    }

    public Object visit(JComboBox jComboBox) throws TestException {
        if (ItemToIndexVisitor.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "visit(JComboBox)", 197).addDetail("com", (Object)jComboBox)).log();
        }
        if (this.a == null) {
            throw new IndexRequiredException(true, "JComboBox");
        }
        if (this.b != null) {
            throw new UnexpectedIndexException(false, "JComboBox");
        }
        int n2 = -1;
        int n3 = jComboBox.getItemCount();
        if (this.a.getType() == 1) {
            n2 = this.a.asNumber();
        } else {
            for (int i2 = 0; i2 < n3; ++i2) {
                String string = h.a(jComboBox, i2, true);
                if (!this.a.matches(string)) continue;
                n2 = i2;
                break;
            }
        }
        if (n2 < 0 || n2 >= n3) {
            throw new IndexNotFoundException(this.a);
        }
        return n2;
    }

    public Object visit(JEditorPane jEditorPane) throws TestException {
        int n2;
        int n3;
        block8: {
            if (ItemToIndexVisitor.c.level >= 7) {
                ((LevelAwareLogBuilder)c.lvlBuild(7, "visit(JEditorPane)", 238).addDetail("text", (Object)jEditorPane)).log();
            }
            if (this.a == null) {
                throw new IndexRequiredException(true, "JEditorPane");
            }
            if (this.b != null) {
                throw new UnexpectedIndexException(false, "JEditorPane");
            }
            Element element = jEditorPane.getDocument().getDefaultRootElement();
            Element element2 = this.a(element);
            if (element2 == null) {
                throw new IndexNotFoundException(this.a);
            }
            n3 = element2.getStartOffset();
            n2 = element2.getEndOffset();
            if (Options.cached_OPT_PLAY_SCROLL_ITEM) {
                try {
                    Rectangle rectangle = jEditorPane.modelToView((n3 + n2) / 2);
                    if (rectangle != null) {
                        jEditorPane.scrollRectToVisible(rectangle);
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (ItemToIndexVisitor.c.level < 3) break block8;
                    ((LevelAwareLogBuilder)c.lvlBuild(3, "visit(JEditorPane)", 265).add("ex", (Object)badLocationException)).log();
                }
            }
        }
        return (n3 + n2) / 2;
    }

    public Object visit(JList jList) throws TestException {
        Rectangle rectangle;
        if (ItemToIndexVisitor.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "visit(JList)", 281).addDetail("com", (Object)jList)).log();
        }
        if (this.a == null) {
            throw new IndexRequiredException(true, "JList");
        }
        if (this.b != null) {
            throw new UnexpectedIndexException(false, "JList");
        }
        int n2 = -1;
        int n3 = jList.getModel().getSize();
        if (this.a.getType() == 1) {
            n2 = this.a.asNumber();
        } else {
            for (int i2 = 0; i2 < n3; ++i2) {
                String string = h.a(jList, i2, true);
                if (!this.a.matches(string)) continue;
                n2 = i2;
                break;
            }
        }
        if (n2 < 0 || n2 >= n3) {
            throw new IndexNotFoundException(this.a);
        }
        if (Options.cached_OPT_PLAY_SCROLL_ITEM && (rectangle = jList.getCellBounds(n2, n2)) != null) {
            jList.scrollRectToVisible(rectangle);
        }
        return n2;
    }

    public Object visit(JTabbedPane jTabbedPane) throws TestException {
        int n2;
        block13: {
            Object object;
            if (ItemToIndexVisitor.c.level >= 7) {
                ((LevelAwareLogBuilder)c.lvlBuild(7, "visit(JTabbedPane)", 328).addDetail("com", (Object)jTabbedPane)).log();
            }
            if (this.a == null) {
                throw new IndexRequiredException(true, "JTabbedPane");
            }
            if (this.b != null) {
                throw new UnexpectedIndexException(false, "JTabbedPane");
            }
            n2 = -1;
            int n3 = jTabbedPane.getTabCount();
            if (this.a.getType() == 1) {
                n2 = this.a.asNumber();
            } else {
                for (int i2 = 0; i2 < n3; ++i2) {
                    object = h.a(jTabbedPane, i2);
                    if (!this.a.matches((String)object)) continue;
                    n2 = i2;
                    break;
                }
            }
            if (n2 < 0 || n2 >= n3) {
                throw new IndexNotFoundException(this.a);
            }
            if (Options.cached_OPT_PLAY_SCROLL_ITEM) {
                try {
                    Object object2 = Reflector.safeCall((Object)jTabbedPane, (String)"getTabLayoutPolicy");
                    if (object2 != null && object2.equals(Reflector.safeGet(JTabbedPane.class, (String)"SCROLL_TAB_LAYOUT")) && (object = jTabbedPane.getUI().getTabBounds(jTabbedPane, n2)) != null) {
                        Object object3 = Reflector.safeGet((Object)jTabbedPane.getUI(), (String)"tabScroller", (boolean)true);
                        JViewport jViewport = (JViewport)Reflector.safeGet((Object)object3, (String)"viewport", (boolean)true);
                        Point point = new Point(((Rectangle)object).x, ((Rectangle)object).y);
                        Point point2 = SwingUtilities.convertPoint(jTabbedPane, point, jViewport.getView());
                        ((Rectangle)object).x = point2.x;
                        ((Rectangle)object).y = point2.y;
                        point = jViewport.getViewPosition();
                        Dimension dimension = jViewport.getSize();
                        if (point2.x + ((Rectangle)object).width > point.x + dimension.width) {
                            point.x = point2.x + ((Rectangle)object).width - dimension.width;
                        }
                        if (point2.y + ((Rectangle)object).height > point2.y + dimension.height) {
                            point.y = point2.y + ((Rectangle)object).height - dimension.height;
                        }
                        point.x = Math.min(point.x, point2.x);
                        point.y = Math.min(point.y, point2.y);
                        jViewport.setViewPosition(point);
                    }
                }
                catch (Exception exception) {
                    if (ItemToIndexVisitor.c.level < 9) break block13;
                    ((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTabbedPane)", 384).add("ex", (Object)exception)).log();
                }
            }
        }
        return n2;
    }

    public Object visit(JTable jTable) throws TestException {
        Object object;
        if (ItemToIndexVisitor.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "visit(JTable)", 400).addDetail("com", (Object)jTable)).log();
        }
        if (this.a == null) {
            throw new IndexRequiredException(true, "JTable");
        }
        int n2 = -1;
        int n3 = jTable.getModel().getColumnCount();
        if (this.a.getType() == 1) {
            n2 = this.a.asNumber();
        } else {
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (jTableHeader != null) {
                n2 = this.a(jTable, jTableHeader);
            }
        }
        if (ItemToIndexVisitor.c.level >= 9) {
            ((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTable)", 417).add("cidx", n2)).log();
        }
        if (n2 < 0 || n2 >= n3) {
            throw new IndexNotFoundException(this.a);
        }
        int n4 = jTable.convertColumnIndexToView(n2);
        if (this.b == null) {
            Rectangle rectangle;
            if (Options.cached_OPT_PLAY_SCROLL_ITEM && jTable.getParent() instanceof JViewport && (rectangle = jTable.getCellRect(0, n4, true)) != null) {
                rectangle.y = ((JViewport)jTable.getParent()).getViewPosition().y;
                jTable.scrollRectToVisible(rectangle);
            }
            return n2;
        }
        int n5 = -1;
        JTree jTree = ResolverRegistry.instance().resolveTreeTableTree(jTable);
        if (jTree != null) {
            object = this.a;
            this.a = this.b;
            this.b = null;
            Integer n6 = (Integer)this.visit(jTree);
            this.b = this.a;
            this.a = object;
            if (n6 != null) {
                n5 = n6;
            }
            if (n5 < 0) {
                throw new IndexNotFoundException(this.a, this.b);
            }
        }
        if (n5 < 0) {
            int n7 = jTable.getRowCount();
            if (ItemToIndexVisitor.c.level >= 9) {
                ((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTable)", 456).add("rmax", n7)).log();
            }
            if (this.b.getType() == 1) {
                n5 = this.b.asNumber();
            } else {
                for (int i2 = 0; i2 < n7; ++i2) {
                    String string = h.a(jTable, i2, n4, true);
                    if (ItemToIndexVisitor.c.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTable)", 462).add("i", i2)).add("name", string)).log();
                    }
                    if (!this.b.matches(string)) continue;
                    n5 = i2;
                    break;
                }
            }
            if (ItemToIndexVisitor.c.level >= 9) {
                ((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTable)", 469).add("ridx", n5)).log();
            }
            if (n5 < 0 || n5 >= n7) {
                throw new IndexNotFoundException(this.a, this.b);
            }
        }
        if (Options.cached_OPT_PLAY_SCROLL_ITEM && (object = jTable.getCellRect(n5, n4, true)) != null) {
            jTable.scrollRectToVisible((Rectangle)object);
        }
        return new Integer[]{n2, n5};
    }

    public Object visit(JTableHeader jTableHeader) throws TestException {
        Rectangle rectangle;
        if (ItemToIndexVisitor.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "visit(JTableHeader)", 494).addDetail("com", (Object)jTableHeader)).log();
        }
        if (this.a == null) {
            throw new IndexRequiredException(true, "JTableHeader");
        }
        if (this.b != null) {
            throw new UnexpectedIndexException(false, "JTableHeader");
        }
        int n2 = -1;
        int n3 = jTableHeader.getTable() == null ? jTableHeader.getColumnModel().getColumnCount() : jTableHeader.getTable().getModel().getColumnCount();
        n2 = this.a.getType() == 1 ? this.a.asNumber() : this.a(jTableHeader.getTable(), jTableHeader);
        if (n2 < 0 || n2 >= n3) {
            throw new IndexNotFoundException(this.a);
        }
        if (Options.cached_OPT_PLAY_SCROLL_ITEM && jTableHeader.getTable() != null && jTableHeader.getTable().getParent() instanceof JViewport && (rectangle = jTableHeader.getTable().getCellRect(0, jTableHeader.getTable().convertColumnIndexToView(n2), true)) != null) {
            rectangle.y = ((JViewport)jTableHeader.getTable().getParent()).getViewPosition().y;
            jTableHeader.getTable().scrollRectToVisible(rectangle);
        }
        return n2;
    }

    public Object visit(JTextArea jTextArea) throws TestException {
        int n2;
        block15: {
            if (ItemToIndexVisitor.c.level >= 7) {
                ((LevelAwareLogBuilder)c.lvlBuild(7, "visit(JTextArea)", 538).addDetail("text", (Object)jTextArea)).log();
            }
            if (this.a == null) {
                throw new IndexRequiredException(true, "JTextArea");
            }
            if (this.b != null) {
                throw new UnexpectedIndexException(false, "JTextArea");
            }
            n2 = -1;
            Element element = jTextArea.getDocument().getDefaultRootElement();
            int n3 = element.getElementCount();
            if (this.a.getType() == 1) {
                n2 = this.a.asNumber();
            } else {
                for (int i2 = 0; i2 < n3; ++i2) {
                    String string;
                    block14: {
                        Element element2 = element.getElement(i2);
                        int n4 = element2.getStartOffset();
                        int n5 = element2.getEndOffset();
                        string = "";
                        try {
                            string = Misc.lineSepToLineFeed((String)jTextArea.getText(n4, n5 - n4));
                            if (string.endsWith("\n")) {
                                string = string.substring(0, string.length() - 1);
                            }
                        }
                        catch (Exception exception) {
                            if (ItemToIndexVisitor.c.level < 1) break block14;
                            ((LevelAwareLogBuilder)c.lvlBuild(1, "visit(JTextArea)", 567).add("ex", (Object)exception)).log();
                        }
                    }
                    if (!this.a.matches(string)) continue;
                    n2 = i2;
                    break;
                }
            }
            if (n2 < 0 || n2 >= n3) {
                throw new IndexNotFoundException(this.a);
            }
            if (Options.cached_OPT_PLAY_SCROLL_ITEM) {
                try {
                    Rectangle rectangle = jTextArea.modelToView(n2 / 2);
                    if (rectangle != null) {
                        jTextArea.scrollRectToVisible(rectangle);
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (ItemToIndexVisitor.c.level < 3) break block15;
                    ((LevelAwareLogBuilder)c.lvlBuild(3, "visit(JTextArea)", 586).add("ex", (Object)badLocationException)).log();
                }
            }
        }
        return n2;
    }

    public Object visit(JTree jTree) throws TestException {
        int n2;
        int n3;
        block52: {
            block51: {
                boolean bl2;
                if (ItemToIndexVisitor.c.level >= 7) {
                    ((LevelAwareLogBuilder)c.lvlBuild(7, "visit(JTree)", 603).addDetail("com", (Object)jTree)).log();
                }
                if (this.a == null) {
                    throw new IndexRequiredException(true, "JTree");
                }
                if (this.b != null) {
                    throw new UnexpectedIndexException(false, "JTree");
                }
                n3 = -1;
                n2 = jTree.getRowCount();
                String string = this.a.getIndex();
                boolean bl3 = bl2 = string.charAt(0) == '/';
                if (ItemToIndexVisitor.c.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTree)", 618).add("tPath", string)).add("asPath", bl2)).log();
                }
                if (!bl2) break block51;
                TreeModel treeModel = jTree.getModel();
                Object object = treeModel.getRoot();
                TreePath treePath = new TreePath(object);
                boolean bl4 = jTree.isRootVisible();
                int n4 = 0;
                block18: while (n4 >= 0) {
                    int n5 = Misc.unquotedIndexOf((String)string, (String)"/", (int)(n4 + 1));
                    String string2 = n5 > n4 ? Misc.unquote((String)string.substring(n4 + 1, n5), (String)"\\#@&%/") : Misc.unquote((String)string.substring(n4 + 1), (String)"\\#@&%/");
                    if (ItemToIndexVisitor.c.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTree)", 637).add("index", string2)).add("pos", n4)).add("pos2", n5)).log();
                    }
                    n4 = n5;
                    if (bl4) {
                        if (ItemToIndexVisitor.c.level >= 9) {
                            ((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTree)", 642).add("Checking root")).log();
                        }
                        String string3 = h.b(jTree, treePath, true);
                        if (ItemToIndexVisitor.c.level >= 9) {
                            ((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTree)", 644).add("name", string3)).log();
                        }
                        if (string3 == null) {
                            string3 = "";
                        }
                        switch (this.a.getType()) {
                            case 0: {
                                if (string2.equals(string3)) break;
                                throw new IndexNotFoundException(this.a);
                            }
                            case 1: {
                                try {
                                    if (Integer.parseInt(string2) != 0) {
                                        throw new IndexNotFoundException(this.a);
                                    }
                                    break;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new IndexFormatException(this.a);
                                }
                            }
                            case 2: {
                                try {
                                    if (!Util.regexpMatches((String)string2, (String)string3)) {
                                        throw new IndexNotFoundException(this.a);
                                    }
                                    break;
                                }
                                catch (RuntimeException runtimeException) {
                                    throw new IndexFormatException(this.a);
                                }
                            }
                        }
                        n3 = 0;
                        bl4 = false;
                        continue;
                    }
                    if (!jTree.isExpanded(treePath) && !Options.cached_OPT_PLAY_EXPAND_TREE) {
                        if (ItemToIndexVisitor.c.level >= 9) {
                            ((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTree)", 679).add("Parent is collapsed")).log();
                        }
                        throw new IndexNotFoundException(this.a);
                    }
                    int n6 = treeModel.getChildCount(object);
                    if (ItemToIndexVisitor.c.level >= 9) {
                        ((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTree)", 685).add("num", n6)).log();
                    }
                    if (n6 == 0 && ItemToIndexVisitor.c.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTree)", 687).add("model", (Object)treeModel)).add("node", object)).log();
                    }
                    switch (this.a.getType()) {
                        case 0: {
                            String string4;
                            TreePath treePath2;
                            Object object2;
                            int n7;
                            for (n7 = 0; n7 < n6; ++n7) {
                                object2 = treeModel.getChild(object, n7);
                                if (ItemToIndexVisitor.c.level >= 9) {
                                    ((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTree)", 694).add("child", object2)).log();
                                }
                                treePath2 = treePath.pathByAddingChild(object2);
                                string4 = h.b(jTree, treePath2, true);
                                if (ItemToIndexVisitor.c.level >= 9) {
                                    ((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTree)", 697).add("name", string4)).log();
                                }
                                if (string4 == null) {
                                    string4 = "";
                                }
                                if (!string2.equals(string4)) continue;
                                treePath = treePath2;
                                object = object2;
                                break;
                            }
                            if (n7 != n6) break;
                            throw new IndexNotFoundException(this.a);
                        }
                        case 1: {
                            try {
                                int n8 = Integer.parseInt(string2);
                                if (n8 < 0 || n8 >= n6) {
                                    throw new IndexNotFoundException(this.a);
                                }
                                object = treeModel.getChild(object, n8);
                                treePath = treePath.pathByAddingChild(object);
                                break;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new IndexFormatException(this.a);
                            }
                        }
                        case 2: {
                            String string4;
                            TreePath treePath2;
                            Object object2;
                            int n7;
                            try {
                                for (n7 = 0; n7 < n6; ++n7) {
                                    object2 = treeModel.getChild(object, n7);
                                    treePath2 = treePath.pathByAddingChild(object2);
                                    string4 = h.b(jTree, treePath2, true);
                                    if (ItemToIndexVisitor.c.level >= 9) {
                                        ((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTree)", 731).add("name", string4)).log();
                                    }
                                    if (string4 == null) {
                                        string4 = "";
                                    }
                                    if (!Util.regexpMatches((String)string2, (String)string4)) continue;
                                    treePath = treePath2;
                                    object = object2;
                                    break;
                                }
                                if (n7 != n6) continue block18;
                                throw new IndexNotFoundException(this.a);
                            }
                            catch (RuntimeException runtimeException) {
                                throw new IndexFormatException(this.a);
                            }
                        }
                    }
                }
                jTree.makeVisible(treePath);
                n3 = jTree.getRowForPath(treePath);
                if (ItemToIndexVisitor.c.level >= 9) {
                    ((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTree)", 753).add("Final idx", n3)).log();
                }
                n2 = jTree.getRowCount();
                if (ItemToIndexVisitor.c.level < 9) break block52;
                ((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTree)", 755).add("max", n2)).log();
                break block52;
            }
            if (this.a.getType() == 1) {
                n3 = this.a.asNumber();
            } else {
                String string = this.a.getIndex();
                if (!Misc.emptyOrNull((String)string)) {
                    string = Misc.unquote((String)string, (String)"\\#@&%/");
                }
                SubItemIndex subItemIndex = new SubItemIndex(string, this.a.getType());
                if (ItemToIndexVisitor.c.level >= 9) {
                    ((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTree)", 766).add("index", (Object)subItemIndex)).log();
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string5 = h.a(jTree, i2, true);
                    if (ItemToIndexVisitor.c.level >= 9) {
                        ((LevelAwareLogBuilder)c.lvlBuild(9, "visit(JTree)", 769).add("name", string5)).log();
                    }
                    if (!subItemIndex.matches(string5)) continue;
                    n3 = i2;
                    break;
                }
            }
        }
        if (n3 < 0 || n3 >= n2) {
            throw new IndexNotFoundException(this.a);
        }
        if (Options.cached_OPT_PLAY_SCROLL_ITEM) {
            jTree.scrollRowToVisible(n3);
        }
        return n3;
    }

    protected Element a(Element element) throws TestException {
        if (this.a.getType() == 0 || this.a.getType() == 2) {
            String string;
            block9: {
                int n2 = element.getStartOffset();
                int n3 = element.getEndOffset();
                string = "";
                try {
                    string = Misc.lineSepToLineFeed((String)element.getDocument().getText(n2, n3 - n2));
                    if (string.endsWith("\n")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    string = Misc.lineSepToLineFeed((String)string);
                }
                catch (Exception exception) {
                    if (ItemToIndexVisitor.c.level < 1) break block9;
                    ((LevelAwareLogBuilder)c.lvlBuild(1, "findIndex(Element)", 820).add("ex", (Object)exception)).log();
                }
            }
            if (element.getElementCount() == 0 && this.a.matches(string)) {
                return element;
            }
            for (int i2 = 0; i2 < element.getElementCount(); ++i2) {
                Element element2 = this.a(element.getElement(i2));
                if (element2 == null) continue;
                return element2;
            }
        } else if (this.a.getType() == 1) {
            if (element.getElementCount() == 0) {
                return element;
            }
            return this.a(element.getElement(element.getElementIndex(this.a.asNumber())));
        }
        return null;
    }

    private int a(JTable jTable, JTableHeader jTableHeader) throws TestException {
        int n2;
        if (ItemToIndexVisitor.c.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "findHeader(JTable,JTableHeader)", 855).addDetail("table", (Object)jTable)).addDetail("header", (Object)jTableHeader)).log();
        }
        int n3 = -1;
        int n4 = (jTable == null ? jTableHeader.getColumnModel() : jTable.getColumnModel()).getColumnCount();
        int n5 = n2 = jTable == null ? n4 : jTable.getModel().getColumnCount();
        if (ItemToIndexVisitor.c.level >= 9) {
            ((LevelAwareLogBuilder)c.lvlBuild(9, "findHeader(JTable,JTableHeader)", 866).add("cols", n4)).log();
        }
        if (jTableHeader != null) {
            for (int i2 = 0; i2 < n4; ++i2) {
                int n6;
                if (ItemToIndexVisitor.c.level >= 9) {
                    ((LevelAwareLogBuilder)c.lvlBuild(9, "findHeader(JTable,JTableHeader)", 870).add("i", i2)).log();
                }
                int n7 = n6 = jTable == null ? f.b(jTableHeader, i2) : jTable.convertColumnIndexToModel(i2);
                if (ItemToIndexVisitor.c.level >= 9) {
                    ((LevelAwareLogBuilder)c.lvlBuild(9, "findHeader(JTable,JTableHeader)", 873).add("col", n6)).log();
                }
                if (n6 < 0) continue;
                String string = h.a(jTableHeader, i2, true);
                if (ItemToIndexVisitor.c.level >= 9) {
                    ((LevelAwareLogBuilder)c.lvlBuild(9, "findHeader(JTable,JTableHeader)", 879).add("tmp", string)).log();
                }
                if (!this.a.matches(string)) continue;
                if (n6 >= n2) {
                    throw new TestException("Inconsistent Table implementation for table " + jTable + ":\nTable.convertColumnIndexToModel(" + i2 + ") returned " + n6 + "\nbut Table.getModel().getColumnCount() returned " + n2 + "\nso the converted column is outside the legal range for the model.");
                }
                n3 = n6;
                break;
            }
        }
        return n3;
    }

    static /* synthetic */ QFLogger a() {
        return c;
    }
}

