/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.awt.items;

import de.qfs.apps.qftest.client.RetryException;
import de.qfs.apps.qftest.client.awt.data.h;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.extensions.items.ItemResolver;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class JTextAreaItemResolver
implements ItemResolver {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.awt.items.JTextAreaItemResolver");

    public JTextAreaItemResolver() {
        if (JTextAreaItemResolver.a.level >= 7) {
            a.lvlBuild(7, "JTextAreaItemResolver()", 61).log();
        }
    }

    @Override
    public Object getItem(Object object, int n2, int n3) {
        int n4;
        JTextArea jTextArea;
        block12: {
            if (JTextAreaItemResolver.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItem(Object,int,int)", 83).addDetail("element", object)).addDetail("x", n2)).addDetail("y", n3)).log();
            }
            if (!(object instanceof JTextArea)) {
                if (JTextAreaItemResolver.a.level >= 1) {
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "getItem(Object,int,int)", 86).add("Internal error: Not a JTextArea", object)).log();
                }
                return null;
            }
            jTextArea = (JTextArea)object;
            Point point = new Point(n2, n3);
            n4 = jTextArea.viewToModel(point);
            if (JTextAreaItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItem(Object,int,int)", 93).add("index", n4)).log();
            }
            if (n4 < 0) {
                return null;
            }
            try {
                Rectangle rectangle = jTextArea.modelToView(n4);
                if (n3 < rectangle.y || n3 >= rectangle.y + rectangle.height) {
                    return null;
                }
            }
            catch (Exception exception) {
                if (JTextAreaItemResolver.a.level < 1) break block12;
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getItem(Object,int,int)", 105).add("ex", (Object)exception)).log();
            }
        }
        try {
            int n5 = jTextArea.getLineOfOffset(n4);
            if (JTextAreaItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItem(Object,int,int)", 111).add("line", n5)).log();
            }
            return n5;
        }
        catch (BadLocationException badLocationException) {
            if (JTextAreaItemResolver.a.level >= 1) {
                a.lvlBuild(1, "getItem(Object,int,int)", 115).log();
            }
            return null;
        }
    }

    @Override
    public String getItemValue(Object object, Object object2) throws BadItemException {
        if (JTextAreaItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemValue(Object,Object)", 132).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        JTextArea jTextArea = (JTextArea)object;
        int n2 = (Integer)object2;
        return this.c(jTextArea, n2);
    }

    @Override
    public Object getItemForIndex(Object object, SubItemIndex[] subItemIndexArray) throws TestException {
        int n2;
        block9: {
            int n3;
            SubItemIndex subItemIndex;
            JTextArea jTextArea;
            block11: {
                block10: {
                    if (JTextAreaItemResolver.a.level >= 7) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForIndex(Object,SubItemIndex[])", 158).addDetail("element", object)).addDetail("idx", (Object)subItemIndexArray)).log();
                    }
                    this.checkItem(object, null);
                    jTextArea = (JTextArea)object;
                    n2 = -1;
                    subItemIndex = subItemIndexArray[0];
                    n3 = jTextArea.getLineCount();
                    if (subItemIndex.getType() != 1) break block10;
                    n2 = subItemIndex.asNumber();
                    if (n2 >= 0) break block11;
                    n2 = n3 + n2;
                    break block11;
                }
                for (int i2 = 0; i2 < n3; ++i2) {
                    Boolean bl2 = ItemRegistry.instance().matchesItemName((Object)jTextArea, i2, subItemIndex, subItemIndex.getIndex());
                    if (bl2 != null) {
                        if (!bl2.booleanValue()) continue;
                        if (JTextAreaItemResolver.a.level >= 9) {
                            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 181).add("item matcher matches.")).log();
                        }
                        n2 = i2;
                        break;
                    }
                    String string = this.b(jTextArea, i2);
                    if (!subItemIndex.matches(string)) continue;
                    n2 = i2;
                    break;
                }
            }
            if (n2 < 0 || n2 >= n3) {
                throw new IndexNotFoundException(subItemIndex);
            }
            if (Options.cached_OPT_PLAY_SCROLL_ITEM) {
                try {
                    Rectangle rectangle = jTextArea.modelToView(n2 / 2);
                    if (rectangle != null) {
                        jTextArea.scrollRectToVisible(rectangle);
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (JTextAreaItemResolver.a.level < 3) break block9;
                    ((LevelAwareLogBuilder)a.lvlBuild(3, "getItemForIndex(Object,SubItemIndex[])", 210).add("ex", (Object)badLocationException)).log();
                }
            }
        }
        return n2;
    }

    public int getItemIndex(Object object, Object object2) throws BadItemException {
        if (JTextAreaItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object)", 231).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        JTextArea jTextArea = (JTextArea)object;
        int n2 = (Integer)object2;
        int n3 = jTextArea.getLineCount();
        if (n2 < 0 || n2 >= n3) {
            throw new BadItemException("Item " + object2 + " does not belong to " + object);
        }
        if (JTextAreaItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object)", 245).add("returned idx", n2)).log();
        }
        return n2;
    }

    @Override
    public SubItemIndex[] getItemIndex(Object object, Object object2, int n2) throws BadItemException {
        boolean bl2;
        if (JTextAreaItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object,int)", 264).addDetail("element", object)).addDetail("item", object2)).addDetail("type", n2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        JTextArea jTextArea = (JTextArea)object;
        if (n2 == 1 && jTextArea.isEditable()) {
            n2 = 3;
        }
        int n3 = (Integer)object2;
        int n4 = jTextArea.getLineCount();
        if (n3 < 0 || n3 >= n4) {
            throw new BadItemException("Item " + object2 + " does not belong to " + object);
        }
        String string = this.a(jTextArea, n3);
        if (JTextAreaItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 283).add("name", string)).log();
        }
        boolean bl3 = bl2 = n2 == 1;
        if (bl2) {
            for (int i2 = 0; i2 < n4; ++i2) {
                if (i2 == n3 || !Misc.equalOrNull((Object)string, (Object)this.a(jTextArea, i2))) continue;
                if (JTextAreaItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 289).add("i", i2)).log();
                }
                bl2 = false;
                break;
            }
        }
        SubItemIndex subItemIndex = n2 == 2 || bl2 && n2 == 1 ? new SubItemIndex(string) : new SubItemIndex(n3);
        if (JTextAreaItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 303).add("returned tIdx", (Object)subItemIndex)).log();
        }
        return new SubItemIndex[]{subItemIndex};
    }

    @Override
    public int[] getItemLocation(Object object, Object object2) throws BadItemException {
        if (JTextAreaItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemLocation(Object,Object)", 321).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        JTextArea jTextArea = (JTextArea)object;
        int n2 = (Integer)object2;
        int n3 = jTextArea.getLineCount();
        if (n2 < 0 || n2 >= n3) {
            throw new BadItemException("Item " + object2 + " does not belong to " + object);
        }
        try {
            int n4 = jTextArea.getLineStartOffset(n2);
            Rectangle rectangle = jTextArea.modelToView(n4);
            if (rectangle == null) {
                TestException testException = new TestException("JTextArea not ready yet!");
                int n5 = Options.cached_OPT_PLAY_POLL_ITEM;
                throw new RetryException(testException, n5);
            }
            return new int[]{rectangle.x, rectangle.y};
        }
        catch (BadLocationException badLocationException) {
            if (JTextAreaItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getItemLocation(Object,Object)", 347).add("ex", (Object)badLocationException)).log();
            }
            throw new BadItemException("Internal error");
        }
    }

    @Override
    public int[] getItemSize(Object object, Object object2) throws BadItemException {
        if (JTextAreaItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemSize(Object,Object)", 366).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        JTextArea jTextArea = (JTextArea)object;
        int n2 = (Integer)object2;
        int n3 = jTextArea.getLineCount();
        if (n2 < 0 || n2 >= n3) {
            throw new BadItemException("Item " + object2 + " does not belong to " + object);
        }
        try {
            int n4 = jTextArea.getLineStartOffset(n2);
            if (JTextAreaItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemSize(Object,Object)", 383).add("start", n4)).log();
            }
            int n5 = jTextArea.getLineEndOffset(n2);
            if (JTextAreaItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemSize(Object,Object)", 385).add("end", n5)).log();
            }
            if (jTextArea.getLineCount() > n2 + 1) {
                --n5;
                if (JTextAreaItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemSize(Object,Object)", 390).add("end2", n5)).log();
                }
            }
            Rectangle rectangle = jTextArea.modelToView(n4);
            if (JTextAreaItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemSize(Object,Object)", 393).add("rect", (Object)rectangle)).log();
            }
            Rectangle rectangle2 = jTextArea.modelToView(n5);
            if (JTextAreaItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemSize(Object,Object)", 395).add("rect2", (Object)rectangle2)).log();
            }
            return new int[]{rectangle2.x + rectangle2.width - rectangle.x, rectangle2.y + rectangle2.height - rectangle.y};
        }
        catch (BadLocationException badLocationException) {
            if (JTextAreaItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getItemSize(Object,Object)", 399).add("ex", (Object)badLocationException)).log();
            }
            throw new BadItemException("Internal error");
        }
    }

    @Override
    public Boolean repositionMouseEvent(Object object, Object object2, int[] nArray) throws BadItemException {
        if (JTextAreaItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "repositionMouseEvent(Object,Object,int[])", 424).addDetail("element", object)).addDetail("item", object2)).addDetail("pos", (Object)nArray)).log();
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean scrollItemVisible(Object object, Object object2, int n2, int n3) throws BadItemException {
        if (JTextAreaItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "scrollItemVisible(Object,Object,int,int)", 449).addDetail("element", object)).addDetail("item", object2)).addDetail("x", n2)).addDetail("y", n3)).log();
        }
        this.checkItem(object, object2);
        return null;
    }

    @Override
    public int getItemCount(Object object, Object object2) throws BadItemException {
        if (JTextAreaItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemCount(Object,Object)", 476).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        JTextArea jTextArea = (JTextArea)object;
        int n2 = jTextArea.getLineCount();
        if (JTextAreaItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemCount(Object,Object)", 482).add("returned count", n2)).log();
        }
        return n2;
    }

    protected void checkItem(Object object, Object object2) throws BadItemException {
        if (!(object instanceof JTextArea)) {
            if (JTextAreaItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "checkItem(Object,Object)", 506).add("Internal error: Not a JTextArea", object)).log();
            }
            throw new BadItemException("Not a JTextArea: " + object);
        }
        if (object2 != null && !(object2 instanceof Integer)) {
            if (JTextAreaItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "checkItem(Object,Object)", 510).add("Internal error: Not an Integer", object2)).log();
            }
            throw new BadItemException("Not an Integer: " + object2);
        }
    }

    private String a(JTextArea jTextArea, int n2) {
        if (JTextAreaItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getTextLine(JTextArea,int)", 526).addDetail("text", (Object)jTextArea)).addDetail("line", n2)).log();
        }
        String string = this.b(jTextArea, n2);
        return ItemRegistry.instance().getItemName(jTextArea, n2, string);
    }

    private String b(JTextArea jTextArea, int n2) {
        if (JTextAreaItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getDefaultTextLineAsIdentifier(JTextArea,int)", 543).addDetail("text", (Object)jTextArea)).addDetail("line", n2)).log();
        }
        return h.a(jTextArea, n2);
    }

    private String c(JTextArea jTextArea, int n2) {
        if (JTextAreaItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getDefaultTextLine(JTextArea,int)", 559).addDetail("text", (Object)jTextArea)).addDetail("line", n2)).log();
        }
        return h.b(jTextArea, n2);
    }
}

