/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.awt.items;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.RetryException;
import de.qfs.apps.qftest.client.awt.data.h;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.extensions.items.ItemResolver;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.IndexFormatException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeItemResolver
implements ItemResolver {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.awt.items.JTreeItemResolver");
    private JTree b = null;
    private TreePath c = null;
    private int d = -1;

    public JTreeItemResolver() {
        if (JTreeItemResolver.a.level >= 7) {
            a.lvlBuild(7, "JTreeItemResolver()", 77).log();
        }
    }

    @Override
    public Object getItem(Object object, int n2, int n3) {
        if (JTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItem(Object,int,int)", 99).addDetail("element", object)).addDetail("x", n2)).addDetail("y", n3)).log();
        }
        if (!(object instanceof JTree)) {
            if (JTreeItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getItem(Object,int,int)", 102).add("Internal error: Not a JTree", object)).log();
            }
            return null;
        }
        JTree jTree = (JTree)object;
        TreePath treePath = jTree.getClosestPathForLocation(n2, n3);
        if (JTreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItem(Object,int,int)", 108).add("path", (Object)treePath)).log();
        }
        if (treePath == null) {
            return null;
        }
        Rectangle rectangle = jTree.getPathBounds(treePath);
        if (rectangle == null || !rectangle.contains(rectangle.x, n3)) {
            return null;
        }
        return treePath;
    }

    @Override
    public Object getItemForIndex(Object object, SubItemIndex[] subItemIndexArray) throws TestException {
        boolean bl2;
        if (JTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForIndex(Object,SubItemIndex[])", 132).addDetail("element", object)).addDetail("idx", (Object)subItemIndexArray)).log();
        }
        ItemRegistry.instance().checkSubItemIndexForTree(subItemIndexArray, true);
        this.checkItem(object, null);
        JTree jTree = (JTree)object;
        int n2 = 0;
        SubItemIndex subItemIndex = subItemIndexArray[n2];
        String string = subItemIndex.getIndex();
        boolean bl3 = bl2 = !Misc.emptyOrNull((String)string) && string.charAt(0) == '/';
        if (JTreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 144).add("tPath", string)).add("asPath", bl2)).log();
        }
        Serializable serializable = null;
        if (bl2) {
            TreeModel treeModel = jTree.getModel();
            Object object2 = treeModel.getRoot();
            serializable = new TreePath(object2);
            boolean bl4 = jTree.isRootVisible();
            int n3 = 0;
            while (n3 >= 0) {
                int n4 = Misc.unquotedIndexOf((String)string, (String)"/", (int)(n3 + 1));
                String string2 = n4 > n3 ? Misc.unquote((String)string.substring(n3 + 1, n4), (String)"\\#@&%/") : Misc.unquote((String)string.substring(n3 + 1), (String)"\\#@&%/");
                if (JTreeItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 164).add("index", string2)).add("pos", n3)).add("pos2", n4)).log();
                }
                n3 = n4;
                if (bl4) {
                    if (JTreeItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 169).add("Checking root")).log();
                    }
                    String string3 = this.a(jTree, (TreePath)serializable, true);
                    if (JTreeItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 171).add("name", string3)).log();
                    }
                    if (string3 == null) {
                        string3 = "";
                    }
                    switch (subItemIndex.getType()) {
                        case 0: {
                            Boolean bl5 = ItemRegistry.instance().matchesItemName((Object)jTree, serializable, subItemIndex, string2);
                            if ((bl5 != null || string2.equals(string3)) && (bl5 == null || bl5.booleanValue())) break;
                            throw new IndexNotFoundException(subItemIndex);
                        }
                        case 1: {
                            Boolean bl6 = ItemRegistry.instance().matchesItemName((Object)jTree, serializable, subItemIndex, string2);
                            if (bl6 == null) {
                                try {
                                    if (Integer.parseInt(string2) != 0) {
                                        throw new IndexNotFoundException(subItemIndex);
                                    }
                                    break;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new IndexFormatException(subItemIndex);
                                }
                            }
                            if (bl6.booleanValue()) break;
                            throw new IndexNotFoundException(subItemIndex);
                        }
                        case 2: {
                            Boolean bl7 = ItemRegistry.instance().matchesItemName((Object)jTree, serializable, subItemIndex, string2);
                            try {
                                if (bl7 == null && !Util.regexpMatches((String)string2, (String)string3) || bl7 != null && !bl7.booleanValue()) {
                                    throw new IndexNotFoundException(subItemIndex);
                                }
                                break;
                            }
                            catch (RuntimeException runtimeException) {
                                throw new IndexFormatException(subItemIndex);
                            }
                        }
                    }
                    bl4 = false;
                    if (n4 >= 0 || n2 >= subItemIndexArray.length - 1 || (subItemIndex = subItemIndexArray[n2 + 1]).getIndex().charAt(0) != '/') continue;
                    if (JTreeItemResolver.a.level >= 5) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(5, "getItemForIndex(Object,SubItemIndex[])", 217).add("multi-level-item, continue path with next index")).add("primary", (Object)subItemIndex)).log();
                    }
                    ++n2;
                    string = subItemIndex.getIndex();
                    n3 = 0;
                    n4 = 0;
                    continue;
                }
                if (!jTree.isExpanded((TreePath)serializable) && !Options.cached_OPT_PLAY_EXPAND_TREE) {
                    if (JTreeItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 228).add("Parent is collapsed")).log();
                    }
                    throw new IndexNotFoundException(subItemIndex);
                }
                jTree.expandPath((TreePath)serializable);
                int n5 = treeModel.getChildCount(object2);
                if (JTreeItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 237).add("num", n5)).log();
                }
                if (n5 == 0 && JTreeItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 239).add("model", (Object)treeModel)).add("node", object2)).log();
                }
                switch (subItemIndex.getType()) {
                    case 0: {
                        Object object3;
                        Serializable serializable2;
                        int n6;
                        for (n6 = 0; n6 < n5; ++n6) {
                            Object object4 = treeModel.getChild(object2, n6);
                            if (JTreeItemResolver.a.level >= 9) {
                                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 246).add("child", object4)).log();
                            }
                            TreePath treePath = serializable.pathByAddingChild(object4);
                            serializable2 = ItemRegistry.instance().matchesItemName((Object)jTree, treePath, subItemIndex, string2);
                            if (serializable2 != null) {
                                if (!((Boolean)serializable2).booleanValue()) continue;
                                serializable = treePath;
                                object2 = object4;
                                break;
                            }
                            object3 = this.a(jTree, treePath, true);
                            if (JTreeItemResolver.a.level >= 9) {
                                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 262).add("name", (String)object3)).log();
                            }
                            if (object3 == null) {
                                object3 = "";
                            }
                            if (!string2.equals(object3)) continue;
                            serializable = treePath;
                            object2 = object4;
                            break;
                        }
                        if (n6 != n5) break;
                        throw new IndexNotFoundException(subItemIndex);
                    }
                    case 1: {
                        Object object3;
                        Serializable serializable2;
                        boolean bl8 = false;
                        if (ItemRegistry.instance().hasItemNameMatchers(jTree)) {
                            for (int i2 = 0; i2 < n5; ++i2) {
                                Object object5 = treeModel.getChild(object2, i2);
                                if (JTreeItemResolver.a.level >= 9) {
                                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 281).add("child", object5)).log();
                                }
                                serializable2 = serializable.pathByAddingChild(object5);
                                object3 = ItemRegistry.instance().matchesItemName((Object)jTree, serializable2, subItemIndex, string2);
                                if (object3 == null || !((Boolean)object3).booleanValue()) continue;
                                serializable = serializable2;
                                object2 = object5;
                                bl8 = true;
                                break;
                            }
                        }
                        if (bl8) break;
                        try {
                            int n7 = Integer.parseInt(string2);
                            if (n7 < 0) {
                                n7 = n5 + n7;
                            }
                            if (n7 < 0 || n7 >= n5) {
                                throw new IndexNotFoundException(subItemIndex);
                            }
                            object2 = treeModel.getChild(object2, n7);
                            serializable = serializable.pathByAddingChild(object2);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IndexFormatException(subItemIndex);
                        }
                    }
                    case 2: {
                        Object object3;
                        Serializable serializable2;
                        try {
                            int n8;
                            for (n8 = 0; n8 < n5; ++n8) {
                                Object object6 = treeModel.getChild(object2, n8);
                                serializable2 = serializable.pathByAddingChild(object6);
                                object3 = ItemRegistry.instance().matchesItemName((Object)jTree, serializable2, subItemIndex, string2);
                                if (object3 != null) {
                                    if (!((Boolean)object3).booleanValue()) continue;
                                    serializable = serializable2;
                                    object2 = object6;
                                    break;
                                }
                                String string4 = this.a(jTree, (TreePath)serializable2, true);
                                if (JTreeItemResolver.a.level >= 9) {
                                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 330).add("name", string4)).log();
                                }
                                if (string4 == null) {
                                    string4 = "";
                                }
                                if (!Util.regexpMatches((String)string2, (String)string4)) continue;
                                serializable = serializable2;
                                object2 = object6;
                                break;
                            }
                            if (n8 == n5) {
                                throw new IndexNotFoundException(subItemIndex);
                            }
                            break;
                        }
                        catch (RuntimeException runtimeException) {
                            throw new IndexFormatException(subItemIndex);
                        }
                    }
                }
                if (n4 >= 0 || n2 >= subItemIndexArray.length - 1 || (subItemIndex = subItemIndexArray[n2 + 1]).getIndex().charAt(0) != '/') continue;
                if (JTreeItemResolver.a.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(5, "getItemForIndex(Object,SubItemIndex[])", 351).add("multi-level-item, continue path with next index")).add("primary", (Object)subItemIndex)).log();
                }
                ++n2;
                string = subItemIndex.getIndex();
                n3 = 0;
                n4 = 0;
            }
            jTree.makeVisible((TreePath)serializable);
        } else {
            int n9 = jTree.getRowCount();
            if (subItemIndex.getType() == 1) {
                serializable = jTree.getPathForRow(subItemIndex.asNumber());
            } else {
                String string5 = subItemIndex.getIndex();
                if (!Misc.emptyOrNull((String)string5)) {
                    string5 = Misc.unquote((String)string5, (String)"\\#@&%/");
                }
                SubItemIndex subItemIndex2 = new SubItemIndex(string5, subItemIndex.getType());
                if (JTreeItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 371).add("index", (Object)subItemIndex2)).log();
                }
                for (int i3 = 0; i3 < n9; ++i3) {
                    String string6 = this.a(jTree, i3, true);
                    if (JTreeItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 374).add("name", string6)).log();
                    }
                    if (!subItemIndex2.matches(string6)) continue;
                    serializable = jTree.getPathForRow(i3);
                    break;
                }
            }
        }
        if (serializable == null) {
            throw new IndexNotFoundException(subItemIndex);
        }
        ItemRegistry.instance().setIndexesResolved(n2 + 1);
        if (Options.cached_OPT_PLAY_SCROLL_ITEM) {
            jTree.scrollPathToVisible((TreePath)serializable);
        }
        this.b = jTree;
        this.c = serializable;
        this.d = jTree.getRowForPath((TreePath)serializable);
        return serializable;
    }

    @Override
    public String getItemValue(Object object, Object object2) throws BadItemException {
        if (JTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemValue(Object,Object)", 409).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        JTree jTree = (JTree)object;
        TreePath treePath = (TreePath)object2;
        return this.c(jTree, treePath, true);
    }

    @Override
    public SubItemIndex[] getItemIndex(Object object, Object object2, int n2) throws BadItemException {
        if (JTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object,int)", 437).addDetail("element", object)).addDetail("item", object2)).addDetail("type", n2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        JTree jTree = (JTree)object;
        TreePath treePath = (TreePath)object2;
        SubItemIndex[] subItemIndexArray = new SubItemIndex[1];
        boolean bl2 = Options.cached_OPT_RECORD_SUBITEM_TREE_PATH;
        if (bl2) {
            boolean bl3 = true;
            boolean[] blArray = new boolean[1];
            while (bl3) {
                bl3 = false;
                String string = "";
                TreePath treePath2 = treePath;
                for (int i2 = treePath.getPathCount(); i2 > (jTree.isRootVisible() ? 0 : 1); --i2) {
                    String string2 = this.a(jTree, treePath2, n2, true, blArray);
                    if (n2 == 1 && !blArray[0]) {
                        bl3 = true;
                        n2 = 3;
                        break;
                    }
                    if (blArray[0]) {
                        string2 = Misc.quote((String)string2, (String)"\\#@&%/");
                        string2 = Misc.quote((String)string2, (String)"$", (char)'$');
                    }
                    string = "/" + string2 + string;
                    treePath2 = treePath2.getParentPath();
                }
                if (bl3) continue;
                subItemIndexArray[0] = new SubItemIndex(string, n2 == 3 ? 1 : 0);
            }
        } else {
            boolean[] blArray = new boolean[1];
            String string = this.a(jTree, treePath, n2, false, blArray);
            if (blArray[0]) {
                string = Misc.quote((String)string, (String)"\\#@&%/");
                string = Misc.quote((String)string, (String)"$", (char)'$');
            }
            subItemIndexArray[0] = new SubItemIndex(string, blArray[0] ? 0 : 1);
        }
        if (Options.getInt((String)Options.OPT_RECORD_SUBITEM_TYPE, (int)1) == 1) {
            subItemIndexArray[0].setSuggestNode(subItemIndexArray[0].getType() == 0 && !jTree.isPathEditable(treePath));
        }
        return subItemIndexArray;
    }

    @Override
    public int[] getItemLocation(Object object, Object object2) throws BadItemException {
        if (JTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemLocation(Object,Object)", 516).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        JTree jTree = (JTree)object;
        TreePath treePath = (TreePath)object2;
        Rectangle rectangle = jTree.getPathBounds(treePath = this.a(jTree, treePath));
        if (rectangle != null) {
            return new int[]{rectangle.x, rectangle.y};
        }
        BadItemException badItemException = new BadItemException("Cannot get bounds for TreePath " + treePath);
        if (Client.instance().getRetryContext() != null) {
            throw new RetryException((TestException)((Object)badItemException), 50L);
        }
        throw badItemException;
    }

    @Override
    public int[] getItemSize(Object object, Object object2) throws BadItemException {
        if (JTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemSize(Object,Object)", 554).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        JTree jTree = (JTree)object;
        TreePath treePath = (TreePath)object2;
        treePath = this.a(jTree, treePath);
        Rectangle rectangle = jTree.getPathBounds(treePath);
        return new int[]{rectangle.width, rectangle.height};
    }

    @Override
    public Boolean repositionMouseEvent(Object object, Object object2, int[] nArray) throws BadItemException {
        if (JTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "repositionMouseEvent(Object,Object,int[])", 588).addDetail("element", object)).addDetail("item", object2)).addDetail("pos", (Object)nArray)).log();
        }
        this.checkItem(object, object2);
        if (nArray[0] >= 0 && nArray[1] >= 0) {
            if (Client.instance().getOptions().getBoolean("RepositionMiddle", true)) {
                nArray[0] = Integer.MAX_VALUE;
                nArray[1] = Integer.MAX_VALUE;
            } else {
                nArray[0] = Math.min(nArray[0], 1);
                nArray[1] = Math.min(nArray[1], 1);
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean scrollItemVisible(Object object, Object object2, int n2, int n3) throws BadItemException {
        if (JTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "scrollItemVisible(Object,Object,int,int)", 624).addDetail("element", object)).addDetail("item", object2)).addDetail("x", n2)).addDetail("y", n3)).log();
        }
        this.checkItem(object, object2);
        return null;
    }

    @Override
    public int getItemCount(Object object, Object object2) throws BadItemException {
        if (JTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemCount(Object,Object)", 650).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        return 0;
    }

    protected void checkItem(Object object, Object object2) throws BadItemException {
        if (!(object instanceof JTree)) {
            if (JTreeItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "checkItem(Object,Object)", 678).add("Internal error: Not a JTree", object)).log();
            }
            throw new BadItemException("Not a JTree: " + object);
        }
        if (object2 != null && !(object2 instanceof TreePath)) {
            if (JTreeItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "checkItem(Object,Object)", 682).add("Internal error: Not a TreePath", object2)).log();
            }
            throw new BadItemException("Not a TreePath: " + object2);
        }
    }

    private String a(JTree jTree, TreePath treePath, int n2, boolean bl2, boolean[] blArray) {
        if (n2 == 1 && jTree.isPathEditable(treePath)) {
            n2 = 3;
        }
        switch (n2) {
            case 1: {
                int n3 = jTree.getRowForPath(treePath);
                String string = this.a(jTree, n3, true);
                if (string == null) {
                    string = "";
                }
                boolean bl3 = true;
                if (bl2) {
                    if (treePath.getPathCount() == 1) {
                        blArray[0] = true;
                        return string;
                    }
                    Object object = treePath.getParentPath().getLastPathComponent();
                    int n4 = jTree.getModel().getChildCount(object);
                    int n5 = 0;
                    for (int i2 = 0; i2 < n4; ++i2) {
                        Object object2 = jTree.getModel().getChild(object, i2);
                        if (object2 == treePath.getLastPathComponent()) {
                            n5 = i2;
                            continue;
                        }
                        if (!bl3) continue;
                        String string2 = this.a(jTree, treePath.pathByAddingChild(object2), true);
                        if (string2 == null) {
                            string2 = "";
                        }
                        if (!Misc.equalOrNull((Object)string, (Object)string2)) continue;
                        bl3 = false;
                    }
                    blArray[0] = bl3;
                    return bl3 ? string : "" + n5;
                }
                int n6 = jTree.getRowCount();
                for (int i3 = 0; i3 < n6; ++i3) {
                    if (i3 == n3) continue;
                    String string3 = this.a(jTree, i3, true);
                    if (string3 == null) {
                        string3 = "";
                    }
                    if (!Misc.equalOrNull((Object)string, (Object)string3)) continue;
                    bl3 = false;
                    break;
                }
                blArray[0] = bl3;
                return bl3 ? string : "" + n3;
            }
            case 2: {
                blArray[0] = true;
                String string = this.a(jTree, treePath, true);
                return string == null ? "" : string;
            }
            case 3: {
                blArray[0] = false;
                if (bl2) {
                    if (treePath.getPathCount() > 1) {
                        return "" + jTree.getModel().getIndexOfChild(treePath.getParentPath().getLastPathComponent(), treePath.getLastPathComponent());
                    }
                    return "0";
                }
                return "" + jTree.getRowForPath(treePath);
            }
        }
        return "";
    }

    private String a(JTree jTree, int n2, boolean bl2) {
        if (JTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getNodeName(JTree,int,boolean)", 796).addDetail("tree", (Object)jTree)).addDetail("row", n2)).addDetail("useRenderer", bl2)).log();
        }
        return this.a(jTree, jTree.getPathForRow(n2), bl2);
    }

    private String a(JTree jTree, TreePath treePath, boolean bl2) {
        String string = this.b(jTree, treePath, bl2);
        return ItemRegistry.instance().getItemName(jTree, treePath, string);
    }

    private String b(JTree jTree, TreePath treePath, boolean bl2) {
        if (JTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getDefaultNodeName(JTree,TreePath,boolean)", 832).addDetail("tree", (Object)jTree)).addDetail("path", (Object)treePath)).addDetail("useRenderer", bl2)).log();
        }
        Object object = treePath.getLastPathComponent();
        return h.b(jTree, treePath, bl2);
    }

    private String c(JTree jTree, TreePath treePath, boolean bl2) {
        if (JTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getDefaultNodeValue(JTree,TreePath,boolean)", 850).addDetail("tree", (Object)jTree)).addDetail("path", (Object)treePath)).addDetail("useRenderer", bl2)).log();
        }
        Object object = treePath.getLastPathComponent();
        return h.c(jTree, treePath, bl2);
    }

    private TreePath a(JTree jTree, TreePath treePath) {
        if (this.b == jTree && this.c == treePath) {
            if (jTree.getPathBounds(treePath) == null) {
                if (JTreeItemResolver.a.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "validatePath(JTree,TreePath)", 874).add("Path is invalid")).add("path", (Object)treePath)).log();
                }
                treePath = jTree.getPathForRow(this.d);
            } else {
                this.d = jTree.getRowForPath(treePath);
            }
        }
        return treePath;
    }
}

