/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.awt.ui;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.ElementHelper;
import de.qfs.apps.qftest.client.Engine;
import de.qfs.apps.qftest.client.EventLog;
import de.qfs.apps.qftest.client.PrivilegedRunnable;
import de.qfs.apps.qftest.client.awt.data.h;
import de.qfs.apps.qftest.client.awt.data.o;
import de.qfs.apps.qftest.client.awt.s;
import de.qfs.apps.qftest.client.awt.ui.b;
import de.qfs.apps.qftest.client.awt.ui.c;
import de.qfs.apps.qftest.client.awt.ui.d;
import de.qfs.apps.qftest.client.awt.ui.e;
import de.qfs.apps.qftest.client.awt.ui.f;
import de.qfs.apps.qftest.client.awt.ui.g;
import de.qfs.apps.qftest.client.awt.ui.i;
import de.qfs.apps.qftest.client.awt.w;
import de.qfs.apps.qftest.extensions.ResolverRegistry;
import de.qfs.apps.qftest.extensions.checks.CheckerRegistry;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.ExtraFeature;
import de.qfs.apps.qftest.shared.data.ExtraFeatureSet;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.system.Native;
import de.qfs.lib.gui.AWTTreeAdapter;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.tree.ReturnFromTraversalException;
import de.qfs.lib.tree.TreeAdapter;
import de.qfs.lib.tree.TreeUtil;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Pair;
import de.qfs.lib.util.Reflector;
import de.qfs.lib.util.Visitor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.annotation.Nullable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;

public class ComponentHelper
extends ElementHelper {
    private static final QFLogger b = new QFLogger("de.qfs.apps.qftest.client.awt.ui.ComponentHelper");
    private static final String[] c = new String[]{"java.awt.Choice", "java.awt.Menu", "java.awt.MenuBar", "java.awt.PopupMenu", "java.awt.ScrollPane", "javax.swing.JColorChooser", "javax.swing.JComboBox", "javax.swing.JDesktopPane", "javax.swing.JFileChooser", "javax.swing.JInternalFrame", "javax.swing.JMenu", "javax.swing.JMenuBar", "javax.swing.JPopupMenu", "javax.swing.JScrollPane", "javax.swing.JSplitPane", "javax.swing.JTabbedPane", "javax.swing.JToolBar", "mseries.Calendar.MDateSelectorPanel", "Panel:TitledPanel", "de.qfs.apps.qfpdf.ui.Panel"};
    private static Class[] d;
    private static final String[] e;
    private static final Hashtable f;
    private static final String[] g;
    private static ComponentHelper h;
    private i i = new i(this);
    private b j = new b(this);
    private AWTTreeAdapter k = new AWTTreeAdapter();
    private s l;

    private ComponentHelper() {
        this(null);
    }

    public ComponentHelper(s s2) {
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "ComponentHelper(AWTEngine)", 326).addDetail("engine", (Object)s2)).log();
        }
        this.l = s2;
        this.labelFinder = new de.qfs.apps.qftest.client.awt.ui.a(this);
        if (h == null) {
            h = this;
        }
    }

    public static ComponentHelper instance() {
        if (h == null) {
            h = new ComponentHelper();
        }
        return h;
    }

    public static void setAlwaysOnTop(Window window, boolean bl2) {
        if (Misc.IS_JAVA_VERSION_AT_LEAST_8) {
            Object object = Reflector.safeGet((Object)window, (String)"peer", (boolean)true);
            if (object != null) {
                try {
                    Reflector.set((Object)window, (String)"alwaysOnTop", (Object)bl2, (boolean)true);
                    Reflector.call((Object)object, (String)"updateAlwaysOnTopState", (boolean)true);
                }
                catch (Throwable throwable) {
                    if (ComponentHelper.b.level >= 3) {
                        ((LevelAwareLogBuilder)b.lvlBuild(3, "setAlwaysOnTop(Window,boolean)", 379).add("ex", (Object)throwable)).log();
                    }
                }
            }
        } else {
            window.setAlwaysOnTop(bl2);
        }
    }

    public static ComponentHelper helperFor(Object object) {
        s s2 = s.engineFor(object);
        return s2 == null ? null : s2.getHelper();
    }

    public Class getNamedClass(Component component) {
        Component component2 = component;
        return h.getNamedClass((Object)component2);
    }

    public final String getComponentName(Component component) {
        return this.getComponentName(component, true);
    }

    public String getComponentName(Component component, boolean bl2) {
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "getComponentName(Component,boolean)", 455).addDetail("com", (Object)component)).addDetail("checkResolvers", bl2)).log();
        }
        String string = this.safeGetName(component);
        string = Util.getFlatIdentifierText((String)string);
        if (ComponentHelper.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getComponentName(Component,boolean)", 458).add("cname", string)).log();
        }
        String string2 = null;
        if (bl2) {
            string2 = ResolverRegistry.instance().resolveComponentName(component);
            if ("".equals(string2)) {
                if (string != null) {
                    EventLog.instance().a((Object)"CH.getComponentName()", "com:", component, "name '" + string + "' suppressed");
                }
            } else if (string2 != null && string != null && !string2.equals(string)) {
                EventLog.instance().a((Object)"CH.getComponentName()", "com:", component, "name '" + string + "' overridden with '" + string2 + "'");
            }
        }
        if (string2 == null) {
            block18: {
                if (this.isTrivialName(string) && this.isMatchingClass((Object)component, "sun.swing.JLightweightFrame")) {
                    Object object = this.getSwingNode(component);
                    if (ComponentHelper.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "getComponentName(Component,boolean)", 483).add("sn", object)).log();
                    }
                    if (object != null && this.isMatchingClass(object, "javafx.embed.swing.SwingNode")) {
                        try {
                            Object object2 = Reflector.call((Object)object, (String)"getProperties");
                            if (ComponentHelper.b.level >= 9) {
                                ((LevelAwareLogBuilder)b.lvlBuild(9, "getComponentName(Component,boolean)", 489).add("map", object2)).log();
                            }
                            string = (String)Reflector.call((Object)object2, (String)"get", Object.class, (Object)"qfs:name");
                            if (ComponentHelper.b.level >= 9) {
                                ((LevelAwareLogBuilder)b.lvlBuild(9, "getComponentName(Component,boolean)", 491).add("cname", string)).log();
                            }
                        }
                        catch (Throwable throwable) {
                            if (ComponentHelper.b.level < 5) break block18;
                            ((LevelAwareLogBuilder)b.lvlBuild(5, "getComponentName(Component,boolean)", 493).add("ex", (Object)throwable)).log();
                        }
                    }
                }
            }
            string2 = this.isTrivialName(string) ? null : string;
        } else if (string2.length() == 0) {
            string2 = null;
        }
        if (bl2) {
            string2 = ResolverRegistry.instance().resolveName2(component, string2);
        }
        return Util.getFlatIdentifierText((String)string2);
    }

    public Component[] getGlassPanes(Component component) {
        Object[] objectArray;
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getGlassPanes(Component)", 524).addDetail("com", (Object)component)).log();
        }
        if (component == null) {
            return null;
        }
        Vector<Component> vector = null;
        Component component2 = component;
        while ((objectArray = (Object[])SwingUtilities.getAncestorOfClass(JRootPane.class, component2)) != null) {
            if (objectArray.getGlassPane().isVisible()) {
                if (ComponentHelper.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getGlassPanes(Component)", 539).add("Got glass pane: ", (Object)objectArray.getGlassPane())).log();
                }
                if (vector == null) {
                    vector = new Vector<Component>();
                }
                vector.addElement(objectArray.getGlassPane());
            }
            component2 = objectArray.getParent();
        }
        if (vector != null) {
            objectArray = new Component[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public Component getPopupWindowParent(Component component) {
        if (component.getParent() != null && component.getParent().isShowing()) {
            return component.getParent();
        }
        JPopupMenu jPopupMenu = (JPopupMenu)TreeUtil.visitTree((TreeAdapter)this.k, (Object)new a(), (Object)component);
        if (jPopupMenu != null && jPopupMenu.getInvoker() instanceof Window) {
            return jPopupMenu.getInvoker();
        }
        return component.getParent();
    }

    public Class getSystemClass(Class clazz) {
        String string = clazz.getName();
        while (clazz != Object.class) {
            int n2 = string.lastIndexOf(36);
            if (n2 > 0) {
                try {
                    Integer.parseInt(string.substring(n2 + 1));
                    clazz = clazz.getSuperclass();
                    string = clazz.getName();
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string.startsWith("java.") || string.startsWith("javax.swing.")) {
                return clazz;
            }
            clazz = clazz.getSuperclass();
            string = clazz.getName();
        }
        return clazz;
    }

    public Component getToplevelParent(Component component) {
        Component component2 = component;
        while (!this.isToplevel(component2)) {
            if (component2.getParent() == null) {
                for (component2 = component; component2 != null; component2 = component2.getParent()) {
                    if (ComponentHelper.b.level < 9) continue;
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getToplevelParent(Component)", 638).add("parent", (Object)component2)).log();
                }
                return null;
            }
            component2 = component2.getParent();
        }
        return component2;
    }

    public Component getToplevelParent(Component component, Point point) {
        Component component2 = component;
        while (!this.isToplevel(component2)) {
            Component component3;
            if (component2.getParent() == null) {
                for (component2 = component; component2 != null; component2 = component2.getParent()) {
                    if (ComponentHelper.b.level < 9) continue;
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getToplevelParent(Component,Point)", 669).add("parent", (Object)component2)).log();
                }
                return null;
            }
            ElementHelper.Geometry geometry = this.getLogicalLocation(component2);
            point.x += geometry.x;
            point.y += geometry.y;
            if (!component2.getParent().isVisible() && this.isPopupWindow(component2) && (component3 = this.getPopupWindowParent(component2)) != component2.getParent()) {
                Point point2 = component.getLocationOnScreen();
                SwingUtilities.convertPointFromScreen(point2, component3);
                point.x = point2.x;
                point.y = point2.y;
                return component3;
            }
            component2 = component2.getParent();
        }
        return component2;
    }

    public Component isGlassPane(Component component) {
        Object object;
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "isGlassPane(Component)", 706).addDetail("com", (Object)component)).log();
        }
        if (component == null) {
            return null;
        }
        Component component2 = null;
        Component component3 = null;
        if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty("qfs:isGlassPaneFor")) instanceof Component) {
            if (ComponentHelper.b.level >= 5) {
                ((LevelAwareLogBuilder)b.lvlBuild(5, "isGlassPane(Component)", 717).add("isGlassPaneFor override - covered: ", object)).log();
            }
            component2 = component;
            component3 = (Component)object;
        }
        if (component3 == null && this.isMatchingClass((Object)component, "oracle.ewt.event.tracking.GlassMouseGrabProvider$Proxy") && component.getParent() != null && component.getParent().getComponents() != null && component.getParent().getComponents().length > 1) {
            component2 = component;
            component3 = component.getParent().getComponents()[1];
            if (ComponentHelper.b.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "isGlassPane(Component)", 729).add("Oracle glass pane override from ")).add((Object)component)).add(" to target: ")).add((Object)component3)).log();
            }
        }
        if (component3 == null && (object = (JRootPane)SwingUtilities.getAncestorOfClass(JRootPane.class, component)) != null && ((JRootPane)object).getGlassPane().isVisible() && SwingUtilities.isDescendingFrom(component, ((JRootPane)object).getGlassPane())) {
            if (ComponentHelper.b.level >= 5) {
                ((LevelAwareLogBuilder)b.lvlBuild(5, "isGlassPane(Component)", 741).add("found GlassPane for: ", (Object)((JRootPane)object).getLayeredPane())).log();
            }
            component2 = ((JRootPane)object).getGlassPane();
            component3 = ((JRootPane)object).getLayeredPane();
        }
        if (ComponentHelper.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "isGlassPane(Component)", 746).add("target", component3)).log();
        }
        Object object2 = object = component3 == null ? null : ResolverRegistry.instance().isGlassPaneFor(component2, component3);
        if (ComponentHelper.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "isGlassPane(Component)", 749).add("ret", object)).log();
        }
        return object == component ? null : (object instanceof Component ? (Component)object : component3);
    }

    @Override
    public boolean isInterestingParent(Object object) {
        if (!(object instanceof Component)) {
            if (ComponentHelper.b.level >= 3) {
                ((LevelAwareLogBuilder)b.lvlBuild(3, "isInterestingParent(Object)", 768).add("Not a Component:", object)).log();
            }
            return false;
        }
        Component component = (Component)object;
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "isInterestingParent(Object)", 773).addDetail("element", object)).log();
        }
        boolean bl2 = this.getComponentName(component) != null ? true : (this.isPopupWindow(component) ? false : (component.getParent() instanceof JTabbedPane || component.getParent() instanceof JSplitPane ? true : this.isMatchingClass((Object)component, c)));
        return ResolverRegistry.instance().resolveInterestingParent(object, bl2);
    }

    public Component getDeepestMouseListenerAt(Component component, int n2, int n3) {
        if (!component.contains(n2, n3)) {
            return null;
        }
        if (component instanceof Container) {
            try {
                Component component2 = (Component)Reflector.call((Object)component, (String)"getMouseEventTarget", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Boolean.TYPE}, (Object[])new Object[]{n2, n3, Boolean.TRUE}, (boolean)true);
                if (ComponentHelper.b.level >= 9) {
                    if (ComponentHelper.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "getDeepestMouseListenerAt(Component,int,int)", 818).add("ret", (Object)component2)).log();
                    }
                    Component component3 = SwingUtilities.getDeepestComponentAt(component, n2, n3);
                    if (ComponentHelper.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "getDeepestMouseListenerAt(Component,int,int)", 820).add("dret", (Object)component3)).log();
                    }
                }
                return component2;
            }
            catch (Exception exception) {
                if (ComponentHelper.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getDeepestMouseListenerAt(Component,int,int)", 824).add("ex", (Object)exception)).log();
                }
                Component component4 = SwingUtilities.getDeepestComponentAt(component, n2, n3);
                if (ComponentHelper.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getDeepestMouseListenerAt(Component,int,int)", 826).add("ret", (Object)component4)).log();
                }
                return component4;
            }
        }
        return component;
    }

    public boolean isPopupWindow(Component component) {
        String string;
        boolean bl2;
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "isPopupWindow(Component)", 845).addDetail("com", (Object)component)).log();
        }
        if (!(component instanceof Window || component.getParent() == null || component instanceof Frame || component instanceof Dialog)) {
            if (ComponentHelper.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "isPopupWindow(Component)", 850).add("Not a Window or Dialog or Frame")).log();
            }
            return false;
        }
        if (d != null) {
            for (int i2 = 0; i2 < d.length; ++i2) {
                if (!d[i2].isAssignableFrom(component.getClass())) continue;
                if (ComponentHelper.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "isPopupWindow(Component)", 856).add("Matches popup class ", (Object)d[i2])).log();
                }
                return true;
            }
        }
        boolean bl3 = bl2 = "javax.swing.JPopupMenu$WindowPopup".equals(string = component.getClass().getName()) || "javax.swing.DefaultPopupFactory$WindowPopup".equals(string) || "javax.swing.Popup$HeavyWeightWindow".equals(string) || "com.sun.java.swing.plaf.windows.WindowsPopupWindow".equals(string) || "mseries.ui.MPopupWindow".equals(string) || "###overrideRedirect###".equals(this.safeGetName(component));
        if (ComponentHelper.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "isPopupWindow(Component)", 869).add("ret", bl2)).log();
        }
        return bl2;
    }

    public boolean isToplevel(Component component) {
        if (component == null) {
            return false;
        }
        if (ComponentHelper.b.level >= 9 && this.isPopupWindow(component)) {
            if (ComponentHelper.b.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "isToplevel(Component)", 892).add("Popup window: ")).add((Object)component)).add("\n parent: ")).add((Object)component.getParent())).log();
            }
            Component[] componentArray = component.getParent().getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (ComponentHelper.b.level < 9) continue;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "isToplevel(Component)", 896).add("parent's children: ")).add((Object)componentArray[i2])).log();
            }
        }
        return component instanceof Dialog || component instanceof Frame || !this.isPopupWindow(component) && component instanceof Window;
    }

    public Component getInterestingParent(Component component, Point point) {
        Object object;
        int n2;
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "getInterestingParent(Component,Point)", 923).addDetail("com", (Object)component)).addDetail("pos", (Object)point)).log();
        }
        if ((n2 = Options.cached_OPT_RECORD_COMPONENT_HIERARCHY) == 3) {
            return this.getToplevelParent(component, point);
        }
        Component component2 = component.getParent();
        if (ComponentHelper.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getInterestingParent(Component,Point)", 940).add("parent", (Object)component2)).log();
        }
        if ((component2 == null || !component2.isVisible()) && this.isPopupWindow(component)) {
            component2 = this.getPopupWindowParent(component);
        }
        if (component2 == null) {
            if (ComponentHelper.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "getInterestingParent(Component,Point)", 946).add("New parent null, leave.")).log();
            }
            return null;
        }
        Component component3 = null;
        if (component instanceof JMenuItem && !(component2 instanceof JMenuBar) && !(component2 instanceof JMenu)) {
            component3 = ((w)this.getEngine().getTracker()).a(component);
            if (ComponentHelper.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "getInterestingParent(Component,Point)", 955).add("mparent", (Object)component3)).log();
            }
        }
        if (component3 == null || component3 == component2) {
            if (point.x != Integer.MAX_VALUE && point.x != Integer.MIN_VALUE) {
                object = this.getLogicalLocation(component);
                point.x += object.x;
                point.y += object.y;
                if (component instanceof Window) {
                    ElementHelper.Geometry geometry = this.getLogicalLocation(component2);
                    point.x -= geometry.x;
                    point.y -= geometry.y;
                }
            }
        } else {
            component2 = component3;
            if (point.x != Integer.MIN_VALUE) {
                point.x = Integer.MAX_VALUE;
                point.y = Integer.MAX_VALUE;
            }
        }
        if (component2 == null) {
            return null;
        }
        if (n2 == 2 || this.isToplevel(component2) || this.isInterestingParent(component2)) {
            return component2;
        }
        object = this.getInterestingParent(component2, point);
        return object != null ? object : component2;
    }

    public Component correctForScrolledTabs(Component component, Point point) {
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "correctForScrolledTabs(Component,Point)", 1003).addDetail("com", (Object)component)).addDetail("pos", (Object)point)).log();
        }
        Component component2 = null;
        for (Component component3 = component; component3 != null; component3 = component3.getParent()) {
            Object object;
            if (ComponentHelper.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "correctForScrolledTabs(Component,Point)", 1009).add("tmp", (Object)component3)).log();
            }
            if (component2 == null && (object = this.getComponentName(component3)) != null && !"TabClose".equals(object)) {
                component2 = component3;
                if (ComponentHelper.b.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "correctForScrolledTabs(Component,Point)", 1019).add("got named: ", (Object)component2)).add("name: ", this.getComponentName(component2))).log();
                }
            }
            if (!(component3 instanceof JTabbedPane)) continue;
            if (ComponentHelper.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "correctForScrolledTabs(Component,Point)", 1023).add("tmp", (Object)component3)).log();
            }
            if ((object = Reflector.safeCall((Object)component3, (String)"getTabLayoutPolicy")) == null || !object.equals(Reflector.safeGet(JTabbedPane.class, (String)"SCROLL_TAB_LAYOUT"))) break;
            Point point2 = SwingUtilities.convertPoint(component, point, component3);
            if (ComponentHelper.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "correctForScrolledTabs(Component,Point)", 1029).add("pp", (Object)point2)).log();
            }
            if (((JTabbedPane)component3).getUI().tabForCoordinate((JTabbedPane)component3, point2.x, point2.y) < 0) break;
            if (component2 != null && component2 != component3) {
                if (component2 != component) {
                    point2 = SwingUtilities.convertPoint(component, point, component2);
                    if (ComponentHelper.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "correctForScrolledTabs(Component,Point)", 1040).add("pp for named: ", (Object)point2)).log();
                    }
                    point.x = point2.x;
                    point.y = point2.y;
                } else if (ComponentHelper.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "correctForScrolledTabs(Component,Point)", 1044).add("named is com")).log();
                }
                return component2;
            }
            point.x = point2.x;
            point.y = point2.y;
            return component3;
        }
        return component;
    }

    public String safeGetName(Component component) {
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "safeGetName(Component)", 1073).addDetail("com", (Object)component)).log();
        }
        if (!Client.instance().getOptions().getBoolean("AWTSafeGetName", true)) {
            return component.getName();
        }
        return de.qfs.apps.qftest.client.awt.a.instance().getName(component);
    }

    @Override
    public boolean isTrivialName(String string) {
        if (super.isTrivialName(string)) {
            return true;
        }
        if (f.containsKey(string)) {
            return true;
        }
        for (int i2 = 0; i2 < e.length; ++i2) {
            if (!string.startsWith(e[i2])) continue;
            return this.a(string, e[i2]);
        }
        return false;
    }

    @Override
    public List getCheckers(Object object, Object object2) {
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "getCheckers(Object,Object)", 1132).addDetail("element", object)).addDetail("subItem", object2)).log();
        }
        Object[] objectArray = ItemRegistry.instance().getParentAndItem(object);
        if (ComponentHelper.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getCheckers(Object,Object)", 1135).add("parentAndItem", (Object)objectArray)).log();
        }
        if (objectArray != null) {
            Object object3 = Client.instance().getContext(Client.CONTEXT_REPLAY);
            if (ComponentHelper.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "getCheckers(Object,Object)", 1139).add("ctxt", object3)).log();
            }
            if (objectArray[0] instanceof JTabbedPane && object2 == null && object3 == Client.CONTEXT_REPLAY_CHECK) {
                if (ComponentHelper.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getCheckers(Object,Object)", 1145).add("Special case for backward compatibility of tabbed pane and sub-item handling.")).log();
                }
                ArrayList<Pair> arrayList = new ArrayList<Pair>();
                List list = CheckerRegistry.instance().getCheckers(object);
                if (list != null) {
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        arrayList.add(new Pair(list.get(i2), (Object)new Pair(object, object2)));
                    }
                }
                return arrayList;
            }
        }
        return super.getCheckers(object, object2);
    }

    @Override
    protected ElementHelper.a getClassInfo(Object object) {
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getClassInfo(Object)", 1176).addDetail("element", object)).log();
        }
        if (object instanceof JComponent && SwingUtilities.isEventDispatchThread()) {
            Object object2 = ((JComponent)object).getClientProperty("qfs:classnames");
            if (ComponentHelper.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "getClassInfo(Object)", 1182).add("ret", object2)).log();
            }
            if (object2 instanceof ElementHelper.a) {
                return (ElementHelper.a)object2;
            }
            ElementHelper.a a2 = super.getClassInfo(object);
            if (ComponentHelper.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "getClassInfo(Object)", 1187).add("cci", (Object)a2)).log();
            }
            ((JComponent)object).putClientProperty("qfs:classnames", a2);
            return a2;
        }
        return super.getClassInfo(object);
    }

    @Override
    public void invalidateClassInfo(Object object) {
        if (object instanceof JComponent && SwingUtilities.isEventDispatchThread()) {
            ((JComponent)object).putClientProperty("qfs:classnames", null);
        }
        super.invalidateClassInfo(object);
    }

    @Override
    protected void _invalidateClassInfo(Object object) {
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "_invalidateClassInfo(Object)", 1225).addDetail("element", object)).log();
        }
        if (object instanceof JComponent) {
            if (SwingUtilities.isEventDispatchThread()) {
                ((JComponent)object).putClientProperty("qfs:classnames", null);
            } else {
                SwingUtilities.invokeLater(new c(this, object));
            }
        }
        super._invalidateClassInfo(object);
    }

    @Override
    public final Engine getEngine() {
        return this.l != null ? this.l : Engine.threadInstance("awt");
    }

    public final AWTTreeAdapter getAdapter() {
        return this.k;
    }

    @Override
    public String getDefaultName(Object object) {
        if (!(object instanceof Component)) {
            if (ComponentHelper.b.level >= 1) {
                ((LevelAwareLogBuilder)b.lvlBuild(1, "getDefaultName(Object)", 1289).add("Bad element: ", object)).log();
            }
            return null;
        }
        return Util.getFlatIdentifierText((String)this.safeGetName((Component)object));
    }

    @Override
    public String getName(Object object, boolean bl2) {
        if (!(object instanceof Component)) {
            return null;
        }
        return this.getComponentName((Component)object, bl2);
    }

    @Override
    public String getDefaultFeature(Object object) {
        if (!(object instanceof Component)) {
            if (ComponentHelper.b.level >= 1) {
                ((LevelAwareLogBuilder)b.lvlBuild(1, "getDefaultFeature(Object)", 1333).add("Bad element: ", object)).log();
            }
            return null;
        }
        Object object2 = Visitor.safeVisit((Object)this.i, (Object)object);
        if (object2 != null) {
            return Util.getFlatIdentifierText((String)object2.toString());
        }
        return null;
    }

    @Override
    public String getFeature(Object object, boolean bl2) {
        Object object2;
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "getFeature(Object,boolean)", 1359).addDetail("element", object)).addDetail("checkResolvers", bl2)).log();
        }
        if (!(object instanceof Component)) {
            return null;
        }
        String string = null;
        if (bl2) {
            string = ResolverRegistry.instance().getFeature(object);
        }
        if (string == null && (object2 = Visitor.safeVisit((Object)this.i, (Object)object)) != null) {
            string = object2.toString();
        }
        string = Misc.safeTrimToNull((String)string);
        if (bl2) {
            string = Misc.safeTrimToNull((String)ResolverRegistry.instance().getFeature2(object, string));
        }
        return Util.getFlatIdentifierText((String)string);
    }

    @Override
    public Object getParentElement(Object object) {
        if (object instanceof Component) {
            return ((Component)object).getParent();
        }
        if (ComponentHelper.b.level >= 1) {
            ((LevelAwareLogBuilder)b.lvlBuild(1, "getParentElement(Object)", 1399).add("Bad element - not a Component: ", object)).log();
        }
        return null;
    }

    @Override
    public String getImageDescription(Object object) {
        String[] stringArray;
        String string;
        String string2;
        if (!(object instanceof Component)) {
            if (ComponentHelper.b.level >= 5) {
                ((LevelAwareLogBuilder)b.lvlBuild(5, "getImageDescription(Object)", 1410).add("Element is not a swing component!")).log();
            }
            return null;
        }
        Component component = (Component)object;
        Object object2 = Reflector.safeCall((Object)component, (String)"getIcon");
        if (object2 != null && object2 instanceof ImageIcon && (string2 = ((ImageIcon)object2).getDescription()) != null && !Misc.emptyOrNull((String)(string = (stringArray = string2.split("/"))[stringArray.length - 1]))) {
            int n2 = string.indexOf(".");
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
            if (this.isTextValid(string)) {
                if (ComponentHelper.b.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "getImageDescription(Object)", 1429).add("Found icon description: ")).add("fileName", string)).log();
                }
                return string;
            }
        }
        if (ComponentHelper.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getImageDescription(Object)", 1438).add("No icon found.")).log();
        }
        return null;
    }

    @Override
    public boolean isEngineWindowComponent(Object object) {
        return object instanceof Dialog || object instanceof Frame || object instanceof JInternalFrame || object instanceof JFileChooser;
    }

    @Override
    public String getEngineWindowTitle(Object object) {
        if (object instanceof Dialog) {
            return ((Dialog)object).getTitle();
        }
        if (object instanceof Frame) {
            return ((Frame)object).getTitle();
        }
        if (object instanceof JInternalFrame) {
            return ((JInternalFrame)object).getTitle();
        }
        if (object instanceof JFileChooser) {
            return ((JFileChooser)object).getDialogTitle();
        }
        return null;
    }

    @Override
    public String getEnginePanelTitle(Object object) {
        return this.getBorderTitle(object);
    }

    @Override
    public String getTooltipText(Object object, Object object2) {
        if (!this.isTooltipManagerEnabled()) {
            return null;
        }
        return this.getTooltipTextFeature(object, object2);
    }

    @Override
    public String getIdentifierTextForLabel(Object object) {
        if (!(object instanceof JComponent)) {
            return null;
        }
        String string = de.qfs.apps.qftest.client.awt.data.h.a((JComponent)object);
        if (this.isTextValid(string)) {
            if (ComponentHelper.b.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "getIdentifierTextForLabel(Object)", 1518).add("Found best label with html text: ")).add("htmlTxt", string)).log();
            }
            return string;
        }
        return this.getIdentifierText(object);
    }

    public String getTooltipTextFeature(Object object, Object object2) {
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "getTooltipTextFeature(Object,Object)", 1537).addDetail("element", object)).addDetail("subElement", object2)).log();
        }
        try {
            if (object instanceof JComponent) {
                JComponent jComponent = (JComponent)object;
                if (object2 != null) {
                    if (object instanceof JTree && object2 instanceof TreePath) {
                        Object object3 = ((TreePath)object2).getLastPathComponent();
                        if (ComponentHelper.b.level >= 9) {
                            ((LevelAwareLogBuilder)b.lvlBuild(9, "getTooltipTextFeature(Object,Object)", 1548).add("node", object3)).log();
                        }
                        Component component = ((JTree)object).getCellRenderer().getTreeCellRendererComponent((JTree)object, object3, false, false, ((JTree)object).getModel().isLeaf(object3), 0, false);
                        if (ComponentHelper.b.level >= 9) {
                            ((LevelAwareLogBuilder)b.lvlBuild(9, "getTooltipTextFeature(Object,Object)", 1554).add("com", (Object)component)).log();
                        }
                        if (component instanceof JComponent) {
                            return this.a((JComponent)component);
                        }
                    } else if (object instanceof JTable) {
                        JTable jTable = (JTable)object;
                        int n2 = ((int[])object2)[0];
                        int n3 = ((int[])object2)[1];
                        if (n3 >= 0) {
                            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n3, n2);
                            Component component = jTable.prepareRenderer(tableCellRenderer, n3, n2);
                            if (component instanceof JComponent) {
                                return this.a((JComponent)component);
                            }
                        } else {
                            TableColumn tableColumn = de.qfs.apps.qftest.client.awt.data.h.a(jTable, n2, true);
                            if (ComponentHelper.b.level >= 9) {
                                ((LevelAwareLogBuilder)b.lvlBuild(9, "getTooltipTextFeature(Object,Object)", 1573).add("column", (Object)tableColumn)).log();
                            }
                            if (tableColumn == null) {
                                return null;
                            }
                            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                            if (tableCellRenderer == null) {
                                tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
                            }
                            if (ComponentHelper.b.level >= 9) {
                                ((LevelAwareLogBuilder)b.lvlBuild(9, "getTooltipTextFeature(Object,Object)", 1581).add("renderer", (Object)tableCellRenderer)).log();
                            }
                            if (tableCellRenderer != null) {
                                Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, -1, n2);
                                if (ComponentHelper.b.level >= 9) {
                                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getTooltipTextFeature(Object,Object)", 1586).add("cellObj", (Object)component)).log();
                                }
                                if (component instanceof JComponent) {
                                    return this.a((JComponent)component);
                                }
                            }
                        }
                    } else if (object instanceof JTableHeader) {
                        TableColumn tableColumn;
                        JTableHeader jTableHeader = (JTableHeader)object;
                        int n4 = (Integer)object2;
                        TableColumn tableColumn2 = tableColumn = jTableHeader.getTable() == null ? jTableHeader.getColumnModel().getColumn(n4) : de.qfs.apps.qftest.client.awt.data.h.a(jTableHeader.getTable(), n4, true);
                        if (ComponentHelper.b.level >= 9) {
                            ((LevelAwareLogBuilder)b.lvlBuild(9, "getTooltipTextFeature(Object,Object)", 1599).add("column", (Object)tableColumn)).log();
                        }
                        if (tableColumn == null) {
                            return null;
                        }
                        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                        if (ComponentHelper.b.level >= 9) {
                            ((LevelAwareLogBuilder)b.lvlBuild(9, "getTooltipTextFeature(Object,Object)", 1604).add("renderer", (Object)tableCellRenderer)).log();
                        }
                        if (tableCellRenderer == null) {
                            tableCellRenderer = jTableHeader.getDefaultRenderer();
                        }
                        if (tableCellRenderer != null) {
                            Component component = tableCellRenderer.getTableCellRendererComponent(jTableHeader.getTable(), tableColumn.getHeaderValue(), false, false, -1, n4);
                            if (ComponentHelper.b.level >= 9) {
                                ((LevelAwareLogBuilder)b.lvlBuild(9, "getTooltipTextFeature(Object,Object)", 1612).add("cellObj", (Object)component)).log();
                            }
                            if (component instanceof JComponent) {
                                return this.a((JComponent)component);
                            }
                        }
                    } else if (object instanceof JTabbedPane) {
                        int n5 = (Integer)object2;
                        return this.a((JTabbedPane)object, n5);
                    }
                    return null;
                }
                return this.a(jComponent);
            }
            if (ComponentHelper.b.level >= 5) {
                ((LevelAwareLogBuilder)b.lvlBuild(5, "getTooltipTextFeature(Object,Object)", 1626).add("Not a swing component!")).log();
            }
            return ResolverRegistry.instance().resolveTooltip(object, this.getClassNames(object), null);
        }
        catch (Throwable throwable) {
            if (ComponentHelper.b.level >= 5) {
                ((LevelAwareLogBuilder)b.lvlBuild(5, "getTooltipTextFeature(Object,Object)", 1631).add("t", (Object)throwable)).log();
            }
            return null;
        }
    }

    private String a(JComponent jComponent) {
        if (jComponent == null) {
            throw new IllegalArgumentException("swingEle is marked non-null but is null");
        }
        String string = jComponent.getToolTipText();
        return ResolverRegistry.instance().resolveTooltip((Object)jComponent, this.getClassNames(jComponent), string);
    }

    private String a(JTabbedPane jTabbedPane, int n2) {
        if (jTabbedPane == null) {
            throw new IllegalArgumentException("tabbedPane is marked non-null but is null");
        }
        String string = jTabbedPane.getToolTipTextAt(n2);
        return string;
    }

    protected boolean isTooltipManagerEnabled() {
        if (!Options.cached_OPT_PLAY_QUERY_TOOLTIP_MANAGER_ENABLED_STATE) {
            return true;
        }
        return ToolTipManager.sharedInstance().isEnabled();
    }

    @Override
    public boolean isToplevel(Object object) {
        return object instanceof Component && this.isToplevel((Component)object);
    }

    @Override
    public boolean isModal(Object object) {
        return object instanceof Dialog && ((Dialog)object).isModal();
    }

    @Override
    public boolean isVisible(Object object) {
        if (!(object instanceof Component)) {
            if (ComponentHelper.b.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(3, "isVisible(Object)", 1722).add("Element is not a component")).add("element", object)).log();
            }
            return false;
        }
        return ((Component)object).isShowing();
    }

    @Override
    protected boolean isHierarchyInvisible(Object object, boolean bl2) {
        boolean bl3;
        if (!bl2 && object instanceof Component) {
            bl3 = !((Component)object).isVisible();
        } else {
            boolean bl4 = bl3 = !this.isVisible(object);
        }
        if (bl3 && ComponentHelper.b.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "isHierarchyInvisible(Object,boolean)", 1750).add("invisible hierarchy: ")).add(object)).log();
        }
        return bl3;
    }

    @Override
    public boolean isEnabled(Object object) {
        boolean bl2 = !(object instanceof Component) || ((Component)object).isEnabled();
        return ResolverRegistry.instance().resolveEnabled(object, bl2);
    }

    @Override
    public Class getElementClass(Object object, boolean bl2) {
        String string;
        boolean bl3;
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "getElementClass(Object,boolean)", 1790).addDetail("com", object)).addDetail("forceCustom", bl2)).log();
        }
        boolean bl4 = Options.cached_OPT_RECORD_COMPONENT_PLAF_INDEPENDENT;
        if (ComponentHelper.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getElementClass(Object,boolean)", 1793).add("noPlaf", bl4)).log();
        }
        boolean bl5 = bl3 = !bl2 && Options.cached_OPT_RECORD_COMPONENT_SYSTEM_CLASS_ONLY;
        if (ComponentHelper.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getElementClass(Object,boolean)", 1798).add("noCustom", bl3)).log();
        }
        Class<Object> clazz = null;
        if (!bl4 && !bl3 || !(object instanceof Component)) {
            clazz = this.getNamedClass(object);
        } else {
            clazz = object.getClass();
            if (object instanceof BasicArrowButton && ((BasicArrowButton)object).getParent() instanceof JComboBox) {
                clazz = JButton.class;
            }
            if (this.isPopupWindow((Component)object)) {
                clazz = JWindow.class;
            }
            while (clazz != Component.class) {
                int n2;
                string = clazz.getName();
                if (ComponentHelper.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getElementClass(Object,boolean)", 1823).add("clazz", string)).log();
                }
                if ((n2 = string.lastIndexOf(36)) < 0) break;
                try {
                    Integer.parseInt(string.substring(n2 + 1));
                    clazz = clazz.getSuperclass();
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
            }
            while (clazz != Component.class) {
                string = clazz.getName();
                if (ComponentHelper.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getElementClass(Object,boolean)", 1838).add("clazz", string)).log();
                }
                if (!(string.startsWith("javax.swing.plaf.") && !string.startsWith("javax.swing.plaf.basic.") || string.startsWith("com.sun.java.swing.plaf.") && !string.startsWith("com.sun.java.swing.plaf.basic.") || bl3 && !string.startsWith("javax.swing.") && !string.startsWith("java.awt.") || "javax.swing.plaf.basic.BasicComboBoxEditor$BorderlessTextField".equals(string) || "javax.swing.plaf.basic.BasicOptionPaneUI$MultiplexingTextField".equals(string)) && !"javax.swing.plaf.basic.BasicOptionPaneUI$ButtonFactory$ConstrainedButton".equals(string)) break;
                clazz = clazz.getSuperclass();
            }
        }
        if (ComponentHelper.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getElementClass(Object,boolean)", 1863).add("default comClass: ", clazz)).log();
        }
        if (!bl2 && (string = ResolverRegistry.instance().getClassName(object, clazz.getName())) != null) {
            Class<Object> clazz2 = clazz;
            while (true) {
                if (string.equals(clazz2.getName())) {
                    clazz = clazz2;
                    if (ComponentHelper.b.level < 9) break;
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getElementClass(Object,boolean)", 1871).add("Resolved comClass: ", clazz)).log();
                    break;
                }
                if ("java.lang.Object".equals(clazz2.getName())) break;
                clazz2 = clazz2.getSuperclass();
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compareFeature(String string, boolean bl2, Object object) {
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "compareFeature(String,boolean,Object)", 1899).addDetail("feature", string)).addDetail("isRegexp", bl2)).addDetail("element", object)).log();
        }
        b b2 = this.j;
        synchronized (b2) {
            return this.j.a(string, bl2, object);
        }
    }

    @Override
    public Boolean matchExtraFeature(Object object, ExtraFeature extraFeature) {
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "matchExtraFeature(Object,ExtraFeature)", 1920).addDetail("element", object)).addDetail("feature", (Object)extraFeature)).log();
        }
        return ResolverRegistry.instance().matchExtraFeature(object, extraFeature);
    }

    @Override
    public String suggestName(Object object, String string, String string2, ExtraFeatureSet extraFeatureSet) {
        String string3;
        if (object instanceof Component && !Misc.emptyOrNull((String)(string3 = o.a((Component)object)))) {
            if (ComponentHelper.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "suggestName(Object,String,String,ExtraFeatureSet)", 1943).add("name", string3)).log();
            }
            return string3;
        }
        return super.suggestName(object, string, string2, extraFeatureSet);
    }

    @Override
    public boolean isDescendingFrom(Object object, Object object2) {
        return object instanceof Component && object2 instanceof Component && SwingUtilities.isDescendingFrom((Component)object, (Component)object2);
    }

    @Override
    public Object withEvents(Runnable runnable) throws InvocationTargetException {
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "withEvents(Runnable)", 1988).addDetail("runnable", (Object)runnable)).log();
        }
        PrivilegedRunnable privilegedRunnable = PrivilegedRunnable.asPrivilegedRunnable(runnable);
        SwingUtil.withEvents((SwingUtil.UnsafeRunnable)new d(this, privilegedRunnable), (int)0, (int)0);
        if (privilegedRunnable.getException() != null) {
            throw new InvocationTargetException(privilegedRunnable.getException());
        }
        return privilegedRunnable.getReturnValue();
    }

    @Override
    public Object getLabelFor(Object object) {
        JLabel jLabel;
        JLabel jLabel2 = jLabel = object instanceof Component ? ((w)this.getEngine().getTracker()).b((Component)object) : null;
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getLabelFor(Object)", 2020).addDetail("element", object)).log();
        }
        return jLabel;
    }

    @Override
    public boolean raiseWindow(Object object) {
        Object object2;
        boolean bl2;
        Window window;
        Engine engine;
        block30: {
            if (ComponentHelper.b.level >= 7) {
                ((LevelAwareLogBuilder)b.lvlBuild(7, "raiseWindow(Object)", 2039).addDetail("element", object)).log();
            }
            if (!(object instanceof Component)) {
                if (ComponentHelper.b.level >= 3) {
                    ((LevelAwareLogBuilder)b.lvlBuild(3, "raiseWindow(Object)", 2041).add("Not a Component: ", object)).log();
                }
                return true;
            }
            Component component = (Component)object;
            if (!Options.cached_OPT_PLAY_RAISE_SUT_WINDOWS) {
                if (ComponentHelper.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "raiseWindow(Object)", 2046).add("Option inactive, nothing to do")).log();
                }
                return true;
            }
            engine = this.getEngine();
            if (engine == null) {
                if (ComponentHelper.b.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(3, "raiseWindow(Object)", 2052).add("No engine for helper ", (Object)this)).add("element: ")).add(object)).dumpStack();
                }
                if ((engine = Engine.engineFor(object)) == null) {
                    if (ComponentHelper.b.level >= 3) {
                        ((LevelAwareLogBuilder)b.lvlBuild(3, "raiseWindow(Object)", 2055).add("No engine for element: ", object)).dumpStack();
                    }
                    return true;
                }
            }
            if (engine.getTracker() == null) {
                if (ComponentHelper.b.level >= 3) {
                    ((LevelAwareLogBuilder)b.lvlBuild(3, "raiseWindow(Object)", 2060).add("No tracker for engine ", (Object)engine)).dumpStack();
                }
                return true;
            }
            Component component2 = ((w)engine.getTracker()).e(component);
            if (ComponentHelper.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "raiseWindow(Object)", 2064).add("cwin from tracker: ", (Object)component2)).log();
            }
            if (!(component2 instanceof Window)) {
                component2 = this.getToplevelParent(component);
                if (ComponentHelper.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "raiseWindow(Object)", 2067).add("cwin parent: ", (Object)component2)).log();
                }
            }
            if (!(component2 instanceof Window)) {
                if (ComponentHelper.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "raiseWindow(Object)", 2070).add("Not a Window:", (Object)component2)).log();
                }
                return true;
            }
            window = (Window)component2;
            boolean bl3 = Client.instance().getOptions().getBoolean("RestoreOnRaise", true);
            bl2 = Options.cached_OPT_PLAY_RAISE_SUT_WINDOWS_FORCED;
            if (this.notifyRaiseWindow("window", window, "restoreOnRaise", bl3, "forcedRaise", bl2)) {
                if (ComponentHelper.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "raiseWindow(Object)", 2078).add("Notification Observer prevents further raising")).log();
                }
                return true;
            }
            if (window instanceof Frame && bl3) {
                SwingUtil.invokeAndWait((Runnable)new e(this, window));
            }
            if (this.isMatchingClass((Object)window, "sun.swing.JLightweightFrame")) {
                Object object3 = this.getSwingNode(window);
                if (ComponentHelper.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "raiseWindow(Object)", 2097).add("sn", object3)).log();
                }
                if (object3 != null) {
                    Engine engine2 = Engine.threadInstance("fx");
                    if (ComponentHelper.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "raiseWindow(Object)", 2100).add("fxEngine", (Object)engine2)).log();
                    }
                    if (engine2 != null) {
                        engine2.safeInvokeNow(new f(this, engine2, object3), new Class[0]);
                    }
                }
                return window.isFocused();
            }
            if (Misc.OS_IS_WINDOWS && bl2 && Options.cached_OPT_PLAY_FORCED_RAISE_WITH_CONTROL) {
                try {
                    object2 = this.getNativeHandle(window);
                    if (ComponentHelper.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "raiseWindow(Object)", 2125).add("hwnd", object2)).log();
                    }
                    if ((Long)object2 != 0L) {
                        int n2 = Options.cached_OPT_PLAY_DELAY_AFTER_RAISE_WITH_CONTROL;
                        if (ComponentHelper.b.level >= 9) {
                            ((LevelAwareLogBuilder)b.lvlBuild(9, "raiseWindow(Object)", 2128).add("delay", n2)).log();
                        }
                        Native.instance().setForegroundWindow(((Long)object2).longValue(), null, (long)n2);
                        return window.isFocused();
                    }
                }
                catch (Throwable throwable) {
                    if (ComponentHelper.b.level < 3) break block30;
                    ((LevelAwareLogBuilder)b.lvlBuild(3, "raiseWindow(Object)", 2133).add("ex", (Object)throwable)).log();
                }
            }
        }
        object2 = engine;
        SwingUtil.invokeAndWait((Runnable)new g(this, window, bl2, (Engine)object2));
        return window.isFocused();
    }

    @Override
    public long getNativeHandle(@Nullable Object object) {
        if (!(object instanceof Container)) {
            if (ComponentHelper.b.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(5, "getNativeHandle(Object)", 2211).add("No container")).add("window", object)).log();
            }
            return 0L;
        }
        try {
            return SwingUtil.getWindowHandle((Component)((Container)object));
        }
        catch (Throwable throwable) {
            if (ComponentHelper.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "getNativeHandle(Object)", 2217).add("ex", (Object)throwable)).log();
            }
            return 0L;
        }
    }

    @Override
    public boolean isFocused(Object object) {
        if (!(object instanceof Component)) {
            if (ComponentHelper.b.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(5, "isFocused(Object)", 2228).add("No Component")).add("widget", object)).log();
            }
            return false;
        }
        Component component = (Component)object;
        return component.hasFocus();
    }

    @Override
    public void setFocused(Object object) {
        if (!(object instanceof JComponent)) {
            if (ComponentHelper.b.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(5, "setFocused(Object)", 2242).add("No JComponent")).add("widget", object)).log();
            }
            return;
        }
        JComponent jComponent = (JComponent)object;
        jComponent.grabFocus();
    }

    @Override
    public ElementHelper.Geometry getLocation(Object object) {
        if (object instanceof Component) {
            ElementHelper.Geometry geometry = new ElementHelper.Geometry();
            geometry.hasLocation = true;
            Point point = ((Component)object).getLocation();
            geometry.x = point.x;
            geometry.y = point.y;
            return geometry;
        }
        return null;
    }

    @Override
    public ElementHelper.Geometry getLocationOnScreen(Object object) {
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getLocationOnScreen(Object)", 2293).addDetail("element", object)).log();
        }
        if (object instanceof Component) {
            ElementHelper.Geometry geometry = new ElementHelper.Geometry();
            geometry.hasLocation = true;
            Point point = new Point();
            SwingUtilities.convertPointToScreen(point, (Component)object);
            geometry.x = point.x;
            geometry.y = point.y;
            return geometry;
        }
        return null;
    }

    @Override
    public ElementHelper.Geometry getLocationInParent(Object object, Object object2) {
        if (object instanceof Component) {
            ElementHelper.Geometry geometry = new ElementHelper.Geometry();
            geometry.hasLocation = true;
            for (Component component = (Component)object; component != null; component = component.getParent()) {
                if (component == object2) {
                    return geometry;
                }
                Point point = component.getLocation();
                geometry.x += point.x;
                geometry.y += point.y;
                if (!(component instanceof Window) || component.getParent() == null) continue;
                point = component.getParent().getLocation();
                geometry.x -= point.x;
                geometry.y -= point.y;
            }
        }
        return null;
    }

    @Override
    public ElementHelper.Geometry getSize(Object object) {
        if (object instanceof Component) {
            ElementHelper.Geometry geometry = new ElementHelper.Geometry();
            geometry.hasSize = true;
            Dimension dimension = ((Component)object).getSize();
            geometry.width = dimension.width;
            geometry.height = dimension.height;
            return geometry;
        }
        return null;
    }

    @Override
    public ElementHelper.Geometry getGeometry(Object object) {
        if (object instanceof Component) {
            ElementHelper.Geometry geometry = new ElementHelper.Geometry();
            geometry.hasLocation = true;
            geometry.hasSize = true;
            Point point = ((Component)object).getLocation();
            geometry.x = point.x;
            geometry.y = point.y;
            Dimension dimension = ((Component)object).getSize();
            geometry.width = dimension.width;
            geometry.height = dimension.height;
            return geometry;
        }
        return null;
    }

    @Override
    @Nullable
    public ElementHelper.Geometry getGeometryOfContainedText(Object object) {
        int n2;
        int n3;
        if (!(object instanceof JLabel)) {
            return null;
        }
        JLabel jLabel = (JLabel)object;
        Rectangle rectangle = new Rectangle();
        Insets insets = jLabel.getInsets(null);
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = jLabel.getWidth() - (insets.left + insets.right);
        rectangle.height = jLabel.getHeight() - (insets.top + insets.bottom);
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        SwingUtilities.layoutCompoundLabel(jLabel, jLabel.getFontMetrics(jLabel.getFont()), jLabel.getText(), jLabel.getIcon(), jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, jLabel.getIconTextGap());
        if (rectangle3.x < 0) {
            rectangle3.width += rectangle3.x;
            rectangle3.x = 0;
        }
        if ((n3 = rectangle3.x + rectangle3.width - jLabel.getWidth()) > 0) {
            rectangle3.width -= n3;
        }
        if (rectangle3.y < 0) {
            rectangle3.height += rectangle3.y;
            rectangle3.y = 0;
        }
        if ((n2 = rectangle3.y + rectangle3.height - jLabel.getHeight()) > 0) {
            rectangle3.height -= n2;
        }
        if (rectangle3.width > 0 && rectangle3.height > 0) {
            return ElementHelper.Geometry.geometry(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
        return null;
    }

    @Override
    public boolean isSystemClass(String string) {
        return string.startsWith("java.") || string.startsWith("javax.swing.");
    }

    protected String getTextBase(Object object) {
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getTextBase(Object)", 2481).addDetail("element", object)).log();
        }
        String string = null;
        if (object instanceof Dialog) {
            string = ((Dialog)object).getTitle();
        } else if (object instanceof Frame) {
            string = ((Frame)object).getTitle();
        } else {
            Object object2 = Reflector.safeCall((Object)object, (String)"getText", (boolean)true);
            if (object2 instanceof String) {
                string = (String)object2;
            }
            if (Misc.emptyOrNull((String)string) && object instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)object;
                int n2 = jComboBox.getSelectedIndex();
                if (n2 >= 0) {
                    try {
                        string = ItemRegistry.instance().getItemValue(jComboBox, n2);
                    }
                    catch (BadItemException badItemException) {
                        if (ComponentHelper.b.level >= 1) {
                            ((LevelAwareLogBuilder)b.lvlBuild(1, "getTextBase(Object)", 2503).add("ex", (Object)badItemException)).log();
                        }
                    }
                } else {
                    Object object3 = jComboBox.getSelectedItem();
                    if (object3 != null) {
                        string = object3.toString();
                    }
                }
            }
            if (Misc.emptyOrNull((String)string)) {
                if (ComponentHelper.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getTextBase(Object)", 2514).add("No standard text, try to build text from children.")).log();
                }
                if (object instanceof Container) {
                    int n3 = ((Container)object).getComponentCount();
                    if (n3 > 0) {
                        if (ComponentHelper.b.level >= 9) {
                            ((LevelAwareLogBuilder)b.lvlBuild(9, "getTextBase(Object)", 2518).add("Children found -> build text.")).log();
                        }
                        double d2 = -1.0;
                        StringBuffer stringBuffer = new StringBuffer("");
                        for (int i2 = 0; i2 < n3; ++i2) {
                            Component component = ((Container)object).getComponent(i2);
                            if (component == null || !this.isVisible(component)) continue;
                            double d3 = component.getLocation().getY();
                            String string2 = this.getTextBase(component);
                            if (Misc.emptyOrNull((String)string2)) continue;
                            if (d2 != -1.0) {
                                if (d2 < d3) {
                                    stringBuffer.append("\n");
                                } else {
                                    stringBuffer.append(" ");
                                }
                            }
                            stringBuffer.append(string2);
                            d2 = d3;
                        }
                        return stringBuffer.toString();
                    }
                    if (ComponentHelper.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "getTextBase(Object)", 2548).add("No children -> no text.")).log();
                    }
                }
            }
        }
        return string;
    }

    @Override
    protected String getMainTextBase(Object object) {
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getMainTextBase(Object)", 2570).addDetail("element", object)).log();
        }
        return this.singleLine(this.getTextBase(object));
    }

    @Override
    protected String getWholeTextBase(Object object) {
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getWholeTextBase(Object)", 2589).addDetail("element", object)).log();
        }
        return this.getTextBase(object);
    }

    public String getBorderTitle(Object object) {
        TitledBorder titledBorder;
        if (ComponentHelper.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getBorderTitle(Object)", 2610).addDetail("component", object)).log();
        }
        if (!(object instanceof JComponent)) {
            return null;
        }
        Border border = ((JComponent)object).getBorder();
        if (border != null && (titledBorder = this.a(border)) != null) {
            return titledBorder.getTitle();
        }
        return null;
    }

    @Override
    public boolean hasTabPanelParent(Object object) {
        Object object2 = this.getParentElement(object);
        if (object2 instanceof JTabbedPane) {
            return true;
        }
        return super.hasTabPanelParent(object);
    }

    @Override
    public boolean hasSplitPanelParent(Object object) {
        Object object2 = this.getParentElement(object);
        if (object2 instanceof JSplitPane) {
            return true;
        }
        return super.hasSplitPanelParent(object);
    }

    public String getTabParentFeature(Component component) {
        Container container = component.getParent();
        if (container instanceof JTabbedPane) {
            int n2 = ((JTabbedPane)container).getTabCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (((JTabbedPane)container).getComponentAt(i2) != component) continue;
                return "Tab: " + de.qfs.apps.qftest.client.awt.data.h.a((JTabbedPane)container, i2);
            }
        }
        return super.getTabParentFeature(component);
    }

    public String getSplitPaneParentFeature(Component component) {
        Container container = component.getParent();
        if (container instanceof JSplitPane) {
            if (component == ((JSplitPane)container).getLeftComponent()) {
                return "Split: Left";
            }
            if (component == ((JSplitPane)container).getRightComponent()) {
                return "Split: Right";
            }
        }
        return super.getSplitPaneParentFeature(component);
    }

    public Object getSwingNode(Object object) {
        Object object2 = Reflector.safeGet((Object)object, (String)"content", (boolean)true);
        if (ComponentHelper.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getSwingNode(Object)", 2733).add("content", object2)).log();
        }
        if (object2 != null) {
            Object object3;
            Object object4 = Reflector.safeGet((Object)object2, (String)"this$0", (boolean)true);
            if (ComponentHelper.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "getSwingNode(Object)", 2736).add("sn", object4)).log();
            }
            if (object4 == null) {
                Object object5 = Reflector.safeGet((Object)object2, (String)"swingNodeRef", (boolean)true);
                if (object5 instanceof WeakReference) {
                    object4 = ((WeakReference)object5).get();
                    if (ComponentHelper.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "getSwingNode(Object)", 2742).add("sn from WeakReference", object4)).log();
                    }
                }
            } else if (Misc.IS_JAVA_VERSION_AT_LEAST_11 && (object3 = Reflector.safeGet((Object)object4, (String)"swingNodeRef", (boolean)true)) instanceof WeakReference) {
                object4 = ((WeakReference)object3).get();
                if (ComponentHelper.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getSwingNode(Object)", 2748).add("sn from WeakReference", object4)).log();
                }
            }
            if (this.isMatchingClass(object4, "javafx.embed.swing.SwingNode")) {
                return object4;
            }
        }
        return null;
    }

    private boolean a(String string, String string2) {
        if (!string.startsWith(string2)) {
            return false;
        }
        try {
            int n2 = Integer.parseInt(string.substring(string2.length()));
            return string.equals(string2 + n2);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static void d() {
        Vector vector = new Vector();
        String[] stringArray = new String[]{"javax.swing.DefaultPopupFactory$WindowPopup", "javax.swing.Popup$HeavyWeightWindow", "com.sun.java.swing.plaf.windows.WindowsPopupWindow", "javax.swing.JPopupMenu$WindowPopup"};
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                Class<?> clazz = Class.forName(stringArray[i2]);
                vector.addElement(clazz);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (vector.size() > 0) {
            d = new Class[vector.size()];
            vector.copyInto(d);
        }
    }

    private TitledBorder a(Border border) {
        if (border instanceof TitledBorder) {
            return (TitledBorder)border;
        }
        if (border instanceof CompoundBorder) {
            TitledBorder titledBorder = this.a(((CompoundBorder)border).getInsideBorder());
            if (titledBorder != null) {
                return titledBorder;
            }
            return this.a(((CompoundBorder)border).getOutsideBorder());
        }
        return null;
    }

    static /* synthetic */ void b() {
        ComponentHelper.bringApplicationToFront();
    }

    static /* synthetic */ QFLogger c() {
        return b;
    }

    static {
        e = new String[]{"button", "canvas", "checkbox", "choice", "dialog", "filedlg", "frame", "label", "list", "menu", "menubar", "menuitem", "panel", "popup", "scrollbar", "scrollpane", "textfield", "text", "win", "VButton", "VCheckbox", "VComboBox", "VPopList", "VRadioButton", "VTextArea", "VTextField"};
        f = new Hashtable();
        g = new String[]{"###focusableSwingPopup###", "###overrideRedirect###", "ColorChooser.panel", "ColorChooser.previewPanelHolder", "ColorChooser.tabPane", "ComboBox.arrowButton", "ComboBox.list", "ComboBox.listRenderer", "ComboBox.renderer", "ComboBox.rendererx", "ComboBox.scrollPane", "ComboBox.textField", "ComboPopup.popup", "GTKColorChooserPanel.colorWell", "GTKColorChooserPanel.lastColorWell", "GTKColorChooserPanel.triangle", "GTKFileChooser.accessoryPanel", "GTKFileChooser.bottomButtonPanel", "GTKFileChooser.centerPanel", "GTKFileChooser.deleteFileButton", "GTKFileChooser.directoryComboBox", "GTKFileChooser.directoryComboBoxPanel", "GTKFileChooser.directoryList", "GTKFileChooser.directoryListLabel", "GTKFileChooser.directoryListPanel", "GTKFileChooser.directoryListScrollPane", "GTKFileChooser.fileList", "GTKFileChooser.fileListLabel", "GTKFileChooser.fileListPanel", "GTKFileChooser.fileListScrollPane", "GTKFileChooser.fileNameTextField", "GTKFileChooser.filterLabel", "GTKFileChooser.interiorPanel", "GTKFileChooser.newFolderButton", "GTKFileChooser.pathField", "GTKFileChooser.pathFieldLabel", "GTKFileChooser.renameFileButton", "GTKFileChooser.splitPanel", "GTKFileChooser.topButtonPanel", "InternalFrame.northPane", "InternalFrameTitlePane.closeButton", "InternalFrameTitlePane.iconifyButton", "InternalFrameTitlePane.maximizeButton", "InternalFrameTitlePane.menuButton", "OptionPane.body", "OptionPane.break", "OptionPane.button", "OptionPane.buttonArea", "OptionPane.comboBox", "OptionPane.iconLabel", "OptionPane.label", "OptionPane.list", "OptionPane.messageArea", "OptionPane.realBody", "OptionPane.scrollPane", "OptionPane.separator", "OptionPane.textField", "OptionPane.verticalBox", "ScrollBar.button", "Slider.label", "Spinner.editor", "Spinner.formattedTextField", "Spinner.nextButton", "Spinner.previousButton", "SplitPaneDivider.leftOneTouchButton", "SplitPaneDivider.rightOneTouchButton", "SynthFileChooser.approveButton", "SynthFileChooser.cancelButton", "TabbedPane.scrollableViewport", "Table.editor", "TableHeader.renderer", "ToolBar.FloatingFrame", "ToolBar.FloatingWindow", "Tree.cellEditor", "Tree.cellRenderer", "null.contentPane", "null.layeredPane", "null.glassPane"};
        ComponentHelper.d();
        for (int i2 = 0; i2 < g.length; ++i2) {
            f.put(g[i2], Boolean.TRUE);
        }
        Reflector.openModule((String)"java.desktop", (String)"sun.awt", ComponentHelper.class);
    }

    public static class a {
        public void visit(Object object) {
            if (object instanceof JPopupMenu) {
                throw new ReturnFromTraversalException(object);
            }
        }
    }
}

