/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.bweb.os.win32;

import com.sun.jna.platform.win32.WinReg;
import de.qfs.apps.qftest.client.bweb.os.win32.Advapi32Util;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import org.openqa.selenium.Proxy;

public class WindowsProxySettings
implements Cloneable {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.client.bweb.os.win32.WindowsProxySettings");
    public static final String BASEKEY = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
    public static final String CONNECTIONS_BASEKEY = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Connections";
    private static final String AUTOCONFIG_URL_VALUENAME = "AutoConfigURL";
    private static final String PROXY_ENABLE_VALUENAME = "ProxyEnable";
    private static final String PROXY_SERVER_VALUENAME = "ProxyServer";
    private static final String PROXY_OVERRIDE_VALUENAME = "ProxyOverride";
    private static final String SETTINGS_VALUENAME = "DefaultConnectionSettings";
    private static final int MANUAL_BIT_VAL = 2;
    private static final int AUTOCONFIG_BIT_VAL = 4;
    private static final int AUTODETECT_BIT_VAL = 8;
    private static final int proxy_settings_index = 8;
    String autoconfigUrl;
    boolean autoDetect;
    boolean proxyEnabled;
    String proxyServer;
    String proxyOverride;

    public static WindowsProxySettings fromProxy(Proxy proxy) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "fromProxy(Proxy)", 69).addDetail("proxy", (Object)proxy)).log();
        }
        if (proxy == null) {
            throw new IllegalArgumentException("proxy is marked non-null but is null");
        }
        WindowsProxySettings windowsProxySettings = new WindowsProxySettings();
        switch (proxy.getProxyType()) {
            case AUTODETECT: {
                windowsProxySettings.autoDetect = true;
                return windowsProxySettings;
            }
            case PAC: {
                windowsProxySettings.autoconfigUrl = proxy.getProxyAutoconfigUrl();
                break;
            }
            case MANUAL: {
                windowsProxySettings.proxyEnabled = true;
                windowsProxySettings.proxyServer = proxy.getHttpProxy();
                if (Misc.emptyOrNull((String)windowsProxySettings.proxyServer)) {
                    windowsProxySettings.proxyServer = proxy.getSslProxy();
                }
                String string = proxy.getNoProxy();
                WindowsProxySettings.setProxyOverrideFromNoProxyString(windowsProxySettings, string);
                break;
            }
            case SYSTEM: {
                return WindowsProxySettings.fromRegistry();
            }
        }
        if (WindowsProxySettings.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "fromProxy(Proxy)", 93).add("settings", (Object)windowsProxySettings)).log();
        }
        return windowsProxySettings;
    }

    private static void setProxyOverrideFromNoProxyString(WindowsProxySettings windowsProxySettings, String string) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setProxyOverrideFromNoProxyString(WindowsProxySettings,String)", 97).addDetail("settings", (Object)windowsProxySettings)).addDetail("noProxy", string)).log();
        }
        if (!Misc.emptyOrNull((String)string)) {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (String string2 : string.split("[;,]")) {
                if (Misc.emptyOrNull((String)(string2 = string2.trim()))) continue;
                linkedList.add(string2);
            }
            if (!linkedList.isEmpty()) {
                windowsProxySettings.proxyOverride = Misc.join(linkedList, (String)";");
            }
        }
        if (windowsProxySettings.proxyOverride != null) {
            windowsProxySettings.proxyOverride = windowsProxySettings.proxyOverride.replace(',', ';');
        }
    }

    public static WindowsProxySettings fromRegistry() {
        if (WindowsProxySettings.logger.level >= 7) {
            logger.lvlBuild(7, "fromRegistry()", 116).log();
        }
        WindowsProxySettings windowsProxySettings = new WindowsProxySettings();
        windowsProxySettings.getAutodetectFromRegistry();
        windowsProxySettings.getAutoconfigUrlFromRegistry();
        windowsProxySettings.getProxyValueFromRegistry();
        if (WindowsProxySettings.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "fromRegistry()", 122).add("settings", (Object)windowsProxySettings)).log();
        }
        return windowsProxySettings;
    }

    private void getAutodetectFromRegistry() {
        if (WindowsProxySettings.logger.level >= 7) {
            logger.lvlBuild(7, "getAutodetectFromRegistry()", 126).log();
        }
        byte[] byArray = this.getBinaryValue(CONNECTIONS_BASEKEY, SETTINGS_VALUENAME);
        this.autoDetect = false;
        if (byArray != null && byArray.length > 8) {
            this.autoDetect = (byArray[8] & 8) > 0;
        }
    }

    private void getAutoconfigUrlFromRegistry() {
        if (WindowsProxySettings.logger.level >= 7) {
            logger.lvlBuild(7, "getAutoconfigUrlFromRegistry()", 135).log();
        }
        this.autoconfigUrl = this.getStringValue(BASEKEY, AUTOCONFIG_URL_VALUENAME);
    }

    private void getProxyValueFromRegistry() {
        if (WindowsProxySettings.logger.level >= 7) {
            logger.lvlBuild(7, "getProxyValueFromRegistry()", 140).log();
        }
        this.proxyEnabled = this.getBooleanValue(BASEKEY, PROXY_ENABLE_VALUENAME);
        this.proxyServer = this.getStringValue(BASEKEY, PROXY_SERVER_VALUENAME);
        this.proxyOverride = this.getStringValue(BASEKEY, PROXY_OVERRIDE_VALUENAME);
        if (Misc.emptyOrNull((String)this.proxyServer)) {
            this.proxyEnabled = false;
        }
    }

    public void writeToRegistry() {
        if (WindowsProxySettings.logger.level >= 7) {
            logger.lvlBuild(7, "writeToRegistry()", 151).log();
        }
        byte[] byArray = this.getBinaryValue(CONNECTIONS_BASEKEY, SETTINGS_VALUENAME);
        long l2 = 1L;
        if (WindowsProxySettings.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "writeToRegistry()", 156).add("originalConnSettings", (Object)byArray)).add("proxySettingsBitmask", l2)).log();
        }
        l2 = this.setBitInBitmask(l2, 8, this.autoDetect);
        boolean bl2 = !Misc.emptyOrNull((String)this.autoconfigUrl);
        l2 = this.setBitInBitmask(l2, 4, bl2);
        if (bl2) {
            this.setStringValue(BASEKEY, AUTOCONFIG_URL_VALUENAME, this.autoconfigUrl);
        }
        if (Misc.emptyOrNull((String)this.proxyServer)) {
            this.proxyEnabled = false;
        }
        if (WindowsProxySettings.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "writeToRegistry()", 169).add("proxyEnabled", this.proxyEnabled)).add("proxyServer", this.proxyServer)).add("proxyOverride", this.proxyOverride)).log();
        }
        l2 = this.setBitInBitmask(l2, 2, this.proxyEnabled);
        this.setBooleanValue(BASEKEY, PROXY_ENABLE_VALUENAME, this.proxyEnabled);
        this.setStringValue(BASEKEY, PROXY_SERVER_VALUENAME, this.proxyServer);
        this.setStringValue(BASEKEY, PROXY_OVERRIDE_VALUENAME, this.proxyOverride);
        if (WindowsProxySettings.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "writeToRegistry()", 175).add("proxySettingsBitmask", l2)).log();
        }
        byte[] byArray2 = this.getBytesOfString(this.proxyServer);
        byte[] byArray3 = this.getBytesOfString(this.proxyOverride);
        byte[] byArray4 = this.getBytesOfString(this.autoconfigUrl);
        int n2 = 16 + byArray2.length + 4 + byArray3.length + 4 + byArray4.length + 32;
        byte[] byArray5 = new byte[n2];
        if (byArray != null && byArray.length >= 4) {
            System.arraycopy(byArray, 0, byArray5, 0, 4);
        } else {
            byArray5[0] = 70;
        }
        long l3 = 0L;
        if (byArray != null && byArray.length >= 8) {
            l3 = this.readNumberFromBytes(byArray, 4);
        }
        this.writeNumberInBytes(byArray5, 4, ++l3);
        this.writeNumberInBytes(byArray5, 8, l2);
        this.writeNumberInBytes(byArray5, 12, byArray2.length);
        System.arraycopy(byArray2, 0, byArray5, 16, byArray2.length);
        this.writeNumberInBytes(byArray5, 16 + byArray2.length, byArray3.length);
        System.arraycopy(byArray3, 0, byArray5, 20 + byArray2.length, byArray3.length);
        this.writeNumberInBytes(byArray5, 20 + byArray2.length + byArray3.length, byArray4.length);
        System.arraycopy(byArray4, 0, byArray5, 24 + byArray2.length + byArray3.length, byArray4.length);
        this.setBinaryValue(CONNECTIONS_BASEKEY, SETTINGS_VALUENAME, byArray5);
        this.setBooleanValue(BASEKEY, "MigrateProxy", true);
    }

    private byte[] getBytesOfString(String string) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getBytesOfString(String)", 222).addDetail("s", string)).log();
        }
        if (string == null) {
            string = "";
        }
        try {
            return string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (WindowsProxySettings.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "getBytesOfString(String)", 228).add("e", (Object)unsupportedEncodingException)).log();
            }
            return new byte[0];
        }
    }

    private long readNumberFromBytes(byte[] byArray, int n2) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "readNumberFromBytes(byte[],int)", 233).addDetail("array", (Object)byArray)).addDetail("startIndex", n2)).log();
        }
        return (byArray[n2] & 0xFF) + ((byArray[n2 + 1] & 0xFF) << 8) + ((byArray[n2 + 2] & 0xFF) << 16) + ((byArray[n2 + 3] & 0xFF) << 24);
    }

    private void writeNumberInBytes(byte[] byArray, int n2, long l2) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "writeNumberInBytes(byte[],int,long)", 241).addDetail("array", (Object)byArray)).addDetail("startIndex", n2)).addDetail("number", l2)).log();
        }
        byArray[n2] = (byte)(l2 & 0xFFL);
        byArray[n2 + 1] = (byte)(l2 >> 8 & 0xFFL);
        byArray[n2 + 2] = (byte)(l2 >> 16 & 0xFFL);
        byArray[n2 + 3] = (byte)(l2 >> 24 & 0xFFL);
    }

    protected long setBitInBitmask(long l2, int n2, boolean bl2) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setBitInBitmask(long,int,boolean)", 249).addDetail("bitmask", l2)).addDetail("valueBit", n2)).addDetail("valueToSet", bl2)).log();
        }
        if (bl2) {
            return l2 | (long)n2;
        }
        return l2 & (long)(0xFF ^ n2);
    }

    protected String getStringValue(String string, String string2) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getStringValue(String,String)", 258).addDetail("key", string)).addDetail("valueName", string2)).log();
        }
        String string3 = null;
        if (Advapi32Util.instance.registryValueExists(WinReg.HKEY_CURRENT_USER, string, string2)) {
            string3 = Advapi32Util.instance.registryGetStringValue(WinReg.HKEY_CURRENT_USER, string, string2);
        }
        return string3;
    }

    protected boolean getBooleanValue(String string, String string2) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getBooleanValue(String,String)", 267).addDetail("key", string)).addDetail("valueName", string2)).log();
        }
        boolean bl2 = false;
        if (Advapi32Util.instance.registryValueExists(WinReg.HKEY_CURRENT_USER, string, string2)) {
            bl2 = Advapi32Util.instance.registryGetIntValue(WinReg.HKEY_CURRENT_USER, string, string2) == 1;
        }
        return bl2;
    }

    protected byte[] getBinaryValue(String string, String string2) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getBinaryValue(String,String)", 276).addDetail("key", string)).addDetail("valueName", string2)).log();
        }
        byte[] byArray = null;
        if (Advapi32Util.instance.registryValueExists(WinReg.HKEY_CURRENT_USER, string, string2)) {
            byArray = Advapi32Util.instance.registryGetBinaryValue(WinReg.HKEY_CURRENT_USER, string, string2);
        }
        return byArray;
    }

    protected void setStringValue(String string, String string2, String string3) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setStringValue(String,String,String)", 285).addDetail("key", string)).addDetail("valueName", string2)).addDetail("value", string3)).log();
        }
        if (string3 == null) {
            if (Advapi32Util.instance.registryValueExists(WinReg.HKEY_CURRENT_USER, string, string2)) {
                Advapi32Util.instance.registryDeleteValue(WinReg.HKEY_CURRENT_USER, string, string2);
            }
        } else {
            Advapi32Util.instance.registrySetStringValue(WinReg.HKEY_CURRENT_USER, string, string2, string3);
        }
    }

    protected void setBooleanValue(String string, String string2, Boolean bl2) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setBooleanValue(String,String,Boolean)", 296).addDetail("key", string)).addDetail("valueName", string2)).addDetail("value", (Object)bl2)).log();
        }
        if (bl2 == null) {
            if (Advapi32Util.instance.registryValueExists(WinReg.HKEY_CURRENT_USER, string, string2)) {
                Advapi32Util.instance.registryDeleteValue(WinReg.HKEY_CURRENT_USER, string, string2);
            }
        } else {
            Advapi32Util.instance.registrySetIntValue(WinReg.HKEY_CURRENT_USER, string, string2, bl2 != false ? 1 : 0);
        }
    }

    protected void setBinaryValue(String string, String string2, byte[] byArray) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setBinaryValue(String,String,byte[])", 307).addDetail("key", string)).addDetail("valueName", string2)).addDetail("value", (Object)byArray)).log();
        }
        if (byArray == null) {
            if (Advapi32Util.instance.registryValueExists(WinReg.HKEY_CURRENT_USER, string, string2)) {
                Advapi32Util.instance.registryDeleteValue(WinReg.HKEY_CURRENT_USER, string, string2);
            }
        } else {
            Advapi32Util.instance.registrySetBinaryValue(WinReg.HKEY_CURRENT_USER, string, string2, byArray);
        }
    }

    public WindowsProxySettings clone() throws CloneNotSupportedException {
        if (WindowsProxySettings.logger.level >= 7) {
            logger.lvlBuild(7, "clone()", 318).log();
        }
        return (WindowsProxySettings)super.clone();
    }

    public WindowsProxySettings() {
        if (WindowsProxySettings.logger.level >= 7) {
            logger.lvlBuild(7, "WindowsProxySettings()", 42).log();
        }
    }

    public String getAutoconfigUrl() {
        if (WindowsProxySettings.logger.level >= 7) {
            logger.lvlBuild(7, "getAutoconfigUrl()", 59).log();
        }
        return this.autoconfigUrl;
    }

    public boolean isAutoDetect() {
        if (WindowsProxySettings.logger.level >= 7) {
            logger.lvlBuild(7, "isAutoDetect()", 60).log();
        }
        return this.autoDetect;
    }

    public boolean isProxyEnabled() {
        if (WindowsProxySettings.logger.level >= 7) {
            logger.lvlBuild(7, "isProxyEnabled()", 61).log();
        }
        return this.proxyEnabled;
    }

    public String getProxyServer() {
        if (WindowsProxySettings.logger.level >= 7) {
            logger.lvlBuild(7, "getProxyServer()", 62).log();
        }
        return this.proxyServer;
    }

    public String getProxyOverride() {
        if (WindowsProxySettings.logger.level >= 7) {
            logger.lvlBuild(7, "getProxyOverride()", 63).log();
        }
        return this.proxyOverride;
    }

    public WindowsProxySettings setAutoconfigUrl(String string) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setAutoconfigUrl(String)", 42).addDetail("autoconfigUrl", string)).log();
        }
        this.autoconfigUrl = string;
        return this;
    }

    public WindowsProxySettings setAutoDetect(boolean bl2) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setAutoDetect(boolean)", 42).addDetail("autoDetect", bl2)).log();
        }
        this.autoDetect = bl2;
        return this;
    }

    public WindowsProxySettings setProxyEnabled(boolean bl2) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setProxyEnabled(boolean)", 42).addDetail("proxyEnabled", bl2)).log();
        }
        this.proxyEnabled = bl2;
        return this;
    }

    public WindowsProxySettings setProxyServer(String string) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setProxyServer(String)", 42).addDetail("proxyServer", string)).log();
        }
        this.proxyServer = string;
        return this;
    }

    public WindowsProxySettings setProxyOverride(String string) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setProxyOverride(String)", 42).addDetail("proxyOverride", string)).log();
        }
        this.proxyOverride = string;
        return this;
    }

    public boolean equals(Object object) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "equals(Object)", 42).addDetail("o", object)).log();
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof WindowsProxySettings)) {
            return false;
        }
        WindowsProxySettings windowsProxySettings = (WindowsProxySettings)object;
        if (!windowsProxySettings.canEqual(this)) {
            return false;
        }
        if (this.isAutoDetect() != windowsProxySettings.isAutoDetect()) {
            return false;
        }
        if (this.isProxyEnabled() != windowsProxySettings.isProxyEnabled()) {
            return false;
        }
        String string = this.getAutoconfigUrl();
        String string2 = windowsProxySettings.getAutoconfigUrl();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getProxyServer();
        String string4 = windowsProxySettings.getProxyServer();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getProxyOverride();
        String string6 = windowsProxySettings.getProxyOverride();
        return !(string5 == null ? string6 != null : !string5.equals(string6));
    }

    protected boolean canEqual(Object object) {
        if (WindowsProxySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "canEqual(Object)", 42).addDetail("other", object)).log();
        }
        return object instanceof WindowsProxySettings;
    }

    public int hashCode() {
        if (WindowsProxySettings.logger.level >= 7) {
            logger.lvlBuild(7, "hashCode()", 42).log();
        }
        int n2 = 1;
        n2 = n2 * 59 + (this.isAutoDetect() ? 79 : 97);
        n2 = n2 * 59 + (this.isProxyEnabled() ? 79 : 97);
        String string = this.getAutoconfigUrl();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getProxyServer();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getProxyOverride();
        n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
        return n2;
    }

    public String toString() {
        if (WindowsProxySettings.logger.level >= 7) {
            logger.lvlBuild(7, "toString()", 42).log();
        }
        return "WindowsProxySettings(autoconfigUrl=" + this.getAutoconfigUrl() + ", autoDetect=" + this.isAutoDetect() + ", proxyEnabled=" + this.isProxyEnabled() + ", proxyServer=" + this.getProxyServer() + ", proxyOverride=" + this.getProxyOverride() + ")";
    }
}

