/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.fx.check;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.fx.check.NodeChecker;
import de.qfs.apps.qftest.client.fx.items.TableItemResolver;
import de.qfs.apps.qftest.client.fx.j;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.extensions.checks.CheckerHelper;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.data.check.BooleanCheckData;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.ImageCheckData;
import de.qfs.apps.qftest.shared.data.check.SelectableItemsCheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.apps.qftest.shared.data.check.StringItemsCheckData;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.image.BaseImageHandler;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Pair;
import de.qfs.lib.util.Reflector;
import java.util.ArrayList;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;

public class TableChecker
extends NodeChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.fx.check.TableChecker");

    public TableChecker(j j2) {
        super(j2);
        if (TableChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "TableChecker(FxEngine)", 71).addDetail("engine", (Object)j2)).log();
        }
    }

    @Override
    protected boolean isCheckerFor(Object object) {
        return object instanceof TableView;
    }

    @Override
    protected ArrayList getSupportedCheckTypesImpl(Object object, Object object2) {
        if (TableChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSupportedCheckTypesImpl(Object,Object)", 106).addDetail("target", object)).addDetail("subItem", object2)).log();
        }
        ArrayList arrayList = super.getSupportedCheckTypesImpl(object, object2);
        arrayList.remove(CheckType.TEXT);
        if (object2 == null) {
            return arrayList;
        }
        if (object2 instanceof TableColumn) {
            arrayList.add(0, CheckType.HEADER_FOR_TABLE);
            arrayList.add(1, CheckType.TITLE_IMAGE);
            arrayList.add(2, CheckType.TITLE_TOOLTIP);
            return arrayList;
        }
        int n2 = ((int[])object2)[0];
        int n3 = ((int[])object2)[1];
        arrayList.add(0, CheckType.HEADER_FOR_TABLE);
        arrayList.add(1, CheckType.COLUMN);
        arrayList.add(2, CheckType.COLUMN_VISIBLE);
        arrayList.add(3, CheckType.COLUMN_WITH_SELECTION);
        if (n3 >= 0) {
            int n4;
            arrayList.add(0, CheckType.CELL);
            arrayList.add(1, CheckType.CELL_VISIBLE);
            arrayList.add(2, CheckType.CELL_SELECTED);
            arrayList.add(3, CheckType.CELL_EDITABLE);
            arrayList.add(8, CheckType.ROW);
            if (this.hasCheckbox((TableView)object, n3, n2)) {
                arrayList.add(2, CheckType.CELL_CHECKED);
            }
            if ((n4 = arrayList.indexOf(CheckType.IMAGE)) >= 0) {
                arrayList.add(n4 + 1, CheckType.CELL_IMAGE);
                arrayList.add(n4 + 2, CheckType.CELL_TOOLTIP);
            } else {
                arrayList.add(CheckType.CELL_IMAGE);
                arrayList.add(CheckType.CELL_TOOLTIP);
            }
        } else {
            arrayList.add(4, CheckType.TITLE_IMAGE);
            arrayList.add(5, CheckType.TITLE_TOOLTIP);
        }
        return arrayList;
    }

    @Override
    protected CheckData getCheckDataImpl(Object object, Object object2, CheckType checkType) throws TestException {
        if (TableChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataImpl(Object,Object,CheckType)", 165).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        TableView tableView = (TableView)object;
        if (object2 instanceof TableColumn) {
            if (checkType.getDataType() == CheckDataType.STRING && ("default".equals(checkType.getIdentifier()) || CheckType.HEADER.getIdentifier().equals(checkType.getIdentifier()) || CheckType.HEADER_FOR_TABLE.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    String string = Util.getCleanElementText((String)ItemRegistry.instance().getItemValue(object, object2));
                    return new StringCheckData(CheckType.HEADER_FOR_TABLE.getIdentifier(), string);
                }
                catch (BadItemException badItemException) {
                    if (TableChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 181).add("ex", (Object)badItemException)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.IMAGE && ("default".equals(checkType.getIdentifier()) || !Client.instance().isCaptureContext() && CheckType.IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.TITLE_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || "title_image".equals(checkType.getIdentifier()) || CheckType.ITEM_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_IMAGE_OLD.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    Object object3 = TableItemResolver.getHeader(this.engine.getHelper(), (TableView)object, (TableColumn)object2);
                    if (object3 != null) {
                        ImageRep imageRep = BaseImageHandler.instance((Object)this.engine).grabImage(object3);
                        return new ImageCheckData(CheckType.ITEM_IMAGE.getIdentifier(), imageRep, -1, -1, -1, -1, -1, -1, false);
                    }
                }
                catch (Exception exception) {
                    if (TableChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 207).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.STRING && (CheckType.TOOLTIP.getIdentifier().equals(checkType.getIdentifier()) || "title_tooltip".equals(checkType.getIdentifier()) || CheckType.ITEM_TOOLTIP.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    boolean bl2 = Client.instance().isCaptureContext() && CheckType.TOOLTIP.getIdentifier().equals(checkType.getIdentifier());
                    return new StringCheckData((bl2 ? CheckType.TOOLTIP : CheckType.CELL_TOOLTIP).getIdentifier(), this.engine.getHelper().getTooltipText(tableView, bl2 ? null : object2));
                }
                catch (Exception exception) {
                    if (TableChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 227).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
        } else if (object2 != null) {
            Pair pair;
            int n2;
            int n3;
            block83: {
                int n4;
                block82: {
                    n3 = ((int[])object2)[0];
                    n2 = ((int[])object2)[1];
                    if (checkType.getDataType() == CheckDataType.STRING_LIST && (n2 < 0 && "default".equals(checkType.getIdentifier()) || CheckType.COLUMN.getIdentifier().equals(checkType.getIdentifier()))) {
                        n4 = tableView.getItems().size();
                        pair = CheckerHelper.instance().getStartAndCountParameters(n4, tableView, new SubItemIndex[]{new SubItemIndex(n3)});
                        try {
                            int[] nArray = (int[])pair.getFirst();
                            if (pair.getSecond() != null) {
                                nArray[0] = ((int[])pair.getSecond())[1];
                            }
                            int n5 = nArray[0];
                            if (nArray[1] >= 0) {
                                n4 = Math.min(n4, n5 + nArray[1]);
                            }
                            if (TableChecker.a.level >= 9) {
                                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getCheckDataImpl(Object,Object,CheckType)", 255).add("start", n5)).add("count", n4)).log();
                            }
                            String[] stringArray = new String[Math.max(0, n4 - n5)];
                            int[] nArray2 = new int[]{n3, 0};
                            for (int i2 = n5; i2 < n4; ++i2) {
                                nArray2[1] = i2;
                                stringArray[i2 - n5] = Util.getCleanElementText((String)ItemRegistry.instance().getItemValue(object, nArray2));
                            }
                            return new StringItemsCheckData(CheckType.COLUMN.getIdentifier(), stringArray);
                        }
                        catch (Exception exception) {
                            if (TableChecker.a.level < 1) break block82;
                            ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 265).add("ex", (Object)exception)).log();
                        }
                    }
                }
                if (checkType.getDataType() == CheckDataType.SELECTABLE_STRING_LIST && (n2 < 0 && "default".equals(checkType.getIdentifier()) || CheckType.COLUMN_WITH_SELECTION.getIdentifier().equals(checkType.getIdentifier()))) {
                    n4 = tableView.getItems().size();
                    pair = CheckerHelper.instance().getStartAndCountParameters(n4, tableView, new SubItemIndex[]{new SubItemIndex(n3)});
                    try {
                        int[] nArray = (int[])pair.getFirst();
                        if (pair.getSecond() != null) {
                            nArray[0] = ((int[])pair.getSecond())[1];
                        }
                        int n6 = nArray[0];
                        if (nArray[1] >= 0) {
                            n4 = Math.min(n4, n6 + nArray[1]);
                        }
                        if (TableChecker.a.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getCheckDataImpl(Object,Object,CheckType)", 289).add("start", n6)).add("count", n4)).log();
                        }
                        Object[][] objectArray = new Object[Math.max(0, n4 - n6)][];
                        int[] nArray3 = new int[]{n3, 0};
                        for (int i3 = n6; i3 < n4; ++i3) {
                            nArray3[1] = i3;
                            objectArray[i3 - n6] = new Object[]{Util.getCleanElementText((String)ItemRegistry.instance().getItemValue(object, nArray3)), Boolean.FALSE, this.isSelected(tableView, i3, n3)};
                        }
                        return new SelectableItemsCheckData(CheckType.COLUMN_WITH_SELECTION.getIdentifier(), objectArray, false);
                    }
                    catch (Exception exception) {
                        if (TableChecker.a.level >= 1) {
                            ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 305).add("ex", (Object)exception)).log();
                        }
                        return null;
                    }
                }
                if (checkType.getDataType() == CheckDataType.IMAGE && (n2 < 0 && ("default".equals(checkType.getIdentifier()) || !Client.instance().isCaptureContext() && CheckType.IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.TITLE_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_IMAGE_OLD.getIdentifier().equals(checkType.getIdentifier())) || "title_image".equals(checkType.getIdentifier()))) {
                    try {
                        Object object4 = TableItemResolver.getHeader(this.engine.getHelper(), (TableView)object, n3);
                        if (object4 != null) {
                            pair = BaseImageHandler.instance((Object)this.engine).grabImage(object4);
                            return new ImageCheckData(CheckType.ITEM_IMAGE.getIdentifier(), (ImageRep)pair, -1, -1, -1, -1, -1, -1, false);
                        }
                    }
                    catch (Exception exception) {
                        if (TableChecker.a.level >= 1) {
                            ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 331).add("ex", (Object)exception)).log();
                        }
                        return null;
                    }
                }
                if (checkType.getDataType() == CheckDataType.STRING_LIST && n2 >= 0 && CheckType.ROW.getIdentifier().equals(checkType.getIdentifier())) {
                    int n7 = TableItemResolver.getVisibleColumnCount(tableView);
                    pair = CheckerHelper.instance().getStartAndCountParameters(n7, tableView, new SubItemIndex[0]);
                    try {
                        int[] nArray = (int[])pair.getFirst();
                        if (pair.getSecond() != null) {
                            nArray[0] = ((int[])pair.getSecond())[0];
                        }
                        int n8 = nArray[0];
                        if (nArray[1] >= 0) {
                            n7 = Math.min(n7, n8 + nArray[1]);
                        }
                        if (TableChecker.a.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getCheckDataImpl(Object,Object,CheckType)", 355).add("start", n8)).add("count", n7)).log();
                        }
                        String[] stringArray = new String[Math.max(0, n7 - n8)];
                        int[] nArray4 = new int[]{0, n2};
                        for (int i4 = n8; i4 < n7; ++i4) {
                            nArray4[0] = i4;
                            stringArray[i4 - n8] = Util.getCleanElementText((String)ItemRegistry.instance().getItemValue(object, nArray4));
                        }
                        return new StringItemsCheckData(CheckType.ROW.getIdentifier(), stringArray);
                    }
                    catch (Exception exception) {
                        if (TableChecker.a.level < 1) break block83;
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 365).add("ex", (Object)exception)).log();
                    }
                }
            }
            if (checkType.getDataType() == CheckDataType.STRING && n2 >= 0 && ("default".equals(checkType.getIdentifier()) || CheckType.CELL.getIdentifier().equals(checkType.getIdentifier()) || "cell".equals(checkType.getIdentifier()) || CheckType.ITEM.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    String string = Util.getCleanElementText((String)ItemRegistry.instance().getItemValue(object, object2));
                    return new StringCheckData(CheckType.ITEM.getIdentifier(), string);
                }
                catch (BadItemException badItemException) {
                    if (TableChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 383).add("ex", (Object)badItemException)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.STRING && (n2 < 0 && "default".equals(checkType.getIdentifier()) || n2 < 0 && CheckType.HEADER.getIdentifier().equals(checkType.getIdentifier()) || CheckType.HEADER_FOR_TABLE.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    String string = Util.getCleanElementText((String)ItemRegistry.instance().getItemValue(object, new int[]{n3, -1}));
                    return new StringCheckData(CheckType.HEADER_FOR_TABLE.getIdentifier(), string);
                }
                catch (BadItemException badItemException) {
                    if (TableChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 400).add("ex", (Object)badItemException)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.BOOLEAN && (n2 >= 0 && CheckType.CELL_VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || "cell_visible".equals(checkType.getIdentifier()) || CheckType.ITEM_VISIBLE.getIdentifier().equals(checkType.getIdentifier()))) {
                return new BooleanCheckData(CheckType.ITEM_VISIBLE.getIdentifier(), this.isVisible(tableView, n2, n3));
            }
            if (checkType.getDataType() == CheckDataType.BOOLEAN && (n2 < 0 && CheckType.COLUMN_VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier()))) {
                return new BooleanCheckData(CheckType.COLUMN_VISIBLE.getIdentifier(), this.isVisible(tableView, -1, n3));
            }
            if (checkType.getDataType() == CheckDataType.BOOLEAN && n2 >= 0 && (CheckType.CELL_CHECKED.getIdentifier().equals(checkType.getIdentifier()) || "cell_checked".equals(checkType.getIdentifier()) || "item_content_selected".equals(checkType.getIdentifier()) || CheckType.CHECKED.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    return new BooleanCheckData(CheckType.CELL_CHECKED.getIdentifier(), this.isChecked(tableView, n2, n3));
                }
                catch (Exception exception) {
                    if (TableChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 443).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.BOOLEAN && n2 >= 0 && (CheckType.CELL_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.SELECTED.getIdentifier().equals(checkType.getIdentifier()) || "cell_selected".equals(checkType.getIdentifier()) || CheckType.ITEM_SELECTED.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    return new BooleanCheckData(CheckType.ITEM_SELECTED.getIdentifier(), this.isSelected(tableView, n2, n3));
                }
                catch (Exception exception) {
                    if (TableChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 461).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.BOOLEAN && n2 >= 0 && (CheckType.CELL_EDITABLE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.EDITABLE.getIdentifier().equals(checkType.getIdentifier()) || "cell_editable".equals(checkType.getIdentifier()) || CheckType.ITEM_EDITABLE.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    return new BooleanCheckData(CheckType.ITEM_EDITABLE.getIdentifier(), this.isEditable(tableView, n2, n3));
                }
                catch (Exception exception) {
                    if (TableChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 479).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.IMAGE && n2 >= 0 && ("default".equals(checkType.getIdentifier()) || !Client.instance().isCaptureContext() && CheckType.IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.CELL_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || "cell_image".equals(checkType.getIdentifier()) || CheckType.ITEM_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_IMAGE_OLD.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    ImageRep imageRep = null;
                    try {
                        pair = TableItemResolver.getCell((TableView)object, (int[])object2);
                        if (TableChecker.a.level >= 9) {
                            ((LevelAwareLogBuilder)a.lvlBuild(9, "getCheckDataImpl(Object,Object,CheckType)", 505).add("cell", (Object)pair)).log();
                        }
                        if (pair != null) {
                            imageRep = BaseImageHandler.instance((Object)this.engine).grabImage((Object)pair);
                        } else {
                            int[] nArray = this.engine.getHelper().getItemLocationInParent(object, object2);
                            int[] nArray5 = this.engine.getHelper().getItemSize(object, object2);
                            if (TableChecker.a.level >= 9) {
                                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getCheckDataImpl(Object,Object,CheckType)", 511).add("ipos", (Object)nArray)).add("isize", (Object)nArray5)).log();
                            }
                            if (nArray == null || nArray5 == null) {
                                imageRep = BaseImageHandler.instance((Object)this.engine).grabImage(object);
                            }
                            imageRep = BaseImageHandler.instance((Object)this.engine).grabImage(object, nArray[0], nArray[1], nArray5[0], nArray5[1]);
                        }
                    }
                    catch (BadItemException badItemException) {
                        if (TableChecker.a.level >= 3) {
                            ((LevelAwareLogBuilder)a.lvlBuild(3, "getCheckDataImpl(Object,Object,CheckType)", 520).add("ex", (Object)badItemException)).log();
                        }
                        imageRep = BaseImageHandler.instance((Object)this.engine).grabImage(object);
                    }
                    return new ImageCheckData(CheckType.ITEM_IMAGE.getIdentifier(), imageRep, -1, -1, -1, -1, -1, -1, false);
                }
                catch (Exception exception) {
                    if (TableChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 526).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.STRING && (CheckType.TOOLTIP.getIdentifier().equals(checkType.getIdentifier()) || "cell_tooltip".equals(checkType.getIdentifier()) || "title_tooltip".equals(checkType.getIdentifier()) || CheckType.ITEM_TOOLTIP.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    boolean bl3 = Client.instance().isCaptureContext() && CheckType.TOOLTIP.getIdentifier().equals(checkType.getIdentifier());
                    return new StringCheckData((bl3 ? CheckType.TOOLTIP : CheckType.CELL_TOOLTIP).getIdentifier(), this.engine.getHelper().getTooltipText(tableView, bl3 ? null : object2));
                }
                catch (Exception exception) {
                    if (TableChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 547).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
        }
        return super.getCheckDataImpl(object, object2, checkType);
    }

    @Override
    public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) throws TestException {
        if (TableChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataAndItem(Object,Object,CheckType)", 572).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
        }
        CheckData checkData = null;
        checkData = CheckType.ENABLED.getIdentifier().equals(checkType.getIdentifier()) ? this.getCheckData(object, null, checkType) : (CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier()) ? this.getCheckData(object, null, checkType) : (CheckType.COLUMN_VISIBLE.getIdentifier().equals(checkType.getIdentifier()) ? this.getCheckData(object, new int[]{((int[])object2)[0], -1}, checkType) : this.getCheckData(object, object2, checkType)));
        if (checkData == null) {
            return null;
        }
        if (CheckType.CELL.getIdentifier().equals(checkType.getIdentifier()) || CheckType.CELL_CHECKED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.CELL_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.CELL_EDITABLE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.CELL_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.CELL_VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.CELL_TOOLTIP.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ROW.getIdentifier().equals(checkType.getIdentifier())) {
            return new Pair((Object)checkData, object2);
        }
        if (CheckType.HEADER_FOR_TABLE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.COLUMN_VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.COLUMN.getIdentifier().equals(checkType.getIdentifier()) || CheckType.COLUMN_WITH_SELECTION.getIdentifier().equals(checkType.getIdentifier())) {
            if (object2 instanceof TableColumn) {
                return new Pair((Object)checkData, object2);
            }
            return new Pair((Object)checkData, (Object)new int[]{((int[])object2)[0], -1});
        }
        return new Pair((Object)checkData, null);
    }

    protected boolean hasCheckbox(TableView tableView, int n2, int n3) {
        TableCell tableCell;
        if (TableChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "hasCheckbox(TableView,int,int)", 626).addDetail("table", (Object)tableView)).addDetail("row", n2)).addDetail("col", n3)).log();
        }
        if ((tableCell = TableItemResolver.getOrCreateCell(tableView, new int[]{n3, n2})) != null) {
            Object[] objectArray = this.engine.getHelper().getElementsByClassName((Object)tableCell, "CheckBox");
            if (TableChecker.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "hasCheckbox(TableView,int,int)", 631).add("cbs", (Object)objectArray)).log();
            }
            return objectArray.length > 0;
        }
        if (TableChecker.a.level >= 3) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "hasCheckbox(TableView,int,int)", 635).add("Oops. No cell ?!? - table", (Object)tableView)).add("row", n2)).add("col", n3)).log();
        }
        return false;
    }

    protected boolean isChecked(TableView tableView, int n2, int n3) {
        TableCell tableCell;
        if (TableChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "isChecked(TableView,int,int)", 651).addDetail("table", (Object)tableView)).addDetail("row", n2)).addDetail("col", n3)).log();
        }
        if ((tableCell = TableItemResolver.getOrCreateCell(tableView, new int[]{n3, n2})) != null) {
            Object[] objectArray = this.engine.getHelper().getElementsByClassName((Object)tableCell, "CheckBox");
            if (TableChecker.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "isChecked(TableView,int,int)", 656).add("cbs", (Object)objectArray)).log();
            }
            if (objectArray.length > 0) {
                Object object = Reflector.safeCall((Object)objectArray[0], (String)"isSelected");
                if (TableChecker.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "isChecked(TableView,int,int)", 659).add("checked", object)).log();
                }
                return object instanceof Boolean && (Boolean)object != false;
            }
        } else if (TableChecker.a.level >= 3) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "isChecked(TableView,int,int)", 665).add("Oops. No cell ?!? - table", (Object)tableView)).add("row", n2)).add("col", n3)).log();
        }
        return false;
    }

    protected boolean isSelected(TableView tableView, int n2, int n3) {
        if (TableChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "isSelected(TableView,int,int)", 681).addDetail("table", (Object)tableView)).addDetail("row", n2)).addDetail("col", n3)).log();
        }
        for (Object e2 : tableView.getSelectionModel().getSelectedCells()) {
            TablePosition tablePosition = (TablePosition)e2;
            if (tablePosition.getRow() != n2) continue;
            return true;
        }
        return false;
    }

    protected boolean isEditable(TableView tableView, int n2, int n3) {
        block4: {
            if (TableChecker.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "isEditable(TableView,int,int)", 707).addDetail("table", (Object)tableView)).addDetail("row", n2)).addDetail("col", n3)).log();
            }
            try {
                TableCell tableCell = (TableCell)ItemRegistry.instance().getElement(tableView, new int[]{n3, n2});
                if (tableCell != null) {
                    return tableCell.isEditable();
                }
            }
            catch (TestException testException) {
                if (TableChecker.a.level < 1) break block4;
                ((LevelAwareLogBuilder)a.lvlBuild(1, "isEditable(TableView,int,int)", 715).add("ex", (Object)testException)).log();
            }
        }
        return true;
    }

    protected boolean isVisible(TableView tableView, int n2, int n3) {
        block4: {
            if (TableChecker.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "isVisible(TableView,int,int)", 732).addDetail("table", (Object)tableView)).addDetail("row", n2)).addDetail("col", n3)).log();
            }
            try {
                Object object = ItemRegistry.instance().getElement(tableView, new int[]{n3, n2});
                if (object != null) {
                    return this.engine.getHelper().isVisible(object);
                }
            }
            catch (TestException testException) {
                if (TableChecker.a.level < 3) break block4;
                ((LevelAwareLogBuilder)a.lvlBuild(3, "isVisible(TableView,int,int)", 740).add("ex", (Object)testException)).log();
            }
        }
        return false;
    }
}

