/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.fx.extrafeatures;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.extensions.ExtraFeatureResolver;
import de.qfs.apps.qftest.shared.data.ExtraFeature;
import de.qfs.apps.qftest.shared.data.ExtraFeatureSet;
import de.qfs.apps.qftest.shared.extensions.BaseHelper;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Reflector;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javafx.scene.Parent;
import javafx.scene.control.Labeled;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;

public class FxImageHashResolver
implements ExtraFeatureResolver,
BaseHelper {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.fx.extrafeatures.FxImageHashResolver");

    public FxImageHashResolver() {
        if (FxImageHashResolver.a.level >= 7) {
            a.lvlBuild(7, "FxImageHashResolver()", 63).log();
        }
    }

    @Override
    public ExtraFeatureSet getExtraFeatures(Object object, ExtraFeatureSet extraFeatureSet) {
        if (FxImageHashResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getExtraFeatures(Object,ExtraFeatureSet)", 86).addDetail("element", object)).addDetail("features", (Object)extraFeatureSet)).log();
        }
        int n2 = Client.instance().getOptions().getInt("ImageHashRelevance", 1);
        if (FxImageHashResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getExtraFeatures(Object,ExtraFeatureSet)", 89).add("state", n2)).log();
        }
        if (Client.instance().isExtraFeatureRelevant("imagehash") && n2 >= 0 && n2 <= 2) {
            if (object instanceof ImageView) {
                Object object2 = Reflector.safeCall((Object)object, (String)"getImage");
                if (object2 instanceof Image) {
                    Vector<Image> vector = new Vector<Image>();
                    vector.add((Image)object2);
                    return this.getExtraFeatures(object, extraFeatureSet, vector, n2);
                }
            } else if (object instanceof Labeled) {
                Object object3;
                Object object4 = Reflector.safeCall((Object)object, (String)"getGraphic");
                if (FxImageHashResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getExtraFeatures(Object,ExtraFeatureSet)", 101).add("graphic", object4)).log();
                }
                Vector<Image> vector = new Vector<Image>();
                if (object4 instanceof ImageView && (object3 = Reflector.safeCall((Object)object4, (String)"getImage")) instanceof Image) {
                    if (FxImageHashResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getExtraFeatures(Object,ExtraFeatureSet)", 107).add("image", object3)).log();
                    }
                    vector.add((Image)object3);
                }
                if (object4 instanceof Parent) {
                    object3 = ((Parent)object4).getChildrenUnmodifiable();
                    Iterator iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        Object object5;
                        Object e2 = iterator.next();
                        if (FxImageHashResolver.a.level >= 9) {
                            ((LevelAwareLogBuilder)a.lvlBuild(9, "getExtraFeatures(Object,ExtraFeatureSet)", 117).add("node", e2)).log();
                        }
                        if (!(e2 instanceof ImageView) || !((object5 = Reflector.safeCall(e2, (String)"getImage")) instanceof Image)) continue;
                        if (FxImageHashResolver.a.level >= 9) {
                            ((LevelAwareLogBuilder)a.lvlBuild(9, "getExtraFeatures(Object,ExtraFeatureSet)", 121).add("image", object5)).log();
                        }
                        vector.add((Image)object5);
                    }
                }
                if (vector.size() > 0) {
                    return this.getExtraFeatures(object, extraFeatureSet, vector, n2);
                }
            }
        }
        return null;
    }

    public ExtraFeatureSet getExtraFeatures(Object object, ExtraFeatureSet extraFeatureSet, Vector vector, int n2) {
        if (FxImageHashResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getExtraFeatures(Object,ExtraFeatureSet,Vector<Image>,int)", 157).addDetail("element", object)).addDetail("features", (Object)extraFeatureSet)).addDetail("images", (Object)vector)).addDetail("state", n2)).log();
        }
        Iterator iterator = vector.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            int n4;
            Image image = (Image)iterator.next();
            PixelReader pixelReader = image.getPixelReader();
            if (FxImageHashResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getExtraFeatures(Object,ExtraFeatureSet,Vector<Image>,int)", 164).add("pr", (Object)pixelReader)).log();
            }
            if (pixelReader == null) continue;
            int[] nArray = new int[(int)image.getWidth() * (int)image.getHeight()];
            pixelReader.getPixels(0, 0, (int)image.getWidth(), (int)image.getHeight(), PixelFormat.getIntArgbInstance(), nArray, 0, (int)image.getWidth());
            int n5 = n4 = nArray != null ? Arrays.hashCode(nArray) : 0;
            if (FxImageHashResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getExtraFeatures(Object,ExtraFeatureSet,Vector<Image>,int)", 174).add("hash", n4)).log();
            }
            n3 += n4;
        }
        if (FxImageHashResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getExtraFeatures(Object,ExtraFeatureSet,Vector<Image>,int)", 177).add("hashes", n3)).log();
        }
        if (n3 != 0) {
            extraFeatureSet.add(new ExtraFeature(n2, "imagehash", "" + n3));
        }
        if (FxImageHashResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getExtraFeatures(Object,ExtraFeatureSet,Vector<Image>,int)", 181).add("features", (Object)extraFeatureSet)).log();
        }
        return extraFeatureSet;
    }
}

