/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.fx.image;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.ElementHelper;
import de.qfs.apps.qftest.client.Engine;
import de.qfs.apps.qftest.client.EventLog;
import de.qfs.apps.qftest.client.fx.FxHelper;
import de.qfs.apps.qftest.client.fx.image.FxImageHelper;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.image.BaseImageHandler;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.apps.qftest.shared.extensions.image.NativeImageHandler;
import de.qfs.apps.qftest.shared.image.BaseImageHelper;
import de.qfs.apps.qftest.shared.system.Native;
import de.qfs.apps.qftest.shared.system.NativeRobot;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Observer;
import de.qfs.lib.util.Reflector;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;
import javafx.stage.Screen;
import javafx.stage.Window;

public class FxImageHandler
extends BaseImageHandler {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.fx.image.FxImageHandler");
    private static FxImageHandler b = new FxImageHandler();
    private FxImageHelper i = FxImageHelper.instance();
    private Object j;
    private long k = 0L;
    private NativeImageHandler l;
    private Observer m = (observable, object) -> this.a();

    protected FxImageHandler() {
        if (FxImageHandler.a.level >= 7) {
            a.lvlBuild(7, "FxImageHandler()", 104).log();
        }
        Options.getOption((String)Options.OPT_DEFAULT_SCREENSHOT_TECHNOLOGY).addObserver(this.m);
        this.a();
    }

    public static synchronized BaseImageHandler instance() {
        if (b == null) {
            b = new FxImageHandler();
        }
        return b;
    }

    public static FxImageHandler fxInstance() {
        return (FxImageHandler)FxImageHandler.instance();
    }

    public ImageRep grabScreenshot() {
        if (FxImageHandler.a.level >= 7) {
            a.lvlBuild(7, "grabScreenshot()", 158).log();
        }
        if (this.l != null) {
            return this.l.grabScreenshot();
        }
        Screen screen = Screen.getPrimary();
        return this.grabScreenshot(0, 0, (int)screen.getBounds().getWidth(), (int)screen.getBounds().getHeight());
    }

    public ImageRep grabScreenshot(int n2, int n3, int n4, int n5) {
        if (FxImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "grabScreenshot(int,int,int,int)", 183).addDetail("x", n2)).addDetail("y", n3)).addDetail("width", n4)).addDetail("height", n5)).log();
        }
        if (this.l != null) {
            return this.l.grabScreenshot(n2, n3, n4, n5);
        }
        this.updateRobot();
        if (this.j == null) {
            return null;
        }
        try {
            if (Misc.IS_JAVA_VERSION_AT_LEAST_11) {
                Class<?> clazz = Class.forName("javafx.scene.image.WritableImage");
                Image image = (Image)Reflector.call((Object)this.j, (String)"getScreenCapture", (Class[])new Class[]{clazz, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE}, (Object[])new Object[]{null, (double)n2, (double)n3, (double)n4, (double)n5}, (boolean)true);
                if (FxImageHandler.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "grabScreenshot(int,int,int,int)", 203).add("img", (Object)image)).log();
                }
                int[] nArray = new int[n4 * n5];
                image.getPixelReader().getPixels(0, 0, n4, n5, PixelFormat.getIntArgbInstance(), nArray, 0, n4);
                return new ImageRep(null, nArray, ImageRep.CompressionMode.BINARY, n4, n5);
            }
            Object object = Reflector.call((Object)this.j, (String)"getScreenCapture", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{n2, n3, n4, n5}, (boolean)true);
            Class<?> clazz = Class.forName("com.sun.javafx.tk.quantum.PixelUtils");
            Class<?> clazz2 = Class.forName("com.sun.glass.ui.Pixels");
            Object object2 = Reflector.call(clazz, (String)"pixelsToImage", clazz2, (Object)object, (boolean)true);
            if (FxImageHandler.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "grabScreenshot(int,int,int,int)", 217).add("img", object2)).log();
            }
            int[] nArray = new int[n4 * n5];
            Reflector.call((Object)object2, (String)"getPixels", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, WritablePixelFormat.class, nArray.getClass(), Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{0, 0, n4, n5, PixelFormat.getIntArgbInstance(), nArray, 0, n4}, (boolean)true);
            return new ImageRep(null, nArray, ImageRep.CompressionMode.BINARY, n4, n5);
        }
        catch (Throwable throwable) {
            if (FxImageHandler.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "grabScreenshot(int,int,int,int)", 230).add("ex", (Object)throwable)).log();
            }
            FxImageHandler.maybeLogWarningInRunLogWithStackTrace(((Object)((Object)this)).getClass(), (String)"screenshotCreationFailure.message", (Object)throwable);
            return null;
        }
    }

    public ImageRep[] grabSpecifiedScreenshots(Set set, boolean bl2) {
        if (FxImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "grabSpecifiedScreenshots(Set<Integer>,boolean)", 244).addDetail("specifiedMonitors", (Object)set)).addDetail("asSingleImage", bl2)).dumpStack();
        }
        if (this.l != null) {
            return this.l.grabSpecifiedScreenshots(set, bl2);
        }
        return super.grabSpecifiedScreenshots(set, bl2);
    }

    public int getMonitorCount() {
        if (this.l != null) {
            return this.l.getMonitorCount();
        }
        return Screen.getScreens().size();
    }

    public ImageRep grabImage(Object object) {
        if (FxImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "grabImage(Object)", 275).addDetail("com", object)).log();
        }
        int n2 = 0;
        int n3 = 0;
        if (object instanceof Node) {
            Node node = (Node)object;
            n2 = (int)node.getBoundsInLocal().getWidth();
            n3 = (int)node.getBoundsInLocal().getHeight();
        } else if (object instanceof Window) {
            Window window = (Window)object;
            n2 = (int)window.getWidth();
            n3 = (int)window.getHeight();
        }
        return this.grabImage(object, 0, 0, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageRep grabImage(Object object, int n2, int n3, int n4, int n5) {
        Object object2;
        Scene scene;
        WritableImage writableImage;
        block26: {
            if (FxImageHandler.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "grabImage(Object,int,int,int,int)", 308).addDetail("com", object)).addDetail("x", n2)).addDetail("y", n3)).addDetail("width", n4)).addDetail("height", n5)).log();
            }
            if (!(object instanceof Node) && !(object instanceof Window)) {
                EventLog.instance().a((Object)"FIH.grabImage()", "Not a Node or Window:", object);
                return null;
            }
            writableImage = null;
            scene = null;
            if (object instanceof Node) {
                scene = ((Node)object).getScene();
                if (scene != null) {
                    Bounds bounds = ((Node)object).getBoundsInLocal();
                    if (FxImageHandler.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "grabImage(Object,int,int,int,int)", 322).add("bounds", (Object)bounds)).log();
                    }
                    object2 = FxHelper.localToScene((Node)object, bounds);
                    if (FxImageHandler.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "grabImage(Object,int,int,int,int)", 324).add("pos", object2)).log();
                    }
                    n2 = (int)((double)n2 + object2.getMinX());
                    n3 = (int)((double)n3 + object2.getMinY());
                }
            } else if (object instanceof Window) {
                scene = ((Window)object).getScene();
            }
            if (FxImageHandler.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "grabImage(Object,int,int,int,int)", 332).add("scene", (Object)scene)).log();
            }
            if (scene == null) {
                EventLog.instance().a((Object)"FIH.grabImage()", "Cannot determine Scene for", object);
                return null;
            }
            if (FxImageHandler.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "grabImage(Object,int,int,int,int)", 338).add("x", n2)).add("y", n3)).add("width", n4)).add("height", n5)).log();
            }
            if (n2 < 0) {
                n4 += n2;
                n2 = 0;
            }
            if (n3 < 0) {
                n5 += n3;
                n3 = 0;
            }
            n4 = Math.min(n4, (int)Math.round(scene.getWidth()) - n2);
            n5 = Math.min(n5, (int)Math.round(scene.getHeight()) - n3);
            boolean bl2 = Client.instance().getOptions().getBoolean("FxSnapshotProtectGeometry", true);
            if (FxImageHandler.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "grabImage(Object,int,int,int,int)", 355).add("Cropped x", n2)).add("y", n3)).add("width", n4)).add("height", n5)).add("protect", bl2)).log();
            }
            object2 = null;
            if (bl2) {
                try {
                    object2 = (Boolean)Reflector.get((Object)scene, (String)"sizeInitialized", (boolean)true);
                    Reflector.set((Object)scene, (String)"sizeInitialized", (Object)Boolean.TRUE, (boolean)true);
                }
                catch (Throwable throwable) {
                    if (FxImageHandler.a.level < 3) break block26;
                    ((LevelAwareLogBuilder)a.lvlBuild(3, "grabImage(Object,int,int,int,int)", 363).add("ex", (Object)throwable)).log();
                }
            }
        }
        try {
            writableImage = scene.snapshot(writableImage);
        }
        finally {
            block28: {
                if (object2 != null) {
                    try {
                        Reflector.set((Object)scene, (String)"sizeInitialized", (Object)object2, (boolean)true);
                    }
                    catch (Throwable throwable) {
                        if (FxImageHandler.a.level < 3) break block28;
                        ((LevelAwareLogBuilder)a.lvlBuild(3, "grabImage(Object,int,int,int,int)", 374).add("ex", (Object)throwable)).log();
                    }
                }
            }
        }
        if (writableImage == null) {
            return null;
        }
        writableImage = new WritableImage(writableImage.getPixelReader(), n2, n3, n4, n5);
        int[] nArray = FxImageHelper.getARGB((Image)writableImage);
        return new ImageRep(null, nArray, ImageRep.CompressionMode.BINARY, n4, n5);
    }

    public int[] getBoundsOfScreen(int n2) {
        if (FxImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getBoundsOfScreen(int)", 398).addDetail("screen", n2)).log();
        }
        if (this.l != null) {
            return this.l.getBoundsOfScreen(n2);
        }
        ObservableList observableList = Screen.getScreens();
        if (n2 < 0 || n2 >= observableList.size()) {
            throw new IllegalArgumentException("Invalid screen " + n2 + " not in [0:" + (observableList.size() - 1) + "]");
        }
        Rectangle2D rectangle2D = ((Screen)observableList.get(n2)).getBounds();
        if (FxImageHandler.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getBoundsOfScreen(int)", 408).add("bounds", (Object)rectangle2D)).log();
        }
        return new int[]{(int)Math.round(rectangle2D.getMinX()), (int)Math.round(rectangle2D.getMinY()), (int)Math.round(rectangle2D.getWidth()), (int)Math.round(rectangle2D.getHeight())};
    }

    public int getScreenForComponent(Object object) {
        ElementHelper elementHelper;
        if (FxImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getScreenForComponent(Object)", 424).addDetail("com", object)).log();
        }
        if ((elementHelper = Engine.helperFor(object)) == null) {
            if (FxImageHandler.a.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "getScreenForComponent(Object)", 428).add("No helper for ")).add(object)).log();
            }
            return -1;
        }
        if (elementHelper.isVisible(object)) {
            ElementHelper.Geometry geometry = elementHelper.getLocationOnScreen(object);
            ElementHelper.Geometry geometry2 = elementHelper.getSize(object);
            if (FxImageHandler.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getScreenForComponent(Object)", 434).add("pos", (Object)geometry)).add("size", (Object)geometry2)).log();
            }
            if (geometry == null || geometry2 == null) {
                if (FxImageHandler.a.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "getScreenForComponent(Object)", 436).add("No location on screen or no size for ")).add(object)).log();
                }
                return -1;
            }
            if (this.l != null) {
                return this.l.getScreenForRegion(geometry.x, geometry.y, geometry2.width, geometry2.height);
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = -1;
            for (Screen screen : Screen.getScreens()) {
                int n5;
                Rectangle2D rectangle2D = screen.getBounds();
                if (FxImageHandler.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getScreenForComponent(Object)", 448).add("bounds", (Object)rectangle2D)).log();
                }
                int n6 = Math.max(geometry.x, (int)Math.round(rectangle2D.getMinX()));
                int n7 = Math.min(geometry.x + geometry2.width, (int)Math.round(rectangle2D.getMaxX()));
                int n8 = Math.max(geometry.y, (int)Math.round(rectangle2D.getMinY()));
                int n9 = Math.min(geometry.y + geometry2.height, (int)Math.round(rectangle2D.getMaxY()));
                if (FxImageHandler.a.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getScreenForComponent(Object)", 453).add("left", n6)).add("right", n7)).add("top", n8)).add("bottom", n9)).log();
                }
                int n10 = n7 - n6;
                int n11 = n9 - n8;
                if (FxImageHandler.a.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getScreenForComponent(Object)", 457).add("w", n10)).add("h", n11)).log();
                }
                if (n10 > 0 && n11 > 0 && (n5 = n10 * n11) > n3) {
                    n3 = n5;
                    n4 = n2;
                    if (FxImageHandler.a.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getScreenForComponent(Object)", 463).add("max", n3)).add("best", n4)).log();
                    }
                }
                ++n2;
            }
            return n4;
        }
        return -1;
    }

    public ImageRep grabImageOfNode(Node node) {
        if (FxImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "grabImageOfNode(Node)", 488).addDetail("com", (Object)node)).log();
        }
        return this.grabImage(node, 0, 0, (int)((Bounds)node.boundsInParentProperty().get()).getWidth(), (int)((Bounds)node.boundsInParentProperty().get()).getHeight());
    }

    public ImageRep grabWindowImage(Window window) {
        if (FxImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "grabWindowImage(Window)", 503).addDetail("window", (Object)window)).log();
        }
        return this.grabImage(window.getScene(), 0, 0, (int)window.getWidth(), (int)window.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRobot() {
        block10: {
            Object object = this;
            synchronized (object) {
                if (this.j != null && (this.k <= 0L || System.currentTimeMillis() - this.k <= 10000L)) {
                    this.k = System.currentTimeMillis();
                    return;
                }
            }
            try {
                if (Misc.IS_JAVA_VERSION_AT_LEAST_11) {
                    object = Class.forName("javafx.scene.robot.Robot");
                    this.j = Reflector.createInstance((Class)object);
                } else {
                    object = Class.forName("com.sun.glass.ui.Application");
                    Object object2 = Reflector.call((Class)object, (String)"GetApplication");
                    this.j = Reflector.call((Object)object2, (String)"createRobot", (boolean)true);
                }
                if (FxImageHandler.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "updateRobot()", 535).add("robot", this.j)).log();
                }
            }
            catch (Exception exception) {
                if (FxImageHandler.a.level >= 3) {
                    ((LevelAwareLogBuilder)a.lvlBuild(3, "updateRobot()", 537).add("ex", (Object)exception)).log();
                }
                if (FxImageHandler.a.level < 1) break block10;
                ((LevelAwareLogBuilder)a.lvlBuild(1, "updateRobot()", 538).add("No Fx Robot available - Creating screenshots won't work")).log();
            }
        }
        this.k = System.currentTimeMillis();
    }

    private void a() {
        if (FxImageHandler.a.level >= 7) {
            a.lvlBuild(7, "updateNativeDelegate()", 546).log();
        }
        this.l = null;
        String string = Options.cached_OPT_DEFAULT_SCREENSHOT_TECHNOLOGY;
        if (FxImageHandler.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "updateNativeDelegate()", 550).add("defaultTechnology", string)).log();
        }
        for (String string2 : string.split(",")) {
            NativeRobot nativeRobot;
            if ("native".equals(string2) && (nativeRobot = Native.instance().getNativeRobot()) != null) {
                this.l = new NativeImageHandler(nativeRobot);
                return;
            }
            if ("fx".equals(string2)) break;
        }
    }

    public BaseImageHelper getHelper() {
        return this.i;
    }
}

