/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.fx.image;

import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.apps.qftest.shared.image.BaseImageHelper;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.io.InputStream;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritablePixelFormat;

public class FxImageHelper
extends BaseImageHelper {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.client.fx.image.FxImageHelper");
    private static FxImageHelper instance = new FxImageHelper();

    protected FxImageHelper() {
        if (FxImageHelper.logger.level >= 7) {
            logger.lvlBuild(7, "FxImageHelper()", 61).log();
        }
    }

    public static synchronized FxImageHelper instance() {
        if (instance == null) {
            instance = new FxImageHelper();
        }
        return instance;
    }

    public static final int[] getARGB(Image image) {
        if (FxImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getARGB(Image)", 101).addDetail("image", (Object)image)).log();
        }
        PixelReader pixelReader = image.getPixelReader();
        int n2 = (int)image.getWidth();
        int n3 = (int)image.getHeight();
        WritablePixelFormat writablePixelFormat = WritablePixelFormat.getIntArgbInstance();
        int[] nArray = new int[n2 * n3];
        pixelReader.getPixels(0, 0, n2, n3, writablePixelFormat, nArray, 0, n2);
        return nArray;
    }

    public ImageRep createImageRep(InputStream inputStream) {
        int[] nArray;
        Image image;
        if (FxImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createImageRep(InputStream)", 118).addDetail("stream", (Object)inputStream)).log();
        }
        if (null != (image = new Image(inputStream)) && null != (nArray = FxImageHelper.getARGB(image))) {
            ImageRep imageRep = new ImageRep(null, nArray, ImageRep.CompressionMode.BINARY, (int)image.getWidth(), (int)image.getHeight());
            return imageRep;
        }
        return null;
    }
}

