/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.fx.items;

import de.qfs.apps.qftest.client.Engine;
import de.qfs.apps.qftest.client.RetryException;
import de.qfs.apps.qftest.client.fx.FxHelper;
import de.qfs.apps.qftest.client.fx.items.ListItemResolver;
import de.qfs.apps.qftest.extensions.ResolverRegistry;
import de.qfs.apps.qftest.extensions.items.ItemParentResolver;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.extensions.items.ItemValueResolver;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.BaseHelper;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Reflector;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Skin;
import javafx.stage.PopupWindow;
import javafx.stage.Window;
import javafx.util.StringConverter;

public class ComboBoxItemResolver
implements ItemParentResolver {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.fx.items.ComboBoxItemResolver");
    protected FxHelper helper;
    protected boolean excludeHiddenItems;
    protected String[] comboClasses;
    protected String[] itemClasses;
    protected ComboItemValueResolver itemValueResolver = new ComboItemValueResolver();

    public ComboBoxItemResolver(FxHelper fxHelper) {
        this(fxHelper, new String[]{"ComboBox"}, new String[]{"Item:ComboBoxListItem"});
    }

    public ComboBoxItemResolver(FxHelper fxHelper, String string, String string2) {
        this(fxHelper, new String[]{string}, new String[]{string2});
    }

    public ComboBoxItemResolver(FxHelper fxHelper, String[] stringArray, String[] stringArray2) {
        if (ComboBoxItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "ComboBoxItemResolver(FxHelper,String[],String[])", 132).addDetail("helper", (Object)fxHelper)).addDetail("comboClasses", (Object)stringArray)).addDetail("itemClasses", (Object)stringArray2)).log();
        }
        this.helper = fxHelper;
        this.comboClasses = stringArray;
        this.itemClasses = stringArray2;
    }

    public static ComboBoxItemResolver createAndRegister(FxHelper fxHelper) {
        return ComboBoxItemResolver.createAndRegister(fxHelper, new String[]{"ComboBox"}, new String[]{"Item:ComboBoxListItem"});
    }

    public static ComboBoxItemResolver createAndRegister(FxHelper fxHelper, String string, String string2) {
        return ComboBoxItemResolver.createAndRegister(fxHelper, new String[]{string}, new String[]{string2});
    }

    public static ComboBoxItemResolver createAndRegister(FxHelper fxHelper, String[] stringArray, String[] stringArray2) {
        if (ComboBoxItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createAndRegister(FxHelper,String[],String[])", 187).addDetail("helper", (Object)fxHelper)).addDetail("comboClasses", (Object)stringArray)).addDetail("itemClasses", (Object)stringArray2)).log();
        }
        ComboBoxItemResolver comboBoxItemResolver = new ComboBoxItemResolver(fxHelper, stringArray, stringArray2);
        for (String string : stringArray) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)comboBoxItemResolver);
            ItemRegistry.instance().registerItemValueResolver(string, comboBoxItemResolver.getItemValueResolver());
        }
        for (String string : stringArray2) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)comboBoxItemResolver);
        }
        ItemRegistry.instance().registerItemParentResolver("Button", (ItemParentResolver)comboBoxItemResolver);
        ItemRegistry.instance().registerItemParentResolver("TextField", (ItemParentResolver)comboBoxItemResolver);
        return comboBoxItemResolver;
    }

    public void unregister() {
        for (String string : this.comboClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
            ItemRegistry.instance().unregisterItemValueResolver(string, (ItemValueResolver)this.itemValueResolver);
        }
        for (String string : this.itemClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
        }
    }

    public final void setExcludeHiddenItems(boolean bl2) {
        if (ComboBoxItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setExcludeHiddenItems(boolean)", 231).addDetail("excludeHiddenItems", bl2)).log();
        }
        this.excludeHiddenItems = bl2;
    }

    @Override
    public Object[] getParentAndItem(Object object) {
        Object object2;
        if (ComboBoxItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getParentAndItem(Object)", 253).addDetail("element", object)).log();
        }
        if (ComboBoxItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getParentAndItem(Object)", 255).add("cls", (Object)this.helper.getClassNames(object))).log();
        }
        if (this.helper.isMatchingClass(object, this.itemClasses)) {
            if (this.helper.isMatchingClass(object, FxHelper.CLASS_MenuItemContainer)) {
                int n2;
                object2 = Reflector.safeCall((Object)object, (String)"getItem");
                if (ComboBoxItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getParentAndItem(Object)", 262).add("menuItem", object2)).log();
                }
                if (object2 instanceof MenuItem && ((MenuItem)object2).getParentMenu() == null && ((MenuItem)object2).getParentPopup() != null && (n2 = ((MenuItem)object2).getParentPopup().getItems().indexOf(object2)) >= 0) {
                    return new Object[]{this.helper.safeGetOwnerNode((PopupWindow)((MenuItem)object2).getParentPopup()), n2};
                }
            }
            if (object instanceof ListCell) {
                object2 = (ListCell)object;
                ListView listView = object2.getListView();
                int n3 = listView.getItems().indexOf(object2.getItem());
                Object object3 = this.helper.getProperty(Reflector.safeGet((Object)listView.getParent(), (String)"this$0", (boolean)true), "qfs:invoker");
                if (object3 != null && object3 instanceof ComboBox) {
                    return new Object[]{object3, n3};
                }
            }
        }
        if (object instanceof Node && (object2 = this.helper.getAncestorOfClass(object, "javafx.scene.control.ComboBox", 3)) instanceof ComboBox && ((ComboBox)object2).isEditable() && (this.helper.isMatchingClass(object, "TextField") || this.helper.isMatchingClass(object, "Button"))) {
            return new Object[]{object2, object};
        }
        return null;
    }

    @Override
    public Object getElement(Object object, Object object2) throws TestException {
        ObservableList observableList;
        ListView listView;
        if (ComboBoxItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getElement(Object,Object)", 321).addDetail("element", object)).addDetail("item", object2)).log();
        }
        if (!this.checkItem(object, object2)) {
            return null;
        }
        if (object instanceof ComboBox) {
            listView = this.a((ComboBox)object);
            if (ComboBoxItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getElement(Object,Object)", 331).add("list", (Object)listView)).log();
            }
            if (listView != null && this.helper.isVisible(listView) && (observableList = ListItemResolver.getCell(listView, (Integer)object2)) != null) {
                if (ComboBoxItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getElement(Object,Object)", 337).add("element", (Object)observableList)).log();
                }
                return observableList;
            }
        }
        if (object instanceof ChoiceBox && (listView = this.a((ChoiceBox)object)) != null && (observableList = listView.getItems()) != null && observableList.size() > 0 && observableList.size() > (Integer)object2) {
            MenuItem menuItem = (MenuItem)observableList.get(((Integer)object2).intValue());
            Object[] objectArray = this.helper.getElementsByClassName((Object)listView, "Item");
            if (objectArray != null) {
                for (Object object3 : objectArray) {
                    if (!this.helper.isMatchingClass(object3, FxHelper.CLASS_MenuItemContainer) || !menuItem.equals(Reflector.safeCall((Object)object3, (String)"getItem"))) continue;
                    if (ComboBoxItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getElement(Object,Object)", 360).add("element", object3)).log();
                    }
                    return object3;
                }
            }
        }
        if (ComboBoxItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getElement(Object,Object)", 370).add("Could not get cell")).log();
        }
        RetryException.throwEither((TestException)((Object)new BadItemException("Cannot find cell for item " + object2)), 10L);
        if (ComboBoxItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getElement(Object,Object)", 374).add("element: null")).log();
        }
        return null;
    }

    @Override
    public Object getItemForIndex(Object object, SubItemIndex[] subItemIndexArray) throws TestException {
        SubItemIndex subItemIndex;
        int n2;
        int n3;
        block8: {
            block7: {
                if (ComboBoxItemResolver.a.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForIndex(Object,SubItemIndex[])", 396).addDetail("element", object)).addDetail("idx", (Object)subItemIndexArray)).log();
                }
                if (!this.checkItem(object, null)) {
                    return null;
                }
                n3 = -1;
                n2 = this.a(object);
                if (n2 == 0) {
                    return null;
                }
                subItemIndex = subItemIndexArray[0];
                if (subItemIndex.getType() != 1) break block7;
                n3 = subItemIndex.asNumber();
                if (n3 >= 0) break block8;
                n3 = n2 + n3;
                break block8;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!subItemIndex.matches(ComboBoxItemResolver.getResolvedName(object, i2))) continue;
                n3 = i2;
                break;
            }
        }
        if (ComboBoxItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 424).add("item", n3)).log();
        }
        if (n3 < 0 || n3 >= n2) {
            if (ComboBoxItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 426).add("item[0]", n3)).dumpStack();
            }
            throw new IndexNotFoundException(subItemIndex);
        }
        return n3;
    }

    @Override
    public SubItemIndex[] getItemIndex(Object object, Object object2, int n2) throws BadItemException {
        if (ComboBoxItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object,int)", 449).addDetail("element", object)).addDetail("item", object2)).addDetail("type", n2)).log();
        }
        if (object2 == null) {
            return null;
        }
        if (this.helper.isMatchingClass(object2, "Button")) {
            return new SubItemIndex[]{new SubItemIndex(Options.cached_OPT_RECORD_SMARTID_INSTEAD_OF_QPATH ? "#Button:" : ":Button", "\\@&%")};
        }
        if (this.helper.isMatchingClass(object2, "TextField")) {
            return new SubItemIndex[]{new SubItemIndex(Options.cached_OPT_RECORD_SMARTID_INSTEAD_OF_QPATH ? "#TextField:" : ":TextField", "\\@&%")};
        }
        if (!this.checkItem(object, object2)) {
            return null;
        }
        int n3 = this.a(object);
        int n4 = (Integer)object2;
        SubItemIndex[] subItemIndexArray = new SubItemIndex[1];
        switch (n2) {
            case 3: {
                subItemIndexArray[0] = new SubItemIndex(n4);
                break;
            }
            case 1: 
            case 2: {
                subItemIndexArray[0] = new SubItemIndex(ComboBoxItemResolver.getResolvedName(object, n4), "\\#@&%");
            }
        }
        if (ComboBoxItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 490).add("result", (Object)subItemIndexArray)).log();
        }
        return subItemIndexArray;
    }

    public static String getName(Object object, int n2) {
        if (ComboBoxItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getName(Object,int)", 510).addDetail("cb", object)).addDetail("item", n2)).log();
        }
        String string = ResolverRegistry.instance().getItemName(object, n2, null);
        if (ComboBoxItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getName(Object,int)", 514).add("name1", string)).log();
        }
        if (string == null) {
            String string2 = ComboBoxItemResolver.getTextFromItem(object, n2);
            if (ComboBoxItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getName(Object,int)", 518).add("txt", string2)).log();
            }
            string = Util.getFlatIdentifierText((String)string2);
            if (ComboBoxItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getName(Object,int)", 520).add("name2", string)).log();
            }
        }
        return string;
    }

    public static String getResolvedName(Object object, int n2) {
        FxHelper fxHelper;
        if (ComboBoxItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getResolvedName(Object,int)", 536).addDetail("cb", object)).addDetail("item", n2)).log();
        }
        if ((fxHelper = (FxHelper)Engine.helperFor(object)) == null) {
            return "";
        }
        String string = ComboBoxItemResolver.getName(object, n2);
        return ItemRegistry.instance().getItemName(object, fxHelper.getClassNames(object), n2, string);
    }

    public static String getValue(Object object, int n2) {
        if (ComboBoxItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getValue(Object,int)", 558).addDetail("cb", object)).addDetail("item", n2)).log();
        }
        String string = ComboBoxItemResolver.getTextFromItem(object, n2);
        if (ComboBoxItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getValue(Object,int)", 561).add("txt", string)).log();
        }
        return Util.getCleanElementText((String)string);
    }

    public static String getResolvedValue(Object object, int n2) {
        FxHelper fxHelper;
        if (ComboBoxItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getResolvedValue(Object,int)", 576).addDetail("cb", object)).addDetail("item", n2)).log();
        }
        if ((fxHelper = (FxHelper)Engine.helperFor(object)) == null) {
            return "";
        }
        String string = ComboBoxItemResolver.getValue(object, n2);
        return ItemRegistry.instance().resolveItemValue(object, fxHelper.getClassNames(object), n2, string);
    }

    public final ItemValueResolver getItemValueResolver() {
        return this.itemValueResolver;
    }

    protected boolean checkItem(Object object, Object object2) throws BadItemException {
        if (!this.helper.isMatchingClass(object, this.comboClasses)) {
            if (ComboBoxItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "checkItem(Object,Object)", 627).add("Not a ComboBox or ChoiceBox", object)).dumpStack();
            }
            return false;
        }
        if (object2 != null && !(object2 instanceof Integer)) {
            if (ComboBoxItemResolver.a.level >= 5) {
                ((LevelAwareLogBuilder)a.lvlBuild(5, "checkItem(Object,Object)", 631).add("Internal error: Not an int", object2)).dumpStack();
            }
            throw new BadItemException("Not an int: " + object2);
        }
        return true;
    }

    private int a(Object object) {
        return ((List)Reflector.safeCall((Object)object, (String)"getItems")).size();
    }

    public static String getTextFromItem(Object object, int n2) {
        if (ComboBoxItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getTextFromItem(Object,int)", 649).addDetail("cb", object)).addDetail("item", n2)).log();
        }
        StringConverter stringConverter = (StringConverter)Reflector.safeCall((Object)object, (String)"getConverter");
        if (ComboBoxItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getTextFromItem(Object,int)", 652).add("converter", (Object)stringConverter)).log();
        }
        List list = (List)Reflector.safeCall((Object)object, (String)"getItems");
        if (ComboBoxItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getTextFromItem(Object,int)", 654).add("items", (Object)list)).log();
        }
        String string = null;
        string = stringConverter != null ? stringConverter.toString(list.get(n2)) : list.get(n2).toString();
        return string;
    }

    private ListView a(ComboBox comboBox) {
        Object[] objectArray;
        if (ComboBoxItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getListViewFromComboBox(ComboBox)", 676).addDetail("element", (Object)comboBox)).log();
        }
        Object object = this.helper.getProperty(comboBox, "qfs:popup");
        if (ComboBoxItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getListViewFromComboBox(ComboBox)", 679).add("cached popup", object)).log();
        }
        if (object instanceof Window) {
            objectArray = this.helper.getElementsByClassName(object, "javafx.scene.control.ListView");
            if (ComboBoxItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getListViewFromComboBox(ComboBox)", 682).add("lists", (Object)objectArray)).log();
            }
            if (objectArray.length == 1) {
                return (ListView)objectArray[0];
            }
        }
        objectArray = this.helper.getElementsByClassName((Object)comboBox, FxHelper.CLASS_ComboBoxBaseSkin);
        if (ComboBoxItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getListViewFromComboBox(ComboBox)", 689).add("skins", (Object)objectArray)).log();
        }
        if (objectArray != null && objectArray.length == 1) {
            object = Reflector.safeGet((Object)objectArray[0], (String)"popup", (boolean)true);
            if (ComboBoxItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getListViewFromComboBox(ComboBox)", 693).add("popup", object)).log();
            }
            if (object != null) {
                Object object2 = Reflector.safeGet((Object)object, (String)"this$0", (boolean)true);
                if (ComboBoxItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getListViewFromComboBox(ComboBox)", 697).add("skin", object2)).log();
                }
                if (object2 != null) {
                    Object object3 = Reflector.safeCall((Object)object2, (String)"getPopupContent");
                    if (ComboBoxItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getListViewFromComboBox(ComboBox)", 701).add("list", object3)).log();
                    }
                    if (object3 != null && object3 instanceof ListView) {
                        return (ListView)object3;
                    }
                }
            }
        } else {
            Object[] objectArray2 = this.helper.getElementsByClassName((Object)comboBox, "javafx.scene.control.ListCell");
            if (ComboBoxItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getListViewFromComboBox(ComboBox)", 711).add("cells", (Object)objectArray2)).log();
            }
            if (objectArray2 != null && objectArray2.length > 0 && objectArray2[0] instanceof ListCell) {
                ListView listView = ((ListCell)objectArray2[0]).getListView();
                if (ComboBoxItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getListViewFromComboBox(ComboBox)", 716).add("ret", (Object)listView)).log();
                }
                return listView;
            }
        }
        return null;
    }

    private ContextMenu a(ChoiceBox choiceBox) {
        Object object;
        Skin skin;
        if (ComboBoxItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getChoiceBoxContextMenu(ChoiceBox)", 732).addDetail("element", (Object)choiceBox)).log();
        }
        if ((skin = choiceBox.getSkin()) != null && (object = Reflector.safeGet((Object)skin, (String)"popup", (boolean)true)) instanceof ContextMenu) {
            return (ContextMenu)object;
        }
        return null;
    }

    public class ComboItemValueResolver
    implements ItemValueResolver,
    BaseHelper {
        public ComboItemValueResolver() {
            if (a.level >= 7) {
                a.lvlBuild(7, "ComboItemValueResolver.ComboItemValueResolver()", 755).log();
            }
        }

        @Override
        public String getItemValue(Object object, Object object2) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "ComboItemValueResolver.getItemValue(Object,Object)", 773).addDetail("element", object)).addDetail("item", object2)).log();
            }
            if (object2 == null) {
                return null;
            }
            try {
                if (!ComboBoxItemResolver.this.checkItem(object, object2)) {
                    return null;
                }
            }
            catch (BadItemException badItemException) {
                if (a.level >= 3) {
                    ((LevelAwareLogBuilder)a.lvlBuild(3, "ComboItemValueResolver.getItemValue(Object,Object)", 783).add("ex", (Object)badItemException)).log();
                }
                return null;
            }
            return ComboBoxItemResolver.getValue(object, (Integer)object2);
        }
    }
}

