/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.fx.items;

import de.qfs.apps.qftest.client.Engine;
import de.qfs.apps.qftest.client.RetryException;
import de.qfs.apps.qftest.client.fx.FxHelper;
import de.qfs.apps.qftest.client.fx.ag;
import de.qfs.apps.qftest.client.fx.j;
import de.qfs.apps.qftest.extensions.ResolverRegistry;
import de.qfs.apps.qftest.extensions.items.ItemParentResolver;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.extensions.items.ItemValueResolver;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.BaseHelper;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Pair;
import de.qfs.lib.util.Reflector;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.collections.ObservableList;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;

public class ListItemResolver
implements ItemParentResolver {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.fx.items.ListItemResolver");
    private static final Map b = new WeakHashMap();
    private static Pair c;
    protected FxHelper helper;
    protected String[] listClasses;
    protected String[] itemClasses;
    protected ListItemValueResolver itemValueResolver = new ListItemValueResolver();

    public ListItemResolver(FxHelper fxHelper) {
        this(fxHelper, new String[]{"List"}, new String[]{"Item:ListItem"});
    }

    public ListItemResolver(FxHelper fxHelper, String string, String string2) {
        this(fxHelper, new String[]{string}, new String[]{string2});
    }

    public ListItemResolver(FxHelper fxHelper, String[] stringArray, String[] stringArray2) {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "ListItemResolver(FxHelper,String[],String[])", 138).addDetail("helper", (Object)fxHelper)).addDetail("listClasses", (Object)stringArray)).addDetail("itemClasses", (Object)stringArray2)).log();
        }
        this.helper = fxHelper;
        this.listClasses = stringArray;
        this.itemClasses = stringArray2;
    }

    public static ListItemResolver createAndRegister(FxHelper fxHelper) {
        return ListItemResolver.createAndRegister(fxHelper, new String[]{"List"}, new String[]{"Item:ListItem"});
    }

    public static ListItemResolver createAndRegister(FxHelper fxHelper, String string, String string2) {
        return ListItemResolver.createAndRegister(fxHelper, new String[]{string}, new String[]{string2});
    }

    public static ListItemResolver createAndRegister(FxHelper fxHelper, String[] stringArray, String[] stringArray2) {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createAndRegister(FxHelper,String[],String[])", 192).addDetail("helper", (Object)fxHelper)).addDetail("listClasses", (Object)stringArray)).addDetail("itemClasses", (Object)stringArray2)).log();
        }
        ListItemResolver listItemResolver = new ListItemResolver(fxHelper, stringArray, stringArray2);
        for (String string : stringArray) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)listItemResolver);
            ItemRegistry.instance().registerItemValueResolver(string, listItemResolver.getItemValueResolver());
        }
        for (String string : stringArray2) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)listItemResolver);
        }
        return listItemResolver;
    }

    public void unregister() {
        for (String string : this.listClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
            ItemRegistry.instance().unregisterItemValueResolver(string, (ItemValueResolver)this.itemValueResolver);
        }
        for (String string : this.itemClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
        }
    }

    @Override
    public Object[] getParentAndItem(Object object) {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getParentAndItem(Object)", 242).addDetail("element", object)).log();
        }
        if (this.helper.isMatchingClass(object, this.itemClasses)) {
            Object object2 = this.helper.getAncestorOfClass(object, this.listClasses);
            int n2 = (Integer)Reflector.safeCall((Object)object, (String)"getIndex");
            if (object2 instanceof ListView && ((ListView)object2).getItems().size() <= n2) {
                if (ListItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getParentAndItem(Object)", 253).add("Row out of bounds", n2)).log();
                }
                return null;
            }
            return new Object[]{object2, n2};
        }
        return null;
    }

    @Override
    public Object getElement(Object object, Object object2) throws TestException {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getElement(Object,Object)", 275).addDetail("element", object)).addDetail("item", object2)).log();
        }
        if (!this.a(object, object2)) {
            return null;
        }
        ListCell listCell = ListItemResolver.getCell((ListView)object, (Integer)object2);
        if (listCell != null) {
            return listCell;
        }
        RetryException.throwEither((TestException)((Object)new BadItemException("Cannot find cell for item " + object2)), 10L);
        return null;
    }

    @Override
    public Object getItemForIndex(Object object, SubItemIndex[] subItemIndexArray) throws TestException {
        SubItemIndex subItemIndex;
        int n2;
        int n3;
        block7: {
            ListView listView;
            block6: {
                if (ListItemResolver.a.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForIndex(Object,SubItemIndex[])", 308).addDetail("element", object)).addDetail("idx", (Object)subItemIndexArray)).log();
                }
                if (!this.a(object, null)) {
                    return null;
                }
                listView = (ListView)object;
                n3 = -1;
                n2 = ListItemResolver.getRowCount(listView);
                if (n2 == 0) {
                    return null;
                }
                subItemIndex = subItemIndexArray[0];
                if (subItemIndex.getType() != 1) break block6;
                n3 = subItemIndex.asNumber();
                if (n3 >= 0) break block7;
                n3 = n2 + n3;
                break block7;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!subItemIndex.matches(ListItemResolver.getResolvedName(listView, i2))) continue;
                n3 = i2;
                break;
            }
        }
        if (n3 < 0 || n3 >= n2) {
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 340).add("item[0]", n3)).dumpStack();
            }
            throw new IndexNotFoundException(subItemIndex);
        }
        return n3;
    }

    @Override
    public SubItemIndex[] getItemIndex(Object object, Object object2, int n2) throws BadItemException {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object,int)", 362).addDetail("element", object)).addDetail("item", object2)).addDetail("type", n2)).log();
        }
        if (object2 == null) {
            return null;
        }
        if (!this.a(object, object2)) {
            return null;
        }
        ListView listView = (ListView)object;
        int n3 = ListItemResolver.getRowCount(listView);
        int n4 = (Integer)object2;
        SubItemIndex[] subItemIndexArray = new SubItemIndex[1];
        switch (n2) {
            case 3: {
                subItemIndexArray[0] = new SubItemIndex(n4);
                break;
            }
            case 1: {
                boolean bl2;
                String string = ListItemResolver.getResolvedName(listView, n4);
                if (ListItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 389).add("name", string)).log();
                }
                boolean bl3 = bl2 = string != null && string.length() > 0;
                if (ListItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 391).add("unique", bl2)).log();
                }
                if (bl2) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        if (i2 == n4) continue;
                        String string2 = ListItemResolver.getResolvedName(listView, i2);
                        if (ListItemResolver.a.level >= 9) {
                            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 396).add("iname", string2)).log();
                        }
                        if (!Misc.equalOrNull((Object)string, (Object)string2)) continue;
                        bl2 = false;
                        break;
                    }
                }
                subItemIndexArray[0] = bl2 ? new SubItemIndex(string, "\\#@&%") : new SubItemIndex(n4);
                break;
            }
            case 2: {
                subItemIndexArray[0] = new SubItemIndex(ListItemResolver.getResolvedName(listView, n4), "\\#@&%");
            }
        }
        if (ListItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 414).add("result", (Object)subItemIndexArray)).log();
        }
        return subItemIndexArray;
    }

    public static int getRowCount(ListView listView) {
        return listView.getItems().size();
    }

    public static ListCell getCell(ListView listView, int n2) {
        ListCell listCell = ListItemResolver.a(listView, n2);
        if (listCell == null) {
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getCell(ListView,int)", 458).add("scrolling to item", n2)).log();
            }
            listView.scrollTo(n2);
            j j2 = (j)Engine.engineFor(listView);
            if (j2 == null) {
                if (ListItemResolver.a.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "getCell(ListView,int)", 462).add("No engine for ")).add((Object)listView)).log();
                }
            } else {
                ((ag)j2.getPlayer()).a(500L);
            }
            listCell = ListItemResolver.a(listView, n2);
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getCell(ListView,int)", 469).add("cell", (Object)listCell)).log();
            }
        }
        return listCell;
    }

    public static ListCell getOrCreateCell(ListView listView, int n2) {
        ListCell listCell;
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getOrCreateCell(ListView,int)", 485).addDetail("list", (Object)listView)).addDetail("item", n2)).log();
        }
        ListCell listCell2 = listCell = listView.getEditingIndex() == n2 ? null : ListItemResolver.a(listView, n2);
        if (listCell != null) {
            return listCell;
        }
        return ListItemResolver.createCell(listView, n2);
    }

    public static ListCell createCell(ListView listView, int n2) {
        ListCell listCell;
        block14: {
            Pair pair;
            if (ListItemResolver.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createCell(ListView,int)", 509).addDetail("list", (Object)listView)).addDetail("item", n2)).log();
            }
            Object object = listView.getItems().get(n2);
            listCell = null;
            Callback callback = listView.getCellFactory();
            WeakReference weakReference = (WeakReference)b.get(listView);
            if (weakReference != null && (pair = (Pair)weakReference.get()) != null && Misc.equalOrNull((Object)pair.getFirst(), (Object)callback)) {
                listCell = (ListCell)pair.getSecond();
                if (ListItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "createCell(ListView,int)", 520).add("cached cell", (Object)listCell)).log();
                }
                if (listCell != null) {
                    c = pair;
                }
            }
            if (listCell == null) {
                if (callback != null) {
                    listCell = (ListCell)callback.call((Object)listView);
                } else {
                    try {
                        listCell = (ListCell)Reflector.call((Object)listView.getSkin(), (String)"createCell", (boolean)true);
                    }
                    catch (Throwable throwable) {
                        if (ListItemResolver.a.level >= 5) {
                            ((LevelAwareLogBuilder)a.lvlBuild(5, "createCell(ListView,int)", 534).add("ex", (Object)throwable)).log();
                        }
                        return null;
                    }
                }
                if (ListItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "createCell(ListView,int)", 538).add("created cell", (Object)listCell)).log();
                }
                c = new Pair((Object)callback, (Object)listCell);
                b.put(listView, new WeakReference<Pair>(c));
            }
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "createCell(ListView,int)", 542).add("cellCache size", b.size())).log();
            }
            try {
                listCell.setItem(object);
                Reflector.call((Object)listCell, (String)"updateItem", (Class[])new Class[]{Object.class, Boolean.TYPE}, (Object[])new Object[]{object, Boolean.FALSE}, (boolean)true);
            }
            catch (Throwable throwable) {
                if (ListItemResolver.a.level < 3) break block14;
                ((LevelAwareLogBuilder)a.lvlBuild(3, "createCell(ListView,int)", 550).add("ex", (Object)throwable)).log();
            }
        }
        return listCell;
    }

    public static String getName(ListView listView, int n2) {
        ListCell listCell;
        FxHelper fxHelper;
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getName(ListView,int)", 566).addDetail("list", (Object)listView)).addDetail("item", n2)).log();
        }
        if ((fxHelper = (FxHelper)Engine.helperFor(listView)) == null) {
            return "";
        }
        String string = ResolverRegistry.instance().getItemName(listView, n2, null);
        if (string == null && (listCell = ListItemResolver.getOrCreateCell(listView, n2)) != null) {
            string = fxHelper.getFlatIdentifierText(listCell);
        }
        return string;
    }

    public static String getResolvedName(ListView listView, int n2) {
        FxHelper fxHelper;
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getResolvedName(ListView,int)", 596).addDetail("list", (Object)listView)).addDetail("item", n2)).log();
        }
        if ((fxHelper = (FxHelper)Engine.helperFor(listView)) == null) {
            return "";
        }
        String string = ListItemResolver.getName(listView, n2);
        return ItemRegistry.instance().getItemName(listView, fxHelper.getClassNames(listView), n2, string);
    }

    public static String getValue(ListView listView, int n2) {
        FxHelper fxHelper;
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getValue(ListView,int)", 618).addDetail("list", (Object)listView)).addDetail("item", n2)).log();
        }
        if ((fxHelper = (FxHelper)Engine.helperFor(listView)) == null) {
            return "";
        }
        ListCell listCell = ListItemResolver.getOrCreateCell(listView, n2);
        if (listCell != null) {
            return Util.getCleanElementText((String)fxHelper.getWholeText(listCell));
        }
        return null;
    }

    public static String getResolvedValue(ListView listView, int n2) {
        FxHelper fxHelper;
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getResolvedValue(ListView,int)", 642).addDetail("list", (Object)listView)).addDetail("item", n2)).log();
        }
        if ((fxHelper = (FxHelper)Engine.helperFor(listView)) == null) {
            return "";
        }
        String string = ListItemResolver.getValue(listView, n2);
        return ItemRegistry.instance().resolveItemValue(listView, fxHelper.getClassNames(listView), n2, string);
    }

    public final ItemValueResolver getItemValueResolver() {
        return this.itemValueResolver;
    }

    private boolean a(Object object, Object object2) throws BadItemException {
        if (!this.helper.isMatchingClass(object, this.listClasses)) {
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "checkItem(Object,Object)", 693).add("Not a ListView", object)).dumpStack();
            }
            return false;
        }
        if (object2 != null && !(object2 instanceof Integer)) {
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "checkItem(Object,Object)", 698).add("Internal error: Not an int", object2)).dumpStack();
            }
            throw new BadItemException("Not an int: " + object2);
        }
        return true;
    }

    private static ListCell a(ListView listView, int n2) {
        ObservableList observableList;
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getListCell(ListView,int)", 715).addDetail("list", (Object)listView)).addDetail("item", n2)).log();
        }
        if (n2 >= (observableList = listView.getItems()).size()) {
            return null;
        }
        Object e2 = observableList.get(n2);
        for (Object object : Engine.engineFor(listView).getElementHelper().getElementsByClassName((Object)listView, "javafx.scene.control.ListCell")) {
            if (((ListCell)object).getIndex() != n2 || ((ListCell)object).getItem() != e2 || !((ListCell)object).isVisible()) continue;
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getListCell(ListView,int)", 733).add("got cell", object)).log();
            }
            return (ListCell)object;
        }
        return null;
    }

    public class ListItemValueResolver
    implements ItemValueResolver,
    BaseHelper {
        public ListItemValueResolver() {
            if (a.level >= 7) {
                a.lvlBuild(7, "ListItemValueResolver.ListItemValueResolver()", 747).log();
            }
        }

        @Override
        public String getItemValue(Object object, Object object2) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "ListItemValueResolver.getItemValue(Object,Object)", 765).addDetail("element", object)).addDetail("item", object2)).log();
            }
            if (object2 == null) {
                return null;
            }
            try {
                if (!ListItemResolver.this.a(object, object2)) {
                    return null;
                }
            }
            catch (BadItemException badItemException) {
                if (a.level >= 3) {
                    ((LevelAwareLogBuilder)a.lvlBuild(3, "ListItemValueResolver.getItemValue(Object,Object)", 775).add("ex", (Object)badItemException)).log();
                }
                return null;
            }
            return ListItemResolver.getValue((ListView)object, (Integer)object2);
        }
    }
}

