/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.fx.items;

import de.qfs.apps.qftest.client.Engine;
import de.qfs.apps.qftest.client.RetryException;
import de.qfs.apps.qftest.client.fx.FxHelper;
import de.qfs.apps.qftest.client.fx.ag;
import de.qfs.apps.qftest.client.fx.j;
import de.qfs.apps.qftest.extensions.items.ItemParentResolver;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.extensions.items.ItemValueResolver;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.BaseHelper;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Pair;
import de.qfs.lib.util.Reflector;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.util.Callback;

public class TableItemResolver
implements ItemParentResolver {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.fx.items.TableItemResolver");
    public static final String CLASS_TABLE = "javafx.scene.control.TableView";
    public static final String CLASS_TABLE_CELL = "javafx.scene.control.TableCell";
    public static final String CLASS_TABLE_HEADER_CELL = FxHelper.CLASS_TableColumnHeader;
    private static final Map b = new WeakHashMap();
    private static Pair c;
    protected FxHelper helper;
    protected String[] tableClasses;
    protected String[] cellClasses;
    protected String[] headerClasses;
    protected TableItemValueResolver itemValueResolver = new TableItemValueResolver();

    public TableItemResolver(FxHelper fxHelper) {
        this.helper = fxHelper;
    }

    public TableItemResolver(FxHelper fxHelper, String string, String string2, String string3) {
        this(fxHelper, new String[]{string}, new String[]{string2}, new String[]{string3});
    }

    public TableItemResolver(FxHelper fxHelper, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "TableItemResolver(FxHelper,String[],String[],String[])", 168).addDetail("helper", (Object)fxHelper)).addDetail("tableClasses", (Object)stringArray)).addDetail("cellClasses", (Object)stringArray2)).addDetail("headerClasses", (Object)stringArray3)).log();
        }
        this.helper = fxHelper;
        this.tableClasses = stringArray;
        this.cellClasses = stringArray2;
        this.headerClasses = stringArray3;
    }

    public static TableItemResolver createAndRegister(FxHelper fxHelper) {
        return TableItemResolver.createAndRegister(fxHelper, new String[]{CLASS_TABLE}, new String[]{CLASS_TABLE_CELL}, new String[]{CLASS_TABLE_HEADER_CELL});
    }

    public static TableItemResolver createAndRegister(FxHelper fxHelper, String string, String string2, String string3) {
        return TableItemResolver.createAndRegister(fxHelper, new String[]{string}, new String[]{string2}, new String[]{string3});
    }

    public static TableItemResolver createAndRegister(FxHelper fxHelper, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createAndRegister(FxHelper,String[],String[],String[])", 231).addDetail("helper", (Object)fxHelper)).addDetail("tableClasses", (Object)stringArray)).addDetail("cellClasses", (Object)stringArray2)).addDetail("headerClasses", (Object)stringArray3)).log();
        }
        TableItemResolver tableItemResolver = new TableItemResolver(fxHelper, stringArray, stringArray2, stringArray3);
        for (String string : stringArray) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)tableItemResolver);
            ItemRegistry.instance().registerItemValueResolver(string, tableItemResolver.getItemValueResolver());
        }
        for (String string : stringArray2) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)tableItemResolver);
        }
        for (String string : stringArray3) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)tableItemResolver);
        }
        return tableItemResolver;
    }

    public void unregister() {
        for (String string : this.tableClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
            ItemRegistry.instance().unregisterItemValueResolver(string, (ItemValueResolver)this.itemValueResolver);
        }
        for (String string : this.cellClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
        }
    }

    @Override
    public Object[] getParentAndItem(Object object) {
        block9: {
            if (TableItemResolver.a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "getParentAndItem(Object)", 285).addDetail("element", object)).log();
            }
            if (object instanceof TableCell) {
                TableCell tableCell = (TableCell)object;
                TableView tableView = tableCell.getTableView();
                int n2 = TableItemResolver.getVisibleColumns(tableView).indexOf(tableCell.getTableColumn());
                int n3 = tableCell.getTableRow().getIndex();
                return new Object[]{tableView, new int[]{n2, n3}};
            }
            if (this.helper.isMatchingClass(object, this.headerClasses)) {
                Object object2 = object;
                try {
                    Object object3 = Reflector.call((Object)object, (String)"getTableColumn");
                    if (TableItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getParentAndItem(Object)", 301).add("column", object3)).log();
                    }
                    if (!(object3 instanceof TableColumn)) {
                        return null;
                    }
                    TableView tableView = ((TableColumn)object3).getTableView();
                    if (((TableColumn)object3).getColumns().size() > 0) {
                        return new Object[]{tableView, object3};
                    }
                    int n4 = TableItemResolver.getVisibleColumns(tableView).indexOf(object3);
                    if (n4 < 0) {
                        return null;
                    }
                    return new Object[]{tableView, new int[]{n4, -1}};
                }
                catch (Throwable throwable) {
                    if (TableItemResolver.a.level < 5) break block9;
                    ((LevelAwareLogBuilder)a.lvlBuild(5, "getParentAndItem(Object)", 316).add("ex", (Object)throwable)).log();
                }
            }
        }
        return null;
    }

    @Override
    public Object getElement(Object object, Object object2) throws TestException {
        Object object3;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getElement(Object,Object)", 335).addDetail("element", object)).addDetail("item", object2)).log();
        }
        if (object2 instanceof TableColumn) {
            object3 = TableItemResolver.getHeader(this.helper, (TableView)object, (TableColumn)object2);
            if (object3 != null) {
                return object3;
            }
            RetryException.throwEither((TestException)((Object)new BadItemException("Cannot find header for column " + object2)), 10L);
        }
        if (!this.checkItem(object, object2)) {
            return null;
        }
        if (((int[])object2)[1] >= 0) {
            object3 = TableItemResolver.getCell((TableView)object, (int[])object2);
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getElement(Object,Object)", 354).add("cell", object3)).log();
            }
            if (object3 != null) {
                return object3;
            }
            RetryException.throwEither((TestException)((Object)new BadItemException("Cannot find cell for item [" + ((int[])object2)[0] + "," + ((int[])object2)[1] + "]")), 10L);
        } else {
            object3 = TableItemResolver.getHeader((TableView)object, ((int[])object2)[0]);
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getElement(Object,Object)", 364).add("header", object3)).log();
            }
            if (object3 != null) {
                return object3;
            }
            RetryException.throwEither((TestException)((Object)new BadItemException("Cannot find header for item [" + ((int[])object2)[0] + "," + ((int[])object2)[1] + "]")), 10L);
        }
        return null;
    }

    @Override
    public Object getItemForIndex(Object object, SubItemIndex[] subItemIndexArray) throws TestException {
        SubItemIndex subItemIndex;
        int n2;
        int[] nArray;
        block20: {
            TableView tableView;
            block19: {
                if (TableItemResolver.a.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForIndex(Object,SubItemIndex[])", 390).addDetail("element", object)).addDetail("idx", (Object)subItemIndexArray)).log();
                }
                if (!this.checkItem(object, null)) {
                    return null;
                }
                tableView = (TableView)object;
                nArray = new int[]{-1, -1};
                int n3 = TableItemResolver.getVisibleColumnCount(tableView);
                if (n3 == 0) {
                    return null;
                }
                SubItemIndex subItemIndex2 = subItemIndexArray[0];
                if (subItemIndex2.getType() == 1) {
                    nArray[0] = subItemIndex2.asNumber();
                    if (nArray[0] < 0) {
                        nArray[0] = n3 + nArray[0];
                    }
                } else {
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (!subItemIndex2.matches(TableItemResolver.getResolvedHeaderName(tableView, n2))) continue;
                        nArray[0] = n2;
                        break;
                    }
                    if (nArray[0] < 0) {
                        ArrayList arrayList = new ArrayList();
                        for (Object object2 : tableView.getColumns()) {
                            TableItemResolver.b(arrayList, (TableColumn)object2);
                        }
                        for (Object object2 : arrayList) {
                            if (!subItemIndex2.matches(TableItemResolver.getResolvedHeaderName(tableView, object2))) continue;
                            if (TableItemResolver.a.level >= 9) {
                                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 428).add("got group header column", object2)).log();
                            }
                            return object2;
                        }
                    }
                }
                if (nArray[0] < 0 || nArray[0] >= n3) {
                    if (TableItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 435).add("item[0]", nArray[0])).dumpStack();
                    }
                    throw new IndexNotFoundException(subItemIndex2);
                }
                if (subItemIndexArray.length == 1) {
                    return nArray;
                }
                n2 = this.a(tableView);
                subItemIndex = subItemIndexArray[1];
                if (subItemIndex.getType() != 1) break block19;
                nArray[1] = subItemIndex.asNumber();
                if (nArray[1] >= 0) break block20;
                nArray[1] = n2 + nArray[1];
                break block20;
            }
            int n4 = 0;
            while (n4 < n2) {
                if (!subItemIndex.matches(TableItemResolver.getResolvedName(tableView, new int[]{nArray[0], n4++}))) continue;
                nArray[1] = n4;
                break;
            }
        }
        if (nArray[1] < 0 || nArray[1] >= n2) {
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 460).add("item[1]", nArray[1])).dumpStack();
            }
            if (subItemIndex.isElementSyntax()) {
                nArray[1] = -1;
                if (TableItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 464).add("Returning item for column", (Object)nArray)).log();
                }
                return nArray;
            }
            throw new IndexNotFoundException(subItemIndex);
        }
        ItemRegistry.instance().setIndexesResolved(2);
        return nArray;
    }

    @Override
    public SubItemIndex[] getItemIndex(Object object, Object object2, int n2) throws BadItemException {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object,int)", 489).addDetail("element", object)).addDetail("item", object2)).addDetail("type", n2)).log();
        }
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof TableColumn) {
            String string = TableItemResolver.getHeaderName((TableView)object, (TableColumn)object2);
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 498).add("headerName", string)).log();
            }
            return new SubItemIndex[]{new SubItemIndex(string)};
        }
        if (!this.checkItem(object, object2)) {
            return null;
        }
        TableView tableView = (TableView)object;
        int[] nArray = (int[])object2;
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = TableItemResolver.getVisibleColumnCount(tableView);
        if (n5 == 0) {
            throw new BadItemException("No header cells in " + tableView);
        }
        if (n3 >= n5) {
            throw new BadItemException("Column index " + n3 + " out of range.");
        }
        SubItemIndex[] subItemIndexArray = new SubItemIndex[2];
        switch (n2) {
            case 1: {
                if (this.a(tableView, n3)) {
                    boolean bl2;
                    String string = TableItemResolver.getResolvedHeaderName(tableView, n3);
                    boolean bl3 = bl2 = string != null && string.length() > 0;
                    if (bl2) {
                        for (int i2 = 0; i2 < n5; ++i2) {
                            if (i2 == n3 || !Misc.equalOrNull((Object)string, (Object)TableItemResolver.getResolvedHeaderName(tableView, i2))) continue;
                            bl2 = false;
                            break;
                        }
                    }
                    subItemIndexArray[0] = bl2 ? new SubItemIndex(string, "\\#@&%") : new SubItemIndex(n3);
                    break;
                }
                subItemIndexArray[0] = new SubItemIndex(n3);
                break;
            }
            case 2: {
                if (this.a(tableView, n3)) {
                    subItemIndexArray[0] = new SubItemIndex(TableItemResolver.getResolvedHeaderName(tableView, n3), "\\#@&%");
                    break;
                }
                subItemIndexArray[0] = new SubItemIndex(n3);
                break;
            }
            case 3: {
                subItemIndexArray[0] = new SubItemIndex(n3);
            }
        }
        if (n4 < 0) {
            return new SubItemIndex[]{subItemIndexArray[0]};
        }
        switch (n2) {
            case 1: 
            case 3: {
                subItemIndexArray[1] = new SubItemIndex(n4);
                break;
            }
            case 2: {
                subItemIndexArray[1] = new SubItemIndex(TableItemResolver.getResolvedName(tableView, nArray), "\\#@&%");
            }
        }
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 574).add("result", (Object)subItemIndexArray)).log();
        }
        return subItemIndexArray;
    }

    public static List getVisibleColumns(TableView tableView) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getVisibleColumns(TableView)", 593).addDetail("table", (Object)tableView)).log();
        }
        ArrayList arrayList = new ArrayList();
        for (Object e2 : tableView.getColumns()) {
            TableItemResolver.a(arrayList, (TableColumn)e2);
        }
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getVisibleColumns(TableView)", 599).add("ret", arrayList)).log();
        }
        return arrayList;
    }

    public static int getVisibleColumnCount(TableView tableView) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getVisibleColumnCount(TableView)", 613).addDetail("table", (Object)tableView)).log();
        }
        int n2 = TableItemResolver.getVisibleColumns(tableView).size();
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getVisibleColumnCount(TableView)", 616).add("ret", n2)).log();
        }
        return n2;
    }

    public static TableColumn getVisibleColumnAt(TableView tableView, int n2) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getVisibleColumnAt(TableView,int)", 631).addDetail("table", (Object)tableView)).addDetail("index", n2)).log();
        }
        TableColumn tableColumn = (TableColumn)TableItemResolver.getVisibleColumns(tableView).get(n2);
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getVisibleColumnAt(TableView,int)", 634).add("ret", (Object)tableColumn)).log();
        }
        return tableColumn;
    }

    public static TableCell getCell(TableView tableView, int[] nArray) {
        j j2;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCell(TableView,int[])", 650).addDetail("table", (Object)tableView)).addDetail("item", (Object)nArray)).log();
        }
        TableCell tableCell = TableItemResolver.getTableCell(tableView, nArray);
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getCell(TableView,int[])", 653).add("cell", (Object)tableCell)).log();
        }
        if (tableCell == null) {
            block17: {
                if (TableItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getCell(TableView,int[])", 658).add("Cell doesn't exist - trying to scroll...")).log();
                }
                tableView.scrollTo(nArray[1]);
                if (Misc.IS_JAVA_VERSION_AT_LEAST_8) {
                    try {
                        Reflector.call((Object)tableView, (String)"scrollToColumn", TableColumn.class, (Object)TableItemResolver.getVisibleColumnAt(tableView, nArray[0]));
                    }
                    catch (Throwable throwable) {
                        if (TableItemResolver.a.level < 3) break block17;
                        ((LevelAwareLogBuilder)a.lvlBuild(3, "getCell(TableView,int[])", 664).add("ex", (Object)throwable)).log();
                    }
                }
            }
            if ((j2 = (j)Engine.engineFor(tableView)) == null) {
                if (TableItemResolver.a.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "getCell(TableView,int[])", 669).add("No engine for ")).add((Object)tableView)).log();
                }
            } else {
                ((ag)j2.getPlayer()).a(500L);
            }
            tableCell = TableItemResolver.getTableCell(tableView, nArray);
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getCell(TableView,int[])", 676).add("cell2", (Object)tableCell)).log();
            }
        }
        if (tableCell == null && Options.cached_OPT_PLAY_FX_TABLE_SCROLL_FURTHER) {
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getCell(TableView,int[])", 681).add("Cell still doesn't exist - trying to scroll one line further...")).log();
            }
            tableView.scrollTo(nArray[1] + 1);
            j2 = (j)Engine.engineFor(tableView);
            if (j2 == null) {
                if (TableItemResolver.a.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "getCell(TableView,int[])", 685).add("No engine for ")).add((Object)tableView)).log();
                }
            } else {
                ((ag)j2.getPlayer()).a(500L);
            }
            tableCell = TableItemResolver.getTableCell(tableView, nArray);
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getCell(TableView,int[])", 692).add("cell3", (Object)tableCell)).log();
            }
        }
        return tableCell;
    }

    public static TableCell getOrCreateCell(TableView tableView, int[] nArray) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getOrCreateCell(TableView,int[])", 708).addDetail("table", (Object)tableView)).addDetail("item", (Object)nArray)).log();
        }
        int n2 = nArray[0];
        int n3 = nArray[1];
        TableCell tableCell = null;
        TablePosition tablePosition = tableView.getEditingCell();
        if (tablePosition == null || tablePosition.getColumn() != n2 || tablePosition.getRow() != n3) {
            tableCell = TableItemResolver.getTableCell(tableView, nArray);
        }
        if (tableCell != null) {
            return tableCell;
        }
        return TableItemResolver.createCell(tableView, nArray);
    }

    public static TableCell createCell(TableView tableView, int[] nArray) {
        TableCell tableCell;
        block17: {
            int n2;
            block16: {
                block15: {
                    WeakReference weakReference;
                    if (TableItemResolver.a.level >= 7) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createCell(TableView,int[])", 737).addDetail("table", (Object)tableView)).addDetail("item", (Object)nArray)).log();
                    }
                    int n3 = nArray[0];
                    n2 = nArray[1];
                    TableColumn tableColumn = TableItemResolver.getVisibleColumnAt(tableView, n3);
                    Callback callback = tableColumn.getCellFactory();
                    tableCell = null;
                    WeakHashMap<TableColumn, WeakReference<Pair>> weakHashMap = (WeakHashMap<TableColumn, WeakReference<Pair>>)b.get(tableView);
                    if (weakHashMap != null && (weakReference = (WeakReference)weakHashMap.get(tableColumn)) != null) {
                        Pair pair = (Pair)weakReference.get();
                        if (pair == null) {
                            weakHashMap.remove(tableColumn);
                        } else if (pair.getFirst() == callback) {
                            tableCell = (TableCell)pair.getSecond();
                            if (TableItemResolver.a.level >= 9) {
                                ((LevelAwareLogBuilder)a.lvlBuild(9, "createCell(TableView,int[])", 754).add("cached cell", (Object)tableCell)).log();
                            }
                            c = pair;
                        }
                    }
                    if (tableCell == null) {
                        tableCell = (TableCell)callback.call((Object)tableColumn);
                        if (TableItemResolver.a.level >= 9) {
                            ((LevelAwareLogBuilder)a.lvlBuild(9, "createCell(TableView,int[])", 761).add("created cell", (Object)tableCell)).log();
                        }
                        if (weakHashMap == null) {
                            weakHashMap = new WeakHashMap<TableColumn, WeakReference<Pair>>();
                            b.put(tableView, weakHashMap);
                        }
                        c = new Pair((Object)callback, (Object)tableCell);
                        weakHashMap.put(tableColumn, new WeakReference<Pair>(c));
                    }
                    try {
                        tableCell.updateTableColumn(tableColumn);
                    }
                    catch (RuntimeException runtimeException) {
                        if (TableItemResolver.a.level < 3) break block15;
                        ((LevelAwareLogBuilder)a.lvlBuild(3, "createCell(TableView,int[])", 774).add("ex", (Object)runtimeException)).log();
                    }
                }
                try {
                    tableCell.updateTableView(tableView);
                }
                catch (RuntimeException runtimeException) {
                    if (TableItemResolver.a.level < 3) break block16;
                    ((LevelAwareLogBuilder)a.lvlBuild(3, "createCell(TableView,int[])", 779).add("ex", (Object)runtimeException)).log();
                }
            }
            try {
                tableCell.updateIndex(n2);
            }
            catch (RuntimeException runtimeException) {
                if (TableItemResolver.a.level < 3) break block17;
                ((LevelAwareLogBuilder)a.lvlBuild(3, "createCell(TableView,int[])", 784).add("ex", (Object)runtimeException)).log();
            }
        }
        return tableCell;
    }

    public static Object getHeader(TableView tableView, int n2) {
        FxHelper fxHelper;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getHeader(TableView,int)", 800).addDetail("table", (Object)tableView)).addDetail("index", n2)).log();
        }
        if ((fxHelper = (FxHelper)Engine.helperFor(tableView)) == null) {
            if (TableItemResolver.a.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "getHeader(TableView,int)", 804).add("No helper for ")).add((Object)tableView)).log();
            }
            return null;
        }
        return TableItemResolver.getHeader(fxHelper, tableView, n2);
    }

    public static Object getHeader(FxHelper fxHelper, TableView tableView, int n2) {
        return TableItemResolver.getHeader(fxHelper, tableView, TableItemResolver.getVisibleColumnAt(tableView, n2));
    }

    public static Object getHeader(FxHelper fxHelper, TableView tableView, TableColumn tableColumn) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getHeader(FxHelper,TableView,TableColumn)", 840).addDetail("helper", (Object)fxHelper)).addDetail("table", (Object)tableView)).addDetail("target", (Object)tableColumn)).log();
        }
        Object[] objectArray = fxHelper.getElementsByClassName((Object)tableView, "TableHeaderCell");
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getHeader(FxHelper,TableView,TableColumn)", 843).add("headers", (Object)objectArray)).log();
        }
        for (Object object : objectArray) {
            try {
                Object object2 = Reflector.call((Object)object, (String)"getTableColumn");
                if (TableItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getHeader(FxHelper,TableView,TableColumn)", 847).add("header", object)).add("column", object2)).log();
                }
                if (!(object2 instanceof TableColumn) || object2 != tableColumn) continue;
                return object;
            }
            catch (Throwable throwable) {
                if (TableItemResolver.a.level < 5) continue;
                ((LevelAwareLogBuilder)a.lvlBuild(5, "getHeader(FxHelper,TableView,TableColumn)", 855).add("ex", (Object)throwable)).log();
            }
        }
        return null;
    }

    public static String getHeaderName(TableView tableView, int n2) {
        return TableItemResolver.getHeaderName(tableView, TableItemResolver.getVisibleColumnAt(tableView, n2));
    }

    public static String getHeaderName(TableView tableView, TableColumn tableColumn) {
        String string;
        Object object;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getHeaderName(TableView,TableColumn)", 889).addDetail("table", (Object)tableView)).addDetail("column", (Object)tableColumn)).log();
        }
        if (tableView == null || tableColumn == null) {
            if (TableItemResolver.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getHeaderName(TableView,TableColumn)", 892).add("Null table or column")).log();
            }
            return "";
        }
        FxHelper fxHelper = (FxHelper)Engine.helperFor(tableView);
        if (fxHelper == null) {
            if (TableItemResolver.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getHeaderName(TableView,TableColumn)", 898).add("Oops - no helper")).log();
            }
            return "";
        }
        Object object2 = TableItemResolver.getHeader(fxHelper, tableView, tableColumn);
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getHeaderName(TableView,TableColumn)", 903).add("header", object2)).add("visible")).add("header == null ? false : ((Node)header).isVisible()", object2 == null ? false : ((Node)object2).isVisible())).add("bounds")).add("header == null ? \"\" : ((Node)header).getBoundsInLocal().toString()", object2 == null ? "" : ((Node)object2).getBoundsInLocal().toString())).log();
        }
        if (object2 != null && fxHelper.isVisible(object2)) {
            object = fxHelper.getSize(object2);
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getHeaderName(TableView,TableColumn)", 908).add("size", object)).log();
            }
            string = object != null && (object.width <= 0 || object.height <= 0) ? "" : fxHelper.getFlatIdentifierText(object2);
        } else {
            string = fxHelper.getFlatIdentifierText(tableColumn);
        }
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getHeaderName(TableView,TableColumn)", 918).add("headerName", string)).log();
        }
        if ((object = Reflector.safeCall((Object)tableColumn, (String)"getParentColumn")) instanceof TableColumn) {
            String string2 = TableItemResolver.getHeaderName(tableView, (TableColumn)object);
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getHeaderName(TableView,TableColumn)", 924).add("parentName", string2)).log();
            }
            if (!Misc.emptyOrNull((String)string2)) {
                string = Misc.emptyOrNull((String)string) ? string2 : string2 + "." + string;
                if (TableItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getHeaderName(TableView,TableColumn)", 931).add("headerName now", string)).log();
                }
            }
        }
        return string;
    }

    public static String getResolvedHeaderName(TableView tableView, int n2) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getResolvedHeaderName(TableView,int)", 948).addDetail("table", (Object)tableView)).addDetail("col", n2)).log();
        }
        if (tableView == null || TableItemResolver.getVisibleColumns(tableView) == null || TableItemResolver.getVisibleColumns(tableView).get(n2) == null) {
            return "";
        }
        FxHelper fxHelper = (FxHelper)Engine.helperFor(tableView);
        if (fxHelper == null) {
            return "";
        }
        String string = TableItemResolver.getHeaderName(tableView, n2);
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getResolvedHeaderName(TableView,int)", 964).add("headerName", string)).log();
        }
        String string2 = ItemRegistry.instance().getItemName(tableView, fxHelper.getClassNames(tableView), new int[]{n2, -1}, string);
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getResolvedHeaderName(TableView,int)", 967).add("ret", string2)).log();
        }
        return string2;
    }

    public static String getResolvedHeaderName(TableView tableView, TableColumn tableColumn) {
        FxHelper fxHelper;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getResolvedHeaderName(TableView,TableColumn)", 982).addDetail("table", (Object)tableView)).addDetail("column", (Object)tableColumn)).log();
        }
        if ((fxHelper = (FxHelper)Engine.helperFor(tableView)) == null) {
            return "";
        }
        String string = TableItemResolver.getHeaderName(tableView, tableColumn);
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getResolvedHeaderName(TableView,TableColumn)", 989).add("headerName", string)).log();
        }
        String string2 = ItemRegistry.instance().getItemName(tableView, fxHelper.getClassNames(tableView), tableColumn, string);
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getResolvedHeaderName(TableView,TableColumn)", 992).add("ret", string2)).log();
        }
        return string2;
    }

    public static String getCellName(TableView tableView, int[] nArray) {
        FxHelper fxHelper;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCellName(TableView,int[])", 1007).addDetail("table", (Object)tableView)).addDetail("item", (Object)nArray)).log();
        }
        if ((fxHelper = (FxHelper)Engine.helperFor(tableView)) == null) {
            return "";
        }
        TableCell tableCell = TableItemResolver.getOrCreateCell(tableView, nArray);
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getCellName(TableView,int[])", 1015).add("cell", (Object)tableCell)).log();
        }
        return fxHelper.getFlatIdentifierText(tableCell);
    }

    public static String getName(TableView tableView, int[] nArray) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getName(TableView,int[])", 1031).addDetail("table", (Object)tableView)).addDetail("item", (Object)nArray)).log();
        }
        String string = nArray[1] < 0 ? TableItemResolver.getHeaderName(tableView, nArray[0]) : TableItemResolver.getCellName(tableView, nArray);
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getName(TableView,int[])", 1039).add("name", string)).log();
        }
        return string;
    }

    public static String getResolvedName(TableView tableView, int[] nArray) {
        FxHelper fxHelper;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getResolvedName(TableView,int[])", 1055).addDetail("table", (Object)tableView)).addDetail("item", (Object)nArray)).log();
        }
        if ((fxHelper = (FxHelper)Engine.helperFor(tableView)) == null) {
            return "";
        }
        String string = TableItemResolver.getName(tableView, nArray);
        return ItemRegistry.instance().getItemName(tableView, fxHelper.getClassNames(tableView), nArray, string);
    }

    public static String getHeaderValue(TableView tableView, int n2) {
        return TableItemResolver.getHeaderValue(tableView, TableItemResolver.getVisibleColumnAt(tableView, n2));
    }

    public static String getHeaderValue(TableView tableView, TableColumn tableColumn) {
        FxHelper fxHelper = (FxHelper)Engine.helperFor(tableView);
        if (fxHelper == null) {
            return "";
        }
        Object object = TableItemResolver.getHeader(fxHelper, tableView, tableColumn);
        String string = object != null && ((Node)object).isVisible() ? Util.getCleanElementText((String)fxHelper.getWholeText(object)) : Util.getCleanElementText((String)fxHelper.getWholeText(tableColumn));
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getHeaderValue(TableView,TableColumn)", 1108).add("value", string)).log();
        }
        return string;
    }

    public static String getCellValue(TableView tableView, int[] nArray) {
        FxHelper fxHelper;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCellValue(TableView,int[])", 1115).addDetail("table", (Object)tableView)).addDetail("item", (Object)nArray)).log();
        }
        if ((fxHelper = (FxHelper)Engine.helperFor(tableView)) == null) {
            return "";
        }
        TableCell tableCell = TableItemResolver.getOrCreateCell(tableView, nArray);
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getCellValue(TableView,int[])", 1123).add("cell", (Object)tableCell)).log();
        }
        String string = Util.getCleanElementText((String)fxHelper.getWholeText(tableCell));
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getCellValue(TableView,int[])", 1126).add("value", string)).log();
        }
        return string;
    }

    public static String getValue(TableView tableView, int[] nArray) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getValue(TableView,int[])", 1141).addDetail("table", (Object)tableView)).addDetail("item", (Object)nArray)).log();
        }
        String string = nArray[1] < 0 ? TableItemResolver.getHeaderValue(tableView, nArray[0]) : TableItemResolver.getCellValue(tableView, nArray);
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getValue(TableView,int[])", 1149).add("value", string)).log();
        }
        return string;
    }

    public final ItemValueResolver getItemValueResolver() {
        return this.itemValueResolver;
    }

    protected static TableCell getTableCell(TableView tableView, int[] nArray) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getTableCell(TableView,int[])", 1187).addDetail("table", (Object)tableView)).addDetail("item", (Object)nArray)).log();
        }
        int n2 = nArray[0];
        int n3 = nArray[1];
        FxHelper fxHelper = (FxHelper)Engine.engineFor(tableView).getElementHelper();
        Object[] objectArray = fxHelper.getElementsByClassName((Object)tableView, "TableRow");
        if (objectArray != null && objectArray.length > 0) {
            for (Object object : objectArray) {
                if (((IndexedCell)object).getIndex() != n3) continue;
                Object[] objectArray2 = fxHelper.getElementsByClassName(object, "Item:TableCell");
                if (objectArray2 == null || objectArray2.length <= 0) break;
                TableColumn tableColumn = TableItemResolver.getVisibleColumnAt(tableView, n2);
                if (objectArray2.length > n2 && ((TableCell)objectArray2[n2]).getTableColumn() == tableColumn && fxHelper.isVisible(objectArray2[n2])) {
                    return (TableCell)objectArray2[n2];
                }
                for (Object object2 : objectArray2) {
                    if (((TableCell)object2).getTableColumn() != tableColumn || !fxHelper.isVisible(object2)) continue;
                    return (TableCell)object2;
                }
                break;
            }
        }
        return null;
    }

    protected boolean checkItem(Object object, Object object2) throws BadItemException {
        if (!(object instanceof TableView)) {
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "checkItem(Object,Object)", 1241).add("Not a TableView", object)).log();
            }
            return false;
        }
        if (!(object2 == null || object2 instanceof int[] && ((int[])object2).length == 2)) {
            if (TableItemResolver.a.level >= 5) {
                ((LevelAwareLogBuilder)a.lvlBuild(5, "checkItem(Object,Object)", 1247).add("Internal error: Not an int[2]", object2)).dumpStack();
            }
            throw new BadItemException("Not an int[2]: " + object2);
        }
        return true;
    }

    private int a(TableView tableView) {
        if (null == tableView || null == tableView.getItems()) {
            return -1;
        }
        return tableView.getItems().size();
    }

    private boolean a(TableView tableView, int[] nArray) {
        TableCell tableCell = null;
        tableCell = TableItemResolver.getCell(tableView, nArray);
        if (null != tableCell) {
            return tableCell.isEditable();
        }
        return false;
    }

    private boolean a(TableView tableView, int n2) {
        return ((TableColumn)TableItemResolver.getVisibleColumns(tableView).get(n2)).isVisible();
    }

    private static void a(List list, TableColumn tableColumn) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "addVisibleColumns(List<TableColumn>,TableColumn)", 1300).addDetail("result", (Object)list)).addDetail("column", (Object)tableColumn)).log();
        }
        if (!tableColumn.isVisible()) {
            return;
        }
        ObservableList observableList = tableColumn.getColumns();
        if (observableList.size() > 0) {
            for (TableColumn tableColumn2 : observableList) {
                TableItemResolver.a(list, tableColumn2);
            }
        } else {
            list.add(tableColumn);
        }
    }

    private static void b(List list, TableColumn tableColumn) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "addGroupColumns(List<TableColumn>,TableColumn)", 1325).addDetail("result", (Object)list)).addDetail("column", (Object)tableColumn)).log();
        }
        if (!tableColumn.isVisible()) {
            return;
        }
        ObservableList observableList = tableColumn.getColumns();
        if (observableList.size() > 0) {
            list.add(tableColumn);
            for (TableColumn tableColumn2 : observableList) {
                TableItemResolver.b(list, tableColumn2);
            }
        }
    }

    public class TableItemValueResolver
    implements ItemValueResolver,
    BaseHelper {
        public TableItemValueResolver() {
            if (a.level >= 7) {
                a.lvlBuild(7, "TableItemValueResolver.TableItemValueResolver()", 1347).log();
            }
        }

        @Override
        public String getItemValue(Object object, Object object2) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "TableItemValueResolver.getItemValue(Object,Object)", 1365).addDetail("element", object)).addDetail("item", object2)).log();
            }
            if (object2 == null) {
                return null;
            }
            if (object instanceof TableView && object2 instanceof TableColumn) {
                return TableItemResolver.getHeaderValue((TableView)object, (TableColumn)object2);
            }
            try {
                if (!TableItemResolver.this.checkItem(object, object2)) {
                    return null;
                }
            }
            catch (BadItemException badItemException) {
                if (a.level >= 3) {
                    ((LevelAwareLogBuilder)a.lvlBuild(3, "TableItemValueResolver.getItemValue(Object,Object)", 1379).add("ex", (Object)badItemException)).log();
                }
                return null;
            }
            TableView tableView = (TableView)object;
            return TableItemResolver.getValue(tableView, (int[])object2);
        }
    }
}

