/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.ios.device;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.ios.device.IOSDeviceRotation;
import de.qfs.apps.qftest.client.ios.device.IOSSimulator;
import de.qfs.apps.qftest.client.recwindow.view.DisplayWindow;
import de.qfs.apps.qftest.shared.Geometry;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.OptionsBase;
import de.qfs.apps.qftest.shared.extensions.TestOptionsProvider;
import de.qfs.apps.qftest.shared.ios.IOSTarget;
import de.qfs.apps.qftest.shared.ios.IOSUtil;
import de.qfs.apps.qftest.shared.script.modules.Automac;
import de.qfs.apps.qftest.shared.script.modules.QF;
import de.qfs.apps.qftest.shared.system.Native;
import de.qfs.apps.qftest.shared.system.mac.PListAccess;
import de.qfs.lib.axjlib.AXAPI;
import de.qfs.lib.axjlib.AXJLib;
import de.qfs.lib.axjlib.appkit.NSRunningApplication;
import de.qfs.lib.axjlib.ui.AXUIElement;
import de.qfs.lib.axjlib.ui.elements.AXApplication;
import de.qfs.lib.axjlib.ui.elements.AXButton;
import de.qfs.lib.axjlib.ui.elements.AXWindow;
import de.qfs.lib.axjlib.values.CGPoint;
import de.qfs.lib.axjlib.values.CGRect;
import de.qfs.lib.axjlib.values.CGSize;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.notifications.DefaultNotificationCenter;
import de.qfs.lib.option.OptionListener;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.ProcessManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class IOSLocalSimulatorApp
implements IOSSimulator,
OptionListener {
    private static final QFLogger m = new QFLogger("de.qfs.apps.qftest.client.ios.device.IOSLocalSimulatorApp");
    final File a;
    final File b;
    final String c;
    boolean d;
    int e;
    NSRunningApplication f;
    AXApplication g;
    @Nullable
    int h;
    DisplayWindow i;
    IOSTarget j;
    Consumer k;
    AXWindow l;

    public IOSLocalSimulatorApp() {
        this(new File(IOSLocalSimulatorApp.b()));
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "IOSLocalSimulatorApp()", 97).log();
        }
    }

    private static String b() {
        String string;
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "getSimulatorPath()", 101).log();
        }
        if (!Misc.emptyOrNull((String)(string = Options.cached_OPT_IOS_TOOL_PATH_SIMULATOR))) {
            return string;
        }
        string = IOSUtil.getActiveDeveloperDirectory();
        if (Misc.emptyOrNull((String)string)) {
            string = "/Applications/Xcode.app/Contents/Developer";
        }
        return string + "/Applications/Simulator.app";
    }

    public IOSLocalSimulatorApp(File file) {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            ((LevelAwareLogBuilder)m.lvlBuild(7, "IOSLocalSimulatorApp(File)", 114).addDetail("app", (Object)file)).log();
        }
        if (file == null) {
            throw new IllegalArgumentException("app is marked non-null but is null");
        }
        if (!Misc.OS_IS_MAC_OS_X) {
            throw new UnsupportedOperationException("iOS Simulator can only be managed on macOS");
        }
        this.a = file;
        this.b = new File(Native.instance().getExecutable(file.getAbsolutePath()));
        this.c = PListAccess.instance().getBundleIdentifier(file);
        DefaultNotificationCenter.instance().addObserver(notification -> this.a((DisplayWindow)notification.getObject()), "de.qfs.apps.qftest.client.recwindow.view.DisplayWindow.Notifications.Recording Window Opened");
        DefaultNotificationCenter.instance().addObserver(notification -> this.e(), "de.qfs.apps.qftest.client.recwindow.view.DisplayWindow.Notifications.Recording Window Closing");
    }

    @Override
    public void start() throws IOException {
        int n2;
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "start()", 128).log();
        }
        this.c();
        if (this.e == 0) {
            block6: {
                try {
                    Runtime.getRuntime().exec(new String[]{"open", this.a.getAbsolutePath()});
                    this.d = true;
                }
                catch (Exception exception) {
                    if (IOSLocalSimulatorApp.m.level < 5) break block6;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)m.lvlBuild(5, "start()", 136).add("Could not get simulator process id: ")).add((Object)exception)).log();
                }
            }
            this.c();
        }
        if (IOSLocalSimulatorApp.m.level >= 5) {
            ((LevelAwareLogBuilder)m.lvlBuild(5, "start()", 140).add("simulator process id", this.e)).log();
        }
        if (this.i != null && ((n2 = Options.cached_OPT_IOS_AUTO_HIDE_SIMULATOR) == 1 || n2 == 3)) {
            this.a(true);
        }
        Client.instance().addOptionListener(this);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (this.e == 0) {
                this.d();
            }
            if (this.h == 0) {
                this.h = (Integer)Options.getOption((String)Options.OPT_IOS_AUTO_CLOSE_SIMULATOR).getDefaultValue();
            }
            switch (this.h) {
                case 2: {
                    return;
                }
                default: {
                    if (this.d) break;
                    return;
                }
                case 1: 
            }
            this.closeWindow();
        }, "Close iOS simulator window"));
    }

    public void closeWindow() {
        block5: {
            if (IOSLocalSimulatorApp.m.level >= 7) {
                m.lvlBuild(7, "closeWindow()", 168).log();
            }
            try {
                if (this.l == null) {
                    this.c();
                }
                if (this.l != null) {
                    Automac.instance().closeWindow((Object)this.l);
                }
            }
            catch (Exception exception) {
                if (IOSLocalSimulatorApp.m.level < 9) break block5;
                ((LevelAwareLogBuilder)m.lvlBuild(9, "closeWindow()", 178).add("Error closing simulator window")).log();
            }
        }
    }

    private void c() {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "detectAXApplication()", 182).log();
        }
        this.d();
        if (this.g == null) {
            if (this.e != 0) {
                this.g = AXAPI.getApplicationAccessibilityObject((int)this.e);
                this.g.addObserver((aXUIElement, string) -> {
                    int n2 = Options.cached_OPT_IOS_AUTO_HIDE_SIMULATOR;
                    if (this.i != null && n2 == 1) {
                        this.a(true);
                        this.i.show(true);
                    }
                }, new String[]{"AXApplicationShown"});
            }
            if (IOSLocalSimulatorApp.m.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)m.lvlBuild(9, "detectAXApplication()", 196).add("pid", this.e)).add("axApplication", (Object)this.g)).log();
            }
        }
        if (this.l == null && this.g != null && this.j != null) {
            List list = this.g.getWindows();
            String string2 = Misc.normalizeCharacters((String)(this.j.getName() + " - " + this.j.getOsVersion().getOriginalVersionString()));
            for (AXUIElement aXUIElement2 : list) {
                if (!string2.equals(Misc.normalizeCharacters((String)aXUIElement2.getTitle()))) continue;
                this.l = (AXWindow)aXUIElement2;
                break;
            }
            if (this.l != null) {
                this.l.addObserver((aXUIElement, string) -> {
                    if (this.k != null && this.j != null) {
                        this.k.accept(this.j);
                    }
                }, new String[]{"AXUIElementDestroyed"});
            }
        }
    }

    @Override
    public void attachToTarget(IOSTarget iOSTarget) {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            ((LevelAwareLogBuilder)m.lvlBuild(7, "attachToTarget(IOSTarget)", 218).addDetail("target", (Object)iOSTarget)).log();
        }
        if (this.j != iOSTarget) {
            this.l = null;
        }
        this.j = iOSTarget;
        this.c();
    }

    private void d() {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "detectRunningApplication()", 227).log();
        }
        int n2 = this.e;
        if (this.f == null) {
            NSRunningApplication[] nSRunningApplicationArray = AXJLib.INSTANCE.runningApplicationsWithBundleIdentifier(this.c);
            if (nSRunningApplicationArray != null && nSRunningApplicationArray.length > 0) {
                this.f = nSRunningApplicationArray[0];
                this.e = this.f.getProcessIdentifier();
            }
            if (IOSLocalSimulatorApp.m.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)m.lvlBuild(9, "detectRunningApplication()", 236).add("pid", this.e)).add("runningApplication", (Object)this.f)).log();
            }
        }
        if (this.e != 0 && n2 != this.e) {
            this.a();
        }
    }

    @Override
    public void stop() {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "stop()", 244).log();
        }
        if (this.e != 0) {
            try {
                ProcessManager.runProcess((String[])new String[]{"/bin/kill", "-9", "" + this.e}, (int)1000);
            }
            catch (ProcessManager.RunProcessException runProcessException) {
                if (IOSLocalSimulatorApp.m.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)m.lvlBuild(5, "stop()", 249).add("Could not kill simulator: ")).add((Object)runProcessException)).log();
                }
                return;
            }
        }
        this.e = 0;
        this.d = false;
    }

    protected void a() {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "syncSubProcessKillFlags()", 257).log();
        }
        if (this.e == 0) {
            this.d();
        }
        if (this.e == 0) {
            return;
        }
        switch (this.h) {
            case 2: {
                Client.instance().removeSupplementalChildPid(this.e);
                break;
            }
            case 3: {
                if (this.d) {
                    Client.instance().addSupplementalChildPid(this.e);
                    break;
                }
                Client.instance().removeSupplementalChildPid(this.e);
                break;
            }
            default: {
                Client.instance().addSupplementalChildPid(this.e);
            }
        }
    }

    public void optionsChanged(OptionSet optionSet) {
        int n2;
        int n3;
        if (IOSLocalSimulatorApp.m.level >= 7) {
            ((LevelAwareLogBuilder)m.lvlBuild(7, "optionsChanged(OptionSet)", 280).addDetail("options", (Object)optionSet)).log();
        }
        if ((n3 = Options.cached_OPT_IOS_AUTO_CLOSE_SIMULATOR) != this.h) {
            this.h = n3;
            this.a();
        }
        if ((n2 = Options.cached_OPT_IOS_AUTO_HIDE_SIMULATOR) == 1 && this.i != null) {
            this.a(true);
        }
    }

    private void a(DisplayWindow displayWindow) {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            ((LevelAwareLogBuilder)m.lvlBuild(7, "recordingWindowShown(DisplayWindow)", 293).addDetail("recordingWindow", (Object)displayWindow)).log();
        }
        this.i = displayWindow;
        int n2 = Options.cached_OPT_IOS_AUTO_HIDE_SIMULATOR;
        if (n2 == 1 || n2 == 3) {
            this.a(true);
        }
    }

    private void a(boolean bl2) {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            ((LevelAwareLogBuilder)m.lvlBuild(7, "setSimulatorHidden(boolean)", 304).addDetail("hiddenState", bl2)).log();
        }
        this.c();
        if (this.g != null) {
            if (bl2) {
                this.g.setHidden(Boolean.valueOf(true));
            } else {
                this.g.setHidden(Boolean.valueOf(false));
            }
        }
    }

    private void e() {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "recordingWindowClosed()", 316).log();
        }
        this.i = null;
        this.a(false);
    }

    @Override
    public void initSimulatorAfterConnect() {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "initSimulatorAfterConnect()", 323).log();
        }
        IOSLocalSimulatorApp.acceptIncomingConnections();
    }

    @Override
    @Nullable
    public Geometry getGeometryOnScreen() {
        block6: {
            if (IOSLocalSimulatorApp.m.level >= 7) {
                m.lvlBuild(7, "getGeometryOnScreen()", 329).log();
            }
            if (this.l == null) {
                this.c();
            }
            if (this.l != null) {
                try {
                    CGRect cGRect = this.l.getFrame();
                    if (cGRect != null) {
                        CGPoint cGPoint = cGRect.getOrigin();
                        CGSize cGSize = cGRect.getSize();
                        return Geometry.geometry((int)((int)cGPoint.getX()), (int)((int)cGPoint.getY()), (int)((int)cGSize.getWidth()), (int)((int)cGSize.getHeight()));
                    }
                }
                catch (Exception exception) {
                    if (IOSLocalSimulatorApp.m.level < 3) break block6;
                    ((LevelAwareLogBuilder)m.lvlBuild(3, "getGeometryOnScreen()", 343).add("Could not get simulator geometry", (Object)exception)).log();
                }
            }
        }
        return null;
    }

    @Override
    public IOSSimulator setRotation(IOSDeviceRotation iOSDeviceRotation) {
        block9: {
            if (IOSLocalSimulatorApp.m.level >= 7) {
                ((LevelAwareLogBuilder)m.lvlBuild(7, "setRotation(IOSDeviceRotation)", 350).addDetail("rotation", (Object)iOSDeviceRotation)).log();
            }
            this.c();
            if (this.l != null && !this.g.isHidden().booleanValue() && !this.l.isMinimized().booleanValue()) {
                String string = switch (iOSDeviceRotation.getZ()) {
                    case 90 -> "Landscape Right";
                    case 270 -> "Landscape Left";
                    case 180 -> "Portrait Upside Down";
                    default -> "Portrait";
                };
                try {
                    this.g.setFrontmost(Boolean.valueOf(true));
                    this.l.raise();
                    this.a((AXUIElement)this.g.getMenuBar(), (Queue)((Object)Misc.fillList(new LinkedList(), (Object[])new String[]{"Device", "Orientation", string})));
                }
                catch (Exception exception) {
                    if (IOSLocalSimulatorApp.m.level < 1) break block9;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)m.lvlBuild(1, "setRotation(IOSDeviceRotation)", 366).add("Could not rotate simulator: ")).add((Object)exception)).log();
                }
            }
        }
        return this;
    }

    private void a(AXUIElement aXUIElement, Queue queue) {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)m.lvlBuild(7, "clickMenuItem(AXUIElement,Queue<String>)", 372).addDetail("menu", (Object)aXUIElement)).addDetail("titles", (Object)queue)).log();
        }
        if (queue == null) {
            throw new IllegalArgumentException("titles is marked non-null but is null");
        }
        String string = (String)queue.poll();
        if (string != null) {
            List list = aXUIElement.getChildrenInNavigationOrder();
            for (AXUIElement aXUIElement2 : list) {
                if (!string.equals(aXUIElement2.getTitle())) continue;
                List list2 = aXUIElement2.getChildren();
                if (!list2.isEmpty()) {
                    aXUIElement2 = (AXUIElement)list2.get(0);
                }
                this.a(aXUIElement2, queue);
                return;
            }
            throw new IllegalArgumentException("Menu item " + string + " not found");
        }
        aXUIElement.performAction("AXPick");
    }

    public static void acceptIncomingConnections() {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "acceptIncomingConnections()", 399).log();
        }
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        AtomicInteger atomicInteger = new AtomicInteger(5);
        Runnable runnable = () -> {
            NSRunningApplication[] nSRunningApplicationArray;
            if (IOSLocalSimulatorApp.m.level >= 5) {
                ((LevelAwareLogBuilder)m.lvlBuild(5, "acceptIncomingConnections()", 405).add("Trying to accept incoming connections")).log();
            }
            if (atomicInteger.decrementAndGet() <= 0) {
                if (IOSLocalSimulatorApp.m.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)m.lvlBuild(5, "acceptIncomingConnections()", 407).add("Stop retry")).add("retryCounter", (Object)atomicInteger)).log();
                }
                scheduledExecutorService.shutdown();
                return;
            }
            for (NSRunningApplication nSRunningApplication : nSRunningApplicationArray = AXJLib.INSTANCE.runningApplicationsWithBundleIdentifier("com.apple.UserNotificationCenter")) {
                Object object;
                AXWindow aXWindow;
                Object object22;
                int n2 = nSRunningApplication.getProcessIdentifier();
                AXApplication aXApplication = AXAPI.getApplicationAccessibilityObject((int)n2);
                if (aXApplication == null) {
                    if (IOSLocalSimulatorApp.m.level < 9) continue;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)m.lvlBuild(9, "acceptIncomingConnections()", 418).add("No app")).add("pid", n2)).log();
                    continue;
                }
                List list = aXApplication.getWindows();
                if (IOSLocalSimulatorApp.m.level >= 9) {
                    ((LevelAwareLogBuilder)m.lvlBuild(9, "acceptIncomingConnections()", 424).add("windows", (Object)list)).log();
                }
                if (Misc.emptyOrNull((Collection)list)) {
                    if (IOSLocalSimulatorApp.m.level < 9) continue;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)m.lvlBuild(9, "acceptIncomingConnections()", 427).add("No windows")).add("pid", n2)).log();
                    continue;
                }
                AXWindow aXWindow2 = null;
                for (Object object22 : list) {
                    if (!(object22 instanceof AXWindow)) continue;
                    aXWindow = (AXWindow)object22;
                    object = aXWindow.getTitle();
                    if (IOSLocalSimulatorApp.m.level >= 9) {
                        ((LevelAwareLogBuilder)m.lvlBuild(9, "acceptIncomingConnections()", 436).add("title", (String)object)).log();
                    }
                    if (!"".equals(object)) continue;
                    aXWindow2 = aXWindow;
                    break;
                }
                if (aXWindow2 == null) {
                    if (IOSLocalSimulatorApp.m.level < 9) continue;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)m.lvlBuild(9, "acceptIncomingConnections()", 445).add("Dialog not found")).add("pid", n2)).log();
                    continue;
                }
                List list2 = aXWindow2.getChildrenInNavigationOrder();
                if (IOSLocalSimulatorApp.m.level >= 9) {
                    ((LevelAwareLogBuilder)m.lvlBuild(9, "acceptIncomingConnections()", 450).add("children", (Object)list2)).log();
                }
                Collections.reverse(list2);
                object22 = list2.iterator();
                while (object22.hasNext()) {
                    block18: {
                        aXWindow = (AXUIElement)object22.next();
                        if (!(aXWindow instanceof AXButton)) continue;
                        object = aXWindow.toString();
                        try {
                            object = "'" + aXWindow.getTitle() + "'";
                        }
                        catch (Exception exception) {
                            if (IOSLocalSimulatorApp.m.level < 3) break block18;
                            ((LevelAwareLogBuilder)m.lvlBuild(3, "acceptIncomingConnections()", 461).add("ex", (Object)exception)).log();
                        }
                    }
                    String string = "Clicking on button to continue automation: " + (String)object;
                    if (IOSLocalSimulatorApp.m.level >= 5) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)m.lvlBuild(5, "acceptIncomingConnections()", 465).add("msg", string)).add("child", (Object)aXWindow)).log();
                    }
                    QF.logMessage((String)string, (boolean)true, (boolean)false, (boolean)true);
                    try {
                        ((AXButton)aXWindow).press();
                        atomicInteger.set(0);
                        return;
                    }
                    catch (Exception exception) {
                        if (IOSLocalSimulatorApp.m.level < 9) continue;
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)m.lvlBuild(9, "acceptIncomingConnections()", 472).add(" with exception: ")).add(exception.getMessage())).log();
                    }
                }
            }
            if (IOSLocalSimulatorApp.m.level >= 5) {
                ((LevelAwareLogBuilder)m.lvlBuild(5, "acceptIncomingConnections()", 479).add("No Button to click on found")).log();
            }
        };
        scheduledExecutorService.scheduleAtFixedRate(runnable, 0L, 500L, TimeUnit.MILLISECONDS);
    }

    public static void main(String[] stringArray) throws Exception {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            ((LevelAwareLogBuilder)m.lvlBuild(7, "main(String[])", 488).addDetail("args", (Object)stringArray)).log();
        }
        Options.setOptionsProvider((OptionsBase.OptionsProvider)new TestOptionsProvider());
        Options.setOption((String)Options.OPT_IOS_AUTO_CLOSE_SIMULATOR, (Object)"false");
        IOSLocalSimulatorApp iOSLocalSimulatorApp = new IOSLocalSimulatorApp();
        iOSLocalSimulatorApp.start();
        Thread.sleep(5000L);
    }

    public boolean equals(Object object) {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            ((LevelAwareLogBuilder)m.lvlBuild(7, "equals(Object)", 73).addDetail("o", object)).log();
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof IOSLocalSimulatorApp)) {
            return false;
        }
        IOSLocalSimulatorApp iOSLocalSimulatorApp = (IOSLocalSimulatorApp)object;
        if (!iOSLocalSimulatorApp.a(this)) {
            return false;
        }
        if (this.isDidStartProcess() != iOSLocalSimulatorApp.isDidStartProcess()) {
            return false;
        }
        if (this.getPid() != iOSLocalSimulatorApp.getPid()) {
            return false;
        }
        if (this.h != iOSLocalSimulatorApp.h) {
            return false;
        }
        File file = this.getApp();
        File file2 = iOSLocalSimulatorApp.getApp();
        if (file == null ? file2 != null : !((Object)file).equals(file2)) {
            return false;
        }
        File file3 = this.getExecutable();
        File file4 = iOSLocalSimulatorApp.getExecutable();
        if (file3 == null ? file4 != null : !((Object)file3).equals(file4)) {
            return false;
        }
        String string = this.getBundleId();
        String string2 = iOSLocalSimulatorApp.getBundleId();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        NSRunningApplication nSRunningApplication = this.getRunningApplication();
        NSRunningApplication nSRunningApplication2 = iOSLocalSimulatorApp.getRunningApplication();
        if (nSRunningApplication == null ? nSRunningApplication2 != null : !nSRunningApplication.equals(nSRunningApplication2)) {
            return false;
        }
        AXApplication aXApplication = this.getAxApplication();
        AXApplication aXApplication2 = iOSLocalSimulatorApp.getAxApplication();
        if (aXApplication == null ? aXApplication2 != null : !aXApplication.equals(aXApplication2)) {
            return false;
        }
        DisplayWindow displayWindow = this.i;
        DisplayWindow displayWindow2 = iOSLocalSimulatorApp.i;
        if (displayWindow == null ? displayWindow2 != null : !displayWindow.equals(displayWindow2)) {
            return false;
        }
        IOSTarget iOSTarget = this.j;
        IOSTarget iOSTarget2 = iOSLocalSimulatorApp.j;
        if (iOSTarget == null ? iOSTarget2 != null : !iOSTarget.equals(iOSTarget2)) {
            return false;
        }
        Consumer consumer = this.k;
        Consumer consumer2 = iOSLocalSimulatorApp.k;
        if (consumer == null ? consumer2 != null : !consumer.equals(consumer2)) {
            return false;
        }
        AXWindow aXWindow = this.getAxWindow();
        AXWindow aXWindow2 = iOSLocalSimulatorApp.getAxWindow();
        return !(aXWindow == null ? aXWindow2 != null : !aXWindow.equals(aXWindow2));
    }

    protected boolean a(Object object) {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            ((LevelAwareLogBuilder)m.lvlBuild(7, "canEqual(Object)", 73).addDetail("other", object)).log();
        }
        return object instanceof IOSLocalSimulatorApp;
    }

    public int hashCode() {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "hashCode()", 73).log();
        }
        int n2 = 1;
        n2 = n2 * 59 + (this.isDidStartProcess() ? 79 : 97);
        n2 = n2 * 59 + this.getPid();
        n2 = n2 * 59 + this.h;
        File file = this.getApp();
        n2 = n2 * 59 + (file == null ? 43 : ((Object)file).hashCode());
        File file2 = this.getExecutable();
        n2 = n2 * 59 + (file2 == null ? 43 : ((Object)file2).hashCode());
        String string = this.getBundleId();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        NSRunningApplication nSRunningApplication = this.getRunningApplication();
        n2 = n2 * 59 + (nSRunningApplication == null ? 43 : nSRunningApplication.hashCode());
        AXApplication aXApplication = this.getAxApplication();
        n2 = n2 * 59 + (aXApplication == null ? 43 : aXApplication.hashCode());
        DisplayWindow displayWindow = this.i;
        n2 = n2 * 59 + (displayWindow == null ? 43 : displayWindow.hashCode());
        IOSTarget iOSTarget = this.j;
        n2 = n2 * 59 + (iOSTarget == null ? 43 : iOSTarget.hashCode());
        Consumer consumer = this.k;
        n2 = n2 * 59 + (consumer == null ? 43 : consumer.hashCode());
        AXWindow aXWindow = this.getAxWindow();
        n2 = n2 * 59 + (aXWindow == null ? 43 : aXWindow.hashCode());
        return n2;
    }

    public String toString() {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "toString()", 74).log();
        }
        return "IOSLocalSimulatorApp(app=" + String.valueOf(this.getApp()) + ", executable=" + String.valueOf(this.getExecutable()) + ", bundleId=" + this.getBundleId() + ", didStartProcess=" + this.isDidStartProcess() + ", pid=" + this.getPid() + ", runningApplication=" + String.valueOf(this.getRunningApplication()) + ", axApplication=" + String.valueOf(this.getAxApplication()) + ", autoCloseSimulatorOptionValue=" + this.h + ", recordingWindow=" + String.valueOf(this.i) + ", attachedTarget=" + String.valueOf(this.j) + ", closeHandler=" + String.valueOf(this.k) + ", axWindow=" + String.valueOf(this.getAxWindow()) + ")";
    }

    public File getApp() {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "getApp()", 79).log();
        }
        return this.a;
    }

    public File getExecutable() {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "getExecutable()", 80).log();
        }
        return this.b;
    }

    public String getBundleId() {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "getBundleId()", 81).log();
        }
        return this.c;
    }

    public boolean isDidStartProcess() {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "isDidStartProcess()", 83).log();
        }
        return this.d;
    }

    public int getPid() {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "getPid()", 84).log();
        }
        return this.e;
    }

    public NSRunningApplication getRunningApplication() {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "getRunningApplication()", 86).log();
        }
        return this.f;
    }

    public AXApplication getAxApplication() {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "getAxApplication()", 87).log();
        }
        return this.g;
    }

    @Override
    public IOSLocalSimulatorApp setCloseHandler(Consumer consumer) {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            ((LevelAwareLogBuilder)m.lvlBuild(7, "setCloseHandler(Consumer<IOSTarget>)", 94).addDetail("closeHandler", (Object)consumer)).log();
        }
        this.k = consumer;
        return this;
    }

    public AXWindow getAxWindow() {
        if (IOSLocalSimulatorApp.m.level >= 7) {
            m.lvlBuild(7, "getAxWindow()", 95).log();
        }
        return this.l;
    }
}

