/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.ios.toolkit;

import de.qfs.apps.qftest.client.ios.IOSEngine;
import de.qfs.apps.qftest.client.ios.device.IOSDeviceControl;
import de.qfs.apps.qftest.client.ios.toolkit.IOSApplication;
import de.qfs.apps.qftest.client.ios.toolkit.IOSElement;
import de.qfs.apps.qftest.client.ios.toolkit.XCUIApplication;
import de.qfs.apps.qftest.client.mobile.MobileEngine;
import de.qfs.apps.qftest.shared.DoubleGeometry;
import de.qfs.apps.qftest.shared.Geometry;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.apps.qftest.shared.h;
import de.qfs.lib.json.Json;
import de.qfs.lib.json.JsonArray;
import de.qfs.lib.json.JsonMapper;
import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonValue;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class XCUIElement
implements IOSElement {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.ios.toolkit.XCUIElement");
    final Set b = Misc.setOf((Object[])new String[]{"uid", "type", "rect", "children"});
    @Nullable
    final String c;
    @Nullable
    XCUIApplication d;
    @Nullable
    XCUIElement e;
    JsonObject f;
    private boolean h = true;

    public XCUIElement(@Nullable XCUIApplication xCUIApplication, @Nullable XCUIElement xCUIElement, JsonObject jsonObject) {
        if (XCUIElement.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "XCUIElement(XCUIApplication,XCUIElement,JsonObject)", 64).addDetail("app", (Object)xCUIApplication)).addDetail("parent", (Object)xCUIElement)).addDetail("base", (Object)jsonObject)).log();
        }
        if (jsonObject == null) {
            throw new IllegalArgumentException("base is marked non-null but is null");
        }
        this.c = XCUIElement.getUidFromJson(jsonObject);
        if (this.c == null && XCUIElement.a.level >= 3) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "XCUIElement(XCUIApplication,XCUIElement,JsonObject)", 69).add("No uid for ")).add((Object)this)).log();
        }
        this.init(xCUIApplication, xCUIElement, jsonObject);
    }

    public void init(XCUIApplication xCUIApplication, XCUIElement xCUIElement, JsonObject jsonObject) {
        if (XCUIElement.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "init(XCUIApplication,XCUIElement,JsonObject)", 78).addDetail("app", (Object)xCUIApplication)).addDetail("parent", (Object)xCUIElement)).addDetail("base", (Object)jsonObject)).log();
        }
        this.e = xCUIElement;
        this.f = jsonObject;
        if (xCUIApplication == null) {
            this.d = (XCUIApplication)this;
        } else {
            this.d = xCUIApplication;
            xCUIApplication.a(this);
        }
        this.h = true;
    }

    public static String getUidFromJson(JsonObject jsonObject) {
        if (XCUIElement.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getUidFromJson(JsonObject)", 93).addDetail("base", (Object)jsonObject)).log();
        }
        if (jsonObject == null) {
            throw new IllegalArgumentException("base is marked non-null but is null");
        }
        return de.qfs.apps.qftest.shared.h.a((JsonValue)jsonObject, (String)"uid", null);
    }

    @Override
    public String getType() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getType()", 102).log();
        }
        return (String)this.getAttribute("type");
    }

    @Override
    public String getIdentifier() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getIdentifier()", 110).log();
        }
        return (String)this.getAttribute("rawIdentifier");
    }

    @Override
    public String getLabel() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getLabel()", 119).log();
        }
        return (String)this.getAttribute("label");
    }

    @Override
    public String getValue() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getValue()", 128).log();
        }
        return (String)this.getAttribute("value");
    }

    @Override
    public String getPlaceholderValue() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getPlaceholderValue()", 137).log();
        }
        return (String)this.getAttribute("placeholderValue");
    }

    @Override
    public String getTraits() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getTraits()", 146).log();
        }
        return (String)this.getAttribute("traits");
    }

    @Override
    public String getBaseType() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getBaseType()", 155).log();
        }
        return (String)this.getAttribute("baseType");
    }

    @Override
    public boolean isVisibleToUser(boolean bl2) {
        if (XCUIElement.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "isVisibleToUser(boolean)", 164).addDetail("forceUpdate", bl2)).log();
        }
        if ("Switch".equals(this.getType())) {
            return this.e != null && this.e.isVisibleToUser(bl2);
        }
        String string = this.getBaseType();
        if ("UITextEffectsWindow".equals(string) || "_UIEditMenuContainerView".equals(string)) {
            return this.getChildCount() > 0;
        }
        if (bl2) {
            this.updateAttribute("isVisible");
        }
        return this.isAttributeTrue("isVisible");
    }

    @Override
    public DoubleGeometry getNativeFrame() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getNativeFrame()", 187).log();
        }
        try {
            return DoubleGeometry.fromJson((JsonValue)this.getAttributeAsJson("nativeFrame"));
        }
        catch (Exception exception) {
            if (XCUIElement.a.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(1, "getNativeFrame()", 192).add("Could not get frame: ")).add((Object)exception)).log();
            }
            return null;
        }
    }

    @Override
    public boolean isEnabled() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "isEnabled()", 202).log();
        }
        return this.isAttributeTrue("isEnabled");
    }

    @Override
    public boolean isAccessible() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "isAccessible()", 211).log();
        }
        return this.isAttributeTrue("isAccessible");
    }

    @Override
    public boolean isHittable() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "isHittable()", 220).log();
        }
        return this.isAttributeTrue("isHittable");
    }

    @Override
    public Object getAttribute(String string) {
        if (XCUIElement.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getAttribute(String)", 229).addDetail("attributeName", string)).log();
        }
        return JsonMapper.map((JsonValue)this.getAttributeAsJson(string));
    }

    public boolean isAttributeTrue(String string) {
        Object object;
        if (XCUIElement.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "isAttributeTrue(String)", 237).addDetail("attributeName", string)).log();
        }
        return Boolean.TRUE.equals(object = this.getAttribute(string)) || "1".equals(object) || "true".equals(object);
    }

    public boolean isAttributeFalse(String string) {
        Object object;
        if (XCUIElement.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "isAttributeFalse(String)", 246).addDetail("attributeName", string)).log();
        }
        return Boolean.FALSE.equals(object = this.getAttribute(string)) || "0".equals(object) || "false".equals(object);
    }

    public JsonValue getAttributeAsJson(String string) {
        if (XCUIElement.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getAttributeAsJson(String)", 255).addDetail("attributeName", string)).log();
        }
        if (this.f.contains(string)) {
            return this.f.get(string);
        }
        JsonValue jsonValue = this.updateAttribute(string);
        if (jsonValue == null) {
            return null;
        }
        return jsonValue;
    }

    @Nullable
    public JsonValue updateAttribute(String string) {
        JsonValue jsonValue;
        if (XCUIElement.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "updateAttribute(String)", 270).addDetail("attributeName", string)).log();
        }
        if ((jsonValue = this.d.getEngine().getDeviceControl().getAttribute(this, string)) == null) {
            return null;
        }
        this.f.set(string, jsonValue);
        return jsonValue;
    }

    @Override
    public int getChildCount() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getChildCount()", 282).log();
        }
        if (!this.f.contains("children")) {
            return 0;
        }
        return this.f.get("children").asArray().size();
    }

    @Override
    public Geometry getFrame() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getFrame()", 292).log();
        }
        try {
            return Geometry.fromJson((JsonValue)this.getAttributeAsJson("rect"));
        }
        catch (Exception exception) {
            if (XCUIElement.a.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(1, "getFrame()", 297).add("Could not get frame: ")).add((Object)exception)).log();
            }
            return null;
        }
    }

    @Override
    public Geometry getFrameInParent() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getFrameInParent()", 305).log();
        }
        Geometry geometry = this.getFrame();
        if (this.e != null) {
            geometry.relateTo(this.e.getFrame());
        }
        return geometry;
    }

    @Override
    public Geometry getVisibleFrame() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getVisibleFrame()", 318).log();
        }
        Geometry geometry = this.getFrame();
        if (this.d == null) {
            return geometry;
        }
        return geometry.intersect(this.d.getFrame());
    }

    @Override
    public boolean isPassword() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "isPassword()", 329).log();
        }
        return "SecureTextField".equals(this.getType());
    }

    @Override
    public boolean isMultiLine() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "isMultiLine()", 338).log();
        }
        return "TextView".equals(this.getType());
    }

    @Override
    public boolean isCheckable() {
        String string;
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "isCheckable()", 347).log();
        }
        return "CheckBox".equals(string = this.getType()) || "RadioButton".equals(string) || "Switch".equals(string);
    }

    @Override
    public boolean isChecked() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "isChecked()", 357).log();
        }
        return this.isAttributeTrue("value");
    }

    @Override
    public boolean isEditable() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "isEditable()", 367).log();
        }
        return true;
    }

    @Override
    public boolean isSelectable() {
        String string;
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "isSelectable()", 376).log();
        }
        return "Button".equals(string = this.getType()) || "Switch".equals(string);
    }

    @Override
    public boolean isSelected() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "isSelected()", 386).log();
        }
        return this.isAttributeTrue("value");
    }

    @Override
    public boolean isFocusable() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "isFocusable()", 394).log();
        }
        return this.f.contains("isFocused");
    }

    @Override
    public boolean isFocused() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "isFocused()", 403).log();
        }
        return this.isAttributeTrue("isFocused");
    }

    @Override
    public boolean hasKeyboardFocus() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "hasKeyboardFocus()", 412).log();
        }
        if (!this.f.contains("isActive")) {
            return false;
        }
        return this.isAttributeTrue("isActive");
    }

    @Override
    public boolean isActive() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "isActive()", 426).log();
        }
        return this.isAttributeTrue("isActive");
    }

    @Override
    public boolean isWebView() {
        String string;
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "isWebView()", 435).log();
        }
        return "Browser".equals(string = this.getType()) || "WebView".equals(string);
    }

    @Override
    public boolean hasText() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "hasText()", 445).log();
        }
        return !this.isCheckable();
    }

    @Override
    public boolean clear() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "clear()", 454).log();
        }
        return this.d.getEngine().getDeviceControl().clear(this);
    }

    @Override
    public boolean scrollIntoView() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "scrollIntoView()", 463).log();
        }
        return this.d.getEngine().getDeviceControl().scrollIntoView(this);
    }

    @Override
    public XCUIElement getChild(int n2) {
        block5: {
            if (XCUIElement.a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "getChild(int)", 472).addDetail("index", n2)).log();
            }
            if (this.f.contains("children")) {
                try {
                    JsonObject jsonObject = this.f.get("children").asArray().get(n2).asObject();
                    String string = XCUIElement.getUidFromJson(jsonObject);
                    if (XCUIElement.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getChild(int)", 478).add("childUid", string)).log();
                    }
                    return this.d.getElement(string);
                }
                catch (Exception exception) {
                    if (XCUIElement.a.level < 1) break block5;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(1, "getChild(int)", 482).add("Could not get child: ")).add((Object)exception)).log();
                }
            }
        }
        return null;
    }

    @Override
    public int getIndexOfChild(IOSElement iOSElement) {
        block8: {
            if (XCUIElement.a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "getIndexOfChild(IOSElement)", 492).addDetail("child", (Object)iOSElement)).log();
            }
            String string = iOSElement.getUid();
            if (this.f.contains("children")) {
                try {
                    JsonArray jsonArray = this.f.get("children").asArray();
                    int n2 = 0;
                    for (JsonValue jsonValue : jsonArray) {
                        String string2 = XCUIElement.getUidFromJson(jsonValue.asObject());
                        if (XCUIElement.a.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getIndexOfChild(IOSElement)", 501).add("expectedUid", string)).add("childUid", string2)).add("index", n2)).log();
                        }
                        if (Misc.equalOrNull((Object)string, (Object)string2)) {
                            return n2;
                        }
                        ++n2;
                    }
                    if (XCUIElement.a.level >= 5) {
                        ((LevelAwareLogBuilder)a.lvlBuild(5, "getIndexOfChild(IOSElement)", 507).add("Child not found")).log();
                    }
                }
                catch (Exception exception) {
                    if (XCUIElement.a.level < 1) break block8;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(1, "getIndexOfChild(IOSElement)", 509).add("Could not get child: ")).add((Object)exception)).log();
                }
            }
        }
        return -1;
    }

    @Override
    public void invalidate() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "invalidate()", 519).log();
        }
        this.invalidateChildren();
        this.h = false;
    }

    @Override
    public void invalidateChildren() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "invalidateChildren()", 528).log();
        }
        for (IOSElement iOSElement : this) {
            iOSElement.invalidate();
        }
    }

    @Override
    public String getClassName() {
        String string;
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getClassName()", 539).log();
        }
        if ((string = this.getType()) == null) {
            string = "Unknown";
        }
        return "XCUIElementType" + string;
    }

    @Override
    public ImageRep getScreenshot(MobileEngine mobileEngine) throws Exception {
        if (XCUIElement.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getScreenshot(MobileEngine)", 552).addDetail("mobileEngine", (Object)mobileEngine)).log();
        }
        IOSDeviceControl iOSDeviceControl = ((IOSEngine)mobileEngine).getDeviceControl();
        return iOSDeviceControl.grabScreenshot(this);
    }

    public String toString() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "toString()", 562).log();
        }
        StringBuilder stringBuilder = new StringBuilder(this.a() + "@");
        stringBuilder.append(this.getUid());
        stringBuilder.append('/');
        stringBuilder.append(System.identityHashCode(this));
        stringBuilder.append(':');
        stringBuilder.append(this.getType());
        stringBuilder.append(" {");
        boolean bl2 = true;
        for (JsonObject.Member member : this.f) {
            String string = member.getName();
            if (this.b.contains(string)) continue;
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(Json.value((String)string).toString());
            stringBuilder.append(":");
            JsonValue jsonValue = member.getValue();
            if (jsonValue == null) {
                stringBuilder.append("null");
                continue;
            }
            stringBuilder.append(jsonValue.toString());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    protected String a() {
        String string;
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getJavaClassName()", 597).log();
        }
        return Misc.emptyOrNull((String)(string = this.getBaseType())) ? "XCUIElement" : string;
    }

    @Override
    public List getJavaClassNames() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getJavaClassNames()", 607).log();
        }
        return Misc.listOf((Object[])new String[]{this.a(), "IOSElement"});
    }

    @Override
    public IOSApplication getApplication() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getApplication()", 616).log();
        }
        return this.d;
    }

    @Override
    public String getApplicationName() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getApplicationName()", 625).log();
        }
        return this.d != null && this.d != this ? this.d.getApplicationName() : this.getLabel();
    }

    @Override
    public String getApplicationBundleId() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getApplicationBundleId()", 634).log();
        }
        return this.d != null && this.d != this ? this.d.getApplicationBundleId() : (String)this.getAttribute("bundleId");
    }

    @Override
    public String getText() {
        String string;
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getText()", 643).log();
        }
        if ((string = this.getType()) == null) {
            return null;
        }
        if (!this.hasText()) {
            return null;
        }
        switch (string) {
            case "SecureTextField": 
            case "TextView": 
            case "TextField": 
            case "PickerWheel": 
            case "Slider": {
                return this.getValue();
            }
        }
        return this.getLabel();
    }

    @Override
    public Object getProperty(String string) {
        if (XCUIElement.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getProperty(String)", 669).addDetail("name", string)).log();
        }
        if (string == null) {
            return null;
        }
        ConcurrentHashMap concurrentHashMap = this.getProperties();
        if (concurrentHashMap != null) {
            return concurrentHashMap.get(string);
        }
        return null;
    }

    @Override
    public ConcurrentHashMap getProperties() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getProperties()", 684).log();
        }
        assert (this.d != null);
        ConcurrentHashMap concurrentHashMap = this.d.getPropertiesMap();
        return (ConcurrentHashMap)concurrentHashMap.get(this.c);
    }

    @Override
    public void setProperty(String string, Object object) {
        if (XCUIElement.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "setProperty(String,Object)", 696).addDetail("name", string)).addDetail("value", object)).log();
        }
        if (string == null) {
            return;
        }
        assert (this.d != null);
        ConcurrentHashMap concurrentHashMap = this.d.getPropertiesMap();
        ConcurrentHashMap<String, Object> concurrentHashMap2 = (ConcurrentHashMap<String, Object>)concurrentHashMap.get(this.c);
        if (concurrentHashMap2 == null) {
            if (object == null) {
                return;
            }
            ConcurrentHashMap concurrentHashMap3 = new ConcurrentHashMap();
            concurrentHashMap2 = concurrentHashMap.putIfAbsent(this.c, concurrentHashMap3);
            if (concurrentHashMap2 == null) {
                concurrentHashMap2 = concurrentHashMap3;
            }
        }
        if (object == null) {
            concurrentHashMap2.remove(string);
        } else {
            concurrentHashMap2.put(string, object);
        }
    }

    @Override
    @Nullable
    public String getUid() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getUid()", 55).log();
        }
        return this.c;
    }

    @Override
    @Nullable
    public XCUIElement getParent() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "getParent()", 57).log();
        }
        return this.e;
    }

    @Override
    public boolean isValid() {
        if (XCUIElement.a.level >= 7) {
            a.lvlBuild(7, "isValid()", 59).log();
        }
        return this.h;
    }
}

