/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.mobile.items;

import de.qfs.apps.qftest.client.mobile.MobileHelper;
import de.qfs.apps.qftest.client.mobile.toolkit.MobileComponent;
import de.qfs.apps.qftest.extensions.items.ItemParentResolver;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.extensions.items.ItemValueResolver;
import de.qfs.apps.qftest.shared.Geometry;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.LinkedList;

public class MobileTableItemResolver
implements ItemParentResolver,
ItemValueResolver {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.mobile.items.MobileTableItemResolver");
    protected static final LinkedList sTableItemResolverInstances = new LinkedList();
    protected final MobileHelper mHelper;
    protected String[] mTableClasses;
    protected String[] mTableHeaderRowClasses;
    protected String[] mTableHeaderCellClasses;
    protected String[] mTableRowClasses;
    protected String[] mTableItemClasses;
    protected final boolean mFilterInvisibleItems;
    protected final boolean mFilterGeometryItems;
    protected final int mHeaderIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MobileTableItemResolver(MobileHelper mobileHelper, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5) {
        if (MobileTableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "MobileTableItemResolver(MobileHelper,String[],String[],String[],String[],String[])", 112).addDetail("helper", (Object)mobileHelper)).addDetail("tableClasses", (Object)stringArray)).addDetail("tableHeaderRowClasses", (Object)stringArray2)).addDetail("tableHeaderCellClasses", (Object)stringArray3)).addDetail("tableRowClasses", (Object)stringArray4)).addDetail("tableItemClasses", (Object)stringArray5)).log();
        }
        if (mobileHelper == null) {
            throw new NullPointerException("Helper must not be null!");
        }
        this.mHelper = mobileHelper;
        this.mTableClasses = stringArray;
        this.mTableHeaderRowClasses = stringArray2;
        this.mTableHeaderCellClasses = stringArray3;
        this.mTableRowClasses = stringArray4;
        this.mTableItemClasses = stringArray5;
        this.mFilterInvisibleItems = Options.cached_OPT_ANDROID_TABLE_ITEM_RESOLVER_FILTER_INVISIBLE;
        this.mFilterGeometryItems = Options.cached_OPT_ANDROID_TABLE_ITEM_RESOLVER_FILTER_GEOMETRY;
        this.mHeaderIndex = Options.cached_OPT_ANDROID_TABLE_ITEM_RESOLVER_HEADER_TO_TAKE;
        LinkedList linkedList = sTableItemResolverInstances;
        synchronized (linkedList) {
            sTableItemResolverInstances.add(this);
        }
    }

    public void register() {
        if (MobileTableItemResolver.a.level >= 7) {
            a.lvlBuild(7, "register()", 143).log();
        }
        for (String string : this.mTableClasses) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)this);
            ItemRegistry.instance().registerItemValueResolver(string, (ItemValueResolver)this);
        }
        for (String string : this.mTableHeaderRowClasses) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)this);
        }
        for (String string : this.mTableHeaderCellClasses) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)this);
        }
        for (String string : this.mTableRowClasses) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)this);
        }
        for (String string : this.mTableItemClasses) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)this);
        }
    }

    public void unregister() {
        if (MobileTableItemResolver.a.level >= 7) {
            a.lvlBuild(7, "unregister()", 169).log();
        }
        this.a(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(boolean bl2) {
        if (MobileTableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "unregister(boolean)", 179).addDetail("remove", bl2)).log();
        }
        for (String string : this.mTableClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
            ItemRegistry.instance().unregisterItemValueResolver(string, (ItemValueResolver)this);
        }
        for (String string : this.mTableHeaderRowClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
        }
        for (String string : this.mTableHeaderCellClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
        }
        for (String string : this.mTableRowClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
        }
        for (String string : this.mTableItemClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
        }
        if (bl2) {
            LinkedList linkedList = sTableItemResolverInstances;
            synchronized (linkedList) {
                int n2 = sTableItemResolverInstances.remove(this) ? 1 : 0;
                if (MobileTableItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "unregister(boolean)", 201).add("removed: ")).add(n2 != 0)).log();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterAll() {
        if (MobileTableItemResolver.a.level >= 7) {
            a.lvlBuild(7, "unregisterAll()", 209).log();
        }
        LinkedList linkedList = sTableItemResolverInstances;
        synchronized (linkedList) {
            for (MobileTableItemResolver mobileTableItemResolver : sTableItemResolverInstances) {
                try {
                    mobileTableItemResolver.a(false);
                }
                catch (Throwable throwable) {
                    if (MobileTableItemResolver.a.level < 3) continue;
                    ((LevelAwareLogBuilder)a.lvlBuild(3, "unregisterAll()", 216).add("t", (Object)throwable)).log();
                }
            }
            sTableItemResolverInstances.clear();
        }
    }

    public MobileComponent getParentObject(MobileComponent mobileComponent, String[] stringArray) {
        if (MobileTableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getParentObject(MobileComponent,String[])", 226).addDetail("com", (Object)mobileComponent)).addDetail("parentClasses", (Object)stringArray)).log();
        }
        while (mobileComponent != null && !this.mHelper.isMatchingClass((Object)mobileComponent, stringArray)) {
            mobileComponent = mobileComponent.getParent();
        }
        return mobileComponent;
    }

    public LinkedList getVisibleElementsByClassName(MobileComponent mobileComponent, String[] stringArray) {
        if (MobileTableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getVisibleElementsByClassName(MobileComponent,String[])", 236).addDetail("parent", (Object)mobileComponent)).addDetail("classNames", (Object)stringArray)).log();
        }
        Object[] objectArray = this.mHelper.getElementsByClassName((Object)mobileComponent, stringArray);
        LinkedList<MobileComponent> linkedList = new LinkedList<MobileComponent>();
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (!(objectArray[i2] instanceof MobileComponent)) continue;
                MobileComponent mobileComponent2 = (MobileComponent)objectArray[i2];
                Geometry geometry = mobileComponent2.getFrame();
                if (this.mFilterGeometryItems && (geometry.getWidth() <= 0 || geometry.getHeight() <= 0) || this.mFilterInvisibleItems && !this.mHelper.isVisible(mobileComponent2)) continue;
                linkedList.add(mobileComponent2);
            }
        }
        return linkedList;
    }

    public int getIndex(MobileComponent mobileComponent, MobileComponent mobileComponent2, String[] stringArray) {
        if (MobileTableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getIndex(MobileComponent,MobileComponent,String[])", 260).addDetail("parent", (Object)mobileComponent)).addDetail("child", (Object)mobileComponent2)).addDetail("classNames", (Object)stringArray)).log();
        }
        LinkedList linkedList = this.getVisibleElementsByClassName(mobileComponent, stringArray);
        int n2 = 0;
        for (MobileComponent mobileComponent3 : linkedList) {
            if (mobileComponent3 == mobileComponent2) {
                return n2;
            }
            ++n2;
        }
        return Integer.MIN_VALUE;
    }

    public MobileComponent getElementByIndex(MobileComponent mobileComponent, int n2, String[] stringArray) {
        if (MobileTableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getElementByIndex(MobileComponent,int,String[])", 275).addDetail("parent", (Object)mobileComponent)).addDetail("idx", n2)).addDetail("classNames", (Object)stringArray)).log();
        }
        LinkedList linkedList = this.getVisibleElementsByClassName(mobileComponent, stringArray);
        if (n2 < 0) {
            n2 = linkedList.size() + n2;
        }
        if (0 <= n2 && n2 < linkedList.size()) {
            return (MobileComponent)linkedList.get(n2);
        }
        return null;
    }

    public int getVisibleColumnCount(MobileComponent mobileComponent) {
        MobileComponent mobileComponent2;
        if (MobileTableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getVisibleColumnCount(MobileComponent)", 289).addDetail("table", (Object)mobileComponent)).log();
        }
        if ((mobileComponent2 = this.getElementByIndex(mobileComponent, this.mHeaderIndex, this.mTableHeaderRowClasses)) != null) {
            LinkedList linkedList = this.getVisibleElementsByClassName(mobileComponent2, this.mTableHeaderCellClasses);
            return linkedList.size();
        }
        MobileComponent mobileComponent3 = this.getElementByIndex(mobileComponent, 0, this.mTableRowClasses);
        if (mobileComponent3 != null) {
            LinkedList linkedList = this.getVisibleElementsByClassName(mobileComponent3, this.mTableItemClasses);
            return linkedList.size();
        }
        return 0;
    }

    public String getColumnName(MobileComponent mobileComponent, int n2) {
        MobileComponent mobileComponent2;
        if (MobileTableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getColumnName(MobileComponent,int)", 306).addDetail("table", (Object)mobileComponent)).addDetail("i", n2)).log();
        }
        if ((mobileComponent2 = this.getElementByIndex(mobileComponent, this.mHeaderIndex, this.mTableHeaderRowClasses)) != null) {
            MobileComponent mobileComponent3 = this.getElementByIndex(mobileComponent2, n2, this.mTableHeaderCellClasses);
            return this.mHelper.getFlatIdentifierText(mobileComponent3);
        }
        return null;
    }

    public int getRowCount(MobileComponent mobileComponent) {
        if (MobileTableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getRowCount(MobileComponent)", 318).addDetail("table", (Object)mobileComponent)).log();
        }
        LinkedList linkedList = this.getVisibleElementsByClassName(mobileComponent, this.mTableRowClasses);
        return linkedList.size();
    }

    public String getCellName(MobileComponent mobileComponent, int n2, int n3) {
        if (MobileTableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCellName(MobileComponent,int,int)", 326).addDetail("table", (Object)mobileComponent)).addDetail("row", n2)).addDetail("cell", n3)).log();
        }
        try {
            MobileComponent mobileComponent2 = this.getElementByIndex(mobileComponent, n2, this.mTableRowClasses);
            MobileComponent mobileComponent3 = this.getElementByIndex(mobileComponent2, n3, this.mTableItemClasses);
            return this.mHelper.getFlatIdentifierText(mobileComponent3);
        }
        catch (IndexOutOfBoundsException | NullPointerException runtimeException) {
            if (MobileTableItemResolver.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getCellName(MobileComponent,int,int)", 332).add("IndexOutOfBoundsException | NullPointerException", (Object)runtimeException)).log();
            }
            return null;
        }
    }

    @Override
    public Object[] getParentAndItem(Object object) {
        int n2;
        MobileComponent mobileComponent;
        MobileComponent mobileComponent2;
        if (MobileTableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getParentAndItem(Object)", 345).addDetail("element", object)).log();
        }
        if (!(object instanceof MobileComponent)) {
            if (MobileTableItemResolver.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getParentAndItem(Object)", 348).add("Not an MobileComponent", object)).dumpStack();
            }
            return null;
        }
        MobileComponent mobileComponent3 = (MobileComponent)object;
        if (this.mHelper.isMatchingClass(object, this.mTableItemClasses) && (mobileComponent2 = this.getParentObject(mobileComponent3, this.mTableRowClasses)) != null && (mobileComponent = this.getParentObject(mobileComponent2, this.mTableClasses)) != null) {
            n2 = this.getIndex(mobileComponent2, mobileComponent3, this.mTableItemClasses);
            int n3 = this.getIndex(mobileComponent, mobileComponent2, this.mTableRowClasses);
            if (n2 != Integer.MIN_VALUE && n3 != Integer.MIN_VALUE) {
                return new Object[]{mobileComponent, new int[]{n2, n3}};
            }
        }
        if (this.mHelper.isMatchingClass(object, this.mTableHeaderCellClasses) && (mobileComponent2 = this.getParentObject(mobileComponent3, this.mTableHeaderRowClasses)) != null && (mobileComponent = this.getParentObject(mobileComponent2, this.mTableClasses)) != null && (n2 = this.getIndex(mobileComponent2, mobileComponent3, this.mTableHeaderCellClasses)) != Integer.MIN_VALUE) {
            return new Object[]{mobileComponent, new int[]{n2}};
        }
        return null;
    }

    @Override
    public Object getElement(Object object, Object object2) throws TestException {
        if (MobileTableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getElement(Object,Object)", 383).addDetail("element", object)).addDetail("item", object2)).log();
        }
        if (!(object instanceof MobileComponent)) {
            if (MobileTableItemResolver.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getElement(Object,Object)", 386).add("Not an MobileComponent", object)).dumpStack();
            }
            return null;
        }
        MobileComponent mobileComponent = (MobileComponent)object;
        if (!this.mHelper.isMatchingClass((Object)mobileComponent, this.mTableClasses)) {
            if (MobileTableItemResolver.a.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "getElement(Object,Object)", 391).add("MobileComponent is not a table!")).addDetail("Element", object)).addDetail("classes", (Object)this.mTableClasses)).log();
            }
            return null;
        }
        if (!(object2 instanceof int[])) {
            if (MobileTableItemResolver.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getElement(Object,Object)", 395).add("Not an int array", object2)).dumpStack();
            }
            return null;
        }
        int[] nArray = (int[])object2;
        if (nArray.length == 1) {
            int n2 = nArray[0];
            MobileComponent mobileComponent2 = this.getElementByIndex(mobileComponent, this.mHeaderIndex, this.mTableHeaderRowClasses);
            if (mobileComponent2 != null) {
                MobileComponent mobileComponent3 = this.getElementByIndex(mobileComponent2, n2, this.mTableHeaderCellClasses);
                return mobileComponent3;
            }
        } else if (nArray.length == 2) {
            int n3 = nArray[0];
            int n4 = nArray[1];
            MobileComponent mobileComponent4 = this.getElementByIndex(mobileComponent, n4, this.mTableRowClasses);
            if (mobileComponent4 != null) {
                MobileComponent mobileComponent5 = this.getElementByIndex(mobileComponent4, n3, this.mTableItemClasses);
                return mobileComponent5;
            }
        } else if (MobileTableItemResolver.a.level >= 3) {
            ((LevelAwareLogBuilder)a.lvlBuild(3, "getElement(Object,Object)", 415).add("Int array of invalid length", object)).dumpStack();
        }
        return null;
    }

    @Override
    public Object getItemForIndex(Object object, SubItemIndex[] subItemIndexArray) throws TestException {
        int n2;
        int[] nArray;
        block19: {
            MobileComponent mobileComponent;
            block18: {
                int n3;
                block17: {
                    block16: {
                        if (MobileTableItemResolver.a.level >= 7) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForIndex(Object,SubItemIndex[])", 424).addDetail("element", object)).addDetail("idx", (Object)subItemIndexArray)).log();
                        }
                        if (!(object instanceof MobileComponent)) {
                            if (MobileTableItemResolver.a.level >= 3) {
                                ((LevelAwareLogBuilder)a.lvlBuild(3, "getItemForIndex(Object,SubItemIndex[])", 427).add("Not an MobileComponent", object)).dumpStack();
                            }
                            throw new BadItemException("Table is not an MobileComponent");
                        }
                        mobileComponent = (MobileComponent)object;
                        if (!this.mHelper.isMatchingClass((Object)mobileComponent, this.mTableClasses)) {
                            if (MobileTableItemResolver.a.level >= 3) {
                                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "getItemForIndex(Object,SubItemIndex[])", 432).add("MobileComponent is not a table!")).addDetail("Element", object)).addDetail("classes", (Object)this.mTableClasses)).log();
                            }
                            throw new BadItemException("Table is not an MobileComponent");
                        }
                        if (subItemIndexArray == null || subItemIndexArray.length == 0) {
                            if (MobileTableItemResolver.a.level >= 3) {
                                ((LevelAwareLogBuilder)a.lvlBuild(3, "getItemForIndex(Object,SubItemIndex[])", 436).add("Table needs subitems", object)).dumpStack();
                            }
                            throw new BadItemException("SubItems?");
                        }
                        nArray = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};
                        n3 = this.getVisibleColumnCount(mobileComponent);
                        if (subItemIndexArray[0].getType() != 1) break block16;
                        nArray[0] = subItemIndexArray[0].asNumber();
                        if (nArray[0] >= 0) break block17;
                        nArray[0] = n3 + nArray[0];
                        break block17;
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        String string = this.getColumnName(mobileComponent, n2);
                        if (!subItemIndexArray[0].matches(string)) continue;
                        nArray[0] = n2;
                        break;
                    }
                }
                if (nArray[0] < 0 || nArray[0] >= n3) {
                    if (MobileTableItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 458).add("item[0]", nArray[0])).dumpStack();
                    }
                    throw new IndexNotFoundException(subItemIndexArray[0]);
                }
                if (subItemIndexArray.length == 1) {
                    ItemRegistry.instance().setIndexesResolved(1);
                    return new int[]{nArray[0]};
                }
                n2 = this.getRowCount(mobileComponent);
                if (subItemIndexArray[1].getType() != 1) break block18;
                nArray[1] = subItemIndexArray[1].asNumber();
                if (nArray[1] >= 0) break block19;
                nArray[1] = n2 + nArray[1];
                break block19;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = this.getCellName(mobileComponent, i2, nArray[0]);
                if (!subItemIndexArray[1].matches(string)) continue;
                nArray[1] = i2;
                break;
            }
        }
        if (nArray[1] < 0 || nArray[1] >= n2) {
            if (MobileTableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 483).add("item[1]", nArray[1])).dumpStack();
            }
            if (subItemIndexArray[1].isElementSyntax()) {
                ItemRegistry.instance().setIndexesResolved(1);
                return new int[]{nArray[0]};
            }
            throw new IndexNotFoundException(subItemIndexArray[1]);
        }
        ItemRegistry.instance().setIndexesResolved(2);
        if (MobileTableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 494).add("item", (Object)nArray)).log();
        }
        return nArray;
    }

    @Override
    public SubItemIndex[] getItemIndex(Object object, Object object2, int n2) throws TestException {
        if (MobileTableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object,int)", 502).addDetail("element", object)).addDetail("item", object2)).addDetail("type", n2)).log();
        }
        if (!(object instanceof MobileComponent)) {
            if (MobileTableItemResolver.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getItemIndex(Object,Object,int)", 506).add("Not an MobileComponent", object)).dumpStack();
            }
            return null;
        }
        if (!this.mHelper.isMatchingClass(object, this.mTableClasses)) {
            if (MobileTableItemResolver.a.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "getItemIndex(Object,Object,int)", 510).add("MobileComponent is not a table!")).addDetail("Element", object)).addDetail("classes", (Object)this.mTableClasses)).log();
            }
            return null;
        }
        MobileComponent mobileComponent = (MobileComponent)object;
        if (!(object2 instanceof int[])) {
            if (MobileTableItemResolver.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getItemIndex(Object,Object,int)", 516).add("Not an int array", object2)).dumpStack();
            }
            return null;
        }
        int[] nArray = (int[])object2;
        if (nArray.length == 1) {
            String string = null;
            if (n2 == 1 || n2 == 2) {
                string = this.getColumnName(mobileComponent, nArray[0]);
                if (n2 == 1) {
                    if (Misc.emptyOrNull((String)string)) {
                        n2 = 3;
                    } else {
                        for (int i2 = 0; i2 < nArray[0]; ++i2) {
                            String string2 = this.getColumnName(mobileComponent, i2);
                            if (!string.contentEquals(string2)) continue;
                            n2 = 3;
                            break;
                        }
                    }
                }
            }
            switch (n2) {
                case 1: 
                case 2: {
                    return new SubItemIndex[]{new SubItemIndex(string == null ? "" : string, "\\#@&%")};
                }
                case 3: {
                    return new SubItemIndex[]{new SubItemIndex(nArray[0])};
                }
            }
        } else if (nArray.length == 2) {
            String string;
            SubItemIndex subItemIndex = this.getItemIndex(object, new int[]{nArray[0]}, n2)[0];
            SubItemIndex subItemIndex2 = null;
            subItemIndex2 = n2 == 1 || n2 == 3 ? new SubItemIndex(nArray[1]) : new SubItemIndex((string = this.getCellName(mobileComponent, nArray[1], nArray[0])) == null ? "" : string, "\\#@&%");
            return new SubItemIndex[]{subItemIndex, subItemIndex2};
        }
        return null;
    }

    @Override
    public String getItemValue(Object object, Object object2) {
        if (MobileTableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemValue(Object,Object)", 574).addDetail("element", object)).addDetail("item", object2)).log();
        }
        try {
            MobileComponent mobileComponent = (MobileComponent)this.getElement(object, object2);
            return this.mHelper.getWholeText(mobileComponent);
        }
        catch (Throwable throwable) {
            if (MobileTableItemResolver.a.level >= 5) {
                ((LevelAwareLogBuilder)a.lvlBuild(5, "getItemValue(Object,Object)", 580).add("getItemValue()", (Object)throwable)).log();
            }
            return null;
        }
    }
}

