/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.resolvers.web;

import de.qfs.apps.qftest.client.Engine;
import de.qfs.apps.qftest.client.Tracker;
import de.qfs.apps.qftest.client.resolvers.VersionedResolver;
import de.qfs.apps.qftest.client.web.AttributeChangedHook;
import de.qfs.apps.qftest.client.web.WebEngine;
import de.qfs.apps.qftest.client.web.WebTracker;
import de.qfs.apps.qftest.client.web.ap;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.Node;
import de.qfs.apps.qftest.extensions.ClassNameResolver;
import de.qfs.apps.qftest.extensions.FeatureResolver2;
import de.qfs.apps.qftest.extensions.IdResolver;
import de.qfs.apps.qftest.extensions.ResolverRegistry;
import de.qfs.apps.qftest.shared.data.ExtraFeature;
import de.qfs.apps.qftest.shared.data.ExtraFeatureSet;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GwtResolver_1_0_0
extends VersionedResolver
implements AttributeChangedHook,
ClassNameResolver,
FeatureResolver2,
IdResolver {
    private static final QFLogger c = new QFLogger("de.qfs.apps.qftest.client.resolvers.web.GwtResolver_1_0_0");
    protected static String[] gwtClasses = new String[]{"gwt-HTML", "gwt-Hyperlink", "gwt-InlineHTML", "gwt-InlineLabel", "gwt-Label", "gwt-TextBox", "gwt-PasswordTextBox", "gwt-TextArea", "gwt-RichTextArea", "gwt-ListBox", "gwt-Button", "gwt-ToggleButton", "gwt-PushButton", "gwt-CustomButton", "gwt-CheckBox", "gwt-SimpleCheckBox", "gwt-RadioButton", "gwt-SimpleRadioButton", "gwt-Tree", "gwt-TreeItem", "gwt-MenuBar", "gwt-MenuBarPopup", "gwt-MenuItem", "gwt-MenuItemSeparator", "gwt-SuggestBox", "gwt-SuggestBoxPopup", "gwt-DecoratedTabBar", "gwt-TabBar", "gwt-TabBarItem", "gwt-TabBarFirst", "gwt-TabBarRest", "gwt-DecoratedTabPanel", "gwt-TabPanel", "gwt-TabPanelBottom", "gwt-StackPanel", "gwt-DecoratedStackPanel", "gwt-StackPanelItem", "gwt-StackPanelContent", "gwt-PopupPanel", "gwt-DecoratedPopupPanel", "gwt-DecoratorPanel", "gwt-DisclosurePanel", "gwt-HorizontalSplitPanel", "gwt-VerticalSplitPanel", "gwt-Anchor", "gwt-DialogBox", "gwt-FileUpload", "gwt-Frame"};
    protected static HashMap gwtClassMap = new HashMap();
    protected static HashSet treeClasses = new HashSet();
    protected static HashSet textFeatureClasses = new HashSet();
    protected static HashSet simpleTextFeatureClasses;
    protected static HashSet postponedFeatureClasses;
    protected static HashMap eventRedirectMap;

    @Override
    public void install() {
        ResolverRegistry.instance().registerClassNameResolver("DOM_NODE", (ClassNameResolver)this);
        ResolverRegistry.instance().registerIdResolver(this);
        Engine engine = Engine.instance("web");
        Tracker tracker = engine.getTracker();
        ((WebTracker)Engine.instance("web").getTracker()).addAttributeChangedHook(null, this);
    }

    @Override
    public void uninstall() {
        ResolverRegistry.instance().unregisterClassNameResolver("DOM_NODE", (ClassNameResolver)this);
        ResolverRegistry.instance().unregisterIdResolver(this);
        ((WebTracker)Engine.instance("web").getTracker()).removeAttributeChangedHook(null, this);
    }

    @Override
    public String getClassName(Object object, String string) {
        String string2;
        if (GwtResolver_1_0_0.c.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "getClassName(Object,String)", 209).addDetail("element", object)).addDetail("className", string)).log();
        }
        if (!(object instanceof DomNode)) {
            return null;
        }
        DomNode domNode = (DomNode)object;
        ExtraFeatureSet extraFeatureSet = null;
        String string3 = this.getGwtClass(domNode);
        if (GwtResolver_1_0_0.c.level >= 9) {
            ((LevelAwareLogBuilder)c.lvlBuild(9, "getClassName(Object,String)", 220).add("gwtClass", string3)).log();
        }
        if (string3 == null) {
            if (postponedFeatureClasses.contains(string)) {
                this.installFeatureResolver(domNode);
            } else {
                this.setResolvedFeatureFromClass(domNode, string);
            }
            if (eventRedirectMap.containsKey(string)) {
                domNode.setProperty("qfs:redirectmouse", eventRedirectMap.get(string));
            }
            return null;
        }
        extraFeatureSet = extraFeatureSet != null ? extraFeatureSet : new ExtraFeatureSet();
        extraFeatureSet.add(new ExtraFeature(0, "tag", string));
        domNode.setProperty("qfs:extrafeatures", extraFeatureSet);
        domNode.setProperty("qfs:interestingparent", null);
        if ("GWT-TREEITEM".equals(string3)) {
            string2 = this.treeGetPath(domNode);
            extraFeatureSet.add(new ExtraFeature(1, "path", string2));
        }
        if (postponedFeatureClasses.contains(string3)) {
            this.installFeatureResolver(domNode);
        } else {
            this.setResolvedFeatureFromClass(domNode, string3);
        }
        string2 = domNode.getAttribute("class");
        if (!Misc.emptyOrNull((String)string2)) {
            extraFeatureSet.add(new ExtraFeature(0, "class", string2));
        }
        if (eventRedirectMap.containsKey(string3)) {
            domNode.setProperty("qfs:redirectmouse", eventRedirectMap.get(string3));
        }
        return string3;
    }

    public String getId_1_0_0(Object object, String string) {
        DomNode domNode;
        if (GwtResolver_1_0_0.c.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "getId_1_0_0(Object,String)", 273).addDetail("element", object)).addDetail("id", string)).log();
        }
        if (!(object instanceof DomNode)) {
            return null;
        }
        DomNode domNode2 = (DomNode)object;
        boolean bl2 = false;
        String string2 = null;
        if (string != null) {
            if (string.startsWith("gwt-uid-")) {
                string2 = "";
            } else if (string.startsWith("gwt-debug-")) {
                string2 = string.substring(10);
            }
        }
        Node node = domNode2.getParent();
        if ("TBODY".equals(domNode2.getName()) && node instanceof DomNode) {
            bl2 |= node.getClassName().indexOf("STACKPANEL") > 0;
            bl2 |= node.getClassName().indexOf("TABPANEL") > 0;
            bl2 |= node.getClassName().indexOf("TABBAR") > 0;
        } else if ("TD".equals(domNode2.getName()) && domNode2.getChildCount() > 0) {
            bl2 |= this.a(domNode2, "GWT-DECORATEDTABPANEL") && this.b(domNode2, "GWT-DECORATEDTABBAR");
            bl2 |= this.a(domNode2, "GWT-DECORATEDTABPANEL") && this.b(domNode2, "GWT-TABPANELBOTTOM");
            bl2 |= this.a(domNode2, "GWT-DECORATEDTABBAR") && this.b(domNode2, "GWT-TABBARITEM");
        } else if ("TR".equals(domNode2.getName()) && domNode2.getChildCount() > 0) {
            bl2 |= "GWT-STACKPANELCONTENT".equals(domNode2.getChild(0).getClassName());
            bl2 |= "GWT-STACKPANELITEM".equals(domNode2.getChild(0).getClassName());
            bl2 |= this.a(domNode2, "GWT-DECORATEDTABPANEL") && this.b(domNode2, "GWT-DECORATEDTABBAR");
            bl2 |= this.a(domNode2, "GWT-DECORATEDTABPANEL") && this.b(domNode2, "GWT-TABPANELBOTTOM");
            bl2 |= this.a(domNode2, "GWT-DECORATEDTABBAR") && this.b(domNode2, "GWT-TABBARITEM");
        }
        if (bl2 |= "CLIPPER".equals(domNode2.getName())) {
            if (GwtResolver_1_0_0.c.level >= 9) {
                ((LevelAwareLogBuilder)c.lvlBuild(9, "getId_1_0_0(Object,String)", 320).add("Make not interesting", (Object)domNode2)).log();
            }
            domNode2.setProperty("qfs:interestingparent", Boolean.FALSE);
        }
        if ("IMG".equals(domNode2.getClassName()) && (domNode = this.d(domNode2)) != null) {
            String string3 = domNode.getSimpleText().trim();
            if (string3 != null) {
                domNode2.setProperty("qfs:feature", string3);
            }
            this.setExtraFeature(domNode2, "path", this.treeGetPath(domNode), 1);
        }
        return string2;
    }

    @Override
    public String getId(Object object, String string) {
        return this.getId_1_0_0(object, string);
    }

    @Override
    public String getFeature(Object object, String string) {
        ResolverRegistry.instance().unregisterFeatureResolver2(object, (FeatureResolver2)this);
        DomNode domNode = (DomNode)object;
        String string2 = null;
        if ("DIV".equals(domNode.getClassName()) && "GWT-TABPANELBOTTOM".equals(domNode.getParent().getClassName())) {
            string2 = this.b(domNode);
        }
        return string2;
    }

    @Override
    public void attributeChanged(DomNode domNode, String string, String string2, String string3) {
        if (GwtResolver_1_0_0.c.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "attributeChanged(DomNode,String,String,String)", 406).addDetail("node", (Object)domNode)).addDetail("attribute", string)).addDetail("oldValue", string2)).addDetail("newValue", string3)).log();
        }
        if ("class".equals(string)) {
            this.setExtraFeature(domNode, "class", domNode.getAttribute("class"), 0);
        }
        WebEngine webEngine = (WebEngine)Engine.threadInstance("web");
        if (GwtResolver_1_0_0.c.level >= 9) {
            ((LevelAwareLogBuilder)c.lvlBuild(9, "attributeChanged(DomNode,String,String,String)", 430).add("engine", (Object)webEngine)).log();
        }
        if (webEngine != null) {
            ((ap)webEngine.getPlayer()).notifySystemEventsPending(System.currentTimeMillis() + 30L);
        }
    }

    public boolean tabpanelIsItemSelected(DomNode domNode) throws TestException {
        this.checkClassName(domNode, "GWT-TABBARITEM");
        String string = domNode.getAttribute("class");
        if (string != null) {
            return string.indexOf("-selected") > 0;
        }
        return false;
    }

    private boolean a(DomNode domNode) {
        DomNode domNode2 = GwtResolver_1_0_0.c(domNode);
        if (domNode2 == null) {
            return true;
        }
        String string = domNode2.getAttribute("style");
        Pattern pattern = Pattern.compile("scroll\\s+([-\\d]*)px\\s+([-\\d]*)px|scroll\\s+([-\\d]*)px");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            if (matcher.group(3) != null && Integer.parseInt(matcher.group(3)) == 0) {
                return true;
            }
            if (matcher.group(1) != null && matcher.group(2) != null) {
                int n2 = Integer.parseInt(matcher.group(1));
                int n3 = Integer.parseInt(matcher.group(2));
                if (n2 == 0 && n3 == 0) {
                    return true;
                }
                if (n2 < -32 && n3 == 0) {
                    return true;
                }
            }
        } else {
            int n4 = domNode2.getLocationOnScreen()[2];
            int n5 = domNode2.getLocationOnScreen()[3];
            if (n4 == 16 && n5 == 16) {
                return true;
            }
            if (n4 > 48 && n5 == 16) {
                return true;
            }
        }
        return false;
    }

    public boolean treeIsNodeExpanded(DomNode domNode) throws TestException {
        this.checkClassName(domNode, "GWT-TREEITEM");
        DomNode domNode2 = GwtResolver_1_0_0.e(domNode);
        if (domNode2 != null) {
            return ((DomNode)domNode2.getChild(1)).isShowing();
        }
        return true;
    }

    public boolean treeIsNodeSelected(DomNode domNode) throws TestException {
        this.checkClassName(domNode, "GWT-TREEITEM");
        String string = domNode.getAttribute("class");
        if (string != null) {
            return string.indexOf("-selected") > 0;
        }
        return false;
    }

    private String b(DomNode domNode) {
        Node node = null;
        try {
            node = domNode.getParent();
            this.checkClassName(node, "GWT-TABPANELBOTTOM");
        }
        catch (TestException testException) {
            if (GwtResolver_1_0_0.c.level >= 5) {
                ((LevelAwareLogBuilder)c.lvlBuild(5, "tabpanelSetContentFeature(DomNode)", 546).add("ex", (Object)testException)).log();
            }
            return null;
        }
        DomNode domNode2 = this.c(domNode, "GWT-DECORATEDTABPANEL");
        if (domNode2 == null) {
            domNode2 = this.c(domNode, "GWT-TABPANEL");
        }
        if (domNode2 != null) {
            Node[] nodeArray = domNode2.getElementsByClassName("GWT-TABBARITEM");
            Node[] nodeArray2 = node.getChildren();
            for (int i2 = 0; i2 < nodeArray2.length; ++i2) {
                if (domNode != nodeArray2[i2]) continue;
                String string = (String)nodeArray[i2].getProperty("qfs:feature");
                if (!Misc.emptyOrNull((String)string)) {
                    domNode.setProperty("qfs:feature", string);
                }
                return string;
            }
        }
        return null;
    }

    private static DomNode c(DomNode domNode) {
        for (Node node = domNode.getParent(); node != null && !"GWT-TREE".equals(node.getClassName()); node = node.getParent()) {
            Node[] nodeArray;
            if (!"TR".equals(node.getName()) || (nodeArray = node.getElementsByTagName("IMG")).length <= 0) continue;
            if (nodeArray[0].getParent() == domNode) {
                return null;
            }
            return (DomNode)nodeArray[0];
        }
        return null;
    }

    private DomNode d(DomNode domNode) {
        for (Node node = domNode.getParent(); node != null && !"GWT-TREE".equals(node.getClassName()); node = node.getParent()) {
            Node[] nodeArray;
            if (!"TR".equals(node.getName()) || (nodeArray = node.getElementsByClassName("GWT-TREEITEM")).length != 1) continue;
            return (DomNode)nodeArray[0];
        }
        return null;
    }

    private static DomNode e(DomNode domNode) {
        for (Node node = domNode.getParent(); node != null && !"GWT-TREE".equals(node.getClassName()); node = node.getParent()) {
            if (!"TABLE".equals(node.getChild(0).getName()) || node.getChildCount() != 2 || !"DIV".equals(node.getChild(1).getName())) continue;
            return (DomNode)node;
        }
        return null;
    }

    private DomNode f(DomNode domNode) {
        Node node = null;
        for (Node node2 = domNode.getParent(); node2 != null && !"GWT-TREE".equals(node2.getClassName()); node2 = node2.getParent()) {
            Node node3 = node2.getChild(0);
            if ("TABLE".equals(node3.getName()) && node3 != node) {
                return (DomNode)node2;
            }
            node = node2;
        }
        return null;
    }

    private String g(DomNode domNode) {
        return domNode.getSimpleText().trim();
    }

    private String h(DomNode domNode) {
        Node[] nodeArray;
        Node node = domNode.getChild(0);
        if ("TABLE".equals(node.getName()) && (nodeArray = node.getElementsByClassName("GWT-TREEITEM")).length == 1) {
            return this.g((DomNode)nodeArray[0]);
        }
        return "";
    }

    protected String treeGetPath(DomNode domNode) {
        String string = "/" + this.g(domNode);
        DomNode domNode2 = this.f(domNode);
        while (domNode2 != null) {
            String string2 = this.h(domNode2);
            string = "/" + string2 + string;
            domNode2 = this.f(domNode2);
        }
        return string;
    }

    protected String getGwtClass(DomNode domNode) {
        String string = domNode.getAttribute("class");
        if (string != null && string.startsWith("gwt-")) {
            HashSet<String> hashSet = new HashSet<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken());
            }
            for (int i2 = 0; i2 < gwtClasses.length; ++i2) {
                if (!hashSet.contains(gwtClasses[i2])) continue;
                return gwtClasses[i2].toUpperCase();
            }
            for (String string2 : gwtClassMap.keySet()) {
                if (!hashSet.contains(string2)) continue;
                return ((String)gwtClassMap.get(string2)).toUpperCase();
            }
        }
        return null;
    }

    protected void checkClassName(Node node, String string) throws TestException {
        if (!node.isMatchingClass(string)) {
            throw new TestException("Expected class: " + string + "\nGot: " + node.getClassName());
        }
    }

    protected DomNode getParentWithClass(DomNode domNode, String string) {
        Node node;
        for (node = domNode.getParent(); node != null; node = node.getParent()) {
            if (node.getProperty("qfs:interestingparent") == Boolean.FALSE) {
                continue;
            }
            if (node instanceof DomNode && string.equals(node.getClassName())) break;
            return null;
        }
        return (DomNode)node;
    }

    private boolean a(DomNode domNode, String string) {
        return this.c(domNode, string) != null;
    }

    private boolean b(DomNode domNode, String string) {
        Node[] nodeArray = domNode.getElementsByClassName(string);
        return nodeArray.length > 0;
    }

    protected String setResolvedFeatureFromParent(DomNode domNode, String string) {
        Object object;
        DomNode domNode2 = this.getParentWithClass(domNode, string);
        if (domNode2 != null && (object = domNode2.getProperty("qfs:feature")) instanceof String && !Misc.emptyOrNull((String)((String)object))) {
            domNode.setProperty("qfs:feature", object);
            return (String)object;
        }
        return null;
    }

    protected String setFeatureForParent(DomNode domNode, String string) {
        DomNode domNode2 = this.getParentWithClass(domNode, string);
        if (domNode2 != null) {
            String string2 = this.setResolvedFeatureFromClass(domNode2, string);
            return string2;
        }
        return null;
    }

    protected void installFeatureResolver(DomNode domNode) {
        ResolverRegistry.instance().registerFeatureResolver2(domNode, (FeatureResolver2)this);
    }

    protected void setExtraFeature(DomNode domNode, String string, String string2, int n2) {
        ExtraFeature extraFeature;
        ExtraFeatureSet extraFeatureSet = (ExtraFeatureSet)domNode.getProperty("qfs:extrafeatures");
        if (extraFeatureSet == null) {
            extraFeatureSet = new ExtraFeatureSet();
            domNode.setProperty("qfs:extrafeatures", extraFeatureSet);
        }
        if ((extraFeature = extraFeatureSet.get(string)) == null) {
            if (!Misc.emptyOrNull((String)string2)) {
                extraFeatureSet.add(new ExtraFeature(n2, string, string2));
            }
        } else {
            extraFeature.setState(n2);
        }
    }

    private DomNode c(DomNode domNode, String string) {
        Node node = domNode.getParent();
        while (node instanceof DomNode) {
            if (string.equals(node.getClassName())) {
                return (DomNode)node;
            }
            node = node.getParent();
        }
        return null;
    }

    public String setResolvedFeatureFromClass(DomNode domNode, String string) {
        if (simpleTextFeatureClasses.contains(string)) {
            return this.simpleTextFeature(domNode);
        }
        if (textFeatureClasses.contains(string)) {
            return this.textFeature(domNode);
        }
        return null;
    }

    protected String textFeature(DomNode domNode) {
        String string = domNode.getText();
        if (!Misc.emptyOrNull((String)string) && !Misc.emptyOrNull((String)(string = this.stripFirstPart(string, "\n")))) {
            domNode.setProperty("qfs:feature", string);
            return string;
        }
        return null;
    }

    protected String simpleTextFeature(DomNode domNode) {
        String string = domNode.getSimpleText();
        if (!Misc.emptyOrNull((String)string) && !Misc.emptyOrNull((String)(string = this.stripFirstPart(string, "\n")))) {
            domNode.setProperty("qfs:feature", string);
            return string;
        }
        return null;
    }

    protected String stripFirstPart(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string = string.replace('\u00a0', ' '), string2);
        if (stringTokenizer.hasMoreTokens() && (string = stringTokenizer.nextToken().trim()).length() == 0 && stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        return string.trim();
    }

    static {
        textFeatureClasses.add("GWT-CHECKBOX");
        textFeatureClasses.add("GWT-STACKPANELITEM");
        textFeatureClasses.add("GWT-TABBARITEM");
        simpleTextFeatureClasses = new HashSet();
        simpleTextFeatureClasses.add("GWT-LABEL");
        simpleTextFeatureClasses.add("GWT-MENUITEM");
        simpleTextFeatureClasses.add("GWT-TREEITEM");
        postponedFeatureClasses = new HashSet();
        postponedFeatureClasses.add("DIV");
        eventRedirectMap = new HashMap();
        eventRedirectMap.put("A", "maybe");
        eventRedirectMap.put("GWT-CHECKBOX", "true");
        eventRedirectMap.put("GWT-STACKPANELITEM", "true");
        eventRedirectMap.put("GWT-TABBARITEM", "true");
    }
}

