/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.resolvers.web.generic;

import de.qfs.apps.qftest.client.Engine;
import de.qfs.apps.qftest.client.web.WebEngine;
import de.qfs.apps.qftest.client.web.WebTracker;
import de.qfs.apps.qftest.client.web.dom.DocumentNode;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.Node;
import de.qfs.apps.qftest.extensions.EventSynchronizer;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.util.ArrayList;

public class GenericEventSynchronizeHandler
implements EventSynchronizer {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.resolvers.web.generic.GenericEventSynchronizeHandler");
    protected BusyChecker runner;
    protected int sleepTime = 99;
    protected int initialSleepTime = 10;
    protected int duration = 10000;

    public GenericEventSynchronizeHandler() {
        WebEngine webEngine = (WebEngine)Engine.threadInstance("web");
        WebTracker webTracker = (WebTracker)webEngine.getTracker();
        this.runner = new BusyChecker(webTracker);
    }

    public GenericEventSynchronizeHandler(WebEngine webEngine) {
        WebTracker webTracker = (WebTracker)webEngine.getTracker();
        this.runner = new BusyChecker(webTracker);
    }

    @Override
    public void sync(Object object) {
        if (GenericEventSynchronizeHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "sync(Object)", 86).addDetail("context", object)).log();
        }
        if (this.duration <= 0) {
            return;
        }
        if (!Options.cached_OPT_WEB_EVENT_SYNCHRONIZER_FOR_LOADING_COMPONENT) {
            return;
        }
        long l2 = System.currentTimeMillis() + (long)this.getDuration();
        if (GenericEventSynchronizeHandler.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "sync(Object)", 96).add("until", l2)).log();
        }
        try {
            if (this.getInitialSleepTime() > 0) {
                if (GenericEventSynchronizeHandler.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "sync(Object)", 99).add("Sleep initialsleeptime: ")).log();
                }
                Thread.sleep(this.getInitialSleepTime());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (true) {
            this.runner.busy = false;
            ((WebEngine)object).safeInvokeNow(this.runner, new Class[0]);
            if (!this.runner.busy || System.currentTimeMillis() > l2) break;
            try {
                if (this.getSleepTime() <= 0) continue;
                Thread.sleep(this.getSleepTime());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setRunner(BusyChecker busyChecker) {
        this.runner = busyChecker;
    }

    public void setDuration(int n2) {
        this.duration = n2;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setSleepTime(int n2) {
        this.sleepTime = n2;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setInitialSleepTime(int n2) {
        this.initialSleepTime = n2;
    }

    public int getInitialSleepTime() {
        return this.initialSleepTime;
    }

    public boolean isDocumentNodeBusy(Object object) {
        Node[] nodeArray;
        if (object instanceof DocumentNode && (nodeArray = ((DocumentNode)object).getElementsByClassName(new String[]{"LoadingComponent"}, true)) != null && nodeArray.length > 0) {
            for (Node node : nodeArray) {
                if (!(node instanceof DomNode) || !((DomNode)node).isValid() || node.isDestroyed() || !node.getHelper().isVisible(node)) continue;
                if (GenericEventSynchronizeHandler.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "isDocumentNodeBusy(Object)", 199).add("Loadercomponent visible: ", (Object)node)).log();
                }
                return true;
            }
        }
        if (GenericEventSynchronizeHandler.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "isDocumentNodeBusy(Object)", 207).add("No document node -> leave.")).log();
        }
        return false;
    }

    public class BusyChecker
    implements Runnable {
        public boolean busy;
        private WebTracker b;

        public BusyChecker(WebTracker webTracker) {
            this.b = webTracker;
        }

        @Override
        public void run() {
            if (a.level >= 7) {
                a.lvlBuild(7, "BusyChecker.run()", 249).log();
            }
            ArrayList arrayList = this.b.getToplevels();
            for (Object e2 : arrayList) {
                if (!(e2 instanceof DocumentNode)) continue;
                if (a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "BusyChecker.run()", 253).add("doc", e2)).log();
                }
                try {
                    this.busy = GenericEventSynchronizeHandler.this.isDocumentNodeBusy(e2);
                    if (a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "BusyChecker.run()", 256).add("busy", this.busy)).log();
                    }
                    if (!this.busy) continue;
                    return;
                }
                catch (Throwable throwable) {
                    if (a.level < 9) continue;
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "BusyChecker.run()", 262).add("ex", (Object)throwable)).log();
                }
            }
        }
    }
}

