/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.swt.items;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.swt.WidgetHelper;
import de.qfs.apps.qftest.client.swt.l;
import de.qfs.apps.qftest.client.swt.z;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.extensions.items.ItemResolver;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.tree.IndexBasedTreeAdapter;
import de.qfs.lib.tree.TreeAdapter;
import de.qfs.lib.tree.TreeUtil;
import de.qfs.lib.util.Misc;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class TreeItemResolver
implements ItemResolver {
    private static final z a = new z("de.qfs.apps.qftest.client.swt.items.TreeItemResolver");
    protected WidgetHelper helper;
    protected boolean asPath = true;
    protected int keyColumn = -1;

    public TreeItemResolver(l l2) {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "TreeItemResolver(SWTEngine)", 87).addDetail("engine", (Object)l2)).log();
        }
        this.helper = l2.getHelper();
    }

    public TreeItemResolver(l l2, int n2) {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "TreeItemResolver(SWTEngine,int)", 102).addDetail("engine", (Object)l2)).addDetail("keyColumn", n2)).log();
        }
        this.helper = l2.getHelper();
        this.asPath = false;
        this.keyColumn = n2;
    }

    public static TreeItemResolver createResolver(l l2) {
        block7: {
            if (TreeItemResolver.a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "createResolver(SWTEngine)", 123).addDetail("engine", (Object)l2)).log();
            }
            String string = SWT.getPlatformAndArch();
            try {
                if ("gtk-64".equals(string)) {
                    return (TreeItemResolver)TreeItemResolver.class.getClassLoader().loadClass("de.qfs.apps.qftest.client.swt.gtk64.items.GtkTreeItemResolver").getConstructor(l.class).newInstance(l2);
                }
                if ("gtk".equals(string)) {
                    return (TreeItemResolver)TreeItemResolver.class.getClassLoader().loadClass("de.qfs.apps.qftest.client.swt.gtk.items.GtkTreeItemResolver").getConstructor(l.class).newInstance(l2);
                }
                if ("win32-64".equals(string)) {
                    return (TreeItemResolver)TreeItemResolver.class.getClassLoader().loadClass("de.qfs.apps.qftest.client.swt.win64.items.Win32TreeItemResolver").getConstructor(l.class).newInstance(l2);
                }
                if ("win32".equals(string)) {
                    return (TreeItemResolver)TreeItemResolver.class.getClassLoader().loadClass("de.qfs.apps.qftest.client.swt.win32.items.Win32TreeItemResolver").getConstructor(l.class).newInstance(l2);
                }
            }
            catch (Throwable throwable) {
                if (TreeItemResolver.a.level < 1) break block7;
                ((LevelAwareLogBuilder)a.lvlBuild(1, "createResolver(SWTEngine)", 156).add("ex", (Object)throwable)).log();
            }
        }
        return null;
    }

    public static TreeItem getItemCol(Object object, Object object2, int[] nArray) throws BadItemException {
        if (!(object instanceof Tree)) {
            if (TreeItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getItemCol(Object,Object,int[])", 186).add("Internal error: Not a Tree", object)).log();
            }
            throw new BadItemException("Not a Tree: " + object);
        }
        Tree tree = (Tree)object;
        if (object2 instanceof TreeItem) {
            nArray[0] = -1;
            return (TreeItem)object2;
        }
        if (object2 instanceof Integer) {
            if (tree.getColumnCount() == 0) {
                if (TreeItemResolver.a.level >= 1) {
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "getItemCol(Object,Object,int[])", 208).add("Internal error: Not an item of a tree without columns", object2)).log();
                }
                throw new BadItemException("Internal error: Not an item of a tree without columns: " + object2);
            }
            nArray[0] = (Integer)object2;
            if (nArray[0] >= tree.getColumnCount()) {
                if (TreeItemResolver.a.level >= 1) {
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "getItemCol(Object,Object,int[])", 214).add("Internal error: Column does not exist in the tree", nArray[0])).log();
                }
                throw new BadItemException("Internal error: Column does not exist in the tree: " + nArray[0]);
            }
            return null;
        }
        if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            if (tree.getColumnCount() == 0 || !(objectArray[0] instanceof Integer) || objectArray[1] != null && !(objectArray[1] instanceof TreeItem)) {
                if (TreeItemResolver.a.level >= 1) {
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "getItemCol(Object,Object,int[])", 225).add("Internal error: Not an item of a tree without columns", object2)).log();
                }
                throw new BadItemException("Internal error: Not an item of a tree without columns: " + object2);
            }
            nArray[0] = (Integer)objectArray[0];
            if (nArray[0] >= tree.getColumnCount()) {
                if (TreeItemResolver.a.level >= 1) {
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "getItemCol(Object,Object,int[])", 231).add("Internal error: Column does not exist in the tree", nArray[0])).log();
                }
                throw new BadItemException("Internal error: Column does not exist in the tree: " + nArray[0]);
            }
            return (TreeItem)objectArray[1];
        }
        if (TreeItemResolver.a.level >= 1) {
            ((LevelAwareLogBuilder)a.lvlBuild(1, "getItemCol(Object,Object,int[])", 237).add("Internal error: Not a tree item", object2)).log();
        }
        throw new BadItemException("Internal error: Not a tree item: " + object2);
    }

    public static ArrayList getVisibleItems(Tree tree) {
        b b2 = new b();
        a a2 = new a();
        TreeUtil.visitTree((TreeAdapter)b2, (Object)a2, (Object)tree);
        return a2.a();
    }

    @Override
    public Object getItem(Object object, int n2, int n3) {
        Object[] objectArray;
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItem(Object,int,int)", 277).addDetail("element", object)).addDetail("xu", n2)).addDetail("yu", n3)).log();
        }
        if (!(object instanceof Tree)) {
            if (TreeItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getItem(Object,int,int)", 280).add("Internal error: Not a tree", object)).log();
            }
            return null;
        }
        Tree tree = (Tree)object;
        int n4 = n3 - this.helper.getHeaderHeight(tree);
        Point point = this.helper.toScrolledLocation((Widget)tree, new Point(n2, n3));
        int n5 = point.x;
        int n6 = point.y - this.helper.getHeaderHeight(tree);
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getItem(Object,int,int)", 291).add("vpos", (Object)point)).add("yuinner", n4)).log();
        }
        int n7 = -1;
        if (tree.getColumnCount() > 0) {
            TreeColumn[] treeColumnArray = tree.getColumns();
            int n8 = 0;
            objectArray = null;
            for (int i2 = 0; i2 < treeColumnArray.length; ++i2) {
                if ((n8 += treeColumnArray[i2].getWidth()) <= n2) continue;
                n7 = i2;
                break;
            }
            if (n7 == -1) {
                if (TreeItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItem(Object,int,int)", 312).add("X coordinate outside all columns")).log();
                }
                return null;
            }
            if (tree.getHeaderVisible() && point.y < this.helper.getHeaderHeight(tree)) {
                if (TreeItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItem(Object,int,int)", 319).add("ret", n7)).log();
                }
                return n7;
            }
        }
        if (tree.getItemCount() == 0) {
            return null;
        }
        int n9 = n4 / this.getItemHeight(tree);
        Object[] objectArray2 = TreeItemResolver.getItemForRow(tree, n9);
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItem(Object,int,int)", 332).add("item", (Object)objectArray2)).log();
        }
        if (objectArray2 != null) {
            objectArray = n7 >= 0 ? new Object[]{n7, objectArray2} : objectArray2;
        } else {
            if (TreeItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItem(Object,int,int)", 346).add("no column, no item found.")).log();
            }
            objectArray = null;
        }
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItem(Object,int,int)", 350).add("ret", (Object)objectArray)).log();
        }
        return objectArray;
    }

    @Override
    public String getItemValue(Object object, Object object2) throws BadItemException {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemValue(Object,Object)", 368).addDetail("element", object)).addDetail("item", object2)).log();
        }
        int[] nArray = new int[1];
        TreeItem treeItem = TreeItemResolver.getItemCol(object, object2, nArray);
        Tree tree = (Tree)object;
        if (treeItem != null) {
            if (nArray[0] >= 0) {
                return Util.getCleanElementText((String)treeItem.getText(nArray[0]));
            }
            return Util.getCleanElementText((String)treeItem.getText(0));
        }
        return Util.getCleanElementText((String)tree.getColumn(nArray[0]).getText());
    }

    @Override
    public Object getItemForIndex(Object object, SubItemIndex[] subItemIndexArray) throws TestException {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForIndex(Object,SubItemIndex[])", 402).addDetail("element", object)).addDetail("idx", (Object)subItemIndexArray)).log();
        }
        if (!(object instanceof Tree)) {
            if (TreeItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getItemForIndex(Object,SubItemIndex[])", 406).add("Internal error: Not a tree", object)).log();
            }
            return null;
        }
        Tree tree = (Tree)object;
        boolean bl2 = tree.getColumnCount() > 0;
        Object object2 = null;
        if (bl2) {
            object2 = this.getColumn(tree, subItemIndexArray[0]);
            if (TreeItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 415).add("column", object2)).log();
            }
        }
        if (bl2 && subItemIndexArray.length == 1) {
            return object2;
        }
        TreeItem treeItem = null;
        int n2 = bl2 ? 1 : 0;
        SubItemIndex subItemIndex = subItemIndexArray[n2];
        ItemRegistry.instance().checkSubItemIndexForTree(Arrays.copyOfRange(subItemIndexArray, n2, subItemIndexArray.length), true);
        String string = subItemIndex.getIndex();
        if (this.asPath && Misc.unquotedIndexOf((String)string, (String)"/", (int)0) == 0) {
            int n3 = 0;
            while (n3 >= 0) {
                int n4 = Misc.unquotedIndexOf((String)string, (String)"/", (int)(n3 + 1));
                String string2 = n4 > n3 ? Misc.unquote((String)string.substring(n3 + 1, n4), (String)"\\#@&%/") : Misc.unquote((String)string.substring(n3 + 1), (String)"\\#@&%/");
                if (TreeItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 438).add("index", string2)).log();
                }
                if (TreeItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 439).add("pos", n3)).log();
                }
                if (TreeItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 440).add("pos2", n4)).log();
                }
                SubItemIndex subItemIndex2 = new SubItemIndex(string2, subItemIndex.getType());
                treeItem = bl2 ? this.getItem(tree, treeItem, subItemIndex2, this.asPath ? null : (this.keyColumn >= 0 ? Integer.valueOf(this.keyColumn) : object2)) : this.getItem(tree, treeItem, subItemIndex2, this.asPath ? null : Integer.valueOf(0));
                if (n4 < 0 && n2 < subItemIndexArray.length - 1 && (subItemIndex = subItemIndexArray[n2 + 1]).getIndex().charAt(0) == '/') {
                    if (TreeItemResolver.a.level >= 5) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(5, "getItemForIndex(Object,SubItemIndex[])", 452).add("multi-level-item, continue path with next index")).add("primary", (Object)subItemIndex)).log();
                    }
                    ++n2;
                    string = subItemIndex.getIndex();
                    n4 = 0;
                }
                n3 = n4;
            }
        } else if (bl2) {
            for (int i2 = 1; i2 < subItemIndexArray.length; ++i2) {
                treeItem = this.getItem(tree, treeItem, subItemIndexArray[i2], this.asPath ? null : (this.keyColumn >= 0 ? Integer.valueOf(this.keyColumn) : object2));
            }
        } else {
            for (int i3 = 0; i3 < subItemIndexArray.length; ++i3) {
                treeItem = this.getItem(tree, treeItem, subItemIndexArray[i3], this.asPath ? null : Integer.valueOf(0));
            }
        }
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 474).add("item", treeItem)).log();
        }
        ItemRegistry.instance().setIndexesResolved(n2 + 1);
        if (object2 != null) {
            return new Object[]{object2, treeItem};
        }
        return treeItem;
    }

    @Override
    public SubItemIndex[] getItemIndex(Object object, Object object2, int n2) throws BadItemException {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object,int)", 498).addDetail("element", object)).addDetail("_item", object2)).addDetail("type", n2)).log();
        }
        try {
            SubItemIndex[] subItemIndexArray;
            String string;
            int n3;
            Object object3;
            int[] nArray = new int[1];
            TreeItem treeItem = TreeItemResolver.getItemCol(object, object2, nArray);
            Tree tree = (Tree)object;
            SubItemIndex[] subItemIndexArray2 = null;
            if (treeItem != null) {
                int n4;
                if (this.asPath) {
                    subItemIndexArray2 = this.getItemPath(object, treeItem, n2);
                    if (n2 == 1) {
                        for (int i2 = 0; i2 < subItemIndexArray2.length; ++i2) {
                            if (subItemIndexArray2[i2].getType() != 1) continue;
                            subItemIndexArray2 = this.getItemPath(object, treeItem, 3);
                            break;
                        }
                    }
                    object3 = new StringBuffer();
                    n3 = subItemIndexArray2[0].getType() == 0 ? 1 : 0;
                    for (n4 = 0; n4 < subItemIndexArray2.length; ++n4) {
                        ((StringBuffer)object3).append('/');
                        if (n3 != 0) {
                            ((StringBuffer)object3).append(Misc.quote((String)subItemIndexArray2[n4].getIndex(), (String)"\\#@&%/"));
                            continue;
                        }
                        ((StringBuffer)object3).append(subItemIndexArray2[n4].getIndex());
                    }
                    subItemIndexArray2 = new SubItemIndex[]{new SubItemIndex(((StringBuffer)object3).toString(), subItemIndexArray2[0].getType())};
                    if (TreeItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 532).add("path", (Object)subItemIndexArray2)).log();
                    }
                } else {
                    object3 = this.asPath ? null : (nArray[0] < 0 ? Integer.valueOf(0) : (this.keyColumn >= 0 ? Integer.valueOf(this.keyColumn) : Integer.valueOf(nArray[0])));
                    n3 = n2;
                    n4 = TreeItemResolver.getExpandedRowCount(tree);
                    String string2 = null;
                    if (n2 == 1) {
                        n3 = 3;
                        if (n4 > 0 && !Misc.emptyOrNull((String)(string2 = this.a(tree, treeItem, object3)))) {
                            TreeItem treeItem2;
                            int n5;
                            for (n5 = 0; !(n5 >= n4 || (treeItem2 = TreeItemResolver.getItemForRow(tree, n5)) != treeItem && Misc.equalOrNull((Object)string2, (Object)this.a(tree, treeItem2, object3))); ++n5) {
                            }
                            if (n5 == n4) {
                                n3 = 2;
                            }
                        }
                    }
                    SubItemIndex subItemIndex = n3 == 2 ? (n4 == 0 ? new SubItemIndex("") : new SubItemIndex(string2 != null ? string2 : this.a(tree, treeItem, object3))) : (n4 == 0 ? new SubItemIndex(0) : new SubItemIndex(this.getRowForItem(tree, treeItem)));
                    if (TreeItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 578).add("rowIdx", (Object)subItemIndex)).log();
                    }
                    subItemIndexArray2 = new SubItemIndex[]{subItemIndex};
                }
            }
            if (nArray[0] < 0) {
                return subItemIndexArray2;
            }
            object3 = tree.getColumns();
            n3 = n2;
            if (n2 == 1 && !Misc.emptyOrNull((String)(string = this.a(tree, nArray[0])))) {
                int n6;
                for (n6 = 0; !(n6 >= ((TreeColumn[])object3).length || n6 != nArray[0] && string.equals(this.a(tree, n6))); ++n6) {
                }
                n3 = n6 == ((TreeColumn[])object3).length ? 2 : 3;
            }
            SubItemIndex subItemIndex = n3 == 2 ? new SubItemIndex(this.a(tree, nArray[0])) : new SubItemIndex(nArray[0]);
            if (TreeItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 615).add("cIdx", (Object)subItemIndex)).log();
            }
            if (subItemIndexArray2 == null) {
                subItemIndexArray = new SubItemIndex[]{subItemIndex};
            } else {
                subItemIndexArray = new SubItemIndex[subItemIndexArray2.length + 1];
                System.arraycopy(subItemIndexArray2, 0, subItemIndexArray, 1, subItemIndexArray2.length);
                subItemIndexArray[0] = subItemIndex;
            }
            if (TreeItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 628).add("ret", (Object)subItemIndexArray)).log();
            }
            return subItemIndexArray;
        }
        catch (Exception exception) {
            if (TreeItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getItemIndex(Object,Object,int)", 631).add("ex", (Object)exception)).log();
            }
            return null;
        }
    }

    @Override
    public int[] getItemLocation(Object object, Object object2) throws BadItemException {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemLocation(Object,Object)", 650).addDetail("element", object)).addDetail("item", object2)).log();
        }
        int[] nArray = new int[1];
        TreeItem treeItem = TreeItemResolver.getItemCol(object, object2, nArray);
        Tree tree = (Tree)object;
        int[] nArray2 = new int[2];
        if (treeItem != null) {
            Rectangle rectangle = nArray[0] >= 0 ? this.getUnscrolledBounds(treeItem, nArray[0]) : this.getUnscrolledBounds(treeItem);
            if (TreeItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemLocation(Object,Object)", 669).add("bounds", (Object)rectangle)).log();
            }
            nArray2[0] = rectangle.x;
            nArray2[1] = rectangle.y;
        } else {
            TreeColumn[] treeColumnArray = tree.getColumns();
            nArray2[1] = 0;
            for (int i2 = 0; i2 < treeColumnArray.length && i2 != nArray[0]; ++i2) {
                nArray2[0] = nArray2[0] + treeColumnArray[i2].getWidth();
            }
        }
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemLocation(Object,Object)", 689).add("ret", (Object)nArray2)).log();
        }
        return nArray2;
    }

    @Override
    public int[] getItemSize(Object object, Object object2) throws BadItemException {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemSize(Object,Object)", 707).addDetail("element", object)).addDetail("item", object2)).log();
        }
        int[] nArray = new int[1];
        TreeItem treeItem = TreeItemResolver.getItemCol(object, object2, nArray);
        Tree tree = (Tree)object;
        int[] nArray2 = new int[]{0, 0};
        if (treeItem != null) {
            Rectangle rectangle = nArray[0] >= 0 ? this.getUnscrolledBounds(treeItem, nArray[0]) : this.getUnscrolledBounds(treeItem);
            nArray2[0] = rectangle.width;
            nArray2[1] = rectangle.height;
        } else {
            nArray2[0] = tree.getColumn(nArray[0]).getWidth();
            nArray2[1] = this.helper.getHeaderHeight(tree) + TreeItemResolver.getExpandedRowCount(tree) * this.getItemHeight(tree);
        }
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemSize(Object,Object)", 755).add("ret", (Object)nArray2)).log();
        }
        return nArray2;
    }

    @Override
    public Boolean repositionMouseEvent(Object object, Object object2, int[] nArray) throws BadItemException {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "repositionMouseEvent(Object,Object,int[])", 779).addDetail("element", object)).addDetail("item", object2)).addDetail("pos", (Object)nArray)).log();
        }
        int[] nArray2 = new int[1];
        TreeItem treeItem = TreeItemResolver.getItemCol(object, object2, nArray2);
        int[] nArray3 = this.getItemSize(object, object2);
        if (treeItem != null && nArray[0] >= 0 && nArray[1] >= 0 && nArray[0] < nArray3[0] && nArray[1] < nArray3[1]) {
            if (Client.instance().getOptions().getBoolean("RepositionMiddle", true)) {
                nArray[0] = Integer.MAX_VALUE;
                nArray[1] = Integer.MAX_VALUE;
            } else {
                nArray[0] = Math.min(nArray[0], 1);
                nArray[1] = Math.min(nArray[1], 1);
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean scrollItemVisible(Object object, Object object2, int n2, int n3) throws BadItemException {
        Rectangle rectangle;
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "scrollItemVisible(Object,Object,int,int)", 822).addDetail("element", object)).addDetail("item", object2)).addDetail("x", n2)).addDetail("y", n3)).log();
        }
        int[] nArray = new int[1];
        TreeItem treeItem = TreeItemResolver.getItemCol(object, object2, nArray);
        Tree tree = (Tree)object;
        int n4 = this.helper.getHeaderHeight(tree);
        int[] nArray2 = this.getItemLocation(object, object2);
        int[] nArray3 = this.getItemSize(object, object2);
        if (treeItem != null && nArray[0] <= 0) {
            int n5 = Math.min(20, nArray2[0]);
            nArray2[0] = nArray2[0] - n5;
            nArray3[0] = nArray3[0] + n5;
            n2 += n5;
        }
        return this.helper.scrollVisible((Widget)tree, rectangle = new Rectangle(nArray2[0], nArray2[1], nArray3[0], nArray3[1]), new Point(n2, n3)) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public int getItemCount(Object object, Object object2) throws BadItemException {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemCount(Object,Object)", 861).addDetail("element", object)).addDetail("item", object2)).log();
        }
        if (object2 == null) {
            return ((Tree)object).getItemCount();
        }
        int[] nArray = new int[1];
        TreeItem treeItem = TreeItemResolver.getItemCol(object, object2, nArray);
        Tree tree = (Tree)object;
        if (treeItem != null) {
            if (nArray[0] >= 0) {
                return treeItem.getItemCount();
            }
            return treeItem.getItemCount();
        }
        return tree.getItemCount();
    }

    protected abstract Rectangle getUnscrolledBounds(TreeItem var1);

    protected abstract Rectangle getUnscrolledBounds(TreeItem var1, int var2);

    public TreeItem getItem(Tree tree, TreeItem treeItem, SubItemIndex subItemIndex, Object object) throws TestException {
        int n2;
        block12: {
            TreeItem[] treeItemArray;
            block14: {
                block13: {
                    if (TreeItemResolver.a.level >= 7) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItem(Tree,TreeItem,SubItemIndex,Object)", 931).addDetail("tree", (Object)tree)).addDetail("parent", (Object)treeItem)).addDetail("idx", (Object)subItemIndex)).addDetail("column", object)).log();
                    }
                    if (treeItem != null && !treeItem.getExpanded() && Options.cached_OPT_PLAY_EXPAND_TREE) {
                        this.helper.expandTreeNode(treeItem, true);
                    }
                    n2 = -1;
                    if (object != null) break block12;
                    TreeItem[] treeItemArray2 = treeItemArray = treeItem == null ? tree.getItems() : treeItem.getItems();
                    if (subItemIndex.getType() != 1) break block13;
                    boolean bl2 = false;
                    if (ItemRegistry.instance().hasItemNameMatchers(tree)) {
                        for (int i2 = 0; i2 < treeItemArray.length; ++i2) {
                            Boolean bl3 = ItemRegistry.instance().matchesItemName(tree, treeItemArray[i2], subItemIndex.getIndex());
                            if (bl3 == null || !bl3.booleanValue()) continue;
                            bl2 = true;
                            n2 = i2;
                            break;
                        }
                    }
                    if (bl2 || (n2 = subItemIndex.asNumber()) >= 0) break block14;
                    n2 = treeItemArray.length + n2;
                    break block14;
                }
                for (int i3 = 0; i3 < treeItemArray.length; ++i3) {
                    Boolean bl4 = ItemRegistry.instance().matchesItemName(tree, treeItemArray[i3], subItemIndex.getIndex());
                    if (bl4 != null) {
                        if (!bl4.booleanValue()) continue;
                        n2 = i3;
                        break;
                    }
                    if (!subItemIndex.matches(this.a(tree, treeItemArray[i3], object))) continue;
                    n2 = i3;
                    break;
                }
            }
            if (n2 < 0 || n2 >= treeItemArray.length) {
                throw new IndexNotFoundException(subItemIndex);
            }
            return treeItemArray[n2];
        }
        int n3 = TreeItemResolver.getExpandedRowCount(tree);
        if (subItemIndex.getType() == 1) {
            n2 = subItemIndex.asNumber();
            if (n2 < 0) {
                n2 = n3 + n2;
            }
            if (n2 < 0 || n2 >= n3) {
                throw new IndexNotFoundException(subItemIndex);
            }
            TreeItem treeItem2 = TreeItemResolver.getItemForRow(tree, n2);
            if (treeItem2 == null) {
                throw new IndexNotFoundException(subItemIndex);
            }
            return treeItem2;
        }
        for (int i4 = 0; i4 < n3; ++i4) {
            TreeItem treeItem3 = TreeItemResolver.getItemForRow(tree, i4);
            Boolean bl5 = ItemRegistry.instance().matchesItemName(tree, treeItem3, subItemIndex.getIndex());
            if (!(bl5 != null ? bl5 != false : subItemIndex.matches(this.a(tree, treeItem3, object)))) continue;
            return treeItem3;
        }
        throw new IndexNotFoundException(subItemIndex);
    }

    public Object getColumn(Tree tree, SubItemIndex subItemIndex) throws TestException {
        int n2;
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getColumn(Tree,SubItemIndex)", 1042).addDetail("tree", (Object)tree)).addDetail("idx", (Object)subItemIndex)).log();
        }
        if ((n2 = tree.getColumnCount()) == 0) {
            if (TreeItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getColumn(Tree,SubItemIndex)", 1047).add("Internal error: Tree has no columns", (Object)tree)).log();
            }
            throw new BadItemException("Internal error: Tree has no columns: " + tree);
        }
        Integer n3 = null;
        if (subItemIndex.getType() == 1) {
            int n4;
            if (TreeItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getColumn(Tree,SubItemIndex)", 1053).add("idx", (Object)subItemIndex)).log();
            }
            if ((n4 = subItemIndex.asNumber()) < 0) {
                n4 = n2 + n4;
            }
            n3 = n4;
        } else {
            int n5 = tree.getColumnCount();
            for (int i2 = 0; i2 < n5; ++i2) {
                Boolean bl2 = ItemRegistry.instance().matchesItemName(tree, i2, subItemIndex.getIndex());
                if (bl2 != null) {
                    if (!bl2.booleanValue()) continue;
                    if (TreeItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getColumn(Tree,SubItemIndex)", 1068).add("item matcher matches.")).log();
                    }
                    n3 = i2;
                    break;
                }
                if (!subItemIndex.matches(this.a(tree, i2))) continue;
                n3 = i2;
                break;
            }
        }
        if (n3 == null) {
            throw new IndexNotFoundException(subItemIndex);
        }
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getColumn(Tree,SubItemIndex)", 1089).add("ret", (Object)n3)).log();
        }
        return n3;
    }

    public SubItemIndex[] getItemPath(Object object, Object object2, int n2) throws BadItemException {
        SubItemIndex[] subItemIndexArray;
        int n3;
        TreeItem[] treeItemArray;
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemPath(Object,Object,int)", 1107).addDetail("element", object)).addDetail("item", object2)).addDetail("type", n2)).log();
        }
        if (!(object instanceof Tree)) {
            if (TreeItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getItemPath(Object,Object,int)", 1111).add("Internal error: Not a tree", object)).log();
            }
            return null;
        }
        if (!(object2 instanceof TreeItem)) {
            if (TreeItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getItemPath(Object,Object,int)", 1116).add("Internal error: Not a tree item", object2)).log();
            }
            throw new BadItemException("Internal error: Not a tree item: " + object2);
        }
        Tree tree = (Tree)object;
        TreeItem treeItem = (TreeItem)object2;
        SubItemIndex[] subItemIndexArray2 = null;
        if (treeItem.getParentItem() == null) {
            treeItemArray = tree.getItems();
        } else {
            treeItemArray = treeItem.getParentItem().getItems();
            subItemIndexArray2 = this.getItemPath(tree, treeItem.getParentItem(), n2);
        }
        String string = this.a(tree, treeItem, null);
        boolean bl2 = n2 == 1;
        int n4 = -1;
        for (n3 = 0; n3 < treeItemArray.length; ++n3) {
            if (treeItemArray[n3] == treeItem) {
                n4 = n3;
                if (bl2) continue;
                break;
            }
            if (Misc.emptyOrNull((String)string) || !string.equals(this.a(tree, treeItemArray[n3], null))) continue;
            bl2 = false;
            if (n4 >= 0) break;
        }
        n3 = n2;
        if (n2 == 1) {
            n3 = bl2 ? 2 : 3;
        }
        SubItemIndex subItemIndex = n3 == 2 ? new SubItemIndex(string) : new SubItemIndex(n4);
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemPath(Object,Object,int)", 1159).add("tIdx", (Object)subItemIndex)).log();
        }
        if (subItemIndexArray2 == null) {
            subItemIndexArray = new SubItemIndex[]{subItemIndex};
        } else {
            subItemIndexArray = new SubItemIndex[subItemIndexArray2.length + 1];
            System.arraycopy(subItemIndexArray2, 0, subItemIndexArray, 0, subItemIndexArray2.length);
            subItemIndexArray[subItemIndexArray2.length] = subItemIndex;
            if (TreeItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemPath(Object,Object,int)", 1167).add("ret", (Object)subItemIndexArray)).log();
            }
        }
        return subItemIndexArray;
    }

    public int getRowForItem(Tree tree, TreeItem treeItem) {
        TreeItem[] treeItemArray;
        int[] nArray;
        int n2;
        int n3;
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getRowForItem(Tree,TreeItem)", 1184).addDetail("tree", (Object)tree)).addDetail("searchedItem", (Object)treeItem)).log();
        }
        int n4 = n3 = (n2 = TreeItemResolver.searchRowOrItem(tree, 0, -1, treeItem, nArray = new int[1], treeItemArray = new TreeItem[1])) < 0 ? nArray[0] : -1;
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getRowForItem(Tree,TreeItem)", 1192).add("ret", n3)).log();
        }
        return n3;
    }

    public static TreeItem getItemForRow(Tree tree, int n2) {
        TreeItem treeItem;
        TreeItem[] treeItemArray;
        int[] nArray;
        int n3;
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForRow(Tree,int)", 1207).addDetail("tree", (Object)tree)).addDetail("searchedRow", n2)).log();
        }
        if ((n3 = TreeItemResolver.searchRowOrItem(tree, 0, n2, null, nArray = new int[1], treeItemArray = new TreeItem[1])) < 0) {
            if (nArray[0] != n2 && TreeItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getItemForRow(Tree,int)", 1217).add("Internal error: foundRow != searchedRow.")).log();
            }
            treeItem = treeItemArray[0];
        } else {
            treeItem = null;
        }
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForRow(Tree,int)", 1223).add("ret", (Object)treeItem)).log();
        }
        return treeItem;
    }

    public static int getExpandedRowCount(Tree tree) {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getExpandedRowCount(Tree)", 1235).addDetail("tree", (Object)tree)).log();
        }
        int[] nArray = new int[1];
        TreeItem[] treeItemArray = new TreeItem[1];
        int n2 = TreeItemResolver.searchRowOrItem(tree, 0, -1, null, nArray, treeItemArray);
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getExpandedRowCount(Tree)", 1242).add("expandedRowCount", n2)).log();
        }
        return n2;
    }

    protected static int searchRowOrItem(Object object, int n2, int n3, TreeItem treeItem, int[] nArray, TreeItem[] treeItemArray) {
        TreeItem[] treeItemArray2;
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "searchRowOrItem(Object,int,int,TreeItem,int[],TreeItem[])", 1262).addDetail("parent", object)).addDetail("parentFirstRow", n2)).addDetail("searchedRow", n3)).addDetail("searchedItem", (Object)treeItem)).addDetail("foundRow", (Object)nArray)).addDetail("foundItem", (Object)treeItemArray)).log();
        }
        if (object instanceof Tree) {
            treeItemArray2 = ((Tree)object).getItems();
        } else if (object instanceof TreeItem) {
            treeItemArray2 = ((TreeItem)object).getItems();
        } else {
            if (TreeItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "searchRowOrItem(Object,int,int,TreeItem,int[],TreeItem[])", 1276).add("parent is of bad type")).log();
            }
            return 0;
        }
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "searchRowOrItem(Object,int,int,TreeItem,int[],TreeItem[])", 1280).add("children", (Object)treeItemArray2)).log();
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < treeItemArray2.length) {
            TreeItem treeItem2 = treeItemArray2[n5];
            int n6 = n2 + n4;
            if (n6 == n3 || treeItem2 == treeItem) {
                treeItemArray[0] = treeItem2;
                nArray[0] = n6;
                if (TreeItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "searchRowOrItem(Object,int,int,TreeItem,int[],TreeItem[])", 1292).add("Found in items. ret -1.")).log();
                }
                return -1;
            }
            if (treeItem2.getExpanded() || treeItem2.getItemCount() == 0) {
                int n7 = TreeItemResolver.searchRowOrItem(treeItem2, n6 + 1, n3, treeItem, nArray, treeItemArray);
                if (n7 < 0) {
                    if (TreeItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "searchRowOrItem(Object,int,int,TreeItem,int[],TreeItem[])", 1303).add("Found in sub-items ret -1.")).log();
                    }
                    return -1;
                }
                n4 += n7;
            }
            ++n5;
            ++n4;
        }
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "searchRowOrItem(Object,int,int,TreeItem,int[],TreeItem[])", 1309).add("returning", n4)).log();
        }
        return n4;
    }

    protected int getItemHeight(Tree tree) {
        if (tree.getItemCount() == 0) {
            return tree.getItemHeight();
        }
        TreeItem treeItem = tree.getItem(0);
        TreeItem treeItem2 = null;
        if (treeItem.getExpanded() && treeItem.getItemCount() > 0) {
            treeItem2 = treeItem.getItem(0);
        } else if (tree.getItemCount() > 1) {
            treeItem2 = tree.getItem(1);
        }
        if (treeItem2 == null) {
            return tree.getItemHeight();
        }
        return treeItem2.getBounds().y - treeItem.getBounds().y;
    }

    private String a(Tree tree, int n2) {
        return Util.getFlatIdentifierText((String)ItemRegistry.instance().getItemName(tree, n2, tree.getColumn(n2).getText()));
    }

    private String a(Tree tree, TreeItem objectArray, Object object) {
        Object[] objectArray2;
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemName(Tree,TreeItem,Object)", 1593).addDetail("tree", (Object)tree)).addDetail("item", (Object)objectArray)).addDetail("column", object)).log();
        }
        ItemRegistry itemRegistry = ItemRegistry.instance();
        if (object == null) {
            objectArray2 = objectArray;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = object;
            objectArray2 = objectArray3;
            objectArray3[1] = objectArray;
        }
        return Util.getFlatIdentifierText((String)itemRegistry.getItemName(tree, objectArray2, object instanceof Integer ? objectArray.getText(((Integer)object).intValue()) : objectArray.getText()));
    }

    public static class a {
        private ArrayList a = new ArrayList();

        public final ArrayList a() {
            return this.a;
        }

        public void visit(Tree tree) {
        }

        public void visit(TreeItem treeItem) {
            this.a.add(treeItem);
        }
    }

    public static class b
    extends IndexBasedTreeAdapter {
        public b() {
            if (a.level >= 7) {
                a.lvlBuild(7, "VisibleNodeAdapter.VisibleNodeAdapter()", 1356).log();
            }
        }

        public Object getParentNode(Object object) {
            if (object instanceof TreeItem) {
                TreeItem treeItem = ((TreeItem)object).getParentItem();
                return treeItem == null ? ((TreeItem)object).getParent() : treeItem;
            }
            return null;
        }

        public boolean isLeaf(Object object) {
            if (object instanceof Tree) {
                return ((Tree)object).getItemCount() == 0;
            }
            if (object instanceof TreeItem) {
                return !((TreeItem)object).getExpanded() || ((TreeItem)object).getItemCount() == 0;
            }
            return true;
        }

        public int getChildCount(Object object) {
            if (object instanceof Tree) {
                return ((Tree)object).getItemCount();
            }
            if (object instanceof TreeItem) {
                return ((TreeItem)object).getExpanded() ? ((TreeItem)object).getItemCount() : 0;
            }
            return 0;
        }

        public Object getChildNode(Object object, int n2) throws IndexOutOfBoundsException {
            if (object instanceof Tree) {
                return ((Tree)object).getItem(n2);
            }
            if (object instanceof TreeItem) {
                return ((TreeItem)object).getItem(n2);
            }
            return null;
        }

        public int getIndexOfChildNode(Object object, Object object2) {
            if (object2 instanceof TreeItem) {
                if (object instanceof Tree) {
                    return ((Tree)object).indexOf((TreeItem)object2);
                }
                if (object instanceof TreeItem) {
                    return ((TreeItem)object).indexOf((TreeItem)object2);
                }
            }
            return -1;
        }
    }
}

