/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.web;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.web.BlockedBrowserException;
import de.qfs.apps.qftest.client.web.DllLoader;
import de.qfs.apps.qftest.client.web.WebEngine;
import de.qfs.apps.qftest.client.web.b;
import de.qfs.apps.qftest.client.web.c;
import de.qfs.apps.qftest.client.web.d;
import de.qfs.apps.qftest.client.web.data.BrowserInfo;
import de.qfs.apps.qftest.client.web.data.EvalResult;
import de.qfs.apps.qftest.client.web.dom.DNode;
import de.qfs.apps.qftest.client.web.dom.DocumentNode;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.Node;
import de.qfs.apps.qftest.client.web.e;
import de.qfs.apps.qftest.client.web.event.BeforeCloseWindowEvent;
import de.qfs.apps.qftest.client.web.event.CloseWindowEvent;
import de.qfs.apps.qftest.client.web.event.HttpDataAvailableEvent;
import de.qfs.apps.qftest.client.web.event.HttpRequestAbortEvent;
import de.qfs.apps.qftest.client.web.event.HttpRequestEvent;
import de.qfs.apps.qftest.client.web.event.HttpRequestTerminateEvent;
import de.qfs.apps.qftest.client.web.event.HttpResponseEvent;
import de.qfs.apps.qftest.client.web.event.MeexEvent;
import de.qfs.apps.qftest.client.web.event.OpenWindowEvent;
import de.qfs.apps.qftest.client.web.j;
import de.qfs.apps.qftest.client.web.jni.NIBrowser;
import de.qfs.apps.qftest.client.web.jni.NIWindowsAPI;
import de.qfs.apps.qftest.client.web.js.i;
import de.qfs.apps.qftest.client.web.l;
import de.qfs.apps.qftest.client.web.m;
import de.qfs.apps.qftest.client.web.qfdriver.browsers.js.qfapp.a;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.lib.json.Json;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public class Browser
extends NIBrowser
implements l {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.client.web.Browser");
    public static final String PROMISIFIED_JS_PREFIX = "/*@promise*/";
    public static final String CALL_JS_PREFIX = "/*@call*/";
    @Nullable
    protected WebEngine engine;
    protected long browserId = 0L;
    protected long beforeNavigate = 0L;
    protected long docComplete = 0L;
    protected Set registeredCallbacks = Collections.newSetFromMap(new ConcurrentHashMap());
    @Nullable
    protected volatile String browserType;
    protected d browserCreationListener;
    protected m mutationObserver = null;
    protected e checkHandler;
    protected Queue eventFilters = new ConcurrentLinkedQueue();
    protected String windowName;
    private String beforeNavigateURL;
    protected boolean headless = false;
    private final AtomicReference chromeNativeQfApp = new AtomicReference();

    public Browser() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "Browser.Browser()", 64).log();
        }
    }

    public boolean controlsNativeBrowser() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "controlsNativeBrowser()", 137).log();
        }
        return false;
    }

    public void registerCallbacks(l l2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "registerCallbacks(IBrowserCallbacks)", 143).addDetail("callbacks", (Object)l2)).log();
        }
        if (l2 != null) {
            this.registeredCallbacks.add(l2);
        }
    }

    public void unregisterCallbacks(l l2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "unregisterCallbacks(IBrowserCallbacks)", 154).addDetail("callbacks", (Object)l2)).log();
        }
        this.registeredCallbacks.remove(l2);
    }

    public void addEventFilter(j j2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addEventFilter(EventFilter)", 162).addDetail("filter", (Object)j2)).log();
        }
        this.eventFilters.remove(j2);
        this.eventFilters.add(j2);
    }

    public void removeEventFilter(j j2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeEventFilter(EventFilter)", 171).addDetail("filter", (Object)j2)).log();
        }
        this.eventFilters.remove(j2);
    }

    @Override
    public boolean callback(MeexEvent meexEvent) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "callback(MeexEvent)", 181).addDetail("p_event", (Object)meexEvent)).log();
        }
        for (Object object : this.registeredCallbacks) {
            object.callback(meexEvent);
        }
        for (Object object : this.eventFilters) {
            boolean bl2;
            if (object == null || (bl2 = object.a(this, meexEvent))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getStaticInjectionCode() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "getStaticInjectionCode()", 208).log();
        }
        if (this.isChrome()) {
            a a2 = this.getChromeNativeQfApp();
            return a2.aT();
        }
        throw new UnsupportedOperationException("only Chrome Requires Injection code");
    }

    private a initChromeNativeQfApp() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "initChromeNativeQfApp()", 220).log();
        }
        return new a();
    }

    @Override
    public void jscallback(long l2, String string) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "jscallback(long,String)", 229).addDetail("docHandle", l2)).addDetail("message", string)).log();
        }
        System.out.println("jscallback: docHandle=" + l2 + ", message=" + string);
    }

    public void visualizeBusyTracker(boolean bl2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "visualizeBusyTracker(boolean)", 244).addDetail("trackerIsBusy", bl2)).log();
        }
    }

    public void showInteractionBlockerOverlay(boolean bl2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "showInteractionBlockerOverlay(boolean)", 248).addDetail("force", bl2)).log();
        }
    }

    public void hideInteractionBlockerOverlay(boolean bl2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "hideInteractionBlockerOverlay(boolean)", 249).addDetail("force", bl2)).log();
        }
    }

    public void bringToFront(WebEngine webEngine, boolean bl2, boolean bl3) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "bringToFront(WebEngine,boolean,boolean)", 257).addDetail("engine", (Object)webEngine)).addDetail("restoreOnRaise", bl2)).addDetail("forcedRaise", bl3)).log();
        }
        if (webEngine == null) {
            throw new IllegalArgumentException("engine is marked non-null but is null");
        }
        if (bl2) {
            this.restoreMinimizedWindow();
        }
        this.bringToFront();
        if (bl3) {
            this.forcedRaise(webEngine);
        }
    }

    public void restoreMinimizedWindow() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "restoreMinimizedWindow()", 271).log();
        }
        this.showWindow(0);
    }

    private void forcedRaise(WebEngine webEngine) {
        long l2;
        long l3;
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "forcedRaise(WebEngine)", 278).addDetail("engine", (Object)webEngine)).log();
        }
        if (webEngine == null) {
            throw new IllegalArgumentException("engine is marked non-null but is null");
        }
        if (Misc.OS_IS_WINDOWS && (l3 = this.getHandle()) != 0L && (l2 = NIWindowsAPI.getParent(l3)) != 0L) {
            this.setWindowShortlyTopmost(webEngine, l2);
        }
    }

    private void setWindowShortlyTopmost(WebEngine webEngine, long l2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setWindowShortlyTopmost(WebEngine,long)", 298).addDetail("engine", (Object)webEngine)).addDetail("wnd", l2)).log();
        }
        if (webEngine == null) {
            throw new IllegalArgumentException("engine is marked non-null but is null");
        }
        NIWindowsAPI.setTopmost(l2, true);
        webEngine.invokeLater(new de.qfs.apps.qftest.client.web.a(this, l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDefaultCheck(long l2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "onDefaultCheck(long)", 318).addDetail("p_lDOMNode", l2)).log();
        }
        try {
            Client.instance().pushCaptureContext(this.engine);
            if (this.checkHandler != null) {
                if (this.requiresMinimalCheckHandlerCalls()) {
                    Node node = DocumentNode.getNode(this, l2);
                    if (node != null) {
                        node.getEngine().invokeLater(new b(this, l2));
                    }
                } else {
                    this.checkHandler.b(this, l2);
                }
            }
        }
        finally {
            Client.instance().popCaptureContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] onContextCheck(long l2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "onContextCheck(long)", 355).addDetail("p_lDOMNode", l2)).log();
        }
        try {
            Client.instance().pushCaptureContext(this.engine);
            if (this.checkHandler != null) {
                Object[] objectArray = this.checkHandler.a(this, l2);
                return objectArray;
            }
            Object[] objectArray = new String[]{};
            return objectArray;
        }
        finally {
            Client.instance().popCaptureContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCheckSelect(long l2, int n2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onCheckSelect(long,int)", 378).addDetail("p_lDOMNode", l2)).addDetail("p_iIndex", n2)).log();
        }
        try {
            Client.instance().pushCaptureContext(this.engine);
            if (this.checkHandler != null) {
                if (this.requiresMinimalCheckHandlerCalls()) {
                    Node node = DocumentNode.getNode(this, l2);
                    if (node != null) {
                        node.getEngine().invokeLater(new c(this, l2, n2));
                    }
                } else {
                    this.checkHandler.a(this, l2, n2);
                }
            }
        }
        finally {
            Client.instance().popCaptureContext();
        }
    }

    protected boolean requiresMinimalCheckHandlerCalls() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "requiresMinimalCheckHandlerCalls()", 409).log();
        }
        return this.isBlinkBrowser();
    }

    public e getCheckHandler() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "getCheckHandler()", 421).log();
        }
        return this.checkHandler;
    }

    public void setCheckHandler(e e2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setCheckHandler(CheckHandler)", 434).addDetail("checkHandler", (Object)e2)).log();
        }
        this.checkHandler = e2;
    }

    @Override
    public void onBrowserClose(boolean bl2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "onBrowserClose(boolean)", 448).addDetail("javascript", bl2)).log();
        }
        CloseWindowEvent closeWindowEvent = new CloseWindowEvent(bl2);
        closeWindowEvent.setEventType(401);
        this.callback(closeWindowEvent);
        DllLoader.getInstance().onBrowserClose(this);
    }

    public void onBrowserOpen() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "onBrowserOpen()", 459).log();
        }
        OpenWindowEvent openWindowEvent = new OpenWindowEvent();
        openWindowEvent.setEventType(400);
        this.callback(openWindowEvent);
    }

    @Override
    public void onBeforeBrowserClose(boolean bl2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "onBeforeBrowserClose(boolean)", 475).addDetail("javascript", bl2)).log();
        }
        BeforeCloseWindowEvent beforeCloseWindowEvent = new BeforeCloseWindowEvent(bl2);
        beforeCloseWindowEvent.setEventType(402);
        this.callback(beforeCloseWindowEvent);
    }

    public String getWindowName() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "getWindowName()", 490).log();
        }
        return this.windowName;
    }

    public void setWindowName(String string) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setWindowName(String)", 503).addDetail("windowName", string)).log();
        }
        this.windowName = string;
    }

    @Nullable
    public String getBrowserType() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "getBrowserType()", 512).log();
        }
        if (this.browserType == null) {
            BrowserInfo browserInfo = this.getInfo(false);
            if (browserInfo == null) {
                return null;
            }
            this.browserType = browserInfo.m_strBrowserType;
        }
        return this.browserType;
    }

    public boolean isIE() {
        return this.isRequiredBrowser("ie");
    }

    public boolean isMozilla() {
        return this.isRequiredBrowser("mozilla");
    }

    public boolean isBlinkBrowser() {
        return this.isChrome() || this.isOpera() || this.isMsEdge();
    }

    public boolean isChrome() {
        return this.isRequiredBrowser("chrome");
    }

    public boolean isOpera() {
        return this.isRequiredBrowser("opera");
    }

    public boolean isEdge() {
        return this.isRequiredBrowser("edge");
    }

    public boolean isMsEdge() {
        return this.isRequiredBrowser("msedge");
    }

    public boolean isSafari() {
        return this.isRequiredBrowser("safari");
    }

    public boolean isRequiredBrowser(String string) {
        String string2 = this.getBrowserType();
        if (string.equals("firefox")) {
            string = "mozilla";
        }
        if ("headless-edge".equals(string2)) {
            string2 = "msedge";
        }
        if (string2.startsWith("headless-")) {
            string2 = string2.substring(9);
        }
        if (string2.equals("firefox")) {
            string2 = "mozilla";
        }
        return string.equals(string2);
    }

    public boolean isBrowserInMobileMode() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "isBrowserInMobileMode()", 654).log();
        }
        return false;
    }

    @Override
    public void onAttributeChanged(long l2, long l3, String string) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onAttributeChanged(long,long,String)", 667).addDetail("docHandle", l2)).addDetail("nodeHandle", l3)).addDetail("attribute", string)).log();
        }
        this.onAttributeChanged(l2, l3, string, null, null, 0, MeexEvent.getNextOrderId());
    }

    public void onAttributeChanged(long l2, long l3, String string, @Nullable String string2, @Nullable String string3, int n2, long l4) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onAttributeChanged(long,long,String,String,String,int,long)", 681).addDetail("docHandle", l2)).addDetail("nodeHandle", l3)).addDetail("attribute", string)).addDetail("oldValue", string2)).addDetail("newValue", string3)).addDetail("domRevision", n2)).addDetail("orderId", l4)).log();
        }
        if (this.mutationObserver != null) {
            this.mutationObserver.a(this, l2, l3, string, string2, string3, n2, l4);
        }
    }

    @Override
    public void onNodeAdded(long l2, long l3, int n2, DNode dNode) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onNodeAdded(long,long,int,DNode)", 702).addDetail("docHandle", l2)).addDetail("parentNode", l3)).addDetail("indexOfNewNode", n2)).addDetail("newNode", (Object)dNode)).log();
        }
        this.onNodeAdded(l2, l3, n2, dNode, 0, MeexEvent.getNextOrderId());
    }

    public void onNodeAdded(long l2, long l3, int n2, DNode dNode, int n3, long l4) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onNodeAdded(long,long,int,DNode,int,long)", 717).addDetail("docHandle", l2)).addDetail("parentNode", l3)).addDetail("indexOfNewNode", n2)).addDetail("newNode", (Object)dNode)).addDetail("domRevision", n3)).addDetail("orderId", l4)).log();
        }
        if (this.mutationObserver != null) {
            this.mutationObserver.a(this, l2, l3, n2, dNode, n3, l4);
        }
    }

    @Override
    public void onNodeAddedAfter(long l2, long l3, long l4, DNode dNode) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onNodeAddedAfter(long,long,long,DNode)", 729).addDetail("docHandle", l2)).addDetail("parentNode", l3)).addDetail("previousSiblingNode", l4)).addDetail("newNode", (Object)dNode)).log();
        }
        this.onNodeAddedAfter(l2, l3, l4, dNode, 0, MeexEvent.getNextOrderId());
    }

    public void onNodeAddedAfter(long l2, long l3, long l4, DNode dNode, int n2, long l5) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onNodeAddedAfter(long,long,long,DNode,int,long)", 737).addDetail("docHandle", l2)).addDetail("parentNode", l3)).addDetail("previousSiblingNode", l4)).addDetail("newNode", (Object)dNode)).addDetail("domRevision", n2)).addDetail("orderId", l5)).log();
        }
        if (this.mutationObserver != null) {
            this.mutationObserver.a(this, l2, l3, l4, dNode, n2, l5);
        }
    }

    @Override
    public void onNodeRemoved(long l2, long l3, long l4) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onNodeRemoved(long,long,long)", 754).addDetail("docHandle", l2)).addDetail("parentNode", l3)).addDetail("handleOfRemovedNode", l4)).log();
        }
        this.onNodeRemoved(l2, l3, l4, 0, MeexEvent.getNextOrderId());
    }

    public void onNodeRemoved(long l2, long l3, long l4, int n2, long l5) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onNodeRemoved(long,long,long,int,long)", 768).addDetail("docHandle", l2)).addDetail("parentNode", l3)).addDetail("handleOfRemovedNode", l4)).addDetail("domRevision", n2)).addDetail("orderId", l5)).log();
        }
        if (this.mutationObserver != null) {
            this.mutationObserver.a(this, l2, l3, l4, n2, l5);
        }
    }

    @Override
    public void onDOMChanged(long l2, long l3, DNode dNode) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onDOMChanged(long,long,DNode)", 780).addDetail("docHandle", l2)).addDetail("oldNodeHandle", l3)).addDetail("changedNode", (Object)dNode)).log();
        }
        this.onDOMChanged(l2, l3, dNode, 0, MeexEvent.getNextOrderId());
    }

    public void onDOMChanged(long l2, long l3, DNode dNode, int n2, long l4) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onDOMChanged(long,long,DNode,int,long)", 788).addDetail("docHandle", l2)).addDetail("oldNodeHandle", l3)).addDetail("changedNode", (Object)dNode)).addDetail("domRevision", n2)).addDetail("orderId", l4)).log();
        }
        if (this.mutationObserver != null) {
            this.mutationObserver.a(this, l2, l3, dNode, n2, l4);
        }
    }

    @Override
    public void onSlotChanged(long l2, long l3, @Nullable long[] lArray) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onSlotChanged(long,long,long[])", 800).addDetail("docHandle", l2)).addDetail("slotHandle", l3)).addDetail("assignedHandles", (Object)lArray)).log();
        }
        this.onSlotChanged(l2, l3, lArray, 0, MeexEvent.getNextOrderId());
    }

    public void onSlotChanged(long l2, long l3, @Nullable long[] lArray, int n2, long l4) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onSlotChanged(long,long,long[],int,long)", 808).addDetail("docHandle", l2)).addDetail("slotHandle", l3)).addDetail("assignedHandles", (Object)lArray)).addDetail("domRevision", n2)).addDetail("orderId", l4)).log();
        }
        if (this.mutationObserver != null) {
            this.mutationObserver.a(this, l2, l3, lArray, n2, l4);
        }
    }

    public void onTitleChanged(long l2, String string) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onTitleChanged(long,String)", 819).addDetail("docHandle", l2)).addDetail("title", string)).log();
        }
        if (this.mutationObserver != null) {
            this.mutationObserver.a(this, l2, string);
        }
    }

    @Override
    public long[] getCachedChildren(long l2, long l3) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getCachedChildren(long,long)", 831).addDetail("docHandle", l2)).addDetail("node", l3)).log();
        }
        if (this.mutationObserver != null) {
            return this.mutationObserver.a(this, l2, l3);
        }
        return null;
    }

    @Override
    public void onPopupBrowser(Browser browser) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "onPopupBrowser(Browser)", 849).addDetail("browser", (Object)browser)).log();
        }
        browser.setMutationObserver(this.mutationObserver);
        browser.setBrowserCreationListener(this.browserCreationListener);
        if (this.browserCreationListener != null) {
            this.browserCreationListener.popupBrowserCreated(this, browser);
        }
    }

    public d getBrowserCreationListener() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "getBrowserCreationListener()", 867).log();
        }
        return this.browserCreationListener;
    }

    public void setBrowserCreationListener(d d2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setBrowserCreationListener(BrowserCreationListener)", 880).addDetail("browserCreationListener", (Object)d2)).log();
        }
        this.browserCreationListener = d2;
    }

    public m getMutationObserver() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "getMutationObserver()", 893).log();
        }
        return this.mutationObserver;
    }

    public void setMutationObserver(m m2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setMutationObserver(IDOMMutationObserver)", 906).addDetail("mutationObserver", (Object)m2)).log();
        }
        this.mutationObserver = m2;
    }

    @Override
    public long onGetNodeForCheck(long[] lArray, int n2, int n3, int n4) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onGetNodeForCheck(long[],int,int,int)", 915).addDetail("handles", (Object)lArray)).addDetail("screenX", n2)).addDetail("screenY", n3)).addDetail("modifiers", n4)).log();
        }
        return this.onGetNodeForCheck(lArray, n2, n3, n4, false);
    }

    @Override
    public long onGetNodeForCheck(long[] lArray, int n2, int n3, int n4, boolean bl2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onGetNodeForCheck(long[],int,int,int,boolean)", 924).addDetail("handles", (Object)lArray)).addDetail("screenX", n2)).addDetail("screenY", n3)).addDetail("modifiers", n4)).addDetail("handlesAreSorted", bl2)).log();
        }
        if (this.checkHandler != null) {
            return this.checkHandler.a(this, lArray, n2, n3, n4, bl2);
        }
        return lArray != null && lArray.length > 0 ? lArray[0] : 0L;
    }

    @Override
    public long[] onGetNodesForCheckMenu(long l2, long[] lArray) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onGetNodesForCheckMenu(long,long[])", 936).addDetail("primaryHandle", l2)).addDetail("potentialHandles", (Object)lArray)).log();
        }
        if (this.checkHandler != null) {
            return this.checkHandler.a(this, l2, lArray);
        }
        return lArray;
    }

    @Override
    public void onDocumentStructureInvalid(long l2, int n2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onDocumentStructureInvalid(long,int)", 950).addDetail("docHandle", l2)).addDetail("type", n2)).log();
        }
    }

    @Override
    public void onRequest(long l2, String string, String string2, String string3, int n2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onRequest(long,String,String,String,int)", 959).addDetail("id", l2)).addDetail("url", string)).addDetail("method", string2)).addDetail("requestHeaders", string3)).addDetail("requestType", n2)).log();
        }
        if (!this.eventFilters.isEmpty()) {
            this.callback(new HttpRequestEvent(l2, string, string2, string3, n2));
        }
    }

    @Override
    public void onResponse(long l2, String string, int n2, String string2, String string3) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onResponse(long,String,int,String,String)", 971).addDetail("id", l2)).addDetail("url", string)).addDetail("statusCode", n2)).addDetail("statusText", string2)).addDetail("responseHeaders", string3)).log();
        }
        if (!this.eventFilters.isEmpty()) {
            this.callback(new HttpResponseEvent(l2, string, n2, string2, string3));
        }
    }

    @Override
    public void onDataAvailable(long l2, byte[] byArray) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onDataAvailable(long,byte[])", 983).addDetail("id", l2)).addDetail("content", (Object)byArray)).log();
        }
        if (!this.eventFilters.isEmpty()) {
            this.callback(new HttpDataAvailableEvent(l2, byArray));
        }
    }

    public void onRequestAbort(long l2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "onRequestAbort(long)", 993).addDetail("id", l2)).log();
        }
        if (!this.eventFilters.isEmpty()) {
            this.callback(new HttpRequestAbortEvent(l2));
        }
    }

    public void onRequestTerminate(long l2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "onRequestTerminate(long)", 1003).addDetail("id", l2)).log();
        }
        if (!this.eventFilters.isEmpty()) {
            this.callback(new HttpRequestTerminateEvent(l2));
        }
    }

    public boolean shouldNotRecordEvents() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "shouldNotRecordEvents()", 1018).log();
        }
        return false;
    }

    @Override
    public long getDocument() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "getDocument()", 1031).log();
        }
        return super.getDocument();
    }

    @Override
    public long getHandle() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "getHandle()", 1040).log();
        }
        return super.getHandle();
    }

    public long getToplevelHandle() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "getToplevelHandle()", 1048).log();
        }
        long l2 = this.getHandle();
        long l3 = NIWindowsAPI.getParent(l2);
        return l3;
    }

    @Override
    public BrowserInfo getInfo(boolean bl2) {
        block4: {
            if (Browser.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "getInfo(boolean)", 1069).addDetail("refresh", bl2)).log();
            }
            if (bl2 || this.info == null) {
                try {
                    this.info = this.getInfo();
                }
                catch (BlockedBrowserException blockedBrowserException) {
                    if (Browser.logger.level < 3) break block4;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "getInfo(boolean)", 1077).add("Browser is blocked", (Object)blockedBrowserException)).log();
                }
            }
        }
        return this.info;
    }

    public boolean eval(long l2, String string, @Nullable Map map, EvalResult evalResult) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "eval(long,String,Map<String, Object>,EvalResult)", 1095).addDetail("doc", l2)).addDetail("code", string)).addDetail("bindings", (Object)map)).addDetail("result", (Object)evalResult)).log();
        }
        if (evalResult == null) {
            throw new IllegalArgumentException("result is marked non-null but is null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string.startsWith(PROMISIFIED_JS_PREFIX)) {
            string = string.substring(PROMISIFIED_JS_PREFIX.length());
            stringBuilder.append(PROMISIFIED_JS_PREFIX);
        }
        this.appendBindings(stringBuilder, map);
        stringBuilder.append(string);
        return this.eval(l2, stringBuilder.toString(), evalResult);
    }

    private void appendBindings(StringBuilder stringBuilder, @Nullable Map map) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "appendBindings(StringBuilder,Map<String, Object>)", 1112).addDetail("codeBuilder", (Object)stringBuilder)).addDetail("bindings", (Object)map)).log();
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String string = i.b((String)entry.getKey());
                Object v2 = entry.getValue();
                this.appendBinding(stringBuilder, string, v2);
            }
        }
    }

    protected void appendBinding(StringBuilder stringBuilder, String string, Object object) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "appendBinding(StringBuilder,String,Object)", 1126).addDetail("codeBuilder", (Object)stringBuilder)).addDetail("varname", string)).addDetail("value", object)).log();
        }
        stringBuilder.append("var ").append(string).append("=");
        this.appendBindingValue(stringBuilder, string, object);
        stringBuilder.append(";");
    }

    private void appendBindingValue(StringBuilder stringBuilder, String string, Object object) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "appendBindingValue(StringBuilder,String,Object)", 1136).addDetail("codeBuilder", (Object)stringBuilder)).addDetail("varname", string)).addDetail("value", object)).log();
        }
        if (object instanceof DomNode) {
            stringBuilder.append(((DomNode)object).asJS(string));
        } else {
            String string2 = Json.value((Object)object).toString();
            stringBuilder.append(string2);
        }
    }

    public boolean callJS(long l2, String string, @Nullable Map map, EvalResult evalResult) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "callJS(long,String,Map<String, Object>,EvalResult)", 1157).addDetail("doc", l2)).addDetail("code", string)).addDetail("bindings", (Object)map)).addDetail("result", (Object)evalResult)).log();
        }
        if (evalResult == null) {
            throw new IllegalArgumentException("result is marked non-null but is null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string.startsWith(PROMISIFIED_JS_PREFIX)) {
            string = string.substring(PROMISIFIED_JS_PREFIX.length());
            stringBuilder.append(PROMISIFIED_JS_PREFIX);
        }
        if (this.evalSupportsFunctionCall()) {
            stringBuilder.append(CALL_JS_PREFIX);
            if (map == null || map.isEmpty()) {
                stringBuilder.append(string);
            } else {
                stringBuilder.append("return ");
                this.appendWrappedFunctionCallInJSStatement(stringBuilder, map, string);
                stringBuilder.append("(");
                this.appendBindingValues(stringBuilder, map);
                stringBuilder.append(")");
            }
        } else {
            this.appendBindings(stringBuilder, map);
            this.appendWrappedFunctionCallInJSStatement(stringBuilder, map, string);
            stringBuilder.append("(");
            this.appendBindingNames(stringBuilder, map);
            stringBuilder.append(")");
        }
        return this.eval(l2, stringBuilder.toString(), evalResult);
    }

    private void appendWrappedFunctionCallInJSStatement(StringBuilder stringBuilder, @Nullable Map map, String string) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "appendWrappedFunctionCallInJSStatement(StringBuilder,Map<String, Object>,String)", 1196).addDetail("codeBuilder", (Object)stringBuilder)).addDetail("bindings", (Object)map)).addDetail("code", string)).log();
        }
        stringBuilder.append("(");
        if (i.a(string)) {
            stringBuilder.append(string);
        } else {
            stringBuilder.append("function(");
            this.appendBindingNames(stringBuilder, map);
            stringBuilder.append("){").append(string).append("}");
        }
        stringBuilder.append(")");
    }

    protected boolean evalSupportsFunctionCall() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "evalSupportsFunctionCall()", 1212).log();
        }
        return false;
    }

    private void appendBindingNames(StringBuilder stringBuilder, @Nullable Map map) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "appendBindingNames(StringBuilder,Map<String, Object>)", 1217).addDetail("codeBuilder", (Object)stringBuilder)).addDetail("bindings", (Object)map)).log();
        }
        if (map != null) {
            boolean bl2 = true;
            for (Map.Entry entry : map.entrySet()) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(i.b((String)entry.getKey()));
            }
        }
    }

    private void appendBindingValues(StringBuilder stringBuilder, @Nullable Map map) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "appendBindingValues(StringBuilder,Map<String, Object>)", 1235).addDetail("codeBuilder", (Object)stringBuilder)).addDetail("bindings", (Object)map)).log();
        }
        if (map != null) {
            int n2 = 0;
            for (Map.Entry entry : map.entrySet()) {
                String string = "_qf_node";
                if (n2 > 0) {
                    stringBuilder.append(",");
                    string = string + n2;
                }
                this.appendBindingValue(stringBuilder, string, entry.getValue());
                ++n2;
            }
        }
    }

    public final String getBeforeNavigateURL() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "getBeforeNavigateURL()", 1258).log();
        }
        return this.beforeNavigateURL;
    }

    public final void setBeforeNavigateURL(String string) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setBeforeNavigateURL(String)", 1271).addDetail("beforeNavigateURL", string)).log();
        }
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setBeforeNavigateURL(String)", 1273).addDetail("beforeNavigateURL", string)).log();
        }
        this.beforeNavigateURL = string;
    }

    public boolean isEmbeddedBrowser() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "isEmbeddedBrowser()", 1283).log();
        }
        return false;
    }

    public void prepareImageCapture(long l2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "prepareImageCapture(long)", 1291).addDetail("handle", l2)).log();
        }
    }

    public void finishImageCapture(long l2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "finishImageCapture(long)", 1299).addDetail("handle", l2)).log();
        }
    }

    public void enableRecordingMode(boolean bl2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "enableRecordingMode(boolean)", 1310).addDetail("recording", bl2)).log();
        }
    }

    @Override
    public void injectionCodeFragmentUpdated(String string, String string2) {
        DocumentNode[] documentNodeArray;
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "injectionCodeFragmentUpdated(String,String)", 1318).addDetail("fragmentName", string)).addDetail("code", string2)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("fragmentName is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("code is marked non-null but is null");
        }
        for (DocumentNode documentNode : documentNodeArray = DocumentNode.getDocuments(this)) {
            try {
                documentNode.evalJS(string2);
            }
            catch (TestException testException) {
                if (Browser.logger.level < 3) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "injectionCodeFragmentUpdated(String,String)", 1326).add("e", (Object)testException)).log();
            }
        }
    }

    public boolean canReceiveSemihardEvents() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "canReceiveSemihardEvents()", 1337).log();
        }
        return !Misc.OS_IS_MAC_OS_X;
    }

    public boolean canReceiveHardEvents() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "canReceiveHardEvents()", 1348).log();
        }
        return !this.isHeadless();
    }

    public double getDevicePixelRatio() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "getDevicePixelRatio()", 1356).log();
        }
        return this.getDevicePixelRatio(false);
    }

    public double getDevicePixelRatio(boolean bl2) {
        Double d2;
        block8: {
            if (Browser.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "getDevicePixelRatio(boolean)", 1361).addDetail("forceUpdate", bl2)).log();
            }
            d2 = this.getInfo(bl2).getDevicePixelRatio();
            if (Browser.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getDevicePixelRatio(boolean)", 1364).add("devicePixelRatio", (Object)d2)).log();
            }
            if (d2 == null && !bl2) {
                try {
                    d2 = this.getInfo(true).getDevicePixelRatio();
                    if (Browser.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "getDevicePixelRatio(boolean)", 1368).add("devicePixelRatio", (Object)d2)).log();
                    }
                }
                catch (Exception exception) {
                    if (Browser.logger.level < 5) break block8;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "getDevicePixelRatio(boolean)", 1370).add("Could not update browser info")).add("ex", (Object)exception)).log();
                }
            }
        }
        if (d2 == null) {
            d2 = 1.0;
        }
        assert (d2 != null);
        return d2;
    }

    public boolean hasMultipleTabs() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "hasMultipleTabs()", 1383).log();
        }
        return false;
    }

    public boolean isHandleValid(long l2) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "isHandleValid(long)", 1391).addDetail("handle", l2)).log();
        }
        return DomNode.isHandleValid(this, l2, '\u0000');
    }

    public boolean isPopup() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "isPopup()", 1398).log();
        }
        return true;
    }

    public String getVisibleBrowserType() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "getVisibleBrowserType()", 1405).log();
        }
        return this.getBrowserType();
    }

    @Nullable
    public WebEngine getEngine() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "getEngine()", 84).log();
        }
        return this.engine;
    }

    public Browser setEngine(@Nullable WebEngine webEngine) {
        if (Browser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setEngine(E)", 84).addDetail("engine", (Object)webEngine)).log();
        }
        this.engine = webEngine;
        return this;
    }

    public boolean isHeadless() {
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "isHeadless()", 129).log();
        }
        return this.headless;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public a getChromeNativeQfApp() {
        Object object;
        if (Browser.logger.level >= 7) {
            logger.lvlBuild(7, "getChromeNativeQfApp()", 134).log();
        }
        if ((object = this.chromeNativeQfApp.get()) == null) {
            AtomicReference atomicReference = this.chromeNativeQfApp;
            synchronized (atomicReference) {
                object = this.chromeNativeQfApp.get();
                if (object == null) {
                    a a2 = this.initChromeNativeQfApp();
                    object = a2 == null ? this.chromeNativeQfApp : a2;
                    this.chromeNativeQfApp.set(object);
                }
            }
        }
        return object == this.chromeNativeQfApp ? null : object;
    }

    static /* synthetic */ QFLogger access$000() {
        return logger;
    }
}

