/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.web.check;

import de.qfs.apps.qftest.client.web.WebHelper;
import de.qfs.apps.qftest.client.web.check.NodeChecker;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.Node;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.shared.data.check.BooleanCheckData;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.util.ArrayList;

public class InputChecker
extends NodeChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.web.check.InputChecker");

    public InputChecker(WebHelper webHelper) {
        super(webHelper);
        if (InputChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "InputChecker(WebHelper)", 55).addDetail("helper", (Object)webHelper)).log();
        }
    }

    @Override
    public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
        if (InputChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSupportedCheckTypes(Object,Object)", 73).addDetail("target", object)).addDetail("item", object2)).log();
        }
        if (!(object instanceof DomNode)) {
            return null;
        }
        DomNode domNode = this.a(object);
        String string = domNode.getDefaultClassName();
        ArrayList<CheckType> arrayList = new ArrayList<CheckType>();
        if ("INPUT:TEXT".equals(string) || "INPUT:PASSWORD".equals(string) || "INPUT:SUBMIT".equals(string) || "INPUT:RESET".equals(string) || "INPUT:BUTTON".equals(string) || "BUTTON:BUTTON".equals(string) || "BUTTON:SUBMIT".equals(string) || "BUTTON:RESET".equals(string)) {
            arrayList.add(CheckType.TEXT);
        } else if ("INPUT:RADIO".equals(string) || "INPUT:CHECKBOX".equals(string)) {
            arrayList.add(CheckType.CHECKED);
        }
        arrayList.add(CheckType.ATT_NAME);
        arrayList.add(CheckType.ATT_VALUE);
        this.addAttrCheckTypes(domNode, arrayList);
        arrayList.add(CheckType.VISIBLE);
        arrayList.add(CheckType.FOCUSED);
        arrayList.add(CheckType.GEOMETRY);
        arrayList.add(CheckType.ENABLED);
        if ("INPUT:TEXT".equals(string) || "INPUT:PASSWORD".equals(string)) {
            arrayList.add(CheckType.EDITABLE);
        }
        return arrayList.toArray(new CheckType[0]);
    }

    @Override
    public CheckData getCheckData(Object object, Object object2, CheckType checkType) {
        if (InputChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckData(Object,Object,CheckType)", 124).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
        }
        DomNode domNode = this.a(object);
        if (checkType.getDataType() == CheckDataType.STRING) {
            if ("default".equals(checkType.getIdentifier()) || CheckType.TEXT.getIdentifier().equals(checkType.getIdentifier())) {
                return new StringCheckData("default", this.helper.getWholeText(domNode));
            }
            if (CheckType.ATT_NAME.getIdentifier().equals(checkType.getIdentifier())) {
                return new StringCheckData(CheckType.ATT_NAME.getIdentifier(), domNode.getAttribute("name"));
            }
            if (CheckType.ATT_VALUE.getIdentifier().equals(checkType.getIdentifier())) {
                return new StringCheckData(CheckType.ATT_VALUE.getIdentifier(), domNode.getAttribute("value"));
            }
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.CHECKED.getIdentifier().equals(checkType.getIdentifier()))) {
            return new BooleanCheckData(CheckType.CHECKED.getIdentifier(), "1".equals(domNode.getAttribute("checked")));
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.ENABLED.getIdentifier().equals(checkType.getIdentifier())) {
            return new BooleanCheckData(CheckType.ENABLED.getIdentifier(), this.helper.isEnabled(domNode));
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.EDITABLE.getIdentifier().equals(checkType.getIdentifier())) {
            return new BooleanCheckData(CheckType.EDITABLE.getIdentifier(), !this.helper.isReadonly(domNode));
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.FOCUSED.getIdentifier().equals(checkType.getIdentifier())) {
            return new BooleanCheckData(CheckType.FOCUSED.getIdentifier(), domNode.hasFocus());
        }
        return super.getCheckData(domNode, object2, checkType);
    }

    private DomNode a(Object object) {
        DomNode domNode = (DomNode)object;
        if (!domNode.isMatchingClass("INPUT") && domNode.isMatchingClass("TextField")) {
            Node[] nodeArray = domNode.getElementsByClassName("INPUT");
            if (InputChecker.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "redirect(Object)", 197).add("inputs", (Object)nodeArray)).log();
            }
            if (nodeArray.length == 1) {
                domNode = (DomNode)nodeArray[0];
            }
        }
        return domNode;
    }
}

