/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.web.check;

import de.qfs.apps.qftest.client.web.WebHelper;
import de.qfs.apps.qftest.client.web.check.NodeChecker;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.Node;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.shared.data.check.BooleanCheckData;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Pair;
import java.util.ArrayList;

public class TextareaChecker
extends NodeChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.web.check.TextareaChecker");

    public TextareaChecker(WebHelper webHelper) {
        super(webHelper);
        if (TextareaChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "TextareaChecker(WebHelper)", 54).addDetail("helper", (Object)webHelper)).log();
        }
    }

    @Override
    public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
        if (TextareaChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSupportedCheckTypes(Object,Object)", 72).addDetail("target", object)).addDetail("item", object2)).log();
        }
        DomNode domNode = this.a(object);
        ArrayList<CheckType> arrayList = new ArrayList<CheckType>();
        arrayList.add(CheckType.TEXT);
        this.addAttrCheckTypes(domNode, arrayList);
        arrayList.add(CheckType.VISIBLE);
        arrayList.add(CheckType.FOCUSED);
        arrayList.add(CheckType.GEOMETRY);
        arrayList.add(CheckType.ENABLED);
        arrayList.add(CheckType.EDITABLE);
        return arrayList.toArray(new CheckType[0]);
    }

    @Override
    public CheckData getCheckData(Object object, Object object2, CheckType checkType) {
        if (TextareaChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckData(Object,Object,CheckType)", 101).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
        }
        DomNode domNode = this.a(object);
        if (checkType.getDataType() == CheckDataType.STRING && (object2 == null && "default".equals(checkType.getIdentifier()) || CheckType.TEXT.getIdentifier().equals(checkType.getIdentifier()))) {
            return new StringCheckData("default", domNode.getAttribute("value"));
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.ENABLED.getIdentifier().equals(checkType.getIdentifier())) {
            return new BooleanCheckData(CheckType.ENABLED.getIdentifier(), this.helper.isEnabled(domNode));
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.EDITABLE.getIdentifier().equals(checkType.getIdentifier())) {
            return new BooleanCheckData(CheckType.EDITABLE.getIdentifier(), !this.helper.isReadonly(domNode));
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.FOCUSED.getIdentifier().equals(checkType.getIdentifier())) {
            return new BooleanCheckData(CheckType.FOCUSED.getIdentifier(), domNode.hasFocus());
        }
        if (TextareaChecker.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 127).add("returns null")).log();
        }
        return super.getCheckData(domNode, object2, checkType);
    }

    @Override
    public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) {
        CheckData checkData;
        if (TextareaChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataAndItem(Object,Object,CheckType)", 146).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
        }
        if ((checkData = this.getCheckData(object, object2, checkType)) == null) {
            return null;
        }
        if (CheckType.TEXT.getIdentifier().equals(checkType.getIdentifier())) {
            return new Pair((Object)checkData, null);
        }
        if (CheckType.LINE.getIdentifier().equals(checkType.getIdentifier())) {
            return new Pair((Object)checkData, object2);
        }
        if (CheckType.LINES.getIdentifier().equals(checkType.getIdentifier())) {
            return new Pair((Object)checkData, null);
        }
        return new Pair((Object)checkData, null);
    }

    private DomNode a(Object object) {
        DomNode domNode = (DomNode)object;
        if (!domNode.isMatchingClass("TEXTAREA") && domNode.isMatchingClass("TextArea")) {
            Node[] nodeArray = domNode.getElementsByClassName("TEXTAREA");
            if (TextareaChecker.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "redirect(Object)", 188).add("areas", (Object)nodeArray)).log();
            }
            if (nodeArray.length == 1) {
                domNode = (DomNode)nodeArray[0];
            }
        }
        return domNode;
    }
}

