/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.web.dom;

import de.qfs.apps.qftest.client.Engine;
import de.qfs.apps.qftest.client.web.Browser;
import de.qfs.apps.qftest.client.web.BrowserDialog;
import de.qfs.apps.qftest.client.web.WebEngine;
import de.qfs.apps.qftest.client.web.ap;
import de.qfs.apps.qftest.client.web.dom.DocumentNode;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.Node;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

public class DialogNode
extends Node {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.web.dom.DialogNode");
    public static final String DIALOG_NODE = "DIALOG_NODE";
    public static final long STYLE_ALERT = 260L;
    public static final long STYLE_CONFIRM = 1044L;
    public static final long STYLE_YESNO_CONFIRM = 1045L;
    public static final long STYLE_RETRY_CANCEL = 1046L;
    public static final long STYLE_PROMPT = 1047L;
    public static final long STYLE_OK_CANCEL_WARNING = 1048L;
    public static final long STYLE_BEFORE_UNLOAD = 1049L;
    public static final long STYLE_AUTHENTICATE = 8000L;
    public static final long STYLE_DOWNLOAD = 9000L;
    public static final long STYLE_UPLOAD = 9001L;
    private DocumentNode b;
    private WebEngine c;
    private BrowserDialog d;
    private String e;

    protected DialogNode(WebEngine webEngine, BrowserDialog browserDialog) {
        super(-500L - (long)Math.abs(browserDialog.getDialogId()));
        if (DialogNode.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "DialogNode(WebEngine,BrowserDialog)", 131).addDetail("engine", (Object)webEngine)).addDetail("dialog", (Object)browserDialog)).log();
        }
        this.c = webEngine;
        this.d = browserDialog;
    }

    @Override
    public DomNode getByXPath(String string) {
        if (DialogNode.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getByXPath(String)", 145).addDetail("xpath", string)).log();
        }
        return null;
    }

    @Override
    public Node getParent() {
        if (DialogNode.a.level >= 7) {
            a.lvlBuild(7, "getParent()", 158).log();
        }
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public Node getChild(int n2) {
        return null;
    }

    @Override
    public DocumentNode getDocument() {
        if (this.b == null) {
            this.b = DocumentNode.getDocument(this.d.getDocHandle());
        }
        return this.b;
    }

    public long getStyle() {
        return this.d.getStyle();
    }

    public final String getTitle() {
        return this.d.getTitle();
    }

    @Override
    public final String getText() {
        return this.d.getText();
    }

    public final String getValue() {
        return this.e;
    }

    public final void setValue(String string) {
        if (DialogNode.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setValue(String)", 282).addDetail("value", string)).log();
        }
        this.e = string;
    }

    @Override
    public Browser getBrowser() {
        Iterator iterator;
        Browser browser = this.d.getBrowser();
        if (this.c.isBrowserValid(browser)) {
            return browser;
        }
        if (DialogNode.a.level >= 5) {
            ((LevelAwareLogBuilder)a.lvlBuild(5, "getBrowser()", 307).add("Browser invalid", (Object)browser)).log();
        }
        if ((iterator = this.c.getBrowserCollection().iterator()).hasNext()) {
            return (Browser)iterator.next();
        }
        if (DialogNode.a.level >= 3) {
            ((LevelAwareLogBuilder)a.lvlBuild(3, "getBrowser()", 312).add("No browser for this dialog", (Object)this)).log();
        }
        return null;
    }

    @Override
    public String getNodeType() {
        return DIALOG_NODE;
    }

    @Override
    protected String getTagName() {
        return "DIALOG";
    }

    public final BrowserDialog getDialog() {
        return this.d;
    }

    public final void setDialog(BrowserDialog browserDialog) {
        if (DialogNode.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setDialog(BrowserDialog)", 368).addDetail("dialog", (Object)browserDialog)).log();
        }
        this.d = browserDialog;
    }

    @Override
    public Object evalJS(String string, @Nullable Map map) throws TestException {
        if (DialogNode.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "evalJS(String,Map<String, Object>)", 377).addDetail("script", string)).addDetail("bindings", (Object)map)).log();
        }
        if (this.b == null) {
            if (DialogNode.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "evalJS(String,Map<String, Object>)", 381).add("No document to evaluate javascript on")).log();
            }
            return null;
        }
        Object object = this.b.evalJS(string, map);
        if (DialogNode.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "evalJS(String,Map<String, Object>)", 386).add("ret", object)).log();
        }
        return object;
    }

    @Override
    public Object evalJS(String string) throws TestException {
        if (DialogNode.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "evalJS(String)", 394).addDetail("script", string)).log();
        }
        return this.evalJS(string, Util.createKeyValueMap((Object[])new Object[0]));
    }

    @Override
    public Object callJS(String string, @Nullable Map map) throws TestException {
        if (DialogNode.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "callJS(String,Map<String, Object>)", 404).addDetail("script", string)).addDetail("bindings", (Object)map)).log();
        }
        if (this.b == null) {
            if (DialogNode.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "callJS(String,Map<String, Object>)", 408).add("No document to call javascript funcztion on")).log();
            }
            return null;
        }
        Object object = this.b.callJS(string, map);
        if (DialogNode.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "callJS(String,Map<String, Object>)", 413).add("ret", object)).log();
        }
        return object;
    }

    @Override
    public Object callJS(String string) throws TestException {
        if (DialogNode.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "callJS(String)", 421).addDetail("script", string)).log();
        }
        return this.callJS(string, Util.createKeyValueMap((Object[])new Object[0]));
    }

    public String getDefaultName() {
        switch ((int)this.getDialog().getStyle()) {
            case 260: {
                return "AlertDialog";
            }
            case 1044: 
            case 1048: 
            case 1049: {
                return "ConfirmDialog";
            }
            case 8000: {
                return "LoginDialog";
            }
            case 9000: {
                return "DownloadDialog";
            }
            case 9001: {
                return "UploadDialog";
            }
            case 1047: {
                return "PromptDialog";
            }
        }
        return "";
    }

    @Override
    public String getDefaultClassName() {
        String string = this.getName();
        switch ((int)this.getDialog().getStyle()) {
            case 260: {
                string = string + ":ALERT";
                break;
            }
            case 1044: 
            case 1048: 
            case 1049: {
                string = string + ":CONFIRM";
                break;
            }
            case 8000: {
                string = string + ":LOGIN";
                break;
            }
            case 9000: {
                string = string + ":DOWNLOAD";
                break;
            }
            case 9001: {
                string = string + ":UPLOAD";
                break;
            }
            case 1047: {
                string = string + ":PROMPT";
            }
        }
        return string;
    }

    @Override
    public WebEngine getEngine() {
        this.getDocument();
        return this.b != null ? this.b.c : (WebEngine)Engine.threadInstance("web");
    }

    public Object getCheckData(String string) {
        if (DialogNode.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckData(String)", 521).addDetail("identifier", string)).log();
        }
        switch (string) {
            case "visible": {
                return true;
            }
            case "default": 
            case "text": {
                return this.getDialog().getText();
            }
        }
        return null;
    }

    public void simulateEvent(String string) throws TestException {
        if (DialogNode.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "simulateEvent(String)", 537).addDetail("eventDetails", string)).log();
        }
        ((ap)this.c.getPlayer()).a(this, string);
    }
}

