/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.web.dom;

import de.qfs.apps.qftest.client.Engine;
import de.qfs.apps.qftest.client.web.WebEngine;
import de.qfs.apps.qftest.client.web.dom.DocumentNode;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.Node;
import de.qfs.apps.qftest.client.web.dom.PseudoAttribute;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.json.Json;
import de.qfs.lib.json.JsonArray;
import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonValue;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DomNodeAttributes {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.client.web.dom.DomNodeAttributes");
    public static final String ATTR_VALUE_NULL = "<<NULL-VALUE>>";
    protected static final Map pseudoAttributes = new LinkedHashMap();
    public static HashMap DEFAULT_ATTRIBUTES = new LinkedHashMap();
    public static final Object DEFAULT_ATTRIBUTES_MONITOR = new Object();
    public static final Set DEFAULT_ATTRIBUTES_BLACKLIST = new HashSet();
    static HashMap baseAttributes;
    static HashMap baseAttributesWithPseudoAttributes;
    static final HashMap initialBaseAttributes;
    static final HashMap initialBaseAttributesWithPseudoAttributes;
    static final HashMap INITIAL_DEFAULT_ATTRIBUTES;

    public static final String getDefaultAttributesAsJSONString() {
        JsonObject jsonObject = new JsonObject();
        Set set = (Set)DEFAULT_ATTRIBUTES.get("<QF_ALL>");
        for (String string : DEFAULT_ATTRIBUTES.keySet()) {
            if ("<QF_ALL>".equals(string)) {
                jsonObject.add(string, Json.value(DEFAULT_ATTRIBUTES.get(string)));
                continue;
            }
            JsonArray jsonArray = new JsonArray();
            for (String string2 : (Set)DEFAULT_ATTRIBUTES.get(string)) {
                if (set != null && set.contains(string2)) continue;
                jsonArray.add(string2);
            }
            if (jsonArray.size() <= 0) continue;
            jsonObject.add(string, (JsonValue)jsonArray);
        }
        return jsonObject.toString();
    }

    @Deprecated
    public static boolean addDefaultAttributes(String string) {
        if (string == null) {
            throw new IllegalArgumentException("tagsAndAttributes is marked non-null but is null");
        }
        Map map = DomNodeAttributes.parseTagsAndAttributes(string);
        return DomNodeAttributes.addDefaultAttributes(map);
    }

    static Map parseTagsAndAttributes(String string) {
        if (string == null) {
            throw new IllegalArgumentException("tagsAndAttributes is marked non-null but is null");
        }
        String[] stringArray = Misc.fastSplit((String)string, (char)',');
        HashMap hashMap = new HashMap();
        for (String string2 : stringArray) {
            String[] stringArray2 = Misc.fastSplit((String)string2, (char)'=');
            if (stringArray2.length != 2) {
                if (DomNodeAttributes.logger.level < 5) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "parseTagsAndAttributes(String)", 213).add("Ops. wrong tagAttributePair: ", string2)).log();
                continue;
            }
            String string3 = stringArray2[0].trim().toUpperCase();
            String[] stringArray3 = Misc.fastSplit((String)stringArray2[1], (char)'|');
            if (stringArray3.length == 0) {
                if (DomNodeAttributes.logger.level < 5) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "parseTagsAndAttributes(String)", 219).add("Ops. no Attributes: ", string2)).log();
                continue;
            }
            HashSet<String> hashSet = (HashSet<String>)hashMap.get(string3);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            for (String string4 : stringArray3) {
                String string5 = string4.trim();
                if (string5.length() <= 0) continue;
                hashSet.add(string5);
            }
            hashMap.put(string3, hashSet);
        }
        return hashMap;
    }

    public static boolean addDefaultAttributes(String string, String ... stringArray) {
        if (string == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("attributesToAdd is marked non-null but is null");
        }
        return DomNodeAttributes.addDefaultAttributes(string, Arrays.asList(stringArray));
    }

    public static boolean addDefaultAttributes(String string, Collection collection) {
        if (DomNodeAttributes.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addDefaultAttributes(String,Collection<String>)", 261).addDetail("tagName", string)).addDetail("attributesToAdd", (Object)collection)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        if (collection == null) {
            throw new IllegalArgumentException("attributesToAdd is marked non-null but is null");
        }
        HashMap<String, Collection> hashMap = new HashMap<String, Collection>();
        hashMap.put(string, collection);
        return DomNodeAttributes.addDefaultAttributes(hashMap);
    }

    public static boolean addDefaultAttributes(Map map) {
        if (DomNodeAttributes.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addDefaultAttributes(Map<String, ? extends Collection<String>>)", 278).addDetail("attributesToAdd", (Object)map)).log();
        }
        if (map == null) {
            throw new IllegalArgumentException("attributesToAdd is marked non-null but is null");
        }
        if (!Options.cached_OPT_WEB_AUTO_GET_ATTRIBUTE) {
            return false;
        }
        HashMap<String, List> hashMap = new HashMap<String, List>();
        TreeSet treeSet = new TreeSet(map.keySet());
        for (String object : treeSet) {
            Collection collection;
            List list = DomNodeAttributes.addDefaultAttributesWithoutSync(object, collection = (Collection)map.get(object), false, false);
            if (list.size() <= 0) continue;
            hashMap.put(object, list);
        }
        if (DomNodeAttributes.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "addDefaultAttributes(Map<String, ? extends Collection<String>>)", 294).add("addedAttributes", hashMap)).log();
        }
        if (hashMap.size() == 0) {
            return false;
        }
        DomNodeAttributes.synchronizeDefaultAttributes();
        for (Map.Entry entry : hashMap.entrySet()) {
            DomNode.cacheAttributeValues((String)entry.getKey(), (List)entry.getValue());
        }
        return true;
    }

    protected static List addDefaultAttributesWithoutSync(String string, String ... stringArray) {
        if (string == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("attributesToAdd is marked non-null but is null");
        }
        return DomNodeAttributes.addDefaultAttributesWithoutSync(string, Arrays.asList(stringArray), false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List addDefaultAttributesWithoutSync(String string, Collection collection, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        Object object3;
        List list;
        if (DomNodeAttributes.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addDefaultAttributesWithoutSync(String,Collection<String>,boolean,boolean)", 325).addDetail("tagName", string)).addDetail("attributesToAdd", (Object)collection)).addDetail("clearBeforeAdd", bl2)).addDetail("initial", bl3)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        if (collection == null) {
            throw new IllegalArgumentException("attributesToAdd is marked non-null but is null");
        }
        string = string.toUpperCase();
        List list2 = list = bl3 ? (List)collection : new LinkedList();
        if (!bl3) {
            object3 = (Set)DEFAULT_ATTRIBUTES.get("<QF_ALL>");
            object2 = collection.iterator();
            while (object2.hasNext()) {
                boolean bl4;
                object = (String)object2.next();
                boolean bl5 = DEFAULT_ATTRIBUTES_BLACKLIST.contains(object);
                boolean bl6 = bl4 = object3 != null && object3.contains(object);
                if (bl5 || bl4) continue;
                list.add(object);
            }
            if (list.size() == 0) {
                return list;
            }
        }
        object3 = DEFAULT_ATTRIBUTES_MONITOR;
        synchronized (object3) {
            Object object4 = object2 = bl2 ? null : (Set)DEFAULT_ATTRIBUTES.get(string);
            if (object2 == null) {
                object2 = new HashSet();
                DEFAULT_ATTRIBUTES.put(string, object2);
            }
            object = list.listIterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                if (!bl3 && object2.contains(string2)) {
                    object.remove();
                    continue;
                }
                object2.add(string2);
                DomNodeAttributes.extendBaseAttributes(string, string2);
            }
        }
        return list;
    }

    public static void setDefaultAttributes(String string, String ... stringArray) {
        if (string == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("attributesToSet is marked non-null but is null");
        }
        DomNodeAttributes.initDefaultAttributes(string, stringArray);
        DomNodeAttributes.synchronizeDefaultAttributes();
    }

    public static void setDefaultAttributes(String string, Collection collection) {
        if (string == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        if (collection == null) {
            throw new IllegalArgumentException("attributesToSet is marked non-null but is null");
        }
        DomNodeAttributes.addDefaultAttributesWithoutSync(string, collection, true, false);
        DomNodeAttributes.synchronizeDefaultAttributes();
    }

    public static void setDefaultAttributes(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("attributesToSet is marked non-null but is null");
        }
        for (Map.Entry entry : map.entrySet()) {
            DomNodeAttributes.addDefaultAttributesWithoutSync((String)entry.getKey(), (Collection)entry.getValue(), true, false);
        }
        DomNodeAttributes.synchronizeDefaultAttributes();
    }

    protected static void initDefaultAttributes(String string, String ... stringArray) {
        if (string == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("attributesToSet is marked non-null but is null");
        }
        DomNodeAttributes.addDefaultAttributesWithoutSync(string, Arrays.asList(stringArray), true, false);
    }

    public static void synchronizeDefaultAttributes() {
        Engine[] engineArray;
        if (DomNodeAttributes.logger.level >= 7) {
            logger.lvlBuild(7, "synchronizeDefaultAttributes()", 417).log();
        }
        for (Engine engine : engineArray = Engine.getAllEngines()) {
            if (!(engine instanceof WebEngine)) continue;
            ((WebEngine)engine).synchronizeDefaultAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetDefaultAttributes() {
        if (DomNodeAttributes.logger.level >= 7) {
            logger.lvlBuild(7, "resetDefaultAttributes()", 434).log();
        }
        Object object = DEFAULT_ATTRIBUTES_MONITOR;
        synchronized (object) {
            DEFAULT_ATTRIBUTES = (HashMap)INITIAL_DEFAULT_ATTRIBUTES.clone();
            baseAttributes = (HashMap)initialBaseAttributes.clone();
            baseAttributesWithPseudoAttributes = (HashMap)initialBaseAttributesWithPseudoAttributes.clone();
        }
        DomNodeAttributes.synchronizeDefaultAttributes();
    }

    public static boolean removeDefaultAttributes(String string, String ... stringArray) {
        if (string == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("attributesToRemove is marked non-null but is null");
        }
        List list = DomNodeAttributes.removeDefaultAttributesWithoutSync(string, Arrays.asList(stringArray));
        if (list.size() == 0) {
            return false;
        }
        DomNodeAttributes.synchronizeDefaultAttributes();
        return true;
    }

    protected static List removeDefaultAttributesWithoutSync(String string, String ... stringArray) {
        if (string == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("attributesToRemove is marked non-null but is null");
        }
        return DomNodeAttributes.removeDefaultAttributesWithoutSync(string, Arrays.asList(stringArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List removeDefaultAttributesWithoutSync(String string, Collection collection) {
        if (DomNodeAttributes.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "removeDefaultAttributesWithoutSync(String,Collection<String>)", 480).addDetail("tagName", string)).addDetail("attributesToRemove", (Object)collection)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        if (collection == null) {
            throw new IllegalArgumentException("attributesToRemove is marked non-null but is null");
        }
        string = string.toUpperCase();
        LinkedList<String> linkedList = new LinkedList<String>();
        Object object = DEFAULT_ATTRIBUTES_MONITOR;
        synchronized (object) {
            Set set = (Set)DEFAULT_ATTRIBUTES.get(string);
            if (set == null) {
                return linkedList;
            }
            for (String string2 : collection) {
                HashMap hashMap;
                if (set.contains(string2)) {
                    set.remove(string2);
                    linkedList.add(string2);
                }
                if ((hashMap = (HashMap)baseAttributes.get(string)) != null) {
                    hashMap.remove(string2);
                }
                if ((hashMap = (HashMap)baseAttributesWithPseudoAttributes.get(string)) == null) continue;
                hashMap.remove(string2);
            }
            if (set.size() == 0) {
                DEFAULT_ATTRIBUTES.remove(string);
            }
        }
        return linkedList;
    }

    protected static void extendBaseAttributes(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("attribute is marked non-null but is null");
        }
        DomNodeAttributes.extendBaseAttributes(baseAttributesWithPseudoAttributes, string, string2);
        if (DomNodeAttributes.getPseudoAttribute(string, string2) != null) {
            return;
        }
        DomNodeAttributes.extendBaseAttributes(baseAttributes, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void extendBaseAttributes(HashMap hashMap, String string, String string2) {
        if (hashMap == null) {
            throw new IllegalArgumentException("baseAttributes is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("attribute is marked non-null but is null");
        }
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            HashMap hashMap3 = (HashMap)hashMap.get(string);
            if (hashMap3 == null) {
                hashMap3 = (HashMap)((HashMap)hashMap.get("<QF_ALL>")).clone();
                hashMap.put(string, hashMap3);
            }
            if (DomNode.canCacheAttribute(string, string2)) {
                hashMap3.put(string2, ATTR_VALUE_NULL);
            }
            if ("<QF_ALL>".equals(string)) {
                for (String string3 : hashMap.keySet()) {
                    if ("<QF_ALL>".equals(string3)) continue;
                    DomNodeAttributes.extendBaseAttributes(hashMap, string3, string2);
                }
            }
        }
    }

    public static final String getPseudoAttributesAsJSString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        boolean bl2 = true;
        for (Map.Entry entry : pseudoAttributes.entrySet()) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(",");
            }
            Map map = (Map)entry.getValue();
            if (map.isEmpty()) continue;
            stringBuilder.append(Json.value((String)((String)entry.getKey()))).append(":{");
            boolean bl3 = true;
            for (Map.Entry entry2 : map.entrySet()) {
                if (bl3) {
                    bl3 = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(Json.value((String)((String)entry2.getKey()))).append(":");
                stringBuilder.append(((PseudoAttribute)entry2.getValue()).getJsDefinition());
            }
            stringBuilder.append("}");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static final String getPseudoAttributeNamesAsJSONString(boolean bl2) {
        boolean bl3 = false;
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry entry : pseudoAttributes.entrySet()) {
            Map map = (Map)entry.getValue();
            if (map.size() <= 0) continue;
            JsonArray jsonArray = new JsonArray();
            for (Map.Entry entry2 : map.entrySet()) {
                if (!bl2 && ((PseudoAttribute)entry2.getValue()).cachable) continue;
                jsonArray.add((String)entry2.getKey());
            }
            if (jsonArray.isEmpty()) continue;
            String string = (String)entry.getKey();
            jsonObject.add(string, (JsonValue)jsonArray);
            bl3 = true;
        }
        return (bl3 ? jsonObject : Json.NULL).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void registerPseudoAttributes(String string, PseudoAttribute ... pseudoAttributeArray) {
        if (DomNodeAttributes.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "registerPseudoAttributes(String,PseudoAttribute[])", 630).addDetail("tagName", string)).addDetail("attributes", (Object)pseudoAttributeArray)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        string = string.toUpperCase();
        HashSet<Object> hashSet = new HashSet<Object>();
        if ("<QF_ALL>".equals(string)) {
            hashSet.addAll(DEFAULT_ATTRIBUTES.keySet());
        } else {
            hashSet.add(string);
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        for (String hashMap : hashSet) {
            PseudoAttribute[] pseudoAttributeArray2 = DomNodeAttributes.unregisterPseudoAttributesWithoutSync(hashMap, pseudoAttributeArray);
            hashSet2.addAll((Collection<String>)pseudoAttributeArray2);
        }
        Map map = pseudoAttributes;
        synchronized (map) {
            Map map2 = (Map)pseudoAttributes.get(string);
            if (map2 == null) {
                HashMap hashMap = new HashMap();
                pseudoAttributes.put(string, hashMap);
            }
            for (PseudoAttribute pseudoAttribute : pseudoAttributeArray) {
                void var6_9;
                String string2 = pseudoAttribute.getName();
                var6_9.put(string2, pseudoAttribute);
                hashSet3.add(string2);
                if (pseudoAttribute.isCachable()) {
                    DomNodeAttributes.addDefaultAttributesWithoutSync(string, string2);
                    hashSet2.add(string2);
                    continue;
                }
                DomNode.a(string, string2);
            }
        }
        DomNodeAttributes.removeValuesFromAttributeCache(hashSet3);
        DomNodeAttributes.synchronizePseudoAttributes();
        if (hashSet2.size() > 0) {
            DomNodeAttributes.synchronizeDefaultAttributes();
        }
    }

    public static void synchronizePseudoAttributes() {
        Engine[] engineArray;
        if (DomNodeAttributes.logger.level >= 7) {
            logger.lvlBuild(7, "synchronizePseudoAttributes()", 686).log();
        }
        for (Engine engine : engineArray = Engine.getAllEngines()) {
            if (!(engine instanceof WebEngine)) continue;
            ((WebEngine)engine).synchronizePseudoAttributes();
        }
    }

    protected static Set unregisterPseudoAttributesWithoutSync(String string, PseudoAttribute ... pseudoAttributeArray) {
        if (DomNodeAttributes.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "unregisterPseudoAttributesWithoutSync(String,PseudoAttribute[])", 704).addDetail("tagName", string)).addDetail("attributes", (Object)pseudoAttributeArray)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < pseudoAttributeArray.length; ++i2) {
            hashSet.add(pseudoAttributeArray[i2].getName());
        }
        return DomNodeAttributes.unregisterPseudoAttributesWithoutSync(string, hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Set unregisterPseudoAttributesWithoutSync(String string, Set set) {
        if (DomNodeAttributes.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "unregisterPseudoAttributesWithoutSync(String,Set<String>)", 723).addDetail("tagName", string)).addDetail("attributeNames", (Object)set)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        string = string.toUpperCase();
        HashSet<String> hashSet = new HashSet<String>();
        Map map = pseudoAttributes;
        synchronized (map) {
            Map map2 = (Map)pseudoAttributes.get(string);
            for (String string2 : set) {
                PseudoAttribute pseudoAttribute;
                List list = DomNodeAttributes.removeDefaultAttributesWithoutSync(string, string2);
                hashSet.addAll(list);
                if (map2 == null || map2.size() == 0 || (pseudoAttribute = (PseudoAttribute)map2.remove(string2)) == null) continue;
                if (pseudoAttribute.isCachable()) {
                    hashSet.add(string2);
                } else {
                    DomNode.b(string, string2);
                }
                if (map2.size() != 0) continue;
                pseudoAttributes.remove(string);
                break;
            }
        }
        return hashSet;
    }

    public static void removeValuesFromAttributeCache(Set set) {
        if (DomNodeAttributes.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeValuesFromAttributeCache(Set<String>)", 766).addDetail("attributeNames", (Object)set)).log();
        }
        if (set.size() == 0) {
            return;
        }
        HashMap hashMap = DomNode.b;
        for (DocumentNode documentNode : DocumentNode.a.values()) {
            for (Node node : documentNode.e.values()) {
                if (!(node instanceof DomNode)) continue;
                for (String string : set) {
                    ((DomNode)node).d.remove(string);
                    if (hashMap == null) continue;
                    Pair pair = new Pair((Object)node, (Object)string);
                    hashMap.remove(pair);
                }
            }
        }
    }

    public static void unregisterPseudoAttributes(String string, String ... stringArray) {
        if (string == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        Set set = Misc.setOf((Object[])stringArray);
        Set set2 = DomNodeAttributes.unregisterPseudoAttributesWithoutSync(string, set);
        DomNodeAttributes.synchronizePseudoAttributes();
        DomNodeAttributes.removeValuesFromAttributeCache(set);
        if (set2.size() > 0) {
            DomNodeAttributes.synchronizeDefaultAttributes();
        }
    }

    public static PseudoAttribute getPseudoAttribute(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        PseudoAttribute pseudoAttribute = DomNodeAttributes.getPseudoAttributeForTag(string, string2);
        if (DomNodeAttributes.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getPseudoAttribute(String,String)", 812).add("attr", (Object)pseudoAttribute)).log();
        }
        if (pseudoAttribute == null) {
            pseudoAttribute = DomNodeAttributes.getPseudoAttributeForTag("<QF_ALL>", string2);
        }
        return pseudoAttribute;
    }

    private static PseudoAttribute getPseudoAttributeForTag(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        Map map = (Map)pseudoAttributes.get(string);
        if (map == null) {
            return null;
        }
        return (PseudoAttribute)map.get(string2);
    }

    public static HashMap getBaseAttributes() {
        return baseAttributes;
    }

    public static HashMap getBaseAttributesWithPseudoAttributes() {
        return baseAttributesWithPseudoAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        if ("ie".equals(System.getProperty("qftest.browser"))) {
            DEFAULT_ATTRIBUTES_BLACKLIST.add("style");
        }
        if ("qfdriver".equals(System.getProperty("qftest.connectionMode"))) {
            DEFAULT_ATTRIBUTES_BLACKLIST.add("checked");
            DEFAULT_ATTRIBUTES_BLACKLIST.add("index");
            DEFAULT_ATTRIBUTES_BLACKLIST.add("disabled");
            DEFAULT_ATTRIBUTES_BLACKLIST.add("value");
            DEFAULT_ATTRIBUTES_BLACKLIST.add("selectedIndex");
            DEFAULT_ATTRIBUTES_BLACKLIST.add("selected");
            DEFAULT_ATTRIBUTES_BLACKLIST.add("multiple");
        }
        baseAttributes = new HashMap();
        baseAttributesWithPseudoAttributes = new HashMap();
        baseAttributes.put("<QF_ALL>", new LinkedHashMap());
        baseAttributesWithPseudoAttributes.put("<QF_ALL>", new LinkedHashMap());
        Object object = DEFAULT_ATTRIBUTES_MONITOR;
        synchronized (object) {
            HashMap hashMap = baseAttributes;
            synchronized (hashMap) {
                HashMap hashMap2 = baseAttributesWithPseudoAttributes;
                synchronized (hashMap2) {
                    DomNodeAttributes.initDefaultAttributes("<QF_ALL>", "class", "id", "lang", "style", "title", "role");
                    DomNodeAttributes.initDefaultAttributes("A", "href", "name", "type");
                    DomNodeAttributes.initDefaultAttributes("BUTTON", "disabled", "name", "type", "value");
                    DomNodeAttributes.initDefaultAttributes("CANVAS", "height", "width");
                    DomNodeAttributes.initDefaultAttributes("DATA", "value");
                    DomNodeAttributes.initDefaultAttributes("DATALIST", "name");
                    DomNodeAttributes.initDefaultAttributes("EMBED", "height", "src", "type", "width");
                    DomNodeAttributes.initDefaultAttributes("FIELDSET", "disabled", "name");
                    DomNodeAttributes.initDefaultAttributes("FORM", "name");
                    DomNodeAttributes.initDefaultAttributes("FRAME", "name", "src");
                    DomNodeAttributes.initDefaultAttributes("IFRAME", "height", "name", "src", "width");
                    DomNodeAttributes.initDefaultAttributes("IMG", "alt", "height", "name", "src", "width");
                    DomNodeAttributes.initDefaultAttributes("INPUT", "multiple", "size", "disabled", "height", "name", "src", "type", "value", "width", "placeholder");
                    DomNodeAttributes.initDefaultAttributes("LABEL", "name", "for");
                    DomNodeAttributes.initDefaultAttributes("LI", "type", "value");
                    DomNodeAttributes.initDefaultAttributes("MENU", "label", "type");
                    DomNodeAttributes.initDefaultAttributes("MENUITEM", "label", "disabled", "type");
                    DomNodeAttributes.initDefaultAttributes("METER", "value");
                    DomNodeAttributes.initDefaultAttributes("OL", "type");
                    DomNodeAttributes.initDefaultAttributes("OPTGROUP", "label", "disabled");
                    DomNodeAttributes.initDefaultAttributes("OPTION", "label", "disabled", "value");
                    DomNodeAttributes.initDefaultAttributes("OUTPUT", "for", "name");
                    DomNodeAttributes.initDefaultAttributes("PROGRESS", "value");
                    DomNodeAttributes.initDefaultAttributes("SELECT", "size", "disabled", "name");
                    DomNodeAttributes.initDefaultAttributes("SLOT", "name");
                    DomNodeAttributes.initDefaultAttributes("TEXTAREA", "disabled", "name");
                    DomNodeAttributes.initDefaultAttributes("TD", "rowspan", "colspan");
                    DomNodeAttributes.initDefaultAttributes("TH", "rowspan", "colspan");
                    DomNodeAttributes.initDefaultAttributes("UL", "type");
                    DomNodeAttributes.initDefaultAttributes("#TEXT", "value");
                }
            }
        }
        initialBaseAttributes = (HashMap)baseAttributes.clone();
        initialBaseAttributesWithPseudoAttributes = (HashMap)baseAttributesWithPseudoAttributes.clone();
        INITIAL_DEFAULT_ATTRIBUTES = (HashMap)DEFAULT_ATTRIBUTES.clone();
    }
}

