/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.web.dom;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.ElementDestroyedException;
import de.qfs.apps.qftest.client.InvalidThreadException;
import de.qfs.apps.qftest.client.web.Browser;
import de.qfs.apps.qftest.client.web.WebEngine;
import de.qfs.apps.qftest.client.web.WebHelper;
import de.qfs.apps.qftest.client.web.dom.DocumentNode;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.c;
import de.qfs.apps.qftest.client.web.dom.q;
import de.qfs.apps.qftest.extensions.ResolverRegistry;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.resolvers.a;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.OptionListener;
import de.qfs.lib.tree.TraversalCallback;
import de.qfs.lib.tree.TreeAdapter;
import de.qfs.lib.tree.TreeUtil;
import de.qfs.lib.util.Misc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class Node {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.web.dom.Node");
    public static final Node[] NO_NODES = new Node[0];
    protected static final c o = new c();
    private static boolean b = Client.instance().getOptions().getBoolean("WebCheckDispatchThread", false);
    private static boolean c = Client.instance().getOptions().getBoolean("WebCheckDestroyedNodes", false);
    private static OptionListener d = optionSet -> {
        b = optionSet.getBoolean("WebCheckDispatchThread", false);
        c = optionSet.getBoolean("WebCheckDestroyedNodes", false);
    };
    public static boolean trustCache;
    public static int logCacheErrorLevel;
    public static boolean forceCache;
    protected long p;
    protected boolean q;
    protected String r;
    protected String s;
    protected String t;
    private String e;
    private String[] f;
    private String[] g;
    private String[] h;
    protected String[] u;

    protected Node() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "Node()", 175).log();
        }
    }

    protected Node(long l2) {
        if (Node.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "Node(long)", 187).addDetail("handle", l2)).log();
        }
        this.p = l2;
    }

    public final long getHandle() {
        return this.p;
    }

    public final String getHandleHex() {
        return "0x" + Long.toHexString(this.p);
    }

    public abstract DomNode getByXPath(String var1);

    public abstract Node getParent();

    public Node getLogicalParent() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getLogicalParent()", 251).log();
        }
        return this.getParent();
    }

    public Node getPhysicalParent() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getPhysicalParent()", 265).log();
        }
        return this.getParent();
    }

    public Node getLegacyParent() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getLegacyParent()", 279).log();
        }
        return this.getParent();
    }

    public Node getInterestingParent() {
        Object object = this.getHelper().getInterestingParent((Object)this, null);
        if (object != null && object instanceof Node) {
            return (Node)object;
        }
        return null;
    }

    public Node getInterestingParent(int n2) {
        Object object = this.getHelper().getInterestingParent((Object)this, n2);
        if (object != null && object instanceof Node) {
            return (Node)object;
        }
        return null;
    }

    public Node getNthParent(int n2) {
        if (n2 <= 0) {
            return this;
        }
        Node node = this;
        for (int n3 = 1; n3 <= n2 && node != null; node = node.getParent(), ++n3) {
        }
        return node;
    }

    public abstract int getChildCount();

    public int getLogicalChildCount() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getLogicalChildCount()", 363).log();
        }
        return this.getChildCount();
    }

    public int getPhysicalChildCount() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getPhysicalChildCount()", 376).log();
        }
        return this.getChildCount();
    }

    public int getLegacyChildCount() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getLegacyChildCount()", 388).log();
        }
        return this.getChildCount();
    }

    public abstract Node getChild(int var1);

    public Node getLogicalChild(int n2) {
        if (Node.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getLogicalChild(int)", 415).addDetail("index", n2)).log();
        }
        return this.getChild(n2);
    }

    public Node getPhysicalChild(int n2) {
        if (Node.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getPhysicalChild(int)", 430).addDetail("index", n2)).log();
        }
        return this.getChild(n2);
    }

    public Node getLegacyChild(int n2) {
        if (Node.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getLegacyChild(int)", 445).addDetail("index", n2)).log();
        }
        return this.getChild(n2);
    }

    public Node[] getChildren() {
        switch (this.getEngine().defaultDomTraversalStrategy) {
            default: {
                return this.getLogicalChildren();
            }
            case b: {
                return this.getPhysicalChildren();
            }
            case c: 
        }
        return this.getLegacyChildren();
    }

    public Node[] getLogicalChildren() {
        this.checkDispatch("Node.getLogicalChildren");
        Node[] nodeArray = new Node[this.getLogicalChildCount()];
        for (int i2 = 0; i2 < nodeArray.length; ++i2) {
            nodeArray[i2] = this.getLogicalChild(i2);
        }
        return nodeArray;
    }

    public Node[] getPhysicalChildren() {
        this.checkDispatch("Node.getPhysicalChildren");
        Node[] nodeArray = new Node[this.getPhysicalChildCount()];
        for (int i2 = 0; i2 < nodeArray.length; ++i2) {
            nodeArray[i2] = this.getPhysicalChild(i2);
        }
        return nodeArray;
    }

    public Node[] getLegacyChildren() {
        this.checkDispatch("Node.getLegacyChildren");
        Node[] nodeArray = new Node[this.getLegacyChildCount()];
        for (int i2 = 0; i2 < nodeArray.length; ++i2) {
            nodeArray[i2] = this.getLegacyChild(i2);
        }
        return nodeArray;
    }

    public int getIndexOfChild(Node node) {
        this.checkDispatch("Node.getIndexOfChild");
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!node.equals(this.getChild(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int getIndexOfLogicalChild(Node node) {
        return this.getIndexOfChild(node);
    }

    public int getIndexOfPhysicalChild(Node node) {
        return this.getIndexOfChild(node);
    }

    public int getIndexOfLegacyChild(Node node) {
        return this.getIndexOfChild(node);
    }

    public Node getFirstChild() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getFirstChild()", 615).log();
        }
        if (this.getChildCount() == 0) {
            return null;
        }
        return this.getChild(0);
    }

    public Node getFirstElementChild() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getFirstElementChild()", 629).log();
        }
        if (this.getChildCount() == 0) {
            return null;
        }
        Node node = this.getChild(0);
        if (node.isTextNode() || node.isCommentNode()) {
            node = node.getNextElementSibling();
        }
        return node;
    }

    public Node getPreviousElementSibling() {
        Node node;
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getPreviousElementSibling()", 648).log();
        }
        for (node = this.getPreviousSibling(); node != null && (node.isTextNode() || node.isCommentNode()); node = node.getPreviousSibling()) {
        }
        return node;
    }

    public Node getPreviousSibling() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getPreviousSibling()", 663).log();
        }
        Node node = this.getParent();
        if (Node.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getPreviousSibling()", 665).add("parent", (Object)node)).log();
        }
        if (node == null) {
            return null;
        }
        int n2 = node.getIndexOfChild(this);
        if (Node.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getPreviousSibling()", 668).add("ownIndex", n2)).log();
        }
        if (n2 == 0) {
            return null;
        }
        Node node2 = node.getChild(n2 - 1);
        return node2;
    }

    public Node getNextElementSibling() {
        Node node;
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getNextElementSibling()", 681).log();
        }
        for (node = this.getNextSibling(); node != null && (node.isTextNode() || node.isCommentNode()); node = node.getNextSibling()) {
        }
        return node;
    }

    public Node getNextSibling() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getNextSibling()", 696).log();
        }
        Node node = this.getParent();
        if (Node.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getNextSibling()", 698).add("parent", (Object)node)).log();
        }
        if (node == null) {
            return null;
        }
        int n2 = node.getIndexOfChild(this);
        if (Node.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getNextSibling()", 701).add("ownIndex", n2)).log();
        }
        try {
            Node node2 = node.getChild(n2 + 1);
            return node2;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
            return null;
        }
    }

    public abstract DocumentNode getDocument();

    public Node getElementById(String string) {
        return null;
    }

    public Node[] getElementsById(String string) {
        return NO_NODES;
    }

    public Node[] getElementsByIdAttribute(String string) {
        return NO_NODES;
    }

    public Node[] getElementsByTagName(String string) {
        return NO_NODES;
    }

    public String getXPath() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getXPath()", 788).log();
        }
        return this.b().toString();
    }

    protected StringBuilder b() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getXPathBuilder()", 795).log();
        }
        return new StringBuilder();
    }

    public Node[] getElementsByIdAndTagname(String string, String string2) {
        return NO_NODES;
    }

    public Node[] getElementsByClassName(String string) {
        return this.getElementsByClassName(new String[]{string});
    }

    public Node[] getElementsByClassName(String string, String string2) {
        return this.getElementsByClassName(new String[]{string}, new String[]{string2});
    }

    public Node[] getElementsByClassName(String[] stringArray) {
        return NO_NODES;
    }

    public Node[] getElementsByClassName(String[] stringArray, String[] stringArray2) {
        return NO_NODES;
    }

    public Node getAncestorOfClass(String string) {
        this.checkDispatch("Node.getAncestorOfClass");
        for (Node node = this.getParent(); node != null; node = node.getParent()) {
            if (!node.isMatchingClass(string)) continue;
            return node;
        }
        return null;
    }

    public Node getAncestorOfClass(String string, int n2) {
        this.checkDispatch("Node.getAncestorOfClass(String,int)");
        Object object = this.getHelper().getAncestorOfClass((Object)this, string, n2);
        if (object != null && object instanceof Node) {
            return (Node)object;
        }
        return null;
    }

    public Node getAncestorOfClass(String[] stringArray) {
        if (Node.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getAncestorOfClass(String[])", 945).addDetail("classes", (Object)stringArray)).log();
        }
        this.checkDispatch("Node.getAncestorOfClass");
        for (Node node = this.getParent(); node != null; node = node.getParent()) {
            if (!node.isMatchingClass(stringArray)) continue;
            return node;
        }
        return null;
    }

    public List getSiblingsOfClass(String string) {
        this.checkDispatch("Node.getSiblingsOfClass");
        return this.getSiblingsOfClass(new String[]{string});
    }

    public List getSiblingElementsOfClass(String string, int n2, int n3) {
        this.checkDispatch("Node.getSiblingElementsOfClass(String,int,int)");
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Node node2 = this.getParent();
        if (node2 == null) {
            return arrayList;
        }
        List list = Arrays.stream(node2.getChildren()).filter(node -> node.getName() != null && !node.getName().startsWith("#")).collect(Collectors.toList());
        int n4 = list.size() - 1;
        int n5 = Math.max(0, Math.min(n4, list.indexOf(this)));
        List list2 = Misc.listOf((Object[])new Integer[]{1, -1});
        for (int i2 = 1; i2 <= n3; ++i2) {
            if (n5 + i2 > n4) {
                list2.remove((Object)1);
            }
            if (n5 - i2 < 0) {
                list2.remove((Object)-1);
            }
            if (list2.isEmpty()) break;
            for (Integer n6 : list2) {
                boolean bl2;
                int n7 = n5 + i2 * n6;
                Node node3 = (Node)list.get(n7);
                if (node3 == null || !(bl2 = node3.isMatchingClass(string))) continue;
                arrayList.add(node3);
                if (arrayList.size() < n2) continue;
                return arrayList;
            }
        }
        return arrayList;
    }

    public List getSiblingElementsOfClass(String string, int n2) {
        this.checkDispatch("Node.getSiblingsOfClass(String,int)");
        return this.getSiblingElementsOfClass(string, Integer.MAX_VALUE, n2);
    }

    public Node getFirstElementSiblingOfClass(String string, int n2) {
        this.checkDispatch("Node.getFirstElementSiblingOfClass(String,int)");
        List list = this.getSiblingElementsOfClass(string, 1, n2);
        return list.isEmpty() ? null : (Node)list.get(0);
    }

    public List getSiblingsOfClass(String[] stringArray) {
        if (Node.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getSiblingsOfClass(String[])", 1057).addDetail("classes", (Object)stringArray)).log();
        }
        this.checkDispatch("Node.getSiblingsOfClass");
        Node node2 = this.getParent();
        if (node2 == null) {
            return new ArrayList();
        }
        return Arrays.stream(node2.getChildren()).filter(node -> node != this).filter(node -> node.isMatchingClass(stringArray)).collect(Collectors.toList());
    }

    public static Node findCommonAncestor(Node node, Node node2, Node node3) {
        Node node4;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (node4 = node.getParent(); node4 != null; node4 = node4.getParent()) {
            arrayList.add(node4);
            if (node4 == node3) break;
        }
        for (node4 = node2.getParent(); node4 != null; node4 = node4.getParent()) {
            if (arrayList.contains(node4)) {
                return node4;
            }
            if (node4 == node3) break;
        }
        return null;
    }

    public boolean isAncestor(Node node) {
        this.checkDispatch("Node.isAncestor");
        for (Node node2 = this.getParent(); node2 != null; node2 = node2.getParent()) {
            if (node2 != node) continue;
            return true;
        }
        return false;
    }

    public abstract Browser getBrowser();

    public boolean isBrowserEdge() {
        Browser browser;
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "isBrowserEdge()", 1152).log();
        }
        if ((browser = this.getBrowser()) == null) {
            if (Node.a.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(1, "isBrowserEdge()", 1156).add("No browser for ")).add((Object)this)).log();
            }
            return false;
        }
        return browser.isEdge();
    }

    public boolean isBrowserIE() {
        Browser browser;
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "isBrowserIE()", 1170).log();
        }
        if ((browser = this.getBrowser()) == null) {
            if (Node.a.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(1, "isBrowserIE()", 1174).add("No browser for ")).add((Object)this)).log();
            }
            return false;
        }
        return browser.isIE();
    }

    public boolean isBrowserMozilla() {
        Browser browser;
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "isBrowserMozilla()", 1188).log();
        }
        if ((browser = this.getBrowser()) == null) {
            if (Node.a.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(1, "isBrowserMozilla()", 1192).add("No browser for ")).add((Object)this)).log();
            }
            return false;
        }
        return browser.isMozilla();
    }

    public boolean isBrowserChrome() {
        Browser browser;
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "isBrowserChrome()", 1206).log();
        }
        if ((browser = this.getBrowser()) == null) {
            if (Node.a.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(1, "isBrowserChrome()", 1210).add("No browser for ")).add((Object)this)).log();
            }
            return false;
        }
        return browser.isBlinkBrowser();
    }

    public boolean isBrowserSafari() {
        Browser browser;
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "isBrowserSafari()", 1224).log();
        }
        if ((browser = this.getBrowser()) == null) {
            if (Node.a.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(1, "isBrowserSafari()", 1228).add("No browser for ")).add((Object)this)).log();
            }
            return false;
        }
        return browser.isSafari();
    }

    public boolean isBrowserHeadless() {
        Browser browser;
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "isBrowserHeadless()", 1240).log();
        }
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "isBrowserHeadless()", 1242).log();
        }
        if ((browser = this.getBrowser()) == null) {
            if (Node.a.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(1, "isBrowserHeadless()", 1245).add("No browser for ")).add((Object)this)).log();
            }
            return false;
        }
        return browser.isHeadless();
    }

    public boolean canBrowserReceiveSemihardEvents() {
        Browser browser;
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "canBrowserReceiveSemihardEvents()", 1257).log();
        }
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "canBrowserReceiveSemihardEvents()", 1259).log();
        }
        if ((browser = this.getBrowser()) == null) {
            if (Node.a.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(1, "canBrowserReceiveSemihardEvents()", 1262).add("No browser for ")).add((Object)this)).log();
            }
            return false;
        }
        return browser.canReceiveSemihardEvents();
    }

    public boolean canBrowserReceiveHardEvents() {
        Browser browser;
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "canBrowserReceiveHardEvents()", 1274).log();
        }
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "canBrowserReceiveHardEvents()", 1276).log();
        }
        if ((browser = this.getBrowser()) == null) {
            if (Node.a.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(1, "canBrowserReceiveHardEvents()", 1279).add("No browser for ")).add((Object)this)).log();
            }
            return false;
        }
        return browser.canReceiveHardEvents();
    }

    public abstract String getNodeType();

    public String getAttribute(String string) {
        return null;
    }

    public String getAttributeIfSpecified(String string) {
        return null;
    }

    public boolean isAttributeSpecified(String string) {
        return this.getAttributeIfSpecified(string) != null;
    }

    public String getName() {
        if (this.r == null) {
            this.r = this.getTagName();
        }
        return this.r;
    }

    public boolean isTextNode() {
        return false;
    }

    public boolean isCommentNode() {
        return false;
    }

    public String getText() {
        return this.getText(false);
    }

    protected String a(boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (Node.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getTextOfNode(boolean,boolean,boolean,boolean)", 1409).addDetail("flat", bl2)).addDetail("simple", bl3)).addDetail("visibleOnly", bl4)).addDetail("includeFields", bl5)).log();
        }
        q q2 = new q(bl2, bl3, bl4, bl5);
        q2.a(this.g != null);
        TreeUtil.traverse((TreeAdapter)de.qfs.apps.qftest.client.web.dom.c.a(), (Object)this, (TraversalCallback)q2);
        return q2.a();
    }

    public String getText(boolean bl2) {
        this.checkDispatch("Node.getText");
        return this.a(false, false, false, bl2);
    }

    public String getVisibleText() {
        this.checkDispatch("Node.getVisibleText");
        return this.a(false, false, true, false);
    }

    public String getVisibleText(boolean bl2) {
        this.checkDispatch("Node.getVisibleText");
        return this.a(false, false, true, bl2);
    }

    public String getFlatText() {
        this.checkDispatch("Node.getFlatText");
        return this.a(true, false, false, false);
    }

    public String getVisibleFlatText() {
        this.checkDispatch("Node.getVisibleFlatText");
        return this.a(true, false, true, false);
    }

    public String getSimpleText() {
        this.checkDispatch("Node.getSimpleText");
        return this.a(false, true, false, false);
    }

    public String getVisibleSimpleText() {
        this.checkDispatch("Node.getVisibleSimpleText");
        return this.a(false, true, true, false);
    }

    protected abstract String getTagName();

    public boolean isNoFurtherResolvingRequired() {
        if (this.getProperty("qfs:resolvingnodeinprogress") != null) {
            if (Node.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "isNoFurtherResolvingRequired()", 1564).add("Node is about to get class-resolved recursively, skipping", (Object)this)).log();
            }
            return true;
        }
        String string = this.getDefaultClassName();
        return this.isTextNode() || "SCRIPT".equals(string) || this.isCommentNode() || "JSCRIPT".equals(string);
    }

    public String getClassName() {
        int n2;
        int n3;
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getClassName()", 1582).log();
        }
        if (this.t != null) {
            return this.t;
        }
        this.checkDispatch("Node.getClassName");
        String string = this.getDefaultClassName();
        if (Node.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getClassName()", 1592).add("Default name", string)).log();
        }
        if (this.isNoFurtherResolvingRequired()) {
            if (Node.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getClassName()", 1596).add("Text and script nodes should walk through resolving mechanism -> leave.")).log();
            }
            this.t = string;
            this.u = new String[]{this.t, this.getNodeType()};
            this.f = this.u;
            return this.t;
        }
        Object object = this.getProperty("qfs:class");
        if (object instanceof String) {
            this.t = (String)object;
        }
        if (Misc.emptyOrNull((String)this.t)) {
            if (this.isNoFurtherResolvingRequired()) {
                this.t = string;
            } else {
                String[] stringArray;
                n3 = string.indexOf(":");
                if (n3 < 0 || n3 == string.length() - 1) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = string;
                    stringArray = stringArray2;
                    stringArray2[1] = this.getNodeType();
                } else {
                    String[] stringArray3 = new String[3];
                    stringArray3[0] = string;
                    stringArray3[1] = string.substring(0, n3);
                    stringArray = stringArray3;
                    stringArray3[2] = this.getNodeType();
                }
                String[] stringArray4 = stringArray;
                this.t = ResolverRegistry.instance().getClassName(this, stringArray4, string);
            }
        }
        if (Node.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getClassName()", 1620).add("cachedClassName", this.t)).log();
        }
        n3 = string.indexOf(":");
        if (this.t.equals(string)) {
            this.e = null;
            n2 = 0;
        } else {
            this.e = this.t;
            n2 = 1;
        }
        this.f = new String[n2 + 2 + (n3 > 0 ? 1 : 0)];
        if (n2 > 0) {
            this.f[0] = this.t;
        }
        this.f[n2] = string;
        if (n3 > 0) {
            this.f[n2 + 1] = string.substring(0, n3);
        }
        this.f[n2 + (n3 > 0 ? 2 : 1)] = this.getNodeType();
        if (Node.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getClassName()", 1641).add("mainClassNames", (Object)this.f)).log();
        }
        this.g = null;
        Object object2 = this.getProperty("qfs:genericclass");
        if (!(object2 instanceof String) || Misc.emptyOrNull((String)((String)object2))) {
            object2 = ResolverRegistry.instance().getGenericClassName(this, this.f, null);
        }
        if (Node.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getClassName()", 1654).add("gclass", object2)).log();
        }
        if (object2 instanceof String && !Misc.emptyOrNull((String)((String)object2))) {
            this.g = de.qfs.apps.qftest.shared.resolvers.a.b((String)((String)object2));
            this.setProperty("qfs:genericclass", de.qfs.apps.qftest.shared.resolvers.a.a((String[])this.g));
            this.a();
            if (Node.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getClassName()", 1662).add("genericClassNames", (Object)this.g)).log();
            }
        }
        this.h = null;
        Object object3 = this.getProperty("qfs:fallbackclass");
        if (!(object3 instanceof String) || Misc.emptyOrNull((String)((String)object3))) {
            String[] stringArray = this.f;
            if (this.g != null) {
                this.c();
                stringArray = this.u;
            }
            object3 = ResolverRegistry.instance().getFallbackClassName(this, stringArray, null);
        }
        if (Node.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getClassName()", 1680).add("fbclass", object3)).log();
        }
        if (object3 != null) {
            this.h = ((String)object3).split("\\|");
            if (this.h.length == 0) {
                this.h = null;
            }
        }
        if (Node.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getClassName()", 1688).add("fallbackClassNames", (Object)this.h)).log();
        }
        this.c();
        return this.t;
    }

    public String getGenericClassName() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getGenericClassName()", 1702).log();
        }
        if (this.t == null) {
            this.getClassName();
        }
        return this.g == null ? null : this.g[0];
    }

    public String[] getGenericClassNames() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getGenericClassNames()", 1721).log();
        }
        if (this.t == null) {
            this.getClassName();
        }
        return this.g;
    }

    public String[] getFallbackClassNames() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getFallbackClassNames()", 1740).log();
        }
        if (this.t == null) {
            this.getClassName();
        }
        return this.h;
    }

    public String getDefaultClassName() {
        return this.getName();
    }

    public String[] getClassNames() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getClassNames()", 1774).log();
        }
        if (this.t == null) {
            this.getClassName();
        }
        return this.u;
    }

    public boolean hasCachedClassName() {
        return !Misc.emptyOrNull((String)this.t);
    }

    public boolean isMatchingClass(String string) {
        if (Node.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "isMatchingClass(String)", 1809).addDetail("className", string)).log();
        }
        for (String string2 : this.getClassNames()) {
            if (!string2.equals(string)) continue;
            if (Node.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "isMatchingClass(String)", 1815).add("classNames", (Object)this.getClassNames())).log();
            }
            return true;
        }
        return false;
    }

    public boolean isMatchingClass(String[] stringArray) {
        this.checkDispatch("Node.isMatchingClass");
        if (stringArray == null) {
            return false;
        }
        for (String string : stringArray) {
            if (!this.isMatchingClass(string)) continue;
            return true;
        }
        return false;
    }

    public String getWhichMatchingClass(String[] stringArray) {
        this.checkDispatch("Node.getWhichMatchingClass");
        if (stringArray == null) {
            return null;
        }
        for (String string : stringArray) {
            if (!this.isMatchingClass(string)) continue;
            return string;
        }
        return null;
    }

    protected boolean f() {
        return this.t != null;
    }

    private String[] a(String[] stringArray) {
        if (Node.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "addIntelligentClasses(String[])", 1898).addDetail("classes", (Object)stringArray)).log();
        }
        Map map = this.getHelper().getOrInitGenericToIntelligentMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
            if (!map.containsKey(stringArray[i2])) continue;
            arrayList.add((String)map.get(stringArray[i2]));
        }
        if (arrayList.size() > stringArray.length) {
            return arrayList.toArray(new String[0]);
        }
        return stringArray;
    }

    public void overrideGenericClassNames(String[] stringArray) {
        if (Node.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "overrideGenericClassNames(String[])", 1926).addDetail("names", (Object)stringArray)).log();
        }
        this.g = stringArray;
        this.a();
        this.c();
    }

    private void a() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "fixupGenericClassNames()", 1939).log();
        }
        if (this.g != null) {
            for (int i2 = 0; i2 < this.g.length; ++i2) {
                if (this.g[i2].length() != 0) continue;
                String[] stringArray = new String[this.g.length - 1];
                System.arraycopy(this.g, 0, stringArray, 0, i2);
                if (i2 < this.g.length - 1) {
                    System.arraycopy(this.g, i2 + 1, stringArray, i2, this.g.length - i2 - 1);
                }
                this.g = stringArray;
            }
            if (this.g.length == 0) {
                this.g = null;
            }
        }
        if (this.g != null) {
            this.g = this.a(this.g);
            if (Node.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "fixupGenericClassNames()", 1960).add("genericClassNames now", (Object)this.g)).log();
            }
        }
    }

    private void c() {
        int n2;
        int n3;
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "joinClassNames()", 1970).log();
        }
        boolean bl2 = false;
        boolean bl3 = true;
        int n4 = 0;
        if (this.g != null) {
            for (n3 = 0; n3 < this.g.length; ++n3) {
                if ("Component".matches(this.g[n3])) {
                    bl2 = true;
                }
                if (!"SmartComponent".matches(this.g[n3])) continue;
                bl3 = false;
            }
            if (bl3) {
                bl3 = false;
                for (String string : this.g) {
                    if (!Options.contains((String)Options.OPT_SMARTID_SMART_COMPONENT_CLASSES, (String)string)) continue;
                    bl3 = true;
                    break;
                }
            }
            n4 = (bl2 ? 0 : 1) + (bl3 ? 1 : 0);
        }
        n3 = this.g == null ? 0 : this.g.length;
        int n5 = this.h == null ? 0 : this.h.length;
        this.u = new String[this.f.length + n3 + n4 + n5];
        int n6 = n2 = this.e == null ? 0 : 1;
        if (this.e != null) {
            this.u[0] = this.e;
        }
        if (this.g != null) {
            System.arraycopy(this.g, 0, this.u, n2, n3);
            if (bl3) {
                this.u[n2 + n3] = "SmartComponent";
            }
            if (!bl2) {
                this.u[n2 + n3 + (bl3 ? 1 : 0)] = "Component";
            }
        }
        if (this.h != null) {
            System.arraycopy(this.h, 0, this.u, n2 + n3 + n4, this.h.length);
        }
        System.arraycopy(this.f, n2, this.u, n2 + n3 + n5 + n4, this.f.length - n2);
        if (Node.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "joinClassNames()", 2017).add("cachedClassNames", (Object)this.u)).log();
        }
    }

    public final boolean isDestroyed() {
        return this.q;
    }

    public final String getRegisteredName() {
        return this.s;
    }

    public final void setRegisteredName(String string) {
        if (Node.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setRegisteredName(String)", 2073).addDetail("registeredName", string)).log();
        }
        this.s = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String string) {
        if (Node.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getProperty(String)", 2092).addDetail("name", string)).log();
        }
        if (string == null) {
            return null;
        }
        DocumentNode documentNode = this.getDocument();
        if (documentNode == null) {
            return null;
        }
        DocumentNode documentNode2 = documentNode;
        synchronized (documentNode2) {
            Map map = documentNode.getPropertiesMap();
            Map map2 = (Map)map.get(this.p);
            if (map2 != null) {
                return map2.get(string);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getProperties() {
        DocumentNode documentNode;
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "getProperties()", 2123).log();
        }
        if ((documentNode = this.getDocument()) == null) {
            return null;
        }
        DocumentNode documentNode2 = documentNode;
        synchronized (documentNode2) {
            Map map = documentNode.getPropertiesMap();
            return (Map)map.get(this.p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String string, Object object) {
        if (Node.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "setProperty(String,Object)", 2147).addDetail("name", string)).addDetail("value", object)).log();
        }
        if (string == null) {
            return;
        }
        if (string == null) {
            return;
        }
        DocumentNode documentNode = this.getDocument();
        if (documentNode == null) {
            return;
        }
        DocumentNode documentNode2 = documentNode;
        synchronized (documentNode2) {
            Map map = documentNode.getPropertiesMap();
            HashMap<String, Object> hashMap = (HashMap<String, Object>)map.get(this.p);
            if (hashMap == null) {
                if (object == null) {
                    return;
                }
                hashMap = new HashMap<String, Object>(4);
                map.put(this.p, hashMap);
            }
            if (object == null) {
                hashMap.remove(string);
            } else {
                hashMap.put(string, object);
            }
        }
    }

    public int hashCode() {
        return (int)this.p;
    }

    public int objectHashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof Node && this.p == ((Node)object).p;
    }

    public void checkDispatch() {
        if (b && !this.getEngine().isEventDispatchThread()) {
            throw new InvalidThreadException("Method may only be called from the event dispatch thread");
        }
        if (c && this.q) {
            throw new ElementDestroyedException(this);
        }
    }

    public void checkDispatch(String string) {
        if (b && !this.getEngine().isEventDispatchThread()) {
            throw new InvalidThreadException("The method " + string + " may only be called from the event dispatch thread.");
        }
        if (c && this.q) {
            throw new ElementDestroyedException(string + " - Illegal use of destroyed element: " + this);
        }
    }

    public void checkNonDispatch() {
        if (b && this.getEngine().isEventDispatchThread()) {
            throw new InvalidThreadException("Method must not be called from the event dispatch thread");
        }
    }

    public void checkNonDispatch(String string) {
        if (b && !this.getEngine().isEventDispatchThread()) {
            throw new InvalidThreadException("The method " + string + " must not be called from the event dispatch thread.");
        }
    }

    public abstract Object evalJS(String var1, @Nullable Map var2) throws TestException;

    public abstract Object evalJS(String var1) throws TestException;

    public abstract Object callJS(String var1, @Nullable Map var2) throws TestException;

    public abstract Object callJS(String var1) throws TestException;

    public final String XXXgetCachedClassName() {
        return this.t;
    }

    public final void clearCachedClassName() {
        if (Node.a.level >= 7) {
            a.lvlBuild(7, "clearCachedClassName()", 2399).log();
        }
        this.t = null;
    }

    public WebEngine getEngine() {
        return this.getDocument().c;
    }

    public WebHelper getHelper() {
        return this.getEngine().getHelper();
    }

    public void transferStableProperties(Node node) {
        if (Node.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "transferStableProperties(Node)", 2435).addDetail("srcNode", (Object)node)).log();
        }
    }

    static {
        Client.instance().addOptionListener(d);
        boolean bl2 = trustCache = !"false".equals(System.getProperty("qftest.web.trustcache")) && (System.getProperty("qftest.web.trustcache") != null || !"false".equals(Client.b.a("QFTEST_WEB_TRUSTCACHE")));
        if (Node.a.level >= 5) {
            ((LevelAwareLogBuilder)a.lvlBuild(5, "static", 99).add("trustCache", trustCache)).log();
        }
        logCacheErrorLevel = 1;
    }
}

