/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.web.items;

import de.qfs.apps.qftest.client.web.WebHelper;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.Node;
import de.qfs.apps.qftest.client.web.items.matcher.MultiLineListItemNameMatcher;
import de.qfs.apps.qftest.extensions.items.ItemNameMatcher2;
import de.qfs.apps.qftest.extensions.items.ItemParentResolver;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.extensions.items.ItemValueResolver;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;

public class ListItemResolver
implements ItemParentResolver,
ItemValueResolver {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.web.items.ListItemResolver");
    protected WebHelper helper;
    protected boolean excludeHiddenItems;
    protected String[] listClasses;
    protected String[] itemClasses;
    protected MultiLineListItemNameMatcher mli;

    public ListItemResolver(WebHelper webHelper) {
        this(webHelper, new String[]{"SELECT"}, new String[]{"OPTION"});
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "ListItemResolver(WebHelper)", 85).addDetail("helper", (Object)webHelper)).log();
        }
    }

    public ListItemResolver(WebHelper webHelper, String string, String string2) {
        this(webHelper, new String[]{string}, new String[]{string2});
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "ListItemResolver(WebHelper,String,String)", 100).addDetail("helper", (Object)webHelper)).addDetail("listClass", string)).addDetail("itemClass", string2)).log();
        }
    }

    public ListItemResolver(WebHelper webHelper, String[] stringArray, String[] stringArray2) {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "ListItemResolver(WebHelper,String[],String[])", 115).addDetail("helper", (Object)webHelper)).addDetail("listClasses", (Object)stringArray)).addDetail("itemClasses", (Object)stringArray2)).log();
        }
        this.helper = webHelper;
        this.listClasses = stringArray;
        this.itemClasses = stringArray2;
    }

    public static ListItemResolver createAndRegister(WebHelper webHelper) {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "createAndRegister(WebHelper)", 132).addDetail("helper", (Object)webHelper)).log();
        }
        return ListItemResolver.createAndRegister(webHelper, new String[]{"SELECT"}, new String[]{"OPTION"});
    }

    public static ListItemResolver createAndRegister(WebHelper webHelper, String string, String string2) {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createAndRegister(WebHelper,String,String)", 149).addDetail("helper", (Object)webHelper)).addDetail("listClass", string)).addDetail("itemClass", string2)).log();
        }
        return ListItemResolver.createAndRegister(webHelper, new String[]{string}, new String[]{string2});
    }

    public static ListItemResolver createAndRegister(WebHelper webHelper, String[] stringArray, String[] stringArray2) {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createAndRegister(WebHelper,String[],String[])", 167).addDetail("helper", (Object)webHelper)).addDetail("listClasses", (Object)stringArray)).addDetail("itemClasses", (Object)stringArray2)).log();
        }
        ListItemResolver listItemResolver = new ListItemResolver(webHelper, stringArray, stringArray2);
        listItemResolver.register();
        return listItemResolver;
    }

    public void register() {
        if (ListItemResolver.a.level >= 7) {
            a.lvlBuild(7, "register()", 183).log();
        }
        this.mli = new MultiLineListItemNameMatcher();
        for (String string : this.listClasses) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)this);
            ItemRegistry.instance().registerItemValueResolver(string, (ItemValueResolver)this);
        }
        for (String string : this.itemClasses) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)this);
            ItemRegistry.instance().registerItemNameMatcher2(string, (ItemNameMatcher2)this.mli);
        }
    }

    public void unregister() {
        if (ListItemResolver.a.level >= 7) {
            a.lvlBuild(7, "unregister()", 204).log();
        }
        for (String string : this.listClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
            ItemRegistry.instance().unregisterItemValueResolver(string, (ItemValueResolver)this);
        }
        for (String string : this.itemClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
            if (this.mli == null) continue;
            ItemRegistry.instance().unregisterItemNameMatcher2(string, (ItemNameMatcher2)this.mli);
        }
        this.mli = null;
    }

    public final void setExcludeHiddenItems(boolean bl2) {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setExcludeHiddenItems(boolean)", 228).addDetail("excludeHiddenItems", bl2)).log();
        }
        this.excludeHiddenItems = bl2;
    }

    @Override
    public Object[] getParentAndItem(Object object) {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getParentAndItem(Object)", 252).addDetail("element", object)).log();
        }
        if (!(object instanceof DomNode)) {
            return null;
        }
        DomNode domNode = (DomNode)object;
        if ("OPTION".equals(domNode.getTagName())) {
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getParentAndItem(Object)", 262).add("Option should be handled by OptionItemResolver -> leave.")).log();
            }
            return null;
        }
        if (domNode.isMatchingClass(this.itemClasses)) {
            Node node = domNode.getAncestorOfClass(this.getStopClassesForItemClassTraversing());
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getParentAndItem(Object)", 268).add("parent", (Object)node)).log();
            }
            if (node != null && node instanceof DomNode) {
                Node[] nodeArray = this.getItems((DomNode)node);
                int n2 = -1;
                for (Node node2 : nodeArray) {
                    ++n2;
                    if (node2 == domNode) break;
                }
                if (n2 > -1) {
                    return new Object[]{node, n2};
                }
            }
        }
        return null;
    }

    @Override
    public Object getElement(Object object, Object object2) throws BadItemException {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getElement(Object,Object)", 302).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        Object[] objectArray = this.getItems((DomNode)object);
        if (Misc.emptyOrNull((Object[])objectArray)) {
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getElement(Object,Object)", 309).add("Wrong resolver, leave.")).log();
            }
            return null;
        }
        return objectArray[(Integer)object2];
    }

    @Override
    public Object getItemForIndex(Object object, SubItemIndex[] subItemIndexArray) throws TestException {
        SubItemIndex subItemIndex;
        int n2;
        int n3;
        block9: {
            Object[] objectArray;
            DomNode domNode;
            block8: {
                if (ListItemResolver.a.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForIndex(Object,SubItemIndex[])", 333).addDetail("element", object)).addDetail("idx", (Object)subItemIndexArray)).log();
                }
                this.checkItem(object, null);
                domNode = (DomNode)object;
                objectArray = this.getItems(domNode);
                if (Misc.emptyOrNull((Object[])objectArray)) {
                    if (ListItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 343).add("Wrong resolver, leave.")).log();
                    }
                    return null;
                }
                if (ListItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 347).add("items", (Object)objectArray)).log();
                }
                n3 = objectArray.length;
                n2 = -1;
                subItemIndex = subItemIndexArray[0];
                if (subItemIndex.getType() != 1) break block8;
                n2 = subItemIndex.asNumber();
                if (n2 >= 0) break block9;
                n2 = n3 + n2;
                break block9;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                Boolean bl2 = ItemRegistry.instance().matchesItemName(domNode, this.itemClasses, objectArray[i2], subItemIndex, subItemIndex.getIndex());
                if (bl2 != null) {
                    if (!bl2.booleanValue()) continue;
                    n2 = i2;
                    break;
                }
                if (!subItemIndex.matches(this.getName(domNode, (Node)objectArray[i2]))) continue;
                n2 = i2;
                break;
            }
        }
        if (n2 < 0 || n2 >= n3) {
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 381).add("item", n2)).log();
            }
            throw new IndexNotFoundException(subItemIndex);
        }
        return n2;
    }

    @Override
    public SubItemIndex[] getItemIndex(Object object, Object object2, int n2) throws BadItemException {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object,int)", 402).addDetail("element", object)).addDetail("item", object2)).addDetail("type", n2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            return null;
        }
        DomNode domNode = (DomNode)object;
        Object[] objectArray = this.getItems(domNode);
        if (Misc.emptyOrNull((Object[])objectArray)) {
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 416).add("Wrong resolver, leave.")).log();
            }
            return null;
        }
        int n3 = objectArray.length;
        DomNode domNode2 = (DomNode)objectArray[(Integer)object2];
        String string = this.getName(domNode, domNode2);
        boolean bl2 = n2 == 1;
        int n4 = -1;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (objectArray[i2] == domNode2) {
                n4 = i2;
                if (bl2) continue;
                break;
            }
            if (!bl2 || !Misc.equalOrNull((Object)string, (Object)this.getName(domNode, (Node)objectArray[i2]))) continue;
            bl2 = false;
            if (n4 >= 0) break;
        }
        SubItemIndex subItemIndex = n2 == 2 || bl2 && n2 == 1 ? new SubItemIndex(string) : new SubItemIndex(n4);
        if (ListItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 452).add("tIdx", (Object)subItemIndex)).log();
        }
        return new SubItemIndex[]{subItemIndex};
    }

    @Override
    public String getItemValue(Object object, Object object2) {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemValue(Object,Object)", 469).addDetail("element", object)).addDetail("item", object2)).log();
        }
        if (object2 == null) {
            return null;
        }
        try {
            this.checkItem(object, object2);
        }
        catch (BadItemException badItemException) {
            return null;
        }
        Object[] objectArray = this.getItems((DomNode)object);
        if (Misc.emptyOrNull((Object[])objectArray)) {
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemValue(Object,Object)", 483).add("Wrong resolver, leave.")).log();
            }
            return null;
        }
        return this.getValue((DomNode)object, (Node)objectArray[(Integer)object2]);
    }

    protected Node[] getItems(DomNode domNode) {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getItems(DomNode)", 503).addDetail("list", (Object)domNode)).log();
        }
        return domNode.getElementsByClassName(this.itemClasses, this.getStopClassesForItemClassTraversing(), false, false, this.excludeHiddenItems);
    }

    protected String[] getStopClassesForItemClassTraversing() {
        if (ListItemResolver.a.level >= 7) {
            a.lvlBuild(7, "getStopClassesForItemClassTraversing()", 518).log();
        }
        return Misc.mergeStringArrays((String[])this.listClasses, (String[])this.helper.getStandardListClasses().toArray(new String[1]));
    }

    protected void checkItem(Object object, Object object2) throws BadItemException {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "checkItem(Object,Object)", 539).addDetail("element", object)).addDetail("item", object2)).log();
        }
        if (!(object instanceof DomNode) || !((DomNode)object).isMatchingClass(this.listClasses)) {
            if (ListItemResolver.a.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(5, "checkItem(Object,Object)", 544).add("Internal error: Not a list DomNode: ")).add(object)).log();
            }
            throw new BadItemException("Not a list DomNode: " + object);
        }
        if (object2 != null && !(object2 instanceof Integer)) {
            if (ListItemResolver.a.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(5, "checkItem(Object,Object)", 549).add("Internal error: Not an item Integer: ")).add(object2)).log();
            }
            throw new BadItemException("Not an item Integer: " + object2);
        }
    }

    protected String getName(DomNode domNode, Node node) {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getName(DomNode,Node)", 565).addDetail("parent", (Object)domNode)).addDetail("node", (Object)node)).log();
        }
        return ItemRegistry.instance().getItemName(domNode, domNode.getClassNames(), node, this.helper.getFlatIdentifierText(node));
    }

    protected String getValue(DomNode domNode, Node node) {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getValue(DomNode,Node)", 583).addDetail("parent", (Object)domNode)).addDetail("node", (Object)node)).log();
        }
        return Util.getCleanElementText((String)ItemRegistry.instance().getItemName(domNode, domNode.getClassNames(), node, this.helper.getWholeText(node)));
    }
}

