/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.web.items;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.Engine;
import de.qfs.apps.qftest.client.web.WebEngine;
import de.qfs.apps.qftest.client.web.WebHelper;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.items.matcher.MultiLineTableCellItemMatcher;
import de.qfs.apps.qftest.client.web.items.matcher.MultiLineTableHeaderItemMatcher;
import de.qfs.apps.qftest.extensions.ResolverRegistry;
import de.qfs.apps.qftest.extensions.items.ItemNameMatcher2;
import de.qfs.apps.qftest.extensions.items.ItemParentResolver;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.extensions.items.ItemValueResolver;
import de.qfs.apps.qftest.extensions.web.TableHelper;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Pair;
import java.util.Arrays;

public class TableItemResolver
implements ItemParentResolver,
ItemValueResolver {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.web.items.TableItemResolver");
    protected static final String QFS_CACHED_ITEM = "qfs:cacheditem";
    protected TableHelper helper;
    protected MultiLineTableCellItemMatcher mlm;
    protected MultiLineTableHeaderItemMatcher mlh;

    public TableItemResolver(TableHelper tableHelper) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "TableItemResolver(TableHelper)", 88).addDetail("helper", (Object)tableHelper)).log();
        }
        this.helper = tableHelper;
    }

    public void register() {
        if (TableItemResolver.a.level >= 7) {
            a.lvlBuild(7, "register()", 103).log();
        }
        for (String string : this.helper.getTableClasses()) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)this);
            ItemRegistry.instance().registerItemValueResolver(string, (ItemValueResolver)this);
        }
        this.mlm = new MultiLineTableCellItemMatcher(this.helper);
        this.mlh = new MultiLineTableHeaderItemMatcher(this.helper);
        for (String string : this.helper.getCellClasses()) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)this);
            ItemRegistry.instance().registerItemNameMatcher2(string, (ItemNameMatcher2)this.mlm);
            ItemRegistry.instance().registerItemNameMatcher2(string, (ItemNameMatcher2)this.mlh);
        }
        if (this.helper.getHeaderCellClasses() != null) {
            for (String string : this.helper.getHeaderCellClasses()) {
                ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)this);
                ItemRegistry.instance().registerItemNameMatcher2(string, (ItemNameMatcher2)this.mlh);
            }
        }
        if (this.helper.getFooterCellClasses() != null) {
            for (String string : this.helper.getFooterCellClasses()) {
                ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)this);
            }
        }
    }

    public void unregister() {
        if (TableItemResolver.a.level >= 7) {
            a.lvlBuild(7, "unregister()", 138).log();
        }
        for (String string : this.helper.getTableClasses()) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
            ItemRegistry.instance().unregisterItemValueResolver(string, (ItemValueResolver)this);
        }
        for (String string : this.helper.getCellClasses()) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
            ItemRegistry.instance().unregisterItemNameMatcher2(string, (ItemNameMatcher2)this.mlm);
            ItemRegistry.instance().unregisterItemNameMatcher2(string, (ItemNameMatcher2)this.mlh);
        }
        if (this.helper.getHeaderCellClasses() != null) {
            for (String string : this.helper.getHeaderCellClasses()) {
                ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
                ItemRegistry.instance().unregisterItemNameMatcher2(string, (ItemNameMatcher2)this.mlh);
            }
        }
        if (this.helper.getFooterCellClasses() != null) {
            for (String string : this.helper.getFooterCellClasses()) {
                ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
            }
        }
    }

    public static TableHelper.HelperContext createAndRegister(String string, String string2, String string3, String string4) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createAndRegister(String,String,String,String)", 176).addDetail("tableClass", string)).addDetail("rowClass", string2)).addDetail("cellClass", string3)).addDetail("headerCellClass", string4)).log();
        }
        WebHelper webHelper = ((WebEngine)Engine.instance("web")).getHelper();
        TableHelper.HelperContext helperContext = TableHelper.createAndRegister(webHelper, new String[]{string}, new String[]{string2}, new String[]{string3}, null, new String[]{string4}, null, null, null);
        helperContext.helper.searchHeader = true;
        return helperContext;
    }

    @Override
    public Object[] getParentAndItem(Object object) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getParentAndItem(Object)", 205).addDetail("element", object)).log();
        }
        if (!(object instanceof DomNode)) {
            return null;
        }
        DomNode domNode = (DomNode)object;
        boolean bl2 = this.helper.checkCell(domNode);
        boolean bl3 = this.helper.checkHeaderCell(domNode);
        if (bl2 || bl3) {
            DomNode domNode2 = this.helper.getTable(domNode);
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getParentAndItem(Object)", 215).add("table", (Object)domNode2)).log();
            }
            if (domNode2 != null && this.shouldHandle(domNode2, domNode)) {
                Object object2;
                boolean bl4 = Client.instance().isCaptureContext();
                if (bl4) {
                    domNode2.setProperty(QFS_CACHED_ITEM, null);
                }
                Object object3 = domNode2.getProperty("qfs:tablehasitems");
                if (TableItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getParentAndItem(Object)", 222).add("prop", object3)).log();
                }
                if (object3 == null) {
                    object3 = ResolverRegistry.instance().resolveTableWithItems((Object)domNode2, domNode2.getClassNames()) ? Boolean.TRUE : Boolean.FALSE;
                    domNode2.setProperty("qfs:tablehasitems", object3);
                }
                if (TableItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getParentAndItem(Object)", 230).add("prop", object3)).log();
                }
                if (!bl4) {
                    object2 = domNode2.getProperty(QFS_CACHED_ITEM);
                    if (TableItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getParentAndItem(Object)", 234).add("cached", object2)).log();
                    }
                    if (object2 instanceof Pair && ((Pair)object2).getFirst() == object && ((Pair)object2).getSecond() instanceof int[] && ((int[])((Pair)object2).getSecond()).length == 2) {
                        return new Object[]{domNode2, ((Pair)object2).getSecond()};
                    }
                }
                if (Misc.toBoolean((Object)object3)) {
                    object2 = this.helper.getRowAndColumn(domNode2, domNode);
                    if (TableItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getParentAndItem(Object)", 244).add("rowcol", object2)).log();
                    }
                    if (object2[1] >= 0) {
                        return new Object[]{domNode2, new int[]{(int)object2[1], (int)object2[0]}};
                    }
                }
            }
        }
        return null;
    }

    @Override
    public Object getElement(Object object, Object object2) throws BadItemException {
        DomNode domNode;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getElement(Object,Object)", 266).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        if (!this.shouldHandle(object, object2)) {
            return null;
        }
        DomNode domNode2 = (DomNode)object;
        int n2 = ((int[])object2)[0];
        int n3 = ((int[])object2)[1];
        if (object2 == null || n2 < 0) {
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getElement(Object,Object)", 278).add("Clearing cached item")).log();
            }
            domNode2.setProperty(QFS_CACHED_ITEM, null);
            return null;
        }
        DomNode domNode3 = domNode = n3 < 0 ? this.helper.getHeaderCell(domNode2, n2) : this.helper.getCell(domNode2, n3, n2);
        if (domNode == null) {
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getElement(Object,Object)", 285).add("Clearing cached item")).log();
            }
            domNode2.setProperty(QFS_CACHED_ITEM, null);
        } else {
            Pair pair = new Pair((Object)domNode, object2);
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getElement(Object,Object)", 289).add("pair", (Object)pair)).log();
            }
            domNode2.setProperty(QFS_CACHED_ITEM, pair);
        }
        return domNode;
    }

    @Override
    public Object getItemForIndex(Object object, SubItemIndex[] subItemIndexArray) throws TestException {
        String[] stringArray;
        int n2;
        int[] nArray;
        block18: {
            Object object2;
            DomNode domNode;
            block17: {
                SubItemIndex subItemIndex;
                int n3;
                block16: {
                    block15: {
                        if (TableItemResolver.a.level >= 7) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForIndex(Object,SubItemIndex[])", 308).addDetail("element", object)).addDetail("idx", (Object)subItemIndexArray)).log();
                        }
                        this.checkItem(object, null);
                        if (!this.shouldHandle(object, null)) {
                            return null;
                        }
                        domNode = (DomNode)object;
                        nArray = new int[]{-1, -1};
                        n3 = this.helper.getColumnCount(domNode);
                        if (n3 == 0) {
                            return null;
                        }
                        subItemIndex = subItemIndexArray[0];
                        if (subItemIndex.getType() != 1) break block15;
                        nArray[0] = subItemIndex.asNumber();
                        if (nArray[0] >= 0) break block16;
                        nArray[0] = n3 + nArray[0];
                        break block16;
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        stringArray = this.helper.getHeaderCellClasses();
                        stringArray = stringArray == null ? this.helper.getCellClasses() : stringArray;
                        DomNode domNode2 = this.helper.getHeaderCell(domNode, n2);
                        object2 = ItemRegistry.instance().matchesItemName(domNode, stringArray, domNode2, subItemIndex, subItemIndex.getIndex());
                        if (object2 != null) {
                            if (!((Boolean)object2).booleanValue()) continue;
                            nArray[0] = n2;
                            break;
                        }
                        if (!subItemIndex.matches(this.getHeaderName(domNode, n2))) continue;
                        nArray[0] = n2;
                        break;
                    }
                }
                if (nArray[0] < 0 || nArray[0] >= n3) {
                    if (TableItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 360).add("item[0]", nArray[0])).dumpStack();
                    }
                    throw new IndexNotFoundException(subItemIndex);
                }
                if (subItemIndexArray.length == 1) {
                    return nArray;
                }
                n2 = this.helper.getRowCount(domNode);
                stringArray = subItemIndexArray[1];
                if (stringArray.getType() != 1) break block17;
                nArray[1] = stringArray.asNumber();
                if (nArray[1] >= 0) break block18;
                nArray[1] = n2 + nArray[1];
                break block18;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                object2 = this.helper.getCell(domNode, i2, nArray[0]);
                Boolean bl2 = ItemRegistry.instance().matchesItemName(domNode, this.helper.getCellClasses(), object2, (SubItemIndex)stringArray, stringArray.getIndex());
                if (bl2 != null) {
                    if (!bl2.booleanValue()) continue;
                    nArray[1] = i2;
                    break;
                }
                if (object2 != null && stringArray.matches(this.getName(domNode, (DomNode)object2, i2))) {
                    nArray[1] = i2;
                    break;
                }
                if (object2 != null || stringArray.matches(".*") || !stringArray.matches("")) continue;
                nArray[1] = i2;
                break;
            }
        }
        if (nArray[1] < 0 || nArray[1] >= n2) {
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 411).add("item[1]", nArray[1])).log();
            }
            if (stringArray.isElementSyntax()) {
                nArray[1] = -1;
                if (TableItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 415).add("Returning item for column: ")).addAll("item", (Object)nArray)).log();
                }
                return nArray;
            }
            throw new IndexNotFoundException((SubItemIndex)stringArray);
        }
        ItemRegistry.instance().setIndexesResolved(2);
        return nArray;
    }

    @Override
    public SubItemIndex[] getItemIndex(Object object, Object object2, int n2) throws TestException {
        SubItemIndex subItemIndex;
        SubItemIndex[] subItemIndexArray;
        String string;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object,int)", 439).addDetail("element", object)).addDetail("item", object2)).addDetail("type", n2)).log();
        }
        this.checkItem(object, object2);
        if (!this.shouldHandle(object, object2)) {
            return null;
        }
        if (object2 == null) {
            return null;
        }
        DomNode domNode = (DomNode)object;
        int[] nArray = (int[])object2;
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = this.helper.getColumnCount(domNode);
        if (n5 == 0) {
            throw new BadItemException("No header cells in " + domNode);
        }
        if (n3 >= n5) {
            throw new BadItemException("Column index " + n3 + " out of range.");
        }
        int n6 = n2;
        int n7 = this.helper.isHeaderless(domNode);
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 466).add("headerless", n7)).log();
        }
        if (n7 == 2 || n7 == 1 && n2 == 1) {
            n6 = 3;
        }
        String string2 = string = n6 == 3 ? "" : this.getHeaderName(domNode, n3);
        if (n6 == 1) {
            int n8;
            for (n8 = 0; !(n8 >= n5 || n8 != n3 && Misc.equalOrNull((Object)string, (Object)this.getHeaderName(domNode, n8))); ++n8) {
            }
            n6 = n8 == n5 ? 2 : 3;
        }
        SubItemIndex subItemIndex2 = n6 == 2 ? new SubItemIndex(string) : new SubItemIndex(n3);
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 495).add("colIdx", (Object)subItemIndex2)).log();
        }
        if (n4 < 0) {
            return new SubItemIndex[]{subItemIndex2};
        }
        int n9 = this.helper.getRowCount(domNode);
        if (n2 == 2) {
            subItemIndexArray = this.helper.getCell(domNode, n4, n3);
            if (subItemIndexArray == null) {
                throw new BadItemException("Invalid row index: " + n4);
            }
            subItemIndex = new SubItemIndex(this.getName(domNode, (DomNode)subItemIndexArray, n4));
        } else {
            subItemIndex = new SubItemIndex(this.isFooterRow(domNode, n4) ? -1 : n4);
        }
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 512).add("rowIdx", (Object)subItemIndex)).log();
        }
        subItemIndexArray = new SubItemIndex[]{subItemIndex2, subItemIndex};
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 514).add("ret", (Object)subItemIndexArray)).log();
        }
        return subItemIndexArray;
    }

    @Override
    public String getItemValue(Object object, Object object2) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemValue(Object,Object)", 530).addDetail("element", object)).addDetail("item", object2)).log();
        }
        if (object2 == null) {
            return null;
        }
        try {
            this.checkItem(object, object2);
        }
        catch (BadItemException badItemException) {
            return null;
        }
        try {
            Object object3 = this.getElement(object, object2);
            if (object3 != null && object3 instanceof DomNode) {
                return Util.getCleanElementText((String)((DomNode)object3).getHelper().getWholeText(object3));
            }
        }
        catch (BadItemException badItemException) {
            if (TableItemResolver.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getItemValue(Object,Object)", 546).add("getElement threw BadItemException.")).log();
            }
            return null;
        }
        return null;
    }

    protected boolean shouldHandle(Object object, Object object2) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "shouldHandle(Object,Object)", 568).addDetail("element", object)).addDetail("item", object2)).log();
        }
        if (!(object instanceof DomNode)) {
            return false;
        }
        if (this.getClass() == TableItemResolver.class) {
            return !((DomNode)object).isMatchingClass("Table");
        }
        return true;
    }

    protected void checkItem(Object object, Object object2) throws BadItemException {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "checkItem(Object,Object)", 595).addDetail("element", object)).addDetail("item", object2)).log();
        }
        if (!(object instanceof DomNode) || !this.helper.checkTable((DomNode)object)) {
            if (TableItemResolver.a.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(5, "checkItem(Object,Object)", 600).add("Internal error: Not a ")).add(Arrays.deepToString(this.helper.getTableClasses()))).add(" DomNode: ")).add(object)).dumpStack();
            }
            throw new BadItemException("Not a " + Arrays.deepToString(this.helper.getTableClasses()) + " DomNode: " + object);
        }
        if (!(object2 == null || object2 instanceof int[] && ((int[])object2).length == 2)) {
            if (TableItemResolver.a.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(5, "checkItem(Object,Object)", 608).add("Internal error: Not an int[2]: ")).add(object2)).log();
            }
            throw new BadItemException("Not an int[2]: " + object2);
        }
    }

    protected String getName(DomNode domNode, DomNode domNode2, int n2) {
        String string;
        int n3;
        String string2;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getName(DomNode,DomNode,int)", 625).addDetail("table", (Object)domNode)).addDetail("node", (Object)domNode2)).addDetail("row", n2)).log();
        }
        if ((string2 = this.helper.getHelper().getFlatIdentifierText(domNode2)) == null) {
            string2 = "";
        }
        if ((n3 = this.helper.getRowAndColumn(domNode, domNode2)[0]) >= 0 && n3 < n2) {
            string2 = string2 + ":" + (n2 - n3 + 1);
        }
        return (string = ItemRegistry.instance().getItemName(domNode, domNode.getClassNames(), domNode2, string2)) == null ? "" : string;
    }

    protected String getHeaderName(DomNode domNode, int n2) {
        int n3;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getHeaderName(DomNode,int)", 652).addDetail("table", (Object)domNode)).addDetail("column", n2)).log();
        }
        DomNode domNode2 = null;
        String string = "";
        domNode2 = this.helper.getHeaderCell(domNode, n2);
        string = this.helper.getHelper().getFlatIdentifierText(domNode2);
        if (string == null) {
            string = "";
        }
        if ((n3 = this.helper.getRowAndColumn(domNode, domNode2)[1]) >= 0 && n3 < n2) {
            string = string + ":" + (n2 - n3 + 1);
        }
        string = ItemRegistry.instance().getItemName(domNode, domNode.getClassNames(), domNode2, string);
        String string2 = ItemRegistry.instance().getItemName(domNode, domNode.getClassNames(), n2, string);
        return string2 == null ? "" : string2;
    }

    protected boolean isFooterRow(DomNode domNode, int n2) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "isFooterRow(DomNode,int)", 686).addDetail("table", (Object)domNode)).addDetail("row", n2)).log();
        }
        return false;
    }
}

