/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.web.items;

import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.Node;
import de.qfs.apps.qftest.extensions.items.ItemParentResolver;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.extensions.web.TreeHelper;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.IndexFormatException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;

public abstract class TreeItemResolver
implements ItemParentResolver {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.web.items.TreeItemResolver");
    protected TreeHelper helper;
    protected String treeClass;
    protected String nodeClass;

    public TreeItemResolver(TreeHelper treeHelper, String string, String string2) {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "TreeItemResolver(TreeHelper,String,String)", 74).addDetail("helper", (Object)treeHelper)).addDetail("treeClass", string)).addDetail("nodeClass", string2)).log();
        }
        this.helper = treeHelper;
        this.treeClass = string;
        this.nodeClass = string2;
    }

    @Override
    public Object[] getParentAndItem(Object object) {
        Node node;
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getParentAndItem(Object)", 95).addDetail("element", object)).log();
        }
        if (!(object instanceof DomNode)) {
            return null;
        }
        DomNode domNode = (DomNode)object;
        if (this.helper.getHelper().isMatchingClass((Object)domNode, this.nodeClass) && (node = this.helper.getHelper().getAncestorOfClass((Node)domNode, this.treeClass)) != null) {
            return new Object[]{node, domNode};
        }
        return null;
    }

    @Override
    public Object getElement(Object object, Object object2) throws BadItemException {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getElement(Object,Object)", 124).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        return object2;
    }

    @Override
    public Object getItemForIndex(Object object, SubItemIndex[] subItemIndexArray) throws TestException {
        boolean bl2;
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForIndex(Object,SubItemIndex[])", 145).addDetail("element", object)).addDetail("idx", (Object)subItemIndexArray)).log();
        }
        this.checkItem(object, null);
        DomNode domNode = (DomNode)object;
        SubItemIndex subItemIndex = subItemIndexArray[0];
        String string = subItemIndex.getIndex();
        if (Misc.emptyOrNull((String)string)) {
            if (TreeItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 155).add("No path specified.")).log();
            }
            return null;
        }
        boolean bl3 = bl2 = string.charAt(0) == '/';
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 161).add("tPath: ")).add(string)).add(", asPath: ")).add(bl2)).log();
        }
        DomNode domNode2 = null;
        if (bl2) {
            DomNode domNode3 = this.helper.getRootNode(domNode);
            int n2 = 0;
            int n3 = 0;
            int n4 = -1;
            while (n2 >= 0) {
                DomNode domNode4 = domNode3;
                int n5 = Misc.unquotedIndexOf((String)string, (String)"/", (int)(n2 + 1));
                String string2 = n5 > n2 ? Misc.unquote((String)string.substring(n2 + 1, n5), (String)"\\#@&%/") : Misc.unquote((String)string.substring(n2 + 1), (String)"\\#@&%/");
                if (TreeItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 182).add("index", string2)).log();
                }
                if (TreeItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 183).add("pos", n2)).log();
                }
                if (TreeItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 184).add("pos2", n5)).log();
                }
                DomNode[] domNodeArray = this.helper.getChildNodes(domNode, domNode3);
                int n6 = domNodeArray.length;
                if (TreeItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 188).add("num", n6)).log();
                }
                switch (subItemIndex.getType()) {
                    case 0: {
                        int n7;
                        for (n7 = 0; n7 < n6; ++n7) {
                            domNodeArray[n7].setProperty("qfs:itemlevel", n3);
                            Boolean bl4 = ItemRegistry.instance().matchesItemName(domNode, domNode.getClassNames(), domNodeArray[n7], subItemIndex, string2);
                            domNodeArray[n7].setProperty("qfs:itemlevel", null);
                            if (bl4 != null) {
                                if (!bl4.booleanValue()) continue;
                                domNode3 = domNodeArray[n7];
                                break;
                            }
                            String string3 = this.a(domNode, domNodeArray[n7]);
                            if (TreeItemResolver.a.level >= 9) {
                                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 208).add("name", string3)).log();
                            }
                            if (string3 == null) {
                                string3 = "";
                            }
                            if (!string2.equals(string3)) continue;
                            domNode3 = domNodeArray[n7];
                            break;
                        }
                        if (n7 != n6) break;
                        throw new IndexNotFoundException(subItemIndex);
                    }
                    case 1: {
                        int n7;
                        boolean bl5 = false;
                        if (ItemRegistry.instance().hasItemNameMatchers(domNode, domNode.getClassNames())) {
                            for (n7 = 0; n7 < n6; ++n7) {
                                domNodeArray[n7].setProperty("qfs:itemlevel", n3);
                                Boolean bl6 = ItemRegistry.instance().matchesItemName(domNode, domNode.getClassNames(), domNodeArray[n7], subItemIndex, string2);
                                domNodeArray[n7].setProperty("qfs:itemlevel", null);
                                if (bl6 == null || !bl6.booleanValue()) continue;
                                domNode3 = domNodeArray[n7];
                                bl5 = true;
                                break;
                            }
                        }
                        if (bl5) break;
                        try {
                            int n8 = Integer.parseInt(string2);
                            if (n8 < 0) {
                                n8 = n6 + n8;
                            }
                            if (n8 < 0 || n8 >= n6) {
                                throw new IndexNotFoundException(subItemIndex);
                            }
                            domNode3 = domNodeArray[n8];
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IndexFormatException(subItemIndex);
                        }
                    }
                    case 2: {
                        int n7;
                        try {
                            for (n7 = 0; n7 < n6; ++n7) {
                                domNodeArray[n7].setProperty("qfs:itemlevel", n3);
                                Boolean bl7 = ItemRegistry.instance().matchesItemName(domNode, domNode.getClassNames(), domNodeArray[n7], subItemIndex, string2);
                                domNodeArray[n7].setProperty("qfs:itemlevel", null);
                                if (bl7 != null) {
                                    if (!bl7.booleanValue()) continue;
                                    domNode3 = domNodeArray[n7];
                                    break;
                                }
                                String string4 = this.a(domNode, domNodeArray[n7]);
                                if (TreeItemResolver.a.level >= 9) {
                                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 273).add("name", string4)).log();
                                }
                                if (string4 == null) {
                                    string4 = "";
                                }
                                if (!Util.regexpMatches((String)string2, (String)string4)) continue;
                                domNode3 = domNodeArray[n7];
                                break;
                            }
                            if (n7 == n6) {
                                throw new IndexNotFoundException(subItemIndex);
                            }
                            break;
                        }
                        catch (RuntimeException runtimeException) {
                            throw new IndexFormatException(subItemIndex);
                        }
                    }
                }
                if (TreeItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 290).add("node", (Object)domNode3)).log();
                }
                if (n5 >= 0) {
                    boolean bl8;
                    boolean bl9 = bl8 = domNode3 == domNode || this.helper.isExpanded(domNode, domNode3);
                    if (!bl8) {
                        if (n4 == n2) {
                            if (TreeItemResolver.a.level >= 9) {
                                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 299).add("Failed to expand node: ")).add("node", (Object)domNode3)).log();
                            }
                        } else {
                            if (!Options.cached_OPT_PLAY_EXPAND_TREE) {
                                if (TreeItemResolver.a.level >= 9) {
                                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 302).add("Parent is collapsed")).log();
                                }
                                throw new IndexNotFoundException(subItemIndex);
                            }
                            this.expandNode(domNode, domNode3);
                            n4 = n2;
                            domNode3 = domNode4;
                            continue;
                        }
                    }
                }
                n2 = n5;
                domNode2 = domNode3;
                ++n3;
            }
        } else {
            Node[] nodeArray = this.getTreeNodes(domNode);
            if (subItemIndex.getType() == 1) {
                int n9 = subItemIndex.asNumber();
                if (n9 < 0) {
                    n9 = nodeArray.length + n9;
                }
                if (n9 >= 0 && n9 < nodeArray.length) {
                    domNode2 = (DomNode)nodeArray[n9];
                }
            } else {
                String string5 = subItemIndex.getIndex();
                if (!Misc.emptyOrNull((String)string5)) {
                    string5 = Misc.unquote((String)string5, (String)"\\#@&%/");
                }
                SubItemIndex subItemIndex2 = new SubItemIndex(string5, subItemIndex.getType());
                if (TreeItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 334).add("index", (Object)subItemIndex2)).log();
                }
                for (Node node : nodeArray) {
                    String string6 = this.a(domNode, (DomNode)node);
                    if (TreeItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 337).add("name", string6)).log();
                    }
                    if (!subItemIndex2.matches(string6)) continue;
                    domNode2 = (DomNode)node;
                }
            }
        }
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 344).add("ret", (Object)domNode2)).log();
        }
        if (domNode2 == null) {
            throw new IndexNotFoundException(subItemIndex);
        }
        if (Options.cached_OPT_PLAY_SCROLL_ITEM) {
            domNode2.scrollPointVisible(0, 0, true);
        }
        return domNode2;
    }

    @Override
    public SubItemIndex[] getItemIndex(Object object, Object object2, int n2) throws BadItemException {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object,int)", 371).addDetail("element", object)).addDetail("item", object2)).addDetail("type", n2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        DomNode domNode = (DomNode)object;
        DomNode domNode2 = (DomNode)object2;
        SubItemIndex[] subItemIndexArray = new SubItemIndex[1];
        boolean bl2 = Options.cached_OPT_RECORD_SUBITEM_TREE_PATH;
        if (bl2) {
            boolean bl3 = true;
            boolean[] blArray = new boolean[1];
            while (bl3) {
                bl3 = false;
                String string = "";
                DomNode domNode3 = domNode2;
                while (domNode3 != null) {
                    String string2 = this.a(domNode, domNode3, n2, true, blArray);
                    if (n2 == 1 && !blArray[0]) {
                        bl3 = true;
                        n2 = 3;
                        break;
                    }
                    if (blArray[0]) {
                        string2 = Misc.quote((String)string2, (String)"\\#@&%/");
                        string2 = Misc.quote((String)string2, (String)"$", (char)'$');
                    }
                    string = "/" + string2 + string;
                    domNode3 = this.helper.getParentItem(domNode, domNode3);
                }
                if (bl3) continue;
                subItemIndexArray[0] = new SubItemIndex(string, n2 == 3 ? 1 : 0);
            }
        } else {
            boolean[] blArray = new boolean[1];
            String string = this.a(domNode, domNode2, n2, false, blArray);
            if (blArray[0]) {
                string = Misc.quote((String)string, (String)"\\#@&%/");
                string = Misc.quote((String)string, (String)"$", (char)'$');
            }
            subItemIndexArray[0] = new SubItemIndex(string, blArray[0] ? 0 : 1);
        }
        if (Options.getInt((String)Options.OPT_RECORD_SUBITEM_TYPE, (int)1) == 1) {
            subItemIndexArray[0].setSuggestNode(subItemIndexArray[0].getType() == 0);
        }
        return subItemIndexArray;
    }

    protected Node[] getTreeNodes(DomNode domNode) {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getTreeNodes(DomNode)", 446).addDetail("tree", (Object)domNode)).log();
        }
        return domNode.getElementsByClassName(this.nodeClass);
    }

    protected void expandNode(DomNode domNode, DomNode domNode2) {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "expandNode(DomNode,DomNode)", 460).addDetail("tree", (Object)domNode)).addDetail("node", (Object)domNode2)).log();
        }
    }

    protected void checkItem(Object object, Object object2) throws BadItemException {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "checkItem(Object,Object)", 480).addDetail("element", object)).addDetail("item", object2)).log();
        }
        if (!(object instanceof DomNode) || !this.helper.getHelper().isMatchingClass(object, this.treeClass)) {
            if (TreeItemResolver.a.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(5, "checkItem(Object,Object)", 485).add("Internal error: Not a ")).add(this.treeClass)).add(" DomNode: ")).add(object)).log();
            }
            throw new BadItemException("Not a " + this.treeClass + " DomNode: " + object);
        }
        if (!(object2 == null || object2 instanceof DomNode && this.helper.getHelper().isMatchingClass(object2, this.nodeClass))) {
            if (TreeItemResolver.a.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(5, "checkItem(Object,Object)", 491).add("Internal error: Not a ")).add(this.nodeClass)).add(" item: ")).add(object2)).log();
            }
            throw new BadItemException("Not a " + this.nodeClass + "item: " + object2);
        }
    }

    private String a(DomNode domNode, DomNode domNode2, int n2, boolean bl2, boolean[] blArray) {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getNodeIndex(DomNode,DomNode,int,boolean,boolean[])", 510).addDetail("tree", (Object)domNode)).addDetail("node", (Object)domNode2)).addDetail("format", n2)).addDetail("asPath", bl2)).addDetail("isString", (Object)blArray)).log();
        }
        switch (n2) {
            case 1: {
                String string = this.a(domNode, domNode2);
                if (string == null) {
                    string = "";
                }
                if (TreeItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getNodeIndex(DomNode,DomNode,int,boolean,boolean[])", 520).add("nodeName", string)).log();
                }
                boolean bl3 = true;
                if (bl2) {
                    DomNode domNode3 = this.helper.getParentItem(domNode, domNode2);
                    if (TreeItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getNodeIndex(DomNode,DomNode,int,boolean,boolean[])", 524).add("parent", (Object)domNode3)).log();
                    }
                    if (domNode3 == null) {
                        blArray[0] = true;
                        return string;
                    }
                    DomNode[] domNodeArray = this.helper.getChildNodes(domNode, domNode3);
                    int n3 = -1;
                    for (int i2 = 0; i2 < domNodeArray.length; ++i2) {
                        if (domNodeArray[i2] == domNode2) {
                            n3 = i2;
                            continue;
                        }
                        if (!bl3) continue;
                        String string2 = this.a(domNode, domNodeArray[i2]);
                        if (string2 == null) {
                            string2 = "";
                        }
                        if (!Misc.equalOrNull((Object)string, (Object)string2)) continue;
                        bl3 = false;
                    }
                    blArray[0] = bl3;
                    return bl3 ? string : "" + n3;
                }
                Node[] nodeArray = domNode.getElementsByClassName(this.nodeClass);
                int n4 = -1;
                for (int i3 = 0; i3 < nodeArray.length; ++i3) {
                    if (nodeArray[i3] == domNode2) {
                        n4 = i3;
                        continue;
                    }
                    String string3 = this.a(domNode, (DomNode)nodeArray[i3]);
                    if (string3 == null) {
                        string3 = "";
                    }
                    if (!Misc.equalOrNull((Object)string, (Object)string3)) continue;
                    bl3 = false;
                    break;
                }
                blArray[0] = bl3;
                return bl3 ? string : "" + n4;
            }
            case 2: {
                blArray[0] = true;
                String string = this.a(domNode, domNode2);
                return string == null ? "" : string;
            }
            case 3: {
                blArray[0] = false;
                if (bl2) {
                    DomNode domNode4 = this.helper.getParentItem(domNode, domNode2);
                    if (domNode4 == null) {
                        blArray[0] = true;
                        return "0";
                    }
                    DomNode[] domNodeArray = this.helper.getChildNodes(domNode, domNode4);
                    int n5 = -1;
                    for (int i4 = 0; i4 < domNodeArray.length; ++i4) {
                        if (domNodeArray[i4] != domNode2) continue;
                        n5 = i4;
                        break;
                    }
                    return "" + n5;
                }
                Node[] nodeArray = domNode.getElementsByClassName(this.nodeClass);
                int n6 = -1;
                for (int i5 = 0; i5 < nodeArray.length; ++i5) {
                    if (nodeArray[i5] != domNode2) continue;
                    n6 = i5;
                    break;
                }
                return "" + n6;
            }
        }
        return "";
    }

    private String a(DomNode domNode, DomNode domNode2) {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getNodeName(DomNode,DomNode)", 616).addDetail("tree", (Object)domNode)).addDetail("node", (Object)domNode2)).log();
        }
        String string = this.b(domNode, domNode2);
        return ItemRegistry.instance().getItemName(domNode, domNode.getClassNames(), domNode2, string);
    }

    private String b(DomNode domNode, DomNode domNode2) {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getDefaultNodeName(DomNode,DomNode)", 634).addDetail("tree", (Object)domNode)).addDetail("node", (Object)domNode2)).log();
        }
        return this.helper.getHelper().getFlatIdentifierText(domNode2);
    }
}

