/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.win.check;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.win.WinHelper;
import de.qfs.apps.qftest.client.win.check.WinControlChecker;
import de.qfs.apps.qftest.client.win.items.ListItemResolver;
import de.qfs.apps.qftest.client.win.toolkit.WinControl;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.extensions.checks.Checker;
import de.qfs.apps.qftest.extensions.checks.CheckerHelper;
import de.qfs.apps.qftest.extensions.checks.QFSChecker;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.shared.data.check.BooleanCheckData;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.ImageCheckData;
import de.qfs.apps.qftest.shared.data.check.SelectableItemsCheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.apps.qftest.shared.data.check.StringItemsCheckData;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Pair;
import java.util.ArrayList;

public class ListChecker
implements Checker,
QFSChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.win.check.ListChecker");
    private WinHelper b;

    public ListChecker(WinHelper winHelper) {
        if (ListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "ListChecker(WinHelper)", 64).addDetail("helper", (Object)winHelper)).log();
        }
        this.b = winHelper;
    }

    @Override
    public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
        if (ListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSupportedCheckTypes(Object,Object)", 74).addDetail("target", object)).addDetail("subItem", object2)).log();
        }
        ArrayList<CheckType> arrayList = new ArrayList<CheckType>();
        if (object2 == null) {
            arrayList.add(CheckType.CURRENT_ITEM);
            arrayList.add(CheckType.ITEMS);
            arrayList.add(CheckType.ITEMS_WITH_SELECTION);
        } else {
            arrayList.add(CheckType.ITEM);
            arrayList.add(CheckType.CURRENT_ITEM);
            arrayList.add(CheckType.ITEM_VISIBLE);
            arrayList.add(CheckType.ITEM_SELECTED);
            arrayList.add(CheckType.ITEMS);
            arrayList.add(CheckType.ITEMS_WITH_SELECTION);
            arrayList.add(CheckType.VISIBLE);
            arrayList.add(CheckType.ENABLED);
            arrayList.add(CheckType.FOCUSED);
            arrayList.add(CheckType.IMAGE);
            arrayList.add(CheckType.ITEM_IMAGE);
        }
        if (arrayList != null && arrayList.size() > 0) {
            return (CheckType[])arrayList.toArray(new CheckType[arrayList.size()]).clone();
        }
        return null;
    }

    @Override
    public CheckData getCheckData(Object object, Object object2, CheckType checkType) throws TestException {
        ImageRep imageRep;
        Object object3;
        if (ListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckData(Object,Object,CheckType)", 104).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        if (!(object instanceof WinControl)) {
            return null;
        }
        WinControl winControl = (WinControl)object;
        if (object2 != null) {
            if (checkType.getDataType() == CheckDataType.STRING && ("default".equals(checkType.getIdentifier()) || CheckType.TEXT.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM.getIdentifier().equals(checkType.getIdentifier()))) {
                String string = WinControlChecker.getTextForCheck(this.b, winControl, object2);
                return new StringCheckData(CheckType.ITEM.getIdentifier(), string);
            }
            object3 = null;
            try {
                imageRep = ItemRegistry.instance().getElement(object, object2);
                if (imageRep instanceof WinControl) {
                    object3 = (WinControl)imageRep;
                }
            }
            catch (TestException testException) {
                // empty catch block
            }
            if (ListChecker.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 130).add("itemCtrl", object3)).log();
            }
            if (object3 == null) {
                return null;
            }
            if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.ITEM_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.SELECTED.getIdentifier().equals(checkType.getIdentifier()))) {
                boolean bl2 = this.b.isSelected(object3);
                return new BooleanCheckData(CheckType.ITEM_SELECTED.getIdentifier(), bl2);
            }
            if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.ITEM_VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || !Client.instance().isCaptureContext() && CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier()))) {
                return new BooleanCheckData(CheckType.ITEM_VISIBLE.getIdentifier(), true);
            }
            if (checkType.getDataType() == CheckDataType.IMAGE && ("default".equals(checkType.getIdentifier()) || CheckType.ITEM_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_IMAGE_OLD.getIdentifier().equals(checkType.getIdentifier()) || !Client.instance().isCaptureContext() && CheckType.IMAGE.getIdentifier().equals(checkType.getIdentifier()))) {
                imageRep = WinControlChecker.getImageForCheck(this.b, (WinControl)object3);
                return new ImageCheckData(CheckType.ITEM_IMAGE.getIdentifier(), imageRep, -1, -1, -1, -1, -1, -1, false);
            }
        }
        if (checkType.getDataType() == CheckDataType.STRING && (object2 == null && ("default".equals(checkType.getIdentifier()) || CheckType.TEXT.getIdentifier().equals(checkType.getIdentifier())) || CheckType.CURRENT_ITEM.getIdentifier().equals(checkType.getIdentifier()))) {
            object3 = ListChecker.getSelectedItem(winControl, this.b);
            if (object3 != null) {
                imageRep = (String)object3.getSecond();
                return new StringCheckData(CheckType.CURRENT_ITEM.getIdentifier(), (String)imageRep);
            }
            return new StringCheckData(CheckType.CURRENT_ITEM.getIdentifier(), null);
        }
        if (checkType.getDataType() == CheckDataType.STRING_LIST && ("default".equals(checkType.getIdentifier()) || CheckType.ITEMS.getIdentifier().equals(checkType.getIdentifier()))) {
            object3 = ListChecker.a(winControl, this.b);
            if (object3 != null) {
                imageRep = new String[((ArrayList)object3).size()];
                for (int i2 = 0; i2 < ((ArrayList)object3).size(); ++i2) {
                    imageRep[i2] = (String)((Pair)((ArrayList)object3).get(i2)).getSecond();
                }
                return new StringItemsCheckData(CheckType.ITEMS.getIdentifier(), (String[])imageRep);
            }
            return null;
        }
        if (checkType.getDataType() == CheckDataType.SELECTABLE_STRING_LIST && ("default".equals(checkType.getIdentifier()) || CheckType.ITEMS_WITH_SELECTION.getIdentifier().equals(checkType.getIdentifier()))) {
            object3 = ListChecker.a(winControl, this.b);
            if (object3 != null) {
                imageRep = new Object[((ArrayList)object3).size()][];
                for (int i3 = 0; i3 < ((ArrayList)object3).size(); ++i3) {
                    WinControl winControl2 = (WinControl)((Pair)((ArrayList)object3).get(i3)).getFirst();
                    String string = (String)((Pair)((ArrayList)object3).get(i3)).getSecond();
                    imageRep[i3] = new Object[]{string, Boolean.FALSE, this.b.isSelected(winControl2)};
                }
                return new SelectableItemsCheckData(CheckType.ITEMS_WITH_SELECTION.getIdentifier(), (Object[][])imageRep, false);
            }
            return null;
        }
        return null;
    }

    @Override
    public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) throws TestException {
        CheckData checkData;
        if (ListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataAndItem(Object,Object,CheckType)", 220).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
        }
        if ((checkData = this.getCheckData(object, object2, checkType)) == null) {
            return null;
        }
        if (CheckType.ITEM.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_CHECKED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_VISIBLE.getIdentifier().equals(checkType.getIdentifier())) {
            return new Pair((Object)checkData, object2);
        }
        return new Pair((Object)checkData, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList a(WinControl winControl, WinHelper winHelper) throws TestException {
        if (ListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemsForCheck(WinControl,WinHelper)", 251).addDetail("list", (Object)winControl)).addDetail("helper", (Object)winHelper)).log();
        }
        if (ListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemsForCheck(WinControl,WinHelper)", 254).addDetail("list", (Object)winControl)).addDetail("helper", (Object)winHelper)).log();
        }
        ArrayList<Pair> arrayList = null;
        int n2 = ListItemResolver.getItemCount(winControl, new String[]{"ListItem"}, winHelper);
        Pair pair = CheckerHelper.instance().getStartAndCountParameters(n2, winControl, null);
        Options.setOption((String)Options.OPT_PLAY_SCROLL_ITEM, (Object)false, (String)"qfs:override");
        try {
            int[] nArray = (int[])pair.getFirst();
            if (pair.getSecond() != null) {
                nArray[0] = ((int[])pair.getSecond())[1];
            }
            int n3 = nArray[0];
            if (nArray[1] >= 0) {
                n2 = Math.min(n2, n3 + nArray[1]);
            }
            if (ListChecker.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getItemsForCheck(WinControl,WinHelper)", 272).add("start", n3)).add("count", n2)).log();
            }
            arrayList = new ArrayList<Pair>();
            for (int i2 = n3; i2 < n2; ++i2) {
                WinControl winControl2 = (WinControl)ItemRegistry.instance().getElement(winControl, i2);
                String string = winHelper.getWholeText(winControl2);
                if (Misc.emptyOrNull((String)string)) {
                    if (ListChecker.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemsForCheck(WinControl,WinHelper)", 284).add("got no text")).log();
                    }
                    string = winControl2.getUiaName();
                }
                string = ItemRegistry.instance().resolveItemValue(winControl, i2, string);
                Pair pair2 = new Pair();
                pair2.setFirst((Object)winControl2);
                pair2.setSecond((Object)string);
                arrayList.add(pair2);
            }
        }
        finally {
            Options.unsetOption((String)Options.OPT_PLAY_SCROLL_ITEM, (String)"qfs:override");
        }
        return arrayList;
    }

    public static Pair getSelectedItem(WinControl winControl, WinHelper winHelper) throws TestException {
        if (ListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSelectedItem(WinControl,WinHelper)", 302).addDetail("list", (Object)winControl)).addDetail("helper", (Object)winHelper)).log();
        }
        Pair pair = null;
        ArrayList arrayList = ListChecker.a(winControl, winHelper);
        if (arrayList != null) {
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                WinControl winControl2 = (WinControl)((Pair)arrayList.get(i2)).getFirst();
                if (!winHelper.isSelected(winControl2)) continue;
                pair = new Pair((Object)winControl2, (Object)((String)((Pair)arrayList.get(i2)).getSecond()));
                break;
            }
        }
        return pair;
    }
}

