/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.win.check;

import de.qfs.apps.qftest.client.ElementHelper;
import de.qfs.apps.qftest.client.RetryException;
import de.qfs.apps.qftest.client.win.WinHelper;
import de.qfs.apps.qftest.client.win.toolkit.WinControl;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.extensions.checks.Checker;
import de.qfs.apps.qftest.extensions.checks.QFSChecker;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.check.BooleanCheckData;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.GeometryCheckData;
import de.qfs.apps.qftest.shared.data.check.ImageCheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Pair;
import java.util.ArrayList;

public class WinControlChecker
implements Checker,
QFSChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.win.check.WinControlChecker");
    protected WinHelper helper;
    public static final String[] NO_TEXT_CHECK_CLASSES = new String[]{"List", "TabPanel", "Table", "Tree"};

    public WinControlChecker(WinHelper winHelper) {
        if (WinControlChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "WinControlChecker(WinHelper)", 81).addDetail("helper", (Object)winHelper)).log();
        }
        this.helper = winHelper;
    }

    @Override
    public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
        if (WinControlChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSupportedCheckTypes(Object,Object)", 99).addDetail("target", object)).addDetail("subItem", object2)).log();
        }
        WinControl winControl = (WinControl)object;
        String string = winControl.getUiaType();
        ArrayList<CheckType> arrayList = new ArrayList<CheckType>();
        if (object2 == null && !this.helper.isMatchingClass(object, NO_TEXT_CHECK_CLASSES)) {
            arrayList.add(CheckType.TEXT);
        }
        arrayList.add(CheckType.VISIBLE);
        if (winControl.hasPattern("Value") || winControl.hasPattern("RangeValue") || winControl.hasPattern("Text")) {
            arrayList.add(CheckType.EDITABLE);
        }
        arrayList.add(CheckType.ENABLED);
        arrayList.add(CheckType.FOCUSED);
        arrayList.add(CheckType.IMAGE);
        arrayList.add(CheckType.GEOMETRY);
        if ("Uia.CheckBox".equals(string) || "Uia.RadioButton".equals(string) || winControl.hasPattern("Toggle")) {
            arrayList.add(0, CheckType.CHECKED);
        } else if ("Uia.MenuItem".equals(string)) {
            arrayList.add(CheckType.CHECKED);
        }
        if (winControl.hasPattern("RangeValue")) {
            arrayList.add(0, CheckType.VALUE);
        }
        return arrayList.toArray(new CheckType[0]);
    }

    @Override
    public CheckData getCheckData(Object object, Object object2, CheckType checkType) throws TestException {
        ElementHelper.Geometry geometry;
        if (WinControlChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckData(Object,Object,CheckType)", 150).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        if (!(object instanceof WinControl)) {
            return null;
        }
        if (object2 != null) {
            if (WinControlChecker.a.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "getCheckData(Object,Object,CheckType)", 158).add("Base WinControlChecker should not be called for item")).add("target", object)).add("subItem", object2)).add("type", (Object)checkType)).dumpStack();
            }
            try {
                object = ItemRegistry.instance().getElement(object, object2);
            }
            catch (TestException testException) {
                object = null;
            }
            if (WinControlChecker.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 164).add("target", object)).log();
            }
            if (!(object instanceof WinControl)) {
                return null;
            }
        }
        WinControl winControl = (WinControl)object;
        String string = checkType.getIdentifier();
        if (checkType.getDataType() == CheckDataType.STRING && CheckType.VALUE.getIdentifier().equals(string) && winControl.hasPattern("RangeValue")) {
            String string2 = winControl.getDriver().getAttribute(winControl.getHandle(), "rangevalue");
            return new StringCheckData(CheckType.VALUE.getIdentifier(), string2);
        }
        if (checkType.getDataType() == CheckDataType.STRING && ("default".equals(string) || CheckType.TEXT.getIdentifier().equals(string))) {
            String string3 = WinControlChecker.getTextForCheck(this.helper, winControl, object2);
            return new StringCheckData("default", string3);
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.VISIBLE.getIdentifier().equals(string)) {
            return new BooleanCheckData(CheckType.VISIBLE.getIdentifier(), this.helper.isVisible(object));
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.EDITABLE.getIdentifier().equals(string)) {
            return new BooleanCheckData(CheckType.EDITABLE.getIdentifier(), this.helper.isEditable(object));
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.ENABLED.getIdentifier().equals(string)) {
            return new BooleanCheckData(CheckType.ENABLED.getIdentifier(), this.helper.isEnabled(object));
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.FOCUSED.getIdentifier().equals(string)) {
            boolean bl2 = "1".equals(winControl.getDriver().getAttribute(winControl.getHandle(), "focus"));
            return new BooleanCheckData(CheckType.FOCUSED.getIdentifier(), bl2);
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.CHECKED.getIdentifier().equals(checkType.getIdentifier())) {
            boolean bl3 = false;
            if (winControl.hasPattern("Toggle")) {
                bl3 = "1".equals(winControl.getDriver().getAttribute(winControl.getHandle(), "toggled"));
            } else {
                if ("WPF.MenuItem".equals(winControl.getUiaClassName())) {
                    return null;
                }
                if (winControl.hasPattern("LegacyIAccessible")) {
                    String string4 = winControl.getDriver().getAttribute(winControl.getHandle(), "accstate");
                    bl3 = string4.indexOf("CHECKED") >= 0;
                }
            }
            return new BooleanCheckData(CheckType.CHECKED.getIdentifier(), bl3);
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.SELECTED.getIdentifier().equals(string)) {
            boolean bl4 = this.helper.isSelected(winControl);
            return new BooleanCheckData(CheckType.SELECTED.getIdentifier(), bl4);
        }
        if (checkType.getDataType() == CheckDataType.IMAGE && ("default".equals(string) || CheckType.IMAGE.getIdentifier().equals(string))) {
            ImageRep imageRep = WinControlChecker.getImageForCheck(this.helper, winControl);
            return new ImageCheckData("default", imageRep, -1, -1, -1, -1, -1, -1, false);
        }
        if (checkType.getDataType() == CheckDataType.GEOMETRY && ("default".equals(string) || CheckType.GEOMETRY.getIdentifier().equals(string)) && (geometry = this.helper.getGeometry(object)) != null) {
            return new GeometryCheckData("default", geometry.x, geometry.y, geometry.width, geometry.height);
        }
        return null;
    }

    @Override
    public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) throws TestException {
        CheckData checkData;
        if (WinControlChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataAndItem(Object,Object,CheckType)", 247).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        return (checkData = this.getCheckData(object, null, checkType)) == null ? null : new Pair((Object)checkData, null);
    }

    public static String getTextForCheck(WinHelper winHelper, WinControl winControl, Object object) {
        String string;
        block9: {
            if (WinControlChecker.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getTextForCheck(WinHelper,WinControl,Object)", 262).addDetail("helper", (Object)winHelper)).addDetail("target", (Object)winControl)).addDetail("subItem", object)).log();
            }
            string = null;
            if (object != null) {
                try {
                    string = ItemRegistry.instance().getItemValue(winControl, object);
                    if (WinControlChecker.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getTextForCheck(WinHelper,WinControl,Object)", 268).add("text1", string)).log();
                    }
                    string = ItemRegistry.instance().resolveItemValue(winControl, object, string);
                    if (WinControlChecker.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getTextForCheck(WinHelper,WinControl,Object)", 270).add("text2", string)).log();
                    }
                    break block9;
                }
                catch (BadItemException badItemException) {
                    if (WinControlChecker.a.level >= 3) {
                        ((LevelAwareLogBuilder)a.lvlBuild(3, "getTextForCheck(WinHelper,WinControl,Object)", 272).add("ex", (Object)badItemException)).log();
                    }
                    break block9;
                }
            }
            string = winHelper.getWholeText(winControl);
        }
        if (WinControlChecker.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getTextForCheck(WinHelper,WinControl,Object)", 277).add("text", string)).log();
        }
        string = Util.getCleanElementText((String)string);
        if (WinControlChecker.a.level >= 10) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(10, "getTextForCheck(WinHelper,WinControl,Object)", 279).add("got clean text", string)).add(" (")).add(winHelper.toHex(string))).add(")")).log();
        }
        return string;
    }

    public static ImageRep getImageForCheck(WinHelper winHelper, WinControl winControl) throws TestException {
        if (WinControlChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getImageForCheck(WinHelper,WinControl)", 286).addDetail("helper", (Object)winHelper)).addDetail("target", (Object)winControl)).log();
        }
        ImageRep imageRep = winHelper.captureImage(winControl);
        if (WinControlChecker.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getImageForCheck(WinHelper,WinControl)", 290).add("image", (Object)imageRep)).log();
        }
        if (imageRep == null) {
            if (WinControlChecker.a.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "getImageForCheck(WinHelper,WinControl)", 292).add("Cannot grab image for ")).add((Object)winControl)).log();
            }
            RetryException.throwEither(new TestException("Cannot grab image for " + String.valueOf(winControl)), 10L);
        }
        return imageRep;
    }
}

